/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

final class RemoveTrailingCommaFromParamList
implements CompilerPass {
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST);
    private final AbstractCompiler compiler;

    RemoveTrailingCommaFromParamList(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, new RemoveComma());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    private static class RemoveComma
    extends NodeTraversal.AbstractPostOrderCallback {
        private RemoveComma() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Preconditions.checkState((!n.isOptChainCall() ? 1 : 0) != 0);
            if (n.hasTrailingComma() && (n.isParamList() || n.isCall() || n.isNew())) {
                n.setTrailingComma(false);
            }
        }
    }
}

