/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.nullness.Nullable;

class PureFunctionIdentifier
implements OptimizeCalls.CallGraphCompilerPass {
    private static final String PROP_NAME_PREFIX = ".";
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private final Map<String, AmbiguatedFunctionSummary> summariesByName = new HashMap<String, AmbiguatedFunctionSummary>();
    private final Multimap<Node, AmbiguatedFunctionSummary> summariesForAllNamesOfFunctionByNode = ArrayListMultimap.create();
    private final List<Node> allFunctionCalls = new ArrayList<Node>();
    private final LinkedDirectedGraph<AmbiguatedFunctionSummary, SideEffectPropagation> reverseCallGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final AmbiguatedFunctionSummary unknownFunctionSummary = AmbiguatedFunctionSummary.createInGraph(this.reverseCallGraph, "<unknown>").setMutatesGlobalStateAndAllOtherFlags();
    private static final Node IMPLICIT_PURE_FN = IR.function(IR.name(""), IR.paramList(new Node[0]), IR.block());
    private final boolean assumeGettersArePure;
    private boolean hasProcessed = false;
    private static final Predicate<Node> RHS_IS_ALWAYS_LOCAL = lhs -> true;
    private static final Predicate<Node> RHS_IS_NEVER_LOCAL = lhs -> false;
    private static final Predicate<Node> FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE = lhs -> {
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        return rhs == null || NodeUtil.evaluatesToLocalValue(rhs);
    };

    public PureFunctionIdentifier(AbstractCompiler compiler, boolean assumeGettersArePure) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.assumeGettersArePure = assumeGettersArePure;
        this.astAnalyzer = compiler.getAstAnalyzer();
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap references) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        Preconditions.checkState((!this.hasProcessed ? 1 : 0) != 0, (Object)"PureFunctionIdentifier::process may only be called once per instance.");
        this.hasProcessed = true;
        this.populateDatastructuresForAnalysisTraversal(references);
        NodeTraversal.traverse(this.compiler, externs, new ExternFunctionAnnotationAnalyzer());
        NodeTraversal.traverse(this.compiler, root, new FunctionBodyAnalyzer());
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    private static @Nullable ImmutableList<Node> collectCallableLeaves(Node expr) {
        ArrayList<Node> callables = new ArrayList<Node>();
        boolean allLegal = PureFunctionIdentifier.collectCallableLeavesInternal(expr, callables);
        return allLegal ? ImmutableList.copyOf(callables) : null;
    }

    private static boolean collectCallableLeavesInternal(Node expr, ArrayList<Node> results) {
        switch (expr.getToken()) {
            case FUNCTION: 
            case GETPROP: 
            case OPTCHAIN_GETPROP: 
            case NAME: {
                results.add(expr);
                return true;
            }
            case SUPER: {
                Node clazz = (Node)Preconditions.checkNotNull((Object)NodeUtil.getEnclosingClass(expr));
                return PureFunctionIdentifier.collectCallableLeavesInternal(clazz.getSecondChild(), results);
            }
            case CLASS: {
                @Nullable Node ctorDef = NodeUtil.getEs6ClassConstructorMemberFunctionDef(expr);
                if (ctorDef != null) {
                    return PureFunctionIdentifier.collectCallableLeavesInternal(ctorDef.getOnlyChild(), results);
                }
                if (expr.getSecondChild().isEmpty()) {
                    results.add(IMPLICIT_PURE_FN);
                    return true;
                }
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case AND: 
            case OR: 
            case COALESCE: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getFirstChild(), results) && PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case COMMA: 
            case ASSIGN: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results);
            }
            case HOOK: {
                return PureFunctionIdentifier.collectCallableLeavesInternal(expr.getSecondChild(), results) && PureFunctionIdentifier.collectCallableLeavesInternal(expr.getChildAtIndex(2), results);
            }
        }
        return false;
    }

    private static boolean isDefinitelyRValue(Node rvalue) {
        Node parent = rvalue.getParent();
        switch (parent.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: 
            case NAME: 
            case AND: 
            case OR: 
            case COALESCE: 
            case COMMA: 
            case HOOK: 
            case ARRAYLIT: 
            case CALL: 
            case EQ: 
            case GETELEM: 
            case INSTANCEOF: 
            case NEW: 
            case NOT: 
            case OPTCHAIN_CALL: 
            case OPTCHAIN_GETELEM: 
            case RETURN: 
            case SHEQ: 
            case TAGGED_TEMPLATELIT: 
            case TYPEOF: 
            case YIELD: {
                return true;
            }
            case CASE: 
            case IF: 
            case SWITCH: 
            case WHILE: {
                return rvalue.isFirstChildOf(parent);
            }
            case EXPR_RESULT: {
                return !rvalue.isFromExterns();
            }
            case CLASS: 
            case ASSIGN: {
                return rvalue.isSecondChildOf(parent);
            }
            case STRING_KEY: {
                return parent.getParent().isObjectLit();
            }
        }
        return false;
    }

    private ImmutableList<Node> getGoogCacheCallableExpression(CodingConvention.Cache cacheCall) {
        Preconditions.checkNotNull((Object)cacheCall);
        ImmutableList.Builder builder = ImmutableList.builder().addAll(PureFunctionIdentifier.collectCallableLeaves(cacheCall.valueFn));
        if (cacheCall.keyFn != null) {
            builder.addAll(PureFunctionIdentifier.collectCallableLeaves(cacheCall.keyFn));
        }
        return builder.build();
    }

    private ImmutableList<AmbiguatedFunctionSummary> getSummariesForCallee(Node invocation) {
        Preconditions.checkArgument((boolean)NodeUtil.isInvocation(invocation), (Object)invocation);
        CodingConvention.Cache cacheCall = this.compiler.getCodingConvention().describeCachingCall(invocation);
        ImmutableList<Node> callees = cacheCall != null ? this.getGoogCacheCallableExpression(cacheCall) : (PureFunctionIdentifier.isInvocationViaCallOrApply(invocation) ? ImmutableList.of((Object)invocation.getFirstFirstChild()) : PureFunctionIdentifier.collectCallableLeaves(invocation.getFirstChild()));
        if (callees == null) {
            return ImmutableList.of((Object)this.unknownFunctionSummary);
        }
        Preconditions.checkState((!callees.isEmpty() ? 1 : 0) != 0, (Object)"Unexpected empty callees for valid result");
        ImmutableList.Builder results = ImmutableList.builder();
        for (Node callee : callees) {
            if (callee.isFunction()) {
                Preconditions.checkState((boolean)callee.isFunction(), (Object)callee);
                Collection summariesForFunction = this.summariesForAllNamesOfFunctionByNode.get((Object)callee);
                Preconditions.checkState((!summariesForFunction.isEmpty() ? 1 : 0) != 0, (String)"Function missed during analysis: %s", (Object)callee);
                results.addAll((Iterable)summariesForFunction);
                continue;
            }
            String calleeName = PureFunctionIdentifier.nameForReference(callee);
            results.add((Object)this.summariesByName.getOrDefault(calleeName, this.unknownFunctionSummary));
        }
        return results.build();
    }

    private void populateDatastructuresForAnalysisTraversal(OptimizeCalls.ReferenceMap referenceMap) {
        ArrayListMultimap referencesByName = ArrayListMultimap.create();
        for (Map.Entry<String, ArrayList<Node>> entry : referenceMap.getNameReferences()) {
            referencesByName.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        for (Map.Entry<String, ArrayList<Node>> entry : referenceMap.getPropReferences()) {
            referencesByName.putAll((Object)(PROP_NAME_PREFIX + entry.getKey()), (Iterable)entry.getValue());
        }
        Preconditions.checkState((!referencesByName.containsKey((Object)"") ? 1 : 0) != 0);
        Preconditions.checkState((!referencesByName.containsKey((Object)PROP_NAME_PREFIX) ? 1 : 0) != 0);
        for (String name : referencesByName.keySet()) {
            this.summariesByName.put(name, AmbiguatedFunctionSummary.createInGraph(this.reverseCallGraph, name));
        }
        Multimaps.asMap((ListMultimap)referencesByName).forEach(this::populateFunctionDefinitions);
        this.summariesForAllNamesOfFunctionByNode.put((Object)IMPLICIT_PURE_FN, (Object)AmbiguatedFunctionSummary.createInGraph(this.reverseCallGraph, "<implicit pure class ctor"));
    }

    private void populateFunctionDefinitions(String name, List<Node> references) {
        AmbiguatedFunctionSummary summaryForName = (AmbiguatedFunctionSummary)Preconditions.checkNotNull((Object)this.summariesByName.get(name));
        boolean invalid = false;
        ArrayList<ImmutableList<Node>> rvaluesAssignedToName = new ArrayList<ImmutableList<Node>>();
        for (Node node : references) {
            if (PureFunctionIdentifier.isDefinitelyRValue(node)) continue;
            Node rvalue = NodeUtil.getRValueOfLValue(node);
            if (rvalue == null) {
                invalid = true;
                break;
            }
            ImmutableList<Node> callables = PureFunctionIdentifier.collectCallableLeaves(rvalue);
            if (callables == null) {
                invalid = true;
                break;
            }
            rvaluesAssignedToName.add(callables);
        }
        if (rvaluesAssignedToName.isEmpty() || invalid) {
            summaryForName.setMutatesGlobalStateAndAllOtherFlags();
        } else {
            for (ImmutableList immutableList : rvaluesAssignedToName) {
                for (Node rvalue : immutableList) {
                    if (rvalue.isFunction()) {
                        this.summariesForAllNamesOfFunctionByNode.put((Object)rvalue, (Object)summaryForName);
                        continue;
                    }
                    String rvalueName = PureFunctionIdentifier.nameForReference(rvalue);
                    AmbiguatedFunctionSummary rvalueSummary = this.summariesByName.getOrDefault(rvalueName, this.unknownFunctionSummary);
                    this.reverseCallGraph.connect(rvalueSummary.graphNode, SideEffectPropagation.forAlias(), summaryForName.graphNode);
                }
            }
        }
    }

    private void propagateSideEffects() {
        FixedPointGraphTraversal.newTraversal((source, edge, destination) -> edge.propagate((AmbiguatedFunctionSummary)source, (AmbiguatedFunctionSummary)destination)).computeFixedPoint(this.reverseCallGraph);
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            ImmutableList<AmbiguatedFunctionSummary> calleeSummaries = this.getSummariesForCallee(callNode);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (calleeSummaries.isEmpty()) {
                flags.setAllFlags();
            } else {
                flags.clearAllFlags();
                for (AmbiguatedFunctionSummary calleeSummary : calleeSummaries) {
                    Preconditions.checkNotNull((Object)calleeSummary);
                    if (calleeSummary.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (calleeSummary.mutatesArguments()) {
                        flags.setMutatesArguments();
                    }
                    if (calleeSummary.functionThrows()) {
                        flags.setThrows();
                    }
                    if (!PureFunctionIdentifier.isCallOrTaggedTemplateLit(callNode) || !calleeSummary.mutatesThis()) continue;
                    if (PureFunctionIdentifier.isInvocationViaCallOrApply(callNode)) {
                        flags.setMutatesArguments();
                        continue;
                    }
                    flags.setMutatesThis();
                }
            }
            if (callNode.getFirstChild().isSuper()) {
                flags.setMutatesThis();
            }
            if (PureFunctionIdentifier.isCallOrTaggedTemplateLit(callNode)) {
                if (!this.astAnalyzer.functionCallHasSideEffects(callNode)) {
                    flags.clearAllFlags();
                }
            } else if (callNode.isNew() && !this.astAnalyzer.constructorCallHasSideEffects(callNode)) {
                flags.clearAllFlags();
            }
            if (callNode.getSideEffectFlags() == flags.valueOf()) continue;
            callNode.setSideEffectFlags(flags);
            this.compiler.reportChangeToEnclosingScope(callNode);
        }
    }

    private static boolean isInvocationViaCallOrApply(Node callSite) {
        Node receiver = callSite.getFirstFirstChild();
        if (receiver == null || !receiver.isName() && !receiver.isGetProp() && !receiver.isOptChainGetProp()) {
            return false;
        }
        return NodeUtil.isFunctionObjectCall(callSite) || NodeUtil.isFunctionObjectApply(callSite);
    }

    private static boolean isCallOrTaggedTemplateLit(Node invocation) {
        return invocation.isCall() || invocation.isOptChainCall() || invocation.isTaggedTemplateLit();
    }

    private static @Nullable String nameForReference(Node nameRef) {
        switch (nameRef.getToken()) {
            case NAME: {
                return nameRef.getString();
            }
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                return PROP_NAME_PREFIX + nameRef.getString();
            }
        }
        throw new IllegalStateException("Unexpected name reference: " + nameRef);
    }

    private AccessorSummary.PropertyAccessKind getPropertyKind(String name) {
        return this.assumeGettersArePure ? AccessorSummary.PropertyAccessKind.NORMAL : this.compiler.getAccessorSummary().getKind(name);
    }

    static final class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;

        Driver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            OptimizeCalls.builder().setCompiler(this.compiler).setConsiderExterns(true).addPass(new PureFunctionIdentifier(this.compiler, this.compiler.getOptions().getAssumeGettersArePure())).build().process(externs, root);
        }
    }

    private static final class AmbiguatedFunctionSummary {
        private static final int THROWS = 1;
        private static final int MUTATES_GLOBAL_STATE = 2;
        private static final int MUTATES_THIS = 4;
        private static final int MUTATES_ARGUMENTS = 8;
        private final String name;
        private final DiGraph.DiGraphNode<AmbiguatedFunctionSummary, SideEffectPropagation> graphNode;
        private int bitmask = 0;

        static AmbiguatedFunctionSummary createInGraph(DiGraph<AmbiguatedFunctionSummary, SideEffectPropagation> graph, String name) {
            return new AmbiguatedFunctionSummary(graph, name);
        }

        private AmbiguatedFunctionSummary(DiGraph<AmbiguatedFunctionSummary, SideEffectPropagation> graph, String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.graphNode = graph.createNode((Object)this);
        }

        @CanIgnoreReturnValue
        private AmbiguatedFunctionSummary setMask(int mask) {
            this.bitmask |= mask;
            return this;
        }

        private boolean getMask(int mask) {
            return (this.bitmask & mask) != 0;
        }

        boolean mutatesThis() {
            return this.getMask(4);
        }

        AmbiguatedFunctionSummary setMutatesThis() {
            return this.setMask(4);
        }

        boolean functionThrows() {
            return this.getMask(1);
        }

        AmbiguatedFunctionSummary setThrows() {
            return this.setMask(1);
        }

        boolean mutatesGlobalState() {
            return this.getMask(2);
        }

        AmbiguatedFunctionSummary setMutatesGlobalStateAndAllOtherFlags() {
            return this.setMask(15);
        }

        boolean mutatesArguments() {
            return this.getMask(8);
        }

        AmbiguatedFunctionSummary setMutatesArguments() {
            return this.setMask(8);
        }

        boolean hasNoFlagsSet() {
            return this.bitmask == 0;
        }

        @DoNotCall
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("graphNode", this.graphNode.hashCode()).add("sideEffects", (Object)this.sideEffectsToString()).toString();
        }

        private String sideEffectsToString() {
            ArrayList<String> status = new ArrayList<String>();
            if (this.mutatesThis()) {
                status.add("this");
            }
            if (this.mutatesGlobalState()) {
                status.add("global");
            }
            if (this.mutatesArguments()) {
                status.add("args");
            }
            if (this.functionThrows()) {
                status.add("throw");
            }
            return ((Object)status).toString();
        }
    }

    private static class SideEffectPropagation {
        private final boolean callerIsAlias;
        private final boolean allArgsUnescapedLocal;
        private final boolean calleeThisEqualsCallerThis;
        private final boolean propagateThrows;
        private final @Nullable Node invocation;

        private SideEffectPropagation(boolean callerIsAlias, boolean allArgsUnescapedLocal, boolean calleeThisEqualsCallerThis, boolean propagateThrows, @Nullable Node invocation) {
            Preconditions.checkArgument((invocation == null || NodeUtil.isInvocation(invocation) ? 1 : 0) != 0, (Object)invocation);
            this.callerIsAlias = callerIsAlias;
            this.allArgsUnescapedLocal = allArgsUnescapedLocal;
            this.calleeThisEqualsCallerThis = calleeThisEqualsCallerThis;
            this.propagateThrows = propagateThrows;
            this.invocation = invocation;
        }

        static SideEffectPropagation forAlias() {
            return new SideEffectPropagation(true, false, false, true, null);
        }

        static SideEffectPropagation forInvocation(Node invocation, boolean propagateThrows) {
            Preconditions.checkArgument((boolean)NodeUtil.isInvocation(invocation), (Object)invocation);
            return new SideEffectPropagation(false, NodeUtil.allArgsUnescapedLocal(invocation), SideEffectPropagation.calleeAndCallerShareThis(invocation), propagateThrows, invocation);
        }

        private static boolean calleeAndCallerShareThis(Node invocation) {
            if (!PureFunctionIdentifier.isCallOrTaggedTemplateLit(invocation)) {
                return false;
            }
            Node callee = invocation.getFirstChild();
            if (callee.isSuper()) {
                return true;
            }
            Node thisArg = PureFunctionIdentifier.isInvocationViaCallOrApply(invocation) ? invocation.getSecondChild() : (callee.isGetProp() || callee.isOptChainGetProp() ? callee.getFirstChild() : null);
            if (thisArg == null) {
                return false;
            }
            return thisArg.isThis() || thisArg.isSuper();
        }

        boolean propagate(AmbiguatedFunctionSummary callee, AmbiguatedFunctionSummary caller) {
            int initialCallerFlags = caller.bitmask;
            if (this.callerIsAlias) {
                caller.setMask(callee.bitmask);
                return caller.bitmask != initialCallerFlags;
            }
            if (callee.mutatesGlobalState()) {
                caller.setMutatesGlobalStateAndAllOtherFlags();
            }
            if (this.propagateThrows && callee.functionThrows()) {
                caller.setThrows();
            }
            if (callee.mutatesArguments() && !this.allArgsUnescapedLocal) {
                caller.setMutatesGlobalStateAndAllOtherFlags();
            }
            if (callee.mutatesThis() && !this.invocation.isNew()) {
                if (this.calleeThisEqualsCallerThis) {
                    caller.setMutatesThis();
                } else {
                    caller.setMutatesGlobalStateAndAllOtherFlags();
                }
            }
            return caller.bitmask != initialCallerFlags;
        }
    }

    private final class FunctionBodyAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final ArrayDeque<FunctionStackEntry> functionScopeStack = new ArrayDeque(ImmutableList.of((Object)new FunctionStackEntry(null)));

        private FunctionBodyAnalyzer() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            this.addToCatchDepthIfTryBlock(node, 1);
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Node root;
            this.addToCatchDepthIfTryBlock(node, -1);
            if (NodeUtil.isInvocation(node)) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if ((root = this.functionScopeStack.getLast().root) != null) {
                for (AmbiguatedFunctionSummary summary : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get((Object)root)) {
                    this.updateSideEffectsForNode((AmbiguatedFunctionSummary)Preconditions.checkNotNull((Object)summary), traversal, node);
                }
            }
        }

        private void updateSideEffectsForNode(AmbiguatedFunctionSummary encloserSummary, NodeTraversal traversal, Node node) {
            if (encloserSummary.mutatesGlobalState()) {
                return;
            }
            switch (node.getToken()) {
                case ASSIGN: {
                    Node lhs = node.getFirstChild();
                    Predicate<Node> rhsLocality = lhs.isDestructuringPattern() ? RHS_IS_NEVER_LOCAL : FIND_RHS_AND_CHECK_FOR_LOCAL_VALUE;
                    NodeUtil.visitLhsNodesInNode(node, lhsNode -> this.visitLhsNode(encloserSummary, traversal.getScope(), (Node)lhsNode, rhsLocality));
                    break;
                }
                case INC: 
                case DEC: 
                case DELPROP: {
                    this.visitLhsNode(encloserSummary, traversal.getScope(), node.getOnlyChild(), RHS_IS_ALWAYS_LOCAL);
                    break;
                }
                case FOR_AWAIT_OF: {
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                }
                case FOR_OF: {
                    NodeUtil.visitLhsNodesInNode(node, lhsNode -> this.visitLhsNode(encloserSummary, traversal.getScope(), (Node)lhsNode, RHS_IS_NEVER_LOCAL));
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    break;
                }
                case FOR_IN: {
                    NodeUtil.visitLhsNodesInNode(node, lhsNode -> this.visitLhsNode(encloserSummary, traversal.getScope(), (Node)lhsNode, RHS_IS_ALWAYS_LOCAL));
                    break;
                }
                case CALL: 
                case NEW: 
                case OPTCHAIN_CALL: 
                case TAGGED_TEMPLATELIT: {
                    this.visitCall(encloserSummary, node);
                    break;
                }
                case DESTRUCTURING_LHS: {
                    if (NodeUtil.isAnyFor(node.getParent())) break;
                    NodeUtil.visitLhsNodesInNode(node.getParent(), lhsNode -> this.visitLhsNode(encloserSummary, traversal.getScope(), (Node)lhsNode, RHS_IS_NEVER_LOCAL));
                    break;
                }
                case NAME: {
                    Node value;
                    if (!NodeUtil.isNameDeclaration(node.getParent()) || (value = node.getFirstChild()) == null || NodeUtil.evaluatesToLocalValue(value)) break;
                    Scope scope = traversal.getScope();
                    Var var = (Var)scope.getVar(node.getString());
                    this.functionScopeStack.getLast().skiplistedVars.add(var);
                    break;
                }
                case THROW: {
                    this.recordThrowsBasedOnContext(encloserSummary);
                    break;
                }
                case YIELD: {
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                    break;
                }
                case AWAIT: {
                    this.deprecatedSetSideEffectsForControlLoss(encloserSummary);
                    break;
                }
                case OBJECT_REST: 
                case OBJECT_SPREAD: {
                    if (PureFunctionIdentifier.this.assumeGettersArePure) break;
                    encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                    break;
                }
                case ITER_REST: 
                case ITER_SPREAD: {
                    this.checkIteratesImpureIterable(node, encloserSummary);
                    break;
                }
                case STRING_KEY: {
                    if (!node.getParent().isObjectPattern() || !PureFunctionIdentifier.this.getPropertyKind(node.getString()).hasGetter()) break;
                    encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                    break;
                }
                case GETPROP: 
                case OPTCHAIN_GETPROP: {
                    if (!PureFunctionIdentifier.this.getPropertyKind(node.getString()).hasGetterOrSetter()) break;
                    encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                    break;
                }
                case DYNAMIC_IMPORT: {
                    encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                    break;
                }
                default: {
                    if (NodeUtil.isCompoundAssignmentOp(node)) {
                        this.visitLhsNode(encloserSummary, traversal.getScope(), node.getFirstChild(), RHS_IS_ALWAYS_LOCAL);
                        break;
                    }
                    if (!PureFunctionIdentifier.this.compiler.getAstAnalyzer().nodeTypeMayHaveSideEffects(node)) break;
                    throw new IllegalArgumentException("Unhandled side effect node type " + node);
                }
            }
        }

        private void checkIteratesImpureIterable(Node node, AmbiguatedFunctionSummary encloserSummary) {
            if (!NodeUtil.iteratesImpureIterable(node)) {
                return;
            }
            encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
        }

        private void deprecatedSetSideEffectsForControlLoss(AmbiguatedFunctionSummary encloserSummary) {
            this.recordThrowsBasedOnContext(encloserSummary);
        }

        private void recordThrowsBasedOnContext(AmbiguatedFunctionSummary encloserSummary) {
            if (this.functionScopeStack.getLast().catchDepth == 0) {
                encloserSummary.setThrows();
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (!t.getScope().isFunctionScope()) {
                return;
            }
            Node function = t.getScopeRoot();
            Preconditions.checkState((boolean)function.isFunction(), (Object)function);
            this.functionScopeStack.addLast(new FunctionStackEntry(function));
            if (!PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.containsKey((Object)function)) {
                AmbiguatedFunctionSummary summary = AmbiguatedFunctionSummary.createInGraph(PureFunctionIdentifier.this.reverseCallGraph, "<anonymous>");
                PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.put((Object)function, (Object)summary);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            Scope functionScope = (Scope)t.getScope().getClosestContainerScope();
            if (!functionScope.isFunctionScope()) {
                return;
            }
            FunctionStackEntry functionEntry = this.functionScopeStack.getLast();
            Preconditions.checkState((boolean)functionScope.getRootNode().equals(functionEntry.root), (Object)functionScope.getRootNode());
            if (t.getScopeRoot().equals(functionEntry.root)) {
                this.functionScopeStack.removeLast();
            }
            block0: for (AmbiguatedFunctionSummary sideEffectInfo : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get((Object)functionEntry.root)) {
                Preconditions.checkNotNull((Object)sideEffectInfo, (String)"%s has no side effect info.", (Object)functionEntry.root);
                if (sideEffectInfo.mutatesGlobalState()) continue;
                for (Var v : t.getScope().getVarIterable()) {
                    boolean isFromDestructuring = NodeUtil.isLhsByDestructuring(v.getNameNode());
                    if (v.isParam() && !isFromDestructuring && !functionEntry.skiplistedVars.contains(v) && functionEntry.taintedVars.contains(v)) {
                        sideEffectInfo.setMutatesArguments();
                        continue;
                    }
                    boolean localVar = false;
                    if (!v.isParam() && !v.isCatch()) {
                        localVar = true;
                    }
                    if (localVar && !functionEntry.skiplistedVars.contains(v) || !functionEntry.taintedVars.contains(v)) continue;
                    sideEffectInfo.setMutatesGlobalStateAndAllOtherFlags();
                    continue block0;
                }
            }
        }

        private boolean isVarDeclaredInSameContainerScope(@Nullable Var v, Scope scope) {
            return v != null && ((Scope)v.getScope()).hasSameContainerScope(scope);
        }

        private void visitLhsNode(AmbiguatedFunctionSummary encloserSummary, Scope scope, Node lhs, Predicate<Node> hasLocalRhs) {
            if (NodeUtil.isNormalOrOptChainGet(lhs)) {
                if (lhs.getFirstChild().isThis()) {
                    encloserSummary.setMutatesThis();
                } else {
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        Var var = (Var)scope.getVar(objectNode.getString());
                        if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                            this.functionScopeStack.getLast().taintedVars.add(var);
                        } else {
                            encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                        }
                    } else {
                        encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                    }
                }
            } else {
                Preconditions.checkState((boolean)lhs.isName(), (Object)lhs);
                Var var = (Var)scope.getVar(lhs.getString());
                if (this.isVarDeclaredInSameContainerScope(var, scope)) {
                    if (!hasLocalRhs.test(lhs)) {
                        this.functionScopeStack.getLast().skiplistedVars.add(var);
                    }
                } else {
                    encloserSummary.setMutatesGlobalStateAndAllOtherFlags();
                }
            }
        }

        private void visitCall(AmbiguatedFunctionSummary callerInfo, Node invocation) {
            if (invocation.isCall() && !PureFunctionIdentifier.this.astAnalyzer.functionCallHasSideEffects(invocation)) {
                return;
            }
            if (invocation.isNew() && !PureFunctionIdentifier.this.astAnalyzer.constructorCallHasSideEffects(invocation)) {
                return;
            }
            ImmutableList<AmbiguatedFunctionSummary> calleeSummaries = PureFunctionIdentifier.this.getSummariesForCallee(invocation);
            if (calleeSummaries.isEmpty()) {
                callerInfo.setMutatesGlobalStateAndAllOtherFlags();
                return;
            }
            boolean propatesThrows = this.functionScopeStack.getLast().catchDepth == 0;
            for (AmbiguatedFunctionSummary calleeInfo : calleeSummaries) {
                SideEffectPropagation edge = SideEffectPropagation.forInvocation(invocation, propatesThrows);
                PureFunctionIdentifier.this.reverseCallGraph.connect(calleeInfo.graphNode, edge, callerInfo.graphNode);
            }
        }

        private void addToCatchDepthIfTryBlock(Node n, int delta) {
            Node parent = n.getParent();
            if (!(n.isBlock() && parent.isTry() && n.isFirstChildOf(parent))) {
                return;
            }
            Node jsCatch = n.getNext().getFirstChild();
            if (jsCatch == null) {
                return;
            }
            this.functionScopeStack.getLast().catchDepth += delta;
        }

        final class FunctionStackEntry {
            final Node root;
            final LinkedHashSet<Var> skiplistedVars = new LinkedHashSet();
            final LinkedHashSet<Var> taintedVars = new LinkedHashSet();
            int catchDepth = 0;

            FunctionStackEntry(Node root) {
                this.root = root;
            }
        }
    }

    private final class ExternFunctionAnnotationAnalyzer
    implements NodeTraversal.Callback {
        private ExternFunctionAnnotationAnalyzer() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isFunction()) {
                return;
            }
            for (AmbiguatedFunctionSummary definitionSummary : PureFunctionIdentifier.this.summariesForAllNamesOfFunctionByNode.get((Object)node)) {
                this.updateSideEffectsForExternFunction(node, definitionSummary);
            }
        }

        private void updateSideEffectsForExternFunction(Node externFunction, AmbiguatedFunctionSummary summary) {
            Preconditions.checkArgument((boolean)externFunction.isFunction());
            Preconditions.checkArgument((boolean)externFunction.isFromExterns());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(externFunction);
            if (info == null) {
                summary.setMutatesGlobalStateAndAllOtherFlags();
                return;
            }
            if (info.modifiesThis()) {
                summary.setMutatesThis();
            }
            if (info.hasSideEffectsArgumentsAnnotation()) {
                summary.setMutatesArguments();
            }
            if (!info.getThrowsAnnotations().isEmpty()) {
                summary.setThrows();
            }
            if (!info.isNoSideEffects() && summary.hasNoFlagsSet()) {
                summary.setMutatesGlobalStateAndAllOtherFlags();
            }
        }
    }
}

