/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ParenthesizeFunctionsInChunks
implements CompilerPass {
    final AbstractCompiler compiler;
    final Set<String> parenthesizeFunctionsInChunks;
    final Map<String, Long> chunkToEagerCompileFnCount = new HashMap<String, Long>();

    public ParenthesizeFunctionsInChunks(AbstractCompiler compiler, Set<String> parenthesizeFunctionsInChunks) {
        this.compiler = compiler;
        this.parenthesizeFunctionsInChunks = parenthesizeFunctionsInChunks;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Traversal());
        for (String key : this.chunkToEagerCompileFnCount.keySet()) {
            LogFile log = this.compiler.createOrReopenLog(this.getClass(), "eager_compile_chunks.log", new String[0]);
            try {
                log.log("%s: %d fn's marked for eager compile", key, this.chunkToEagerCompileFnCount.get(key));
            }
            finally {
                if (log == null) continue;
                log.close();
            }
        }
    }

    private class Traversal
    implements NodeTraversal.Callback {
        Traversal() {
        }

        private void rewriteAsFunctionExpression(Node n) {
            Node nameNode = n.getFirstChild();
            Node name = IR.name(nameNode.getString()).srcref(nameNode);
            Node var = IR.var(name).srcref(n);
            n.replaceWith(var);
            n.getFirstChild().setString("");
            name.addChildToFront(n);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isScript() || n.isRoot() || n.isModuleBody()) {
                return true;
            }
            if (n.isFunction()) {
                String chunkName = t.getChunk().getName();
                ParenthesizeFunctionsInChunks.this.chunkToEagerCompileFnCount.putIfAbsent(chunkName, 0L);
                if (ParenthesizeFunctionsInChunks.this.parenthesizeFunctionsInChunks.contains(chunkName)) {
                    n.putBooleanProp(Node.MARK_FOR_PARENTHESIZE, true);
                    if (!NodeUtil.isFunctionExpression(n)) {
                        this.rewriteAsFunctionExpression(n);
                    }
                    ParenthesizeFunctionsInChunks.this.chunkToEagerCompileFnCount.put(chunkName, ParenthesizeFunctionsInChunks.this.chunkToEagerCompileFnCount.get(chunkName) + 1L);
                }
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

