/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class MakeDeclaredNamesUnique
extends NodeTraversal.AbstractScopedCallback {
    public static final String ARGUMENTS = "arguments";
    private final Deque<Renamer> renamerStack = new ArrayDeque<Renamer>();
    private final Renamer rootRenamer;
    private final boolean markChanges;

    MakeDeclaredNamesUnique() {
        this(new ContextualRenamer(), true);
    }

    MakeDeclaredNamesUnique(Renamer renamer) {
        this(renamer, true);
    }

    MakeDeclaredNamesUnique(Renamer renamer, boolean markChanges) {
        this.rootRenamer = renamer;
        this.markChanges = markChanges;
    }

    static CompilerPass getContextualRenameInverter(AbstractCompiler compiler) {
        return new ContextualRenameInverter(compiler, true);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Renamer renamer;
        Node declarationRoot = t.getScopeRoot();
        if (this.renamerStack.isEmpty()) {
            Preconditions.checkState((!declarationRoot.isFunction() || !(this.rootRenamer instanceof ContextualRenamer) ? 1 : 0) != 0);
            renamer = this.rootRenamer;
        } else {
            boolean hoist = !declarationRoot.isFunction() && !NodeUtil.createsBlockScope(declarationRoot);
            renamer = this.renamerStack.peek().createForChildScope(t.getScopeRoot(), hoist);
        }
        this.renamerStack.push(renamer);
        this.findDeclaredNames(t, declarationRoot);
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            this.renamerStack.pop();
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: 
            case IMPORT_STAR: {
                this.visitNameOrImportStar(t, n, parent);
                break;
            }
        }
    }

    private void visitNameOrImportStar(NodeTraversal t, Node n, Node parent) {
        if (n.isName() && NodeUtil.isNonlocalModuleExportName(n)) {
            return;
        }
        String newName = this.getReplacementName(n.getString());
        if (newName != null) {
            Renamer renamer = this.renamerStack.peek();
            if (renamer.stripConstIfReplaced()) {
                n.putBooleanProp(Node.IS_CONSTANT_NAME, false);
                Node jsDocInfoNode = NodeUtil.getBestJSDocInfoNode(n);
                if (jsDocInfoNode != null && jsDocInfoNode.getJSDocInfo() != null) {
                    JSDocInfo.Builder builder = JSDocInfo.Builder.copyFrom(jsDocInfoNode.getJSDocInfo());
                    builder.recordMutable();
                    jsDocInfoNode.setJSDocInfo(builder.build());
                }
            }
            n.setString(newName);
            if (this.markChanges) {
                t.reportCodeChange();
                if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
                    t.getCompiler().reportChangeToEnclosingScope(parent);
                }
            }
        }
    }

    private @Nullable String getReplacementName(String oldName) {
        for (Renamer renamer : this.renamerStack) {
            String newName = renamer.getReplacementName(oldName);
            if (newName == null) continue;
            return newName;
        }
        return null;
    }

    private void findDeclaredNames(NodeTraversal t, Node n) {
        Preconditions.checkState((NodeUtil.createsScope(n) || n.isScript() ? 1 : 0) != 0, (Object)n);
        for (Var v : t.getScope().getVarIterable()) {
            this.renamerStack.peek().addDeclaredName(v.getName(), false);
        }
    }

    static class TargettedRenamer
    implements Renamer {
        private final Renamer delegate;
        private final Set<String> targets;

        TargettedRenamer(Renamer delegate, Set<String> targets) {
            this.delegate = delegate;
            this.targets = targets;
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (this.targets.contains(name)) {
                this.delegate.addDeclaredName(name, hoisted);
            }
        }

        @Override
        public @Nullable String getReplacementName(String oldName) {
            return this.targets.contains(oldName) ? this.delegate.getReplacementName(oldName) : null;
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.delegate.stripConstIfReplaced();
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new TargettedRenamer(this.delegate.createForChildScope(scopeRoot, hoistingTargetScope), this.targets);
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.delegate.getHoistRenamer();
        }
    }

    static class BoilerplateRenamer
    extends ContextualRenamer {
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final CodingConvention convention;

        BoilerplateRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            this.idPrefix = idPrefix;
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoisted) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, false, hoisted, this);
        }
    }

    static class InlineRenamer
    implements Renamer {
        private final Map<String, String> declarations = new LinkedHashMap<String, String>();
        private final Supplier<String> uniqueIdSupplier;
        private final String idPrefix;
        private final boolean removeConstness;
        private final CodingConvention convention;
        private final Renamer hoistRenamer;

        InlineRenamer(CodingConvention convention, Supplier<String> uniqueIdSupplier, String idPrefix, boolean removeConstness, boolean hoistingTargetScope, Renamer parent) {
            this.convention = convention;
            this.uniqueIdSupplier = uniqueIdSupplier;
            Preconditions.checkArgument((!idPrefix.isEmpty() ? 1 : 0) != 0);
            this.idPrefix = idPrefix;
            this.removeConstness = removeConstness;
            this.hoistRenamer = hoistingTargetScope ? this : parent.getHoistRenamer();
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            Preconditions.checkState((!name.equals(MakeDeclaredNamesUnique.ARGUMENTS) ? 1 : 0) != 0);
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, hoisted);
            } else {
                this.declarations.computeIfAbsent(name, this::getUniqueName);
            }
        }

        private String getUniqueName(String name) {
            if (((String)name).isEmpty()) {
                return name;
            }
            if (((String)name).contains("$jscomp$")) {
                name = ((String)name).substring(0, ((String)name).lastIndexOf("$jscomp$"));
            }
            if (this.convention.isExported((String)name)) {
                name = "JSCompiler_" + (String)name;
            }
            return (String)name + "$jscomp$" + this.idPrefix + (String)this.uniqueIdSupplier.get();
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new InlineRenamer(this.convention, this.uniqueIdSupplier, this.idPrefix, this.removeConstness, hoistingTargetScope, this);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return this.removeConstness;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenamer
    implements Renamer {
        private final @Nullable Node scopeRoot;
        private final Multiset<String> nameUsage;
        private final Map<String, String> declarations = new LinkedHashMap<String, String>();
        private final boolean global;
        private final Renamer hoistRenamer;
        static final String UNIQUE_ID_SEPARATOR = "$jscomp$";

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("scopeRoot", (Object)this.scopeRoot).add("nameUsage", this.nameUsage).add("declarations", this.declarations).add("global", this.global).toString();
        }

        ContextualRenamer() {
            this.scopeRoot = null;
            this.global = true;
            this.nameUsage = HashMultiset.create();
            this.hoistRenamer = this;
        }

        private ContextualRenamer(Node scopeRoot, Multiset<String> nameUsage, boolean hoistingTargetScope, Renamer parent) {
            Preconditions.checkState((boolean)NodeUtil.createsScope(scopeRoot), (Object)scopeRoot);
            if (scopeRoot.isFunction()) {
                Preconditions.checkState((!hoistingTargetScope ? 1 : 0) != 0, (Object)scopeRoot);
            }
            this.scopeRoot = scopeRoot;
            this.global = false;
            this.nameUsage = nameUsage;
            if (hoistingTargetScope) {
                Preconditions.checkState((!NodeUtil.createsBlockScope(scopeRoot) ? 1 : 0) != 0, (Object)scopeRoot);
                this.hoistRenamer = this;
            } else {
                Preconditions.checkState((NodeUtil.createsBlockScope(scopeRoot) || scopeRoot.isFunction() ? 1 : 0) != 0, (Object)scopeRoot);
                this.hoistRenamer = parent.getHoistRenamer();
            }
        }

        @Override
        public Renamer createForChildScope(Node scopeRoot, boolean hoistingTargetScope) {
            return new ContextualRenamer(scopeRoot, this.nameUsage, hoistingTargetScope, this);
        }

        @Override
        public void addDeclaredName(String name, boolean hoisted) {
            if (hoisted && this.hoistRenamer != this) {
                this.hoistRenamer.addDeclaredName(name, true);
            } else if (!name.equals(MakeDeclaredNamesUnique.ARGUMENTS)) {
                if (this.global) {
                    this.reserveName(name);
                } else if (!this.declarations.containsKey(name)) {
                    int id = this.incrementNameCount(name);
                    String newName = null;
                    if (id != 0) {
                        newName = ContextualRenamer.getUniqueName(name, id);
                    }
                    this.declarations.put(name, newName);
                }
            }
        }

        @Override
        public String getReplacementName(String oldName) {
            return this.declarations.get(oldName);
        }

        private static String getUniqueName(String name, int id) {
            return name + UNIQUE_ID_SEPARATOR + id;
        }

        private void reserveName(String name) {
            this.nameUsage.setCount((Object)name, 0, 1);
        }

        private int incrementNameCount(String name) {
            return this.nameUsage.add((Object)name, 1);
        }

        @Override
        public boolean stripConstIfReplaced() {
            return false;
        }

        @Override
        public Renamer getHoistRenamer() {
            return this.hoistRenamer;
        }
    }

    static class ContextualRenameInverter
    implements NodeTraversal.ScopedCallback,
    CompilerPass {
        private final AbstractCompiler compiler;
        private Set<String> referencedNames = ImmutableSet.of();
        private final Deque<Set<String>> referenceStack = new ArrayDeque<Set<String>>();
        private final ListMultimap<String, Node> nameMap = MultimapBuilder.hashKeys().arrayListValues().build();
        private final boolean markChanges;

        private ContextualRenameInverter(AbstractCompiler compiler, boolean markChanges) {
            this.compiler = compiler;
            this.markChanges = markChanges;
        }

        @Override
        public void process(Node externs, Node js) {
            NodeTraversal.traverse(this.compiler, js, this);
        }

        public static String getOriginalName(String name) {
            int index = ContextualRenameInverter.indexOfSeparator(name);
            return index == -1 ? name : name.substring(0, index);
        }

        private static int indexOfSeparator(String name) {
            return name.lastIndexOf("$jscomp$");
        }

        private static boolean containsSeparator(String name) {
            return name.contains("$jscomp$");
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            this.referenceStack.push(this.referencedNames);
            this.referencedNames = new LinkedHashSet<String>();
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            for (Var v : t.getScope().getVarIterable()) {
                this.handleScopeVar(v);
            }
            Set<String> current = this.referencedNames;
            this.referencedNames = this.referenceStack.pop();
            if (!this.referenceStack.isEmpty()) {
                this.referencedNames.addAll(current);
            }
        }

        void handleScopeVar(Var v) {
            String name = v.getName();
            if (ContextualRenameInverter.containsSeparator(name) && !ContextualRenameInverter.getOriginalName(name).isEmpty()) {
                String newName = this.findReplacementName(name);
                this.referencedNames.remove(name);
                this.referencedNames.add(newName);
                List references = this.nameMap.get((Object)name);
                for (Node n : references) {
                    Preconditions.checkState((n.isName() || n.isImportStar() ? 1 : 0) != 0, (Object)n);
                    n.setString(newName);
                    if (!this.markChanges) continue;
                    this.compiler.reportChangeToEnclosingScope(n);
                    Node parent = n.getParent();
                    if (!parent.isFunction() || !NodeUtil.isFunctionDeclaration(parent)) continue;
                    this.compiler.reportChangeToEnclosingScope(parent);
                }
                this.nameMap.removeAll((Object)name);
            }
        }

        private String findReplacementName(String name) {
            String original = ContextualRenameInverter.getOriginalName(name);
            Object newName = original;
            int i = 0;
            while (!this.isValidName((String)newName)) {
                newName = original + "$jscomp$" + i++;
            }
            return newName;
        }

        private boolean isValidName(String name) {
            return TokenStream.isJSIdentifier(name) && !this.referencedNames.contains(name) && !name.equals(MakeDeclaredNamesUnique.ARGUMENTS);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            if (NodeUtil.isReferenceName(node) || node.isImportStar()) {
                String name = node.getString();
                this.referencedNames.add(name);
                if (ContextualRenameInverter.containsSeparator(name)) {
                    this.addCandidateNameReference(name, node);
                }
            }
        }

        private void addCandidateNameReference(String name, Node n) {
            this.nameMap.put((Object)name, (Object)n);
        }
    }

    static interface Renamer {
        public void addDeclaredName(String var1, boolean var2);

        public String getReplacementName(String var1);

        public boolean stripConstIfReplaced();

        public Renamer createForChildScope(Node var1, boolean var2);

        public Renamer getHoistRenamer();
    }
}

