/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class LiveVariablesAnalysis
extends DataFlowAnalysis<Node, LiveVariableLattice> {
    static final int MAX_VARIABLES_TO_ANALYZE = 100;
    private final Scope jsScope;
    private final Scope jsScopeChild;
    private final Set<Var> escaped;
    private final Map<String, Integer> scopeVariables;
    private final List<Var> orderedVars;
    private final Map<String, Var> allVarsInFn;

    LiveVariablesAnalysis(ControlFlowGraph<Node> cfg, Scope jsScope, @Nullable Scope jsScopeChild, AbstractCompiler compiler, ScopeCreator scopeCreator, NodeUtil.AllVarsDeclaredInFunction allVarsDeclaredInFunction) {
        super(cfg);
        Preconditions.checkState((boolean)jsScope.isFunctionScope(), (Object)jsScope);
        this.jsScope = jsScope;
        this.jsScopeChild = jsScopeChild;
        this.escaped = new HashSet<Var>();
        this.scopeVariables = new HashMap<String, Integer>();
        this.orderedVars = allVarsDeclaredInFunction.getAllVariablesInOrder();
        this.allVarsInFn = allVarsDeclaredInFunction.getAllVariables();
        LiveVariablesAnalysis.computeEscaped(jsScope, this.escaped, compiler, scopeCreator, this.allVarsInFn);
        this.addScopeVariables();
    }

    private void addScopeVariables() {
        int num = 0;
        for (Var v : this.orderedVars) {
            this.scopeVariables.put(v.getName(), num);
            ++num;
        }
    }

    public Set<? extends Var> getEscapedLocals() {
        return this.escaped;
    }

    public Map<String, Var> getAllVariables() {
        return this.allVarsInFn;
    }

    public List<Var> getAllVariablesInOrder() {
        return this.orderedVars;
    }

    public int getVarIndex(String var) {
        return this.scopeVariables.get(var);
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    LiveVariableLattice createEntryLattice() {
        return new LiveVariableLattice(this.orderedVars.size());
    }

    @Override
    LiveVariableLattice createInitialEstimateLattice() {
        return new LiveVariableLattice(this.orderedVars.size());
    }

    @Override
    DataFlowAnalysis.FlowJoiner<LiveVariableLattice> createFlowJoiner() {
        return new LiveVariableJoinOp();
    }

    @Override
    LiveVariableLattice flowThrough(Node node, LiveVariableLattice input) {
        BitSet gen = new BitSet(input.liveSet.size());
        BitSet kill = new BitSet(input.liveSet.size());
        boolean conditional = false;
        List edgeList = this.getCfg().getOutEdges(node);
        for (DiGraph.DiGraphEdge diGraphEdge : edgeList) {
            if (!ControlFlowGraph.Branch.ON_EX.equals(diGraphEdge.getValue())) continue;
            conditional = true;
        }
        this.computeGenKill(node, gen, kill, conditional);
        LiveVariableLattice result = new LiveVariableLattice(input);
        result.liveSet.andNot(kill);
        result.liveSet.or(gen);
        return result;
    }

    private void computeGenKill(Node n, BitSet gen, BitSet kill, boolean conditional) {
        switch (n.getToken()) {
            case SCRIPT: 
            case ROOT: 
            case FUNCTION: 
            case BLOCK: {
                return;
            }
            case WHILE: 
            case DO: 
            case IF: 
            case FOR: {
                this.computeGenKill(NodeUtil.getConditionExpression(n), gen, kill, conditional);
                return;
            }
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case FOR_IN: {
                Node lhs = n.getFirstChild();
                if (NodeUtil.isNameDeclaration(lhs)) {
                    lhs = lhs.getLastChild();
                }
                this.computeGenKill(lhs, gen, kill, conditional);
                return;
            }
            case LET: 
            case CONST: 
            case VAR: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (c.isName()) {
                        if (!c.hasChildren()) continue;
                        this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                        if (conditional) continue;
                        this.addToSetIfLocal(c, kill);
                        continue;
                    }
                    Preconditions.checkState((boolean)c.isDestructuringLhs(), (Object)c);
                    if (!conditional) {
                        NodeUtil.visitLhsNodesInNode(c, lhsNode -> this.addToSetIfLocal((Node)lhsNode, kill));
                    }
                    this.computeGenKill(c.getFirstChild(), gen, kill, conditional);
                    this.computeGenKill(c.getSecondChild(), gen, kill, conditional);
                }
                return;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case OPTCHAIN_GETELEM: 
            case OPTCHAIN_GETPROP: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case OPTCHAIN_CALL: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
                    this.computeGenKill(c, gen, kill, true);
                }
                return;
            }
            case HOOK: {
                this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
                this.computeGenKill(n.getSecondChild(), gen, kill, true);
                this.computeGenKill(n.getLastChild(), gen, kill, true);
                return;
            }
            case NAME: {
                if (n.getString().equals("arguments")) {
                    this.markAllParametersEscaped();
                } else if (!NodeUtil.isLhsByDestructuring(n)) {
                    this.addToSetIfLocal(n, gen);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
            Node lhs = n.getFirstChild();
            if (!conditional) {
                this.addToSetIfLocal(lhs, kill);
            }
            if (!n.isAssign()) {
                this.addToSetIfLocal(lhs, gen);
            }
            this.computeGenKill(lhs.getNext(), gen, kill, conditional);
        } else if (n.isAssign() && n.getFirstChild().isDestructuringPattern()) {
            if (!conditional) {
                NodeUtil.visitLhsNodesInNode(n, child -> {
                    if (child.isName()) {
                        this.addToSetIfLocal((Node)child, kill);
                    }
                });
            }
            this.computeGenKill(n.getFirstChild(), gen, kill, conditional);
            this.computeGenKill(n.getSecondChild(), gen, kill, conditional);
        } else {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.computeGenKill(c, gen, kill, conditional);
            }
        }
    }

    private void addToSetIfLocal(Node node, BitSet set) {
        Preconditions.checkState((boolean)node.isName(), (Object)node);
        String name = node.getString();
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        Scope localScope = (Scope)var.getScope();
        boolean local = localScope.isFunctionBlockScope() ? LiveVariablesAnalysis.isDeclaredInFunctionBlockOrParameter(localScope, name) : (localScope == this.jsScope && this.jsScopeChild != null ? LiveVariablesAnalysis.isDeclaredInFunctionBlockOrParameter(this.jsScopeChild, name) : localScope.hasOwnSlot(name));
        if (!local) {
            return;
        }
        if (!this.escaped.contains(var)) {
            set.set(this.getVarIndex(var.getName()));
        }
    }

    private static boolean isDeclaredInFunctionBlockOrParameter(Scope scope, String name) {
        Preconditions.checkState((boolean)scope.isFunctionBlockScope());
        return scope.hasOwnSlot(name) || scope.getParent().hasOwnSlot(name);
    }

    void markAllParametersEscaped() {
        Node paramList = NodeUtil.getFunctionParameters(this.jsScope.getRootNode());
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            if (!param.isName()) continue;
            this.escaped.add((Var)this.jsScope.getVar(param.getString()));
        }
    }

    static class LiveVariableLattice
    implements LatticeElement {
        private final BitSet liveSet;

        private LiveVariableLattice(int numVars) {
            this.liveSet = new BitSet(numVars);
        }

        private LiveVariableLattice(LiveVariableLattice other) {
            Preconditions.checkNotNull((Object)other);
            this.liveSet = (BitSet)other.liveSet.clone();
        }

        public boolean equals(Object other) {
            Preconditions.checkNotNull((Object)other);
            return other instanceof LiveVariableLattice && this.liveSet.equals(((LiveVariableLattice)other).liveSet);
        }

        public boolean isLive(int index) {
            return this.liveSet.get(index);
        }

        public String toString() {
            return this.liveSet.toString();
        }

        public int nextSetBit(int fromIndex) {
            return this.liveSet.nextSetBit(fromIndex);
        }

        public int hashCode() {
            return this.liveSet.hashCode();
        }
    }

    private final class LiveVariableJoinOp
    implements DataFlowAnalysis.FlowJoiner<LiveVariableLattice> {
        final LiveVariableLattice result;

        private LiveVariableJoinOp() {
            this.result = new LiveVariableLattice(LiveVariablesAnalysis.this.orderedVars.size());
        }

        @Override
        public void joinFlow(LiveVariableLattice x) {
            this.result.liveSet.or(x.liveSet);
        }

        @Override
        public LiveVariableLattice finish() {
            return this.result;
        }
    }
}

