/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;

public final class InvalidatingTypes {
    private final ImmutableSetMultimap<JSType, Node> typeToLocation;
    private static final ImmutableList<JSTypeNative> ALWAYS_INVALIDATING_TYPES = ImmutableList.of((Object)((Object)JSTypeNative.FUNCTION_FUNCTION_TYPE), (Object)((Object)JSTypeNative.FUNCTION_TYPE), (Object)((Object)JSTypeNative.FUNCTION_PROTOTYPE), (Object)((Object)JSTypeNative.FUNCTION_INSTANCE_PROTOTYPE), (Object)((Object)JSTypeNative.OBJECT_TYPE), (Object)((Object)JSTypeNative.OBJECT_PROTOTYPE), (Object)((Object)JSTypeNative.OBJECT_FUNCTION_TYPE));
    private static final Node ALWAYS_INVALIDATING_LOCATION = IR.name("alwaysInvalidatingLocation").setStaticSourceFile(SourceFile.fromCode("InvalidatingTypes_alwaysInvalidatingLocation", ""));

    private InvalidatingTypes(ImmutableSetMultimap<JSType, Node> typeToLocation) {
        this.typeToLocation = typeToLocation;
    }

    public boolean isInvalidating(JSType type) {
        if (type == null || type.isUnknownType() || type.isEmptyType()) {
            return true;
        }
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.getUnionMembers()) {
                if (!this.isInvalidating(alt)) continue;
                return true;
            }
            return false;
        }
        ObjectType objType = type.toMaybeObjectType();
        if (objType == null) {
            return false;
        }
        if (objType.isTemplatizedType()) {
            objType = objType.toMaybeTemplatizedType().getReferencedType();
        }
        return this.typeToLocation.containsKey((Object)objType) || InvalidatingTypes.isAmbiguousOrStructuralType(objType);
    }

    public ImmutableSetMultimap<JSType, Node> getMismatchLocations() {
        return this.typeToLocation;
    }

    private static boolean isAmbiguousOrStructuralType(ObjectType type) {
        if (type.isEnumType()) {
            return false;
        }
        if (type.isEnumElementType()) {
            ObjectType primitive = type.toMaybeEnumElementType().getPrimitiveType().toMaybeObjectType();
            return primitive == null || InvalidatingTypes.isAmbiguousOrStructuralType(primitive);
        }
        if (type.isFunctionType()) {
            return !type.isNominalConstructorOrInterface() || type.toMaybeFunctionType().isAmbiguousConstructor();
        }
        if (type.isFunctionPrototypeType()) {
            FunctionType ownerFunction = type.getOwnerFunction();
            return ownerFunction == null || !ownerFunction.isNominalConstructorOrInterface() || ownerFunction.isAmbiguousConstructor() || ownerFunction.isStructuralInterface();
        }
        if (type.isInstanceType()) {
            FunctionType ctor = type.getConstructor();
            return ctor == null || ctor.isAmbiguousConstructor() || ctor.isStructuralInterface();
        }
        return true;
    }

    public static final class Builder {
        private final JSTypeRegistry registry;
        private final ImmutableSetMultimap.Builder<JSType, Node> typeToLocation = ImmutableSetMultimap.builder();

        public Builder(JSTypeRegistry registry) {
            this.registry = registry;
        }

        public InvalidatingTypes build() {
            for (JSTypeNative t : ALWAYS_INVALIDATING_TYPES) {
                this.typeToLocation.put((Object)this.registry.getNativeType(t), (Object)ALWAYS_INVALIDATING_LOCATION);
            }
            return new InvalidatingTypes((ImmutableSetMultimap<JSType, Node>)this.typeToLocation.build());
        }

        @CanIgnoreReturnValue
        public Builder addAllTypeMismatches(Iterable<TypeMismatch> mismatches) {
            for (TypeMismatch mismatch : mismatches) {
                this.addTypeWithReason(mismatch.getFound(), mismatch.getLocation());
                this.addTypeWithReason(mismatch.getRequired(), mismatch.getLocation());
            }
            return this;
        }

        private void addTypeWithReason(JSType type, Node location) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : type.getUnionMembers()) {
                    this.addTypeWithReason(alt, location);
                }
                return;
            }
            if (type.isEnumElementType()) {
                this.addTypeWithReason(type.getEnumeratedTypeOfEnumElement(), location);
                return;
            }
            ObjectType objType = type.toMaybeObjectType();
            if (objType == null) {
                return;
            }
            this.recordTypeWithReason(objType, location);
            this.recordTypeWithReason(objType.getImplicitPrototype(), location);
            if (objType.isConstructor()) {
                ObjectType instanceType = objType.toMaybeFunctionType().getInstanceType();
                this.recordTypeWithReason(instanceType, location);
            } else if (objType.isInstanceType()) {
                this.recordTypeWithReason(objType.getConstructor(), location);
            }
        }

        private void recordTypeWithReason(ObjectType type, Node location) {
            if (type == null) {
                return;
            }
            if (type.isTemplatizedType()) {
                type = type.toMaybeTemplatizedType().getReferencedType();
            }
            if (InvalidatingTypes.isAmbiguousOrStructuralType(type)) {
                return;
            }
            this.typeToLocation.put((Object)type, (Object)location);
        }
    }
}

