/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jspecify.nullness.Nullable;

final class InlineProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ColorRegistry registry;
    private static final PropertyInfo INVALIDATED = new PropertyInfo(null, null);
    private final Map<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();

    InlineProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.registry = compiler.getColorRegistry();
        this.invalidateExternProperties();
    }

    private void invalidateExternProperties() {
        for (String name : this.compiler.getExternProperties()) {
            this.props.put(name, INVALIDATED);
        }
    }

    private Color getColor(Node n) {
        Color color = n.getColor();
        if (color == null) {
            return StandardColors.UNKNOWN;
        }
        return color;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherCandidates());
        NodeTraversal.traverse(this.compiler, root, new ReplaceCandidates());
    }

    private static Color removeNullAndUndefinedIfUnion(Color original) {
        return original.isUnion() ? original.subtractNullOrVoid() : original;
    }

    class ReplaceCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        private final LinkedHashSet<Color> hasInSupertypesListSeenSet = new LinkedHashSet();

        ReplaceCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp() && !NodeUtil.isLValue(n)) {
                Node target = n.getFirstChild();
                String propName = n.getString();
                PropertyInfo info = InlineProperties.this.props.get(propName);
                if (info != null && info != INVALIDATED && this.isMatchingType(target, info.color)) {
                    Node replacement = info.value.cloneTree();
                    if (InlineProperties.this.compiler.getAstAnalyzer().mayHaveSideEffects(n.getFirstChild())) {
                        replacement = IR.comma(n.removeFirstChild(), replacement).srcref(n);
                    }
                    n.replaceWith(replacement);
                    InlineProperties.this.compiler.reportChangeToEnclosingScope(replacement);
                }
            }
        }

        private boolean isMatchingType(Node n, Color src) {
            src = InlineProperties.removeNullAndUndefinedIfUnion(src);
            Color dest = InlineProperties.removeNullAndUndefinedIfUnion(InlineProperties.this.getColor(n));
            if (dest.isInvalidating()) {
                return false;
            }
            if (dest.isUnion() || src.isUnion()) {
                return false;
            }
            return this.hasInSupertypesList(dest, src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasInSupertypesList(Color subCtor, Color superCtor) {
            try {
                if (!this.hasInSupertypesListSeenSet.add(subCtor)) {
                    boolean bl = false;
                    return bl;
                }
                if (subCtor == null || superCtor == null) {
                    boolean bl = false;
                    return bl;
                }
                if (subCtor.equals(superCtor)) {
                    boolean bl = true;
                    return bl;
                }
                for (Color immediateSupertype : InlineProperties.this.registry.getDisambiguationSupertypes(subCtor)) {
                    if (immediateSupertype.isUnion() || !this.hasInSupertypesList(immediateSupertype, superCtor)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.hasInSupertypesListSeenSet.remove(subCtor);
            }
        }
    }

    class GatherCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        GatherCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean invalidatingPropRef;
            String propName;
            if (n.isGetProp()) {
                propName = n.getString();
                invalidatingPropRef = parent.isAssign() ? !this.maybeRecordCandidateGetpropDefinition(t, n, parent) : (NodeUtil.isLValue(n) ? true : parent.isDelProp());
            } else if (n.isStringKey() && !n.getParent().isObjectPattern() || n.isGetterDef() || n.isSetterDef() || n.isMemberFunctionDef()) {
                propName = n.getString();
                invalidatingPropRef = true;
            } else if (n.isMemberFieldDef()) {
                propName = n.getString();
                invalidatingPropRef = !this.maybeRecordCandidateClassFieldDefinition(n);
            } else {
                return;
            }
            if (invalidatingPropRef) {
                Preconditions.checkNotNull((Object)propName);
                this.invalidateProperty(propName);
            }
        }

        private boolean maybeRecordCandidateClassFieldDefinition(Node n) {
            ImmutableSet<Color> possibleInstances;
            Preconditions.checkState((boolean)n.isMemberFieldDef(), (Object)n);
            Node src = n.getFirstChild();
            String propName = n.getString();
            Node classNode = n.getGrandparent();
            Color c = n.isStaticMember() ? InlineProperties.this.getColor(classNode) : ((possibleInstances = InlineProperties.this.getColor(classNode).getInstanceColors()).isEmpty() ? StandardColors.UNKNOWN : Color.createUnion(possibleInstances));
            return this.maybeStoreCandidateValue(c, propName, src);
        }

        private boolean maybeRecordCandidateGetpropDefinition(NodeTraversal t, Node n, Node parent) {
            Color targetType;
            Preconditions.checkState((n.isGetProp() && parent.isAssign() ? 1 : 0) != 0, (Object)n);
            Node src = n.getFirstChild();
            String propName = n.getString();
            Node value = parent.getLastChild();
            if (src.isThis()) {
                if (this.inConstructor(t)) {
                    return this.maybeStoreCandidateValue(InlineProperties.this.getColor(src), propName, value);
                }
                return false;
            }
            if (t.inGlobalHoistScope() && src.isGetProp() && src.getString().equals("prototype")) {
                Color instanceType = InlineProperties.this.getColor(src);
                return this.maybeStoreCandidateValue(instanceType, propName, value);
            }
            if (t.inGlobalHoistScope() && (targetType = InlineProperties.this.getColor(src)) != null && targetType.isConstructor()) {
                return this.maybeStoreCandidateValue(targetType, propName, value);
            }
            return false;
        }

        private void invalidateProperty(String propName) {
            InlineProperties.this.props.put(propName, INVALIDATED);
        }

        private boolean maybeStoreCandidateValue(Color color, String propName, Node value) {
            Preconditions.checkNotNull((Object)value);
            if (!InlineProperties.this.props.containsKey(propName) && !color.isInvalidating() && NodeUtil.isImmutableValue(value) && NodeUtil.isExecutedExactlyOnce(value)) {
                InlineProperties.this.props.put(propName, new PropertyInfo(color, value));
                return true;
            }
            return false;
        }

        private boolean inConstructor(NodeTraversal t) {
            Node root = t.getEnclosingFunction();
            if (root == null) {
                return false;
            }
            return NodeUtil.isConstructor(root);
        }
    }

    private static class PropertyInfo {
        final Color color;
        final Node value;

        PropertyInfo(@Nullable Color color, @Nullable Node value) {
            this.color = color;
            this.value = value;
        }
    }
}

