/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConcretizeStaticInheritanceForInlining;
import com.google.javascript.jscomp.ConvertChunksToESModules;
import com.google.javascript.jscomp.DestructuringGlobalNameExtractor;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceCollector;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.StaticSuperPropReplacer;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

class InlineAndCollapseProperties
implements CompilerPass {
    static final DiagnosticType PARTIAL_NAMESPACE_WARNING = DiagnosticType.warning("JSC_PARTIAL_NAMESPACE", "Partial alias created for namespace {0}, possibly due to await/yield transpilation.\nThis may prevent optimization of anything nested under this namespace.\nSee https://github.com/google/closure-compiler/wiki/FAQ#i-got-a-partial-alias-created-for-namespace-error--what-do-i-do for more details.");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning("JSC_NAMESPACE_REDEFINED", "namespace {0} should not be redefined");
    static final DiagnosticType RECEIVER_AFFECTED_BY_COLLAPSE = DiagnosticType.warning("JSC_RECEIVER_AFFECTED_BY_COLLAPSE", "Receiver reference in function {0} changes meaning when namespace is collapsed.\n Consider annotating @nocollapse; however, other properties on the receiver may still be collapsed.");
    static final DiagnosticType UNSAFE_CTOR_ALIASING = DiagnosticType.warning("JSC_UNSAFE_CTOR_ALIASING", "Variable {0} aliases a constructor, so it cannot be assigned multiple times");
    static final DiagnosticType ALIAS_CYCLE = DiagnosticType.error("JSC_ALIAS_CYCLE", "Alias path contains a cycle: {0} to {1}");
    private final AbstractCompiler compiler;
    private final CompilerOptions.PropertyCollapseLevel propertyCollapseLevel;
    private final CompilerOptions.ChunkOutputType chunkOutputType;
    private final boolean haveModulesBeenRewritten;
    private final ModuleLoader.ResolutionMode moduleResolutionMode;
    private final boolean staticInheritanceUsed;
    private final boolean testAggressiveInliningOnly;
    private final Optional<Consumer<GlobalNamespace>> optionalGlobalNamespaceTester;
    private @Nullable LogFile decisionsLog = null;
    private GlobalNamespace namespace;

    private InlineAndCollapseProperties(Builder builder) {
        this.compiler = builder.compiler;
        this.propertyCollapseLevel = builder.propertyCollapseLevel;
        this.chunkOutputType = builder.chunkOutputType;
        this.haveModulesBeenRewritten = builder.haveModulesBeenRewritten;
        this.moduleResolutionMode = builder.moduleResolutionMode;
        this.testAggressiveInliningOnly = builder.testAggressiveInliningOnly;
        this.optionalGlobalNamespaceTester = builder.optionalGlobalNamespaceTester;
        this.staticInheritanceUsed = builder.staticInheritanceUsed;
    }

    static Builder builder(AbstractCompiler compiler) {
        return new Builder(compiler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((!this.testAggressiveInliningOnly || this.propertyCollapseLevel == CompilerOptions.PropertyCollapseLevel.ALL ? 1 : 0) != 0, (String)"testAggressiveInlining is invalid for: %s", (Object)((Object)this.propertyCollapseLevel));
        try (LogFile logFile = this.compiler.createOrReopenIndexedLog(this.getClass(), "decisions.log", new String[0]);){
            this.decisionsLog = logFile;
            switch (this.propertyCollapseLevel) {
                case NONE: {
                    this.performMinimalInliningAndNoCollapsing(externs, root);
                    return;
                }
                case MODULE_EXPORT: {
                    this.performMinimalInliningAndModuleExportCollapsing(externs, root);
                    return;
                }
                case ALL: {
                    if (this.testAggressiveInliningOnly) {
                        this.performAggressiveInliningForTest(externs, root);
                        return;
                    }
                    this.performAggressiveInliningAndCollapsing(externs, root);
                    return;
                }
            }
            return;
        }
        finally {
            this.decisionsLog = null;
        }
    }

    private void performMinimalInliningAndNoCollapsing(Node externs, Node root) {
        new InlineAliases().process(externs, root);
    }

    private void performMinimalInliningAndModuleExportCollapsing(Node externs, Node root) {
        new InlineAliases().process(externs, root);
        this.namespace = new GlobalNamespace(this.decisionsLog, this.compiler, root);
        new CollapseProperties().process(externs, root);
    }

    private void performAggressiveInliningAndCollapsing(Node externs, Node root) {
        new ConcretizeStaticInheritanceForInlining(this.compiler).process(externs, root);
        new AggressiveInlineAliases().process(externs, root);
        new CollapseProperties().process(externs, root);
    }

    private void performAggressiveInliningForTest(Node externs, Node root) {
        AggressiveInlineAliases aggressiveInlineAliases = new AggressiveInlineAliases();
        aggressiveInlineAliases.process(externs, root);
        this.optionalGlobalNamespaceTester.get().accept(aggressiveInlineAliases.getLastUsedGlobalNamespace());
    }

    private static @Nullable Node maybeGetInnerNameNode(Node maybeFunctionOrClassNode) {
        if (NodeUtil.isFunctionExpression(maybeFunctionOrClassNode)) {
            Node nameNode = maybeFunctionOrClassNode.getFirstChild();
            Preconditions.checkState((boolean)nameNode.isName(), (Object)nameNode);
            return nameNode.getString().isEmpty() ? null : nameNode;
        }
        if (NodeUtil.isClassExpression(maybeFunctionOrClassNode)) {
            Node nameNode = maybeFunctionOrClassNode.getFirstChild();
            return nameNode.isName() ? nameNode : null;
        }
        return null;
    }

    private static void maybeAddPropertiesToWorklist(GlobalNamespace.Name name, Deque<GlobalNamespace.Name> workList) {
        if (!(name.isObjectLiteral() || name.isFunction() || name.isClass())) {
            return;
        }
        if (InlineAndCollapseProperties.isUnsafelyReassigned(name)) {
            return;
        }
        if (name.props == null) {
            return;
        }
        if (name.getAliasingGets() == 0) {
            workList.addAll(name.props);
        } else {
            for (GlobalNamespace.Name property : name.props) {
                if (!property.canCollapse()) continue;
                workList.add(property);
            }
        }
    }

    private static boolean mayBeGlobalAlias(GlobalNamespace.Ref alias) {
        Node aliasLhsNode;
        if (alias.scope.isGlobal()) {
            return true;
        }
        Node aliasParent = alias.getNode().getParent();
        if (!aliasParent.isAssign() && !aliasParent.isName()) {
            return true;
        }
        Node node = aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
        if (!aliasLhsNode.isName()) {
            return true;
        }
        String aliasVarName = aliasLhsNode.getString();
        Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
        if (aliasVar != null) {
            return aliasVar.isGlobal();
        }
        return true;
    }

    private static boolean referencesCollapsibleProperty(ReferenceCollection aliasRefs, GlobalNamespace.Name aliasedName, GlobalNamespace namespace) {
        for (Reference ref : aliasRefs.references) {
            if (ref.getParent() == null || !NodeUtil.isNormalOrOptChainGetProp(ref.getParent())) continue;
            String propertyName = ref.getParent().getString();
            String originalPropertyName = aliasedName.getName() + "." + propertyName;
            GlobalNamespace.Name originalProperty = namespace.getOwnSlot(originalPropertyName);
            if (originalProperty == null || !originalProperty.canCollapse()) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsafelyReassigned(GlobalNamespace.Name name) {
        boolean foundOriginalDefinition = false;
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            if (!ref.isSet() || InlineAndCollapseProperties.isSafeNamespaceReinit(ref)) continue;
            if (!foundOriginalDefinition) {
                foundOriginalDefinition = true;
                continue;
            }
            return true;
        }
        return false;
    }

    private static @Nullable Node getSubclassForEs6Superclass(Node superclass) {
        Node classNode = superclass.getParent();
        Preconditions.checkArgument((boolean)classNode.isClass(), (Object)classNode);
        if (NodeUtil.isNameDeclaration(classNode.getGrandparent())) {
            return classNode.getParent();
        }
        if (superclass.getGrandparent().isAssign()) {
            return classNode.getPrevious();
        }
        if (NodeUtil.isClassDeclaration(classNode)) {
            return classNode.getFirstChild();
        }
        return null;
    }

    static boolean isSafeNamespaceReinit(GlobalNamespace.Ref ref) {
        Node valParent = InlineAndCollapseProperties.getValueParent(ref);
        Node val = valParent.getLastChild();
        if (val != null && val.isOr()) {
            Node maybeName = val.getFirstChild();
            if (ref.getNode().matchesQualifiedName(maybeName)) {
                return true;
            }
        }
        return false;
    }

    private static Node getValueParent(GlobalNamespace.Ref ref) {
        Node n = ref.getNode().getParent();
        return n != null && NodeUtil.isNameDeclaration(n) ? ref.getNode() : ref.getNode().getParent();
    }

    final class InlineAliases
    implements CompilerPass {
        private final Map<String, String> aliases = new LinkedHashMap<String, String>();
        private GlobalNamespace namespace;
        private final AstFactory astFactory;

        InlineAliases() {
            this.astFactory = InlineAndCollapseProperties.this.compiler.createAstFactory();
        }

        @Override
        public void process(Node externs, Node root) {
            this.namespace = new GlobalNamespace(InlineAndCollapseProperties.this.compiler, externs, root);
            NodeTraversal.traverseRoots(InlineAndCollapseProperties.this.compiler, new AliasesCollector(), externs, root);
            NodeTraversal.traverseRoots(InlineAndCollapseProperties.this.compiler, new AliasesInliner(), externs, root);
        }

        private class AliasesInliner
        extends NodeTraversal.ExternsSkippingCallback {
            private AliasesInliner() {
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                switch (n.getToken()) {
                    case NAME: 
                    case GETPROP: {
                        if (!n.isQualifiedName() || !InlineAliases.this.aliases.containsKey(n.getQualifiedName())) break;
                        if (this.isLeftmostNameLocal(t, n)) {
                            return;
                        }
                        if (NodeUtil.isNameDeclOrSimpleAssignLhs(n, parent)) {
                            return;
                        }
                        Node newNode = InlineAliases.this.astFactory.createQName((StaticScope)InlineAliases.this.namespace, this.resolveAlias(n.getQualifiedName(), n));
                        if (this.isLeftmostNameLocal(t, newNode)) {
                            return;
                        }
                        newNode.srcrefTree(n);
                        if (newNode.isGetProp()) {
                            newNode.getFirstChild().makeNonIndexableRecursive();
                        }
                        n.replaceWith(newNode);
                        t.reportCodeChange();
                        break;
                    }
                }
            }

            private boolean isLeftmostNameLocal(NodeTraversal t, Node n) {
                Preconditions.checkState((boolean)n.isQualifiedName());
                String leftmostName = NodeUtil.getRootOfQualifiedName(n).getString();
                Var v = (Var)t.getScope().getVar(leftmostName);
                return v != null && v.isLocal();
            }

            private String resolveAlias(String name, Node n) {
                LinkedHashSet<String> aliasPath = new LinkedHashSet<String>();
                while (InlineAliases.this.aliases.containsKey(name)) {
                    if (!aliasPath.add(name)) {
                        InlineAndCollapseProperties.this.compiler.report(JSError.make(n, ALIAS_CYCLE, ((Object)aliasPath).toString(), name));
                        InlineAliases.this.aliases.remove(name);
                        break;
                    }
                    name = InlineAliases.this.aliases.get(name);
                }
                return name;
            }
        }

        private class AliasesCollector
        extends NodeTraversal.ExternsSkippingCallback {
            private AliasesCollector() {
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                switch (n.getToken()) {
                    case VAR: 
                    case LET: 
                    case CONST: {
                        if (!n.hasOneChild() || !t.inGlobalScope()) break;
                        this.visitAliasDefinition(n.getFirstChild(), NodeUtil.getBestJSDocInfo(n.getFirstChild()));
                        break;
                    }
                    case ASSIGN: {
                        if (parent == null || !parent.isExprResult() || !t.inGlobalScope()) break;
                        this.visitAliasDefinition(n.getFirstChild(), n.getJSDocInfo());
                        break;
                    }
                }
            }

            private void visitAliasDefinition(Node lhs, JSDocInfo info) {
                Node rhs;
                if (this.isDeclaredConst(lhs, info) && (info == null || !info.hasTypeInformation()) && lhs.isQualifiedName() && (rhs = NodeUtil.getRValueOfLValue(lhs)) != null && rhs.isQualifiedName()) {
                    GlobalNamespace.Name lhsName = InlineAliases.this.namespace.getOwnSlot(lhs.getQualifiedName());
                    GlobalNamespace.Name rhsName = InlineAliases.this.namespace.getOwnSlot(rhs.getQualifiedName());
                    if (lhsName != null && lhsName.calculateInlinability().shouldInlineUsages() && rhsName != null && rhsName.calculateInlinability().shouldInlineUsages()) {
                        InlineAliases.this.aliases.put(lhs.getQualifiedName(), rhs.getQualifiedName());
                    }
                }
            }

            private boolean isDeclaredConst(Node lhs, JSDocInfo info) {
                if (info != null && info.hasConstAnnotation()) {
                    return true;
                }
                return lhs.getParent().isConst();
            }
        }
    }

    class CollapseProperties
    implements CompilerPass {
        private Map<String, GlobalNamespace.Name> nameMap;
        private final HashSet<String> dynamicallyImportedModules = new HashSet();

        CollapseProperties() {
        }

        @Override
        public void process(Node externs, Node root) {
            if (InlineAndCollapseProperties.this.propertyCollapseLevel == CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || InlineAndCollapseProperties.this.chunkOutputType == CompilerOptions.ChunkOutputType.ES_MODULES) {
                NodeTraversal.traverse(InlineAndCollapseProperties.this.compiler, root, new FindDynamicallyImportedModules(InlineAndCollapseProperties.this.haveModulesBeenRewritten, InlineAndCollapseProperties.this.moduleResolutionMode));
            }
            this.nameMap = ((GlobalNamespace)Preconditions.checkNotNull((Object)InlineAndCollapseProperties.this.namespace, (Object)"namespace was not initialized")).getNameIndex();
            List<GlobalNamespace.Name> globalNames = InlineAndCollapseProperties.this.namespace.getNameForest();
            ImmutableSet<GlobalNamespace.Name> escaped = this.checkNamespaces();
            for (GlobalNamespace.Name name : globalNames) {
                this.flattenReferencesToCollapsibleDescendantNames(name, name.getBaseName(), (Set<GlobalNamespace.Name>)escaped);
                this.collapseDeclarationOfNameAndDescendants(name, name.getBaseName(), (Set<GlobalNamespace.Name>)escaped);
            }
            new Normalize.PropagateConstantAnnotationsOverVars(InlineAndCollapseProperties.this.compiler, false).process(externs, root);
        }

        private boolean canCollapse(GlobalNamespace.Name name) {
            GlobalNamespace.Inlinability inlinability = name.canCollapseOrInline();
            if (!inlinability.canCollapse()) {
                this.logDecisionForName(name, inlinability, "canCollapse() returns false");
                return false;
            }
            if (InlineAndCollapseProperties.this.propertyCollapseLevel == CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT) {
                if (!name.isModuleExport()) {
                    this.logDecisionForName(name, inlinability, "module export: canCollapse() returns false");
                    return false;
                }
                if (this.dynamicallyImportedModules.contains(name.getBaseName())) {
                    this.logDecisionForName(name, inlinability, "dynamic module export: canCollapse() returns false");
                    return false;
                }
            }
            this.logDecisionForName(name, inlinability, "canCollapse() returns true");
            return true;
        }

        private boolean canEliminate(GlobalNamespace.Name name) {
            if (!name.canEliminate()) {
                return false;
            }
            return name.props == null || name.props.isEmpty() || InlineAndCollapseProperties.this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT;
        }

        private ImmutableSet<GlobalNamespace.Name> checkNamespaces() {
            ImmutableSet.Builder escaped = ImmutableSet.builder();
            HashSet<String> dynamicallyImportedModuleRefs = new HashSet<String>(this.dynamicallyImportedModules);
            if (!this.dynamicallyImportedModules.isEmpty()) {
                for (GlobalNamespace.Name name : this.nameMap.values()) {
                    if (!this.dynamicallyImportedModules.contains(name.getFullName())) continue;
                    this.logDecisionForName(name, "escapes - dynamically imported module namespace");
                    escaped.add((Object)name);
                    if (name.props == null) continue;
                    for (GlobalNamespace.Name prop : name.props) {
                        Node rValue;
                        GlobalNamespace.Ref propDeclaration = prop.getDeclaration();
                        if (propDeclaration == null || propDeclaration.getNode() == null || !(rValue = NodeUtil.getRValueOfLValue(propDeclaration.getNode())).isName()) continue;
                        this.logDecisionForName(name, "escapes - dynamically imported module namespace property alias");
                        dynamicallyImportedModuleRefs.add(rValue.getQualifiedName());
                    }
                }
            }
            block2: for (GlobalNamespace.Name name : this.nameMap.values()) {
                if (!dynamicallyImportedModuleRefs.isEmpty() && dynamicallyImportedModuleRefs.contains(name.getFullName())) {
                    escaped.add((Object)name);
                }
                if (!name.isNamespaceObjectLit() || name.getAliasingGets() == 0 && name.getLocalSets() + name.getGlobalSets() <= 1 && name.getDeleteProps() == 0) continue;
                boolean initialized = name.getDeclaration() != null;
                for (GlobalNamespace.Ref ref : name.getRefs()) {
                    if (ref == name.getDeclaration()) continue;
                    if (ref.type == GlobalNamespace.Ref.Type.DELETE_PROP) {
                        if (!initialized) continue;
                        this.warnAboutNamespaceRedefinition(name, ref);
                        continue;
                    }
                    if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                        if (initialized && !InlineAndCollapseProperties.isSafeNamespaceReinit(ref)) {
                            this.warnAboutNamespaceRedefinition(name, ref);
                        }
                        initialized = true;
                        continue;
                    }
                    if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET) continue;
                    this.warnAboutNamespaceAliasing(name, ref);
                    this.logDecisionForName(name, "escapes");
                    escaped.add((Object)name);
                    continue block2;
                }
            }
            return escaped.build();
        }

        private void warnAboutNamespaceAliasing(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
            InlineAndCollapseProperties.this.compiler.report(JSError.make(ref.getNode(), PARTIAL_NAMESPACE_WARNING, nameObj.getFullName()));
        }

        private void warnAboutNamespaceRedefinition(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
            InlineAndCollapseProperties.this.compiler.report(JSError.make(ref.getNode(), NAMESPACE_REDEFINED_WARNING, nameObj.getFullName()));
        }

        private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name n, String alias, Set<GlobalNamespace.Name> escaped) {
            if (n.props == null) {
                return;
            }
            if (n.isCollapsingExplicitlyDenied()) {
                this.logDecisionForName(n, "@nocollapse: will not flatten descendant name references");
                return;
            }
            if (escaped.contains(n)) {
                this.logDecisionForName(n, "escapes: will not flatten descendant name references");
                return;
            }
            for (GlobalNamespace.Name p : n.props) {
                boolean isAllowedToCollapse;
                String propAlias = this.appendPropForAlias(alias, p.getBaseName());
                GlobalNamespace.Inlinability inlinability = p.canCollapseOrInline();
                boolean bl = isAllowedToCollapse = InlineAndCollapseProperties.this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || p.isModuleExport();
                if (isAllowedToCollapse) {
                    if (inlinability.canCollapse()) {
                        this.logDecisionForName(p, inlinability, "will flatten references");
                        this.flattenReferencesTo(p, propAlias);
                    } else if (p.isCollapsingExplicitlyDenied()) {
                        this.logDecisionForName(p, "@nocollapse: will not flatten references");
                    } else if (p.isSimpleStubDeclaration()) {
                        this.logDecisionForName(p, "simple stub declaration: will flatten references");
                        this.flattenSimpleStubDeclaration(p, propAlias);
                    } else {
                        this.logDecisionForName(p, inlinability, "will not flatten references");
                    }
                }
                this.flattenReferencesToCollapsibleDescendantNames(p, propAlias, escaped);
            }
        }

        private void logDecisionForName(GlobalNamespace.Name name, GlobalNamespace.Inlinability inlinability, String message) {
            this.logDecisionForName(name, () -> SimpleFormat.format("inlinability %s: %s", new Object[]{inlinability, message}));
        }

        private void logDecisionForName(GlobalNamespace.Name name, String message) {
            InlineAndCollapseProperties.this.decisionsLog.log(() -> SimpleFormat.format("%s: %s", name.getFullName(), message));
        }

        private void logDecisionForName(GlobalNamespace.Name name, Supplier<String> messageSupplier) {
            InlineAndCollapseProperties.this.decisionsLog.log(() -> SimpleFormat.format("%s: %s", name.getFullName(), messageSupplier.get()));
        }

        private void flattenSimpleStubDeclaration(GlobalNamespace.Name name, String alias) {
            GlobalNamespace.Ref ref = (GlobalNamespace.Ref)Iterables.getOnlyElement(name.getRefs());
            Node nameNode = NodeUtil.newName(InlineAndCollapseProperties.this.compiler, alias, ref.getNode(), name.getFullName());
            Node varNode = IR.var(nameNode).srcrefIfMissing(nameNode);
            Preconditions.checkState((boolean)ref.getNode().getParent().isExprResult());
            Node parent = ref.getNode().getParent();
            parent.replaceWith(varNode);
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(varNode);
        }

        private void flattenReferencesTo(GlobalNamespace.Name n, String alias) {
            String originalName = n.getFullName();
            for (GlobalNamespace.Ref r : n.getRefs()) {
                if (r == n.getDeclaration()) continue;
                Node rParent = r.getNode().getParent();
                if (!NodeUtil.mayBeObjectLitKey(r.getNode()) && (r.getTwin() == null || r.isSet())) {
                    this.flattenNameRef(alias, r.getNode(), rParent, originalName);
                    continue;
                }
                if (!r.getNode().isStringKey() || !r.getNode().getParent().isObjectPattern()) continue;
                Node newNode = IR.name(alias).srcref(r.getNode());
                NodeUtil.copyNameAnnotations(r.getNode(), newNode);
                DestructuringGlobalNameExtractor.reassignDestructringLvalue(r.getNode(), newNode, null, r, InlineAndCollapseProperties.this.compiler);
            }
            if (n.props != null) {
                for (GlobalNamespace.Name p : n.props) {
                    this.flattenPrefixes(alias, originalName + p.getBaseName(), p, 1);
                }
            }
        }

        private void flattenPrefixes(String alias, String originalName, GlobalNamespace.Name n, int depth) {
            GlobalNamespace.Ref decl = n.getDeclaration();
            if (decl != null && decl.getNode() != null && decl.getNode().isGetProp()) {
                this.flattenNameRefAtDepth(alias, decl.getNode(), depth, originalName);
            }
            for (GlobalNamespace.Ref r : n.getRefs()) {
                if (r == decl || r.getTwin() != null && !r.isSet()) continue;
                this.flattenNameRefAtDepth(alias, r.getNode(), depth, originalName);
            }
            if (n.props != null) {
                for (GlobalNamespace.Name p : n.props) {
                    this.flattenPrefixes(alias, originalName + p.getBaseName(), p, depth + 1);
                }
            }
        }

        private void flattenNameRefAtDepth(String alias, Node n, int depth, String originalName) {
            Token nType = n.getToken();
            boolean isQName = nType == Token.NAME || nType == Token.GETPROP;
            boolean isObjKey = NodeUtil.mayBeObjectLitKey(n);
            Preconditions.checkState((isObjKey || isQName ? 1 : 0) != 0);
            if (isQName) {
                for (int i = 1; i < depth && n.hasChildren(); ++i) {
                    n = n.getFirstChild();
                }
                if (n.isGetProp() && n.getFirstChild().isGetProp()) {
                    this.flattenNameRef(alias, n.getFirstChild(), n, originalName);
                }
            }
        }

        private void flattenNameRef(String alias, Node n, Node parent, String originalName) {
            Preconditions.checkArgument((boolean)n.isGetProp(), (String)"Expected GETPROP, found %s. Node: %s", (Object)((Object)n.getToken()), (Object)n);
            Node ref = NodeUtil.newName(InlineAndCollapseProperties.this.compiler, alias, n, originalName).copyTypeFrom(n);
            NodeUtil.copyNameAnnotations(n, ref);
            if (NodeUtil.isNormalOrOptChainCall(parent) && n.isFirstChildOf(parent)) {
                parent.putBooleanProp(Node.FREE_CALL, true);
            }
            n.replaceWith(ref);
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(ref);
        }

        private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name n, String alias, Set<GlobalNamespace.Name> escaped) {
            boolean canCollapseChildNames;
            GlobalNamespace.Inlinability childNameInlinability = n.canCollapseOrInlineChildNames();
            if (!childNameInlinability.canCollapse()) {
                this.logDecisionForName(n, () -> SimpleFormat.format("child name inlinability: %s: will not collapse child names", new Object[]{childNameInlinability}));
                canCollapseChildNames = false;
            } else if (escaped.contains(n)) {
                this.logDecisionForName(n, "escapes: will not collapse child names");
                canCollapseChildNames = false;
            } else {
                canCollapseChildNames = true;
            }
            if (this.canCollapse(n)) {
                this.logDecisionForName(n, "collapsing");
                this.updateGlobalNameDeclaration(n, alias, canCollapseChildNames);
            }
            if (n.props == null || escaped.contains(n)) {
                return;
            }
            this.logDecisionForName(n, "collapsing descendants");
            for (GlobalNamespace.Name p : n.props) {
                this.collapseDeclarationOfNameAndDescendants(p, this.appendPropForAlias(alias, p.getBaseName()), escaped);
            }
        }

        private void updateTwinnedDeclaration(String alias, GlobalNamespace.Name refName, GlobalNamespace.Ref ref) {
            Preconditions.checkNotNull((Object)ref.getTwin());
            if (!ref.getNode().isGetProp()) {
                return;
            }
            Node rvalue = ref.getNode().getNext();
            Node parent = ref.getNode().getParent();
            Node grandparent = parent.getParent();
            if (rvalue != null && rvalue.isFunction()) {
                this.checkForReceiverAffectedByCollapse(rvalue, refName.getJSDocInfo(), refName);
            }
            Node nameNode = NodeUtil.newName(InlineAndCollapseProperties.this.compiler, alias, grandparent.getFirstChild(), refName.getFullName());
            NodeUtil.copyNameAnnotations(ref.getNode(), nameNode);
            Node current = grandparent;
            Node currentParent = grandparent.getParent();
            while (!currentParent.isScript() && !currentParent.isBlock()) {
                current = currentParent;
                currentParent = currentParent.getParent();
            }
            Node stubVar = IR.var(nameNode.cloneTree()).srcrefIfMissing(nameNode);
            stubVar.insertBefore(current);
            ref.getNode().replaceWith(nameNode);
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(nameNode);
        }

        private void updateGlobalNameDeclaration(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
            GlobalNamespace.Ref decl = n.getDeclaration();
            if (decl == null) {
                this.logDecisionForName(n, "no global declaration found");
                return;
            }
            Node declNode = decl.getNode();
            switch (declNode.getParent().getToken()) {
                case ASSIGN: {
                    this.logDeclarationAction(n, declNode, "updating assignment");
                    this.updateGlobalNameDeclarationAtAssignNode(n, alias, canCollapseChildNames);
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    this.logDeclarationAction(n, declNode, "updating variable declaration");
                    this.updateGlobalNameDeclarationAtVariableNode(n, canCollapseChildNames);
                    break;
                }
                case FUNCTION: {
                    this.logDeclarationAction(n, declNode, "updating function declaration");
                    this.updateGlobalNameDeclarationAtFunctionNode(n, canCollapseChildNames);
                    break;
                }
                case CLASS: {
                    this.logDeclarationAction(n, declNode, "updating class declaration");
                    this.updateGlobalNameDeclarationAtClassNode(n, canCollapseChildNames);
                    break;
                }
                case CLASS_MEMBERS: {
                    this.logDeclarationAction(n, declNode, "updating static member declaration");
                    this.updateGlobalNameDeclarationAtStaticMemberNode(n, alias, canCollapseChildNames);
                    break;
                }
                default: {
                    this.logDeclarationAction(n, declNode, "not updating an unsupported type of declaration node");
                }
            }
        }

        private void logDeclarationAction(GlobalNamespace.Name name, Node declarationNode, String message) {
            this.logDecisionForName(name, () -> SimpleFormat.format("%s: %s", declarationNode, message));
        }

        private void updateGlobalNameDeclarationAtAssignNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
            GlobalNamespace.Ref ref = n.getDeclaration();
            Node rvalue = ref.getNode().getNext();
            if (ref.getTwin() != null) {
                this.updateTwinnedDeclaration(alias, ref.name, ref);
                return;
            }
            Node varNode = new Node(Token.VAR);
            Node varParent = ref.getNode().getAncestor(3);
            Node grandparent = ref.getNode().getAncestor(2);
            boolean isObjLit = rvalue.isObjectLit();
            boolean insertedVarNode = false;
            if (isObjLit && this.canEliminate(n)) {
                grandparent.replaceWith(varNode);
                n.updateRefNode(ref, null);
                insertedVarNode = true;
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(varNode);
            } else if (!n.isSimpleName()) {
                if (rvalue.isFunction()) {
                    this.checkForReceiverAffectedByCollapse(rvalue, n.getJSDocInfo(), n);
                }
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(rvalue);
                rvalue.detach();
                Node nameNode = NodeUtil.newName(InlineAndCollapseProperties.this.compiler, alias, ref.getNode().getAncestor(2), n.getFullName());
                Node constPropNode = ref.getNode();
                JSDocInfo info = NodeUtil.getBestJSDocInfo(ref.getNode().getParent());
                nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, info != null && info.hasConstAnnotation() || constPropNode.getBooleanProp(Node.IS_CONSTANT_NAME));
                if (info != null) {
                    varNode.setJSDocInfo(info);
                }
                varNode.addChildToBack(nameNode);
                nameNode.addChildToFront(rvalue);
                grandparent.replaceWith(varNode);
                n.updateRefNode(ref, nameNode);
                insertedVarNode = true;
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(varNode);
            }
            if (canCollapseChildNames) {
                if (isObjLit) {
                    this.declareVariablesForObjLitValues(n, alias, rvalue, varNode, varNode.getPrevious());
                }
                this.addStubsForUndeclaredProperties(n, alias, varParent, varNode);
            }
            if (insertedVarNode && !varNode.hasChildren()) {
                varNode.detach();
            }
        }

        private void checkForReceiverAffectedByCollapse(Node function, JSDocInfo docInfo, GlobalNamespace.Name name) {
            Preconditions.checkState((boolean)function.isFunction());
            if (docInfo != null) {
                if (docInfo.isConstructorOrInterface()) {
                    return;
                }
                if (docInfo.hasThisType()) {
                    return;
                }
            }
            if (NodeUtil.referencesOwnReceiver(function)) {
                InlineAndCollapseProperties.this.compiler.report(JSError.make(function, RECEIVER_AFFECTED_BY_COLLAPSE, name.getFullName()));
            }
        }

        private void updateGlobalNameDeclarationAtVariableNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
            if (!canCollapseChildNames) {
                this.logDecisionForName(n, "cannot collapse child names: skipping");
                return;
            }
            GlobalNamespace.Ref ref = n.getDeclaration();
            String name = ref.getNode().getString();
            Node rvalue = ref.getNode().getFirstChild();
            Node variableNode = ref.getNode().getParent();
            Node grandparent = variableNode.getParent();
            boolean isObjLit = rvalue.isObjectLit();
            if (isObjLit) {
                this.declareVariablesForObjLitValues(n, name, rvalue, variableNode, variableNode.getPrevious());
            }
            this.addStubsForUndeclaredProperties(n, name, grandparent, variableNode);
            if (isObjLit && this.canEliminate(n)) {
                ref.getNode().detach();
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(variableNode);
                if (!variableNode.hasChildren()) {
                    variableNode.detach();
                }
                n.updateRefNode(ref, null);
            }
        }

        private void updateGlobalNameDeclarationAtFunctionNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
            if (!canCollapseChildNames || !this.canCollapse(n)) {
                return;
            }
            GlobalNamespace.Ref ref = n.getDeclaration();
            String fnName = ref.getNode().getString();
            this.addStubsForUndeclaredProperties(n, fnName, ref.getNode().getAncestor(2), ref.getNode().getParent());
        }

        private void updateGlobalNameDeclarationAtClassNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
            if (!canCollapseChildNames || !this.canCollapse(n)) {
                return;
            }
            GlobalNamespace.Ref ref = n.getDeclaration();
            String className = ref.getNode().getString();
            this.addStubsForUndeclaredProperties(n, className, ref.getNode().getAncestor(2), ref.getNode().getParent());
        }

        private void updateGlobalNameDeclarationAtStaticMemberNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
            GlobalNamespace.Ref declaration = n.getDeclaration();
            Node classNode = declaration.getNode().getGrandparent();
            Preconditions.checkState((boolean)classNode.isClass(), (Object)classNode);
            Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
            if (canCollapseChildNames) {
                this.addStubsForUndeclaredProperties(n, alias, enclosingStatement.getParent(), classNode);
            }
            Node memberFn = declaration.getNode().detach();
            Node fnNode = memberFn.getOnlyChild().detach();
            this.checkForReceiverAffectedByCollapse(fnNode, memberFn.getJSDocInfo(), n);
            Node varDecl = IR.var(NodeUtil.newName(InlineAndCollapseProperties.this.compiler, alias, memberFn), fnNode).srcref(memberFn);
            varDecl.insertBefore(enclosingStatement);
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(varDecl);
            n.updateRefNode(declaration, varDecl.getFirstChild());
        }

        private void declareVariablesForObjLitValues(GlobalNamespace.Name objlitName, String alias, Node objlit, Node varNode, Node nameToAddAfter) {
            int arbitraryNameCounter = 0;
            boolean discardKeys = !objlitName.shouldKeepKeys();
            Node key = objlit.getFirstChild();
            while (key != null) {
                Node nextKey;
                block15: {
                    Node value = key.getFirstChild();
                    nextKey = key.getNext();
                    switch (key.getToken()) {
                        case GETTER_DEF: 
                        case SETTER_DEF: 
                        case COMPUTED_PROP: 
                        case OBJECT_SPREAD: {
                            break block15;
                        }
                        case STRING_KEY: 
                        case MEMBER_FUNCTION_DEF: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected child of OBJECTLIT: " + key.toStringTree());
                        }
                    }
                    boolean isJsIdentifier = !key.isNumber() && TokenStream.isJSIdentifier(key.getString());
                    String propName = isJsIdentifier ? key.getString() : String.valueOf(++arbitraryNameCounter);
                    String qName = objlitName.getFullName() + "." + propName;
                    GlobalNamespace.Name p = this.nameMap.get(qName);
                    if (p == null || this.canCollapse(p)) {
                        String propAlias = this.appendPropForAlias(alias, propName);
                        Node refNode = null;
                        if (discardKeys) {
                            key.detach();
                            value.detach();
                        } else {
                            refNode = IR.name(propAlias);
                            if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                                refNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                            }
                            value.replaceWith(refNode);
                            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(refNode);
                        }
                        Node nameNode = IR.name(propAlias);
                        nameNode.addChildToFront(value);
                        if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                            nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                        }
                        Node newVar = IR.var(nameNode).srcrefTreeIfMissing(key);
                        if (nameToAddAfter != null) {
                            newVar.insertAfter(nameToAddAfter);
                        } else {
                            newVar.insertBefore(varNode);
                        }
                        InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(newVar);
                        nameToAddAfter = newVar;
                        if (isJsIdentifier && p != null) {
                            if (!discardKeys) {
                                p.addAliasingGetClonedFromDeclaration(refNode);
                            }
                            p.updateRefNode(p.getDeclaration(), nameNode);
                            if (value.isFunction()) {
                                this.checkForReceiverAffectedByCollapse(value, key.getJSDocInfo(), p);
                            }
                        }
                    }
                }
                key = nextKey;
            }
        }

        private void addStubsForUndeclaredProperties(GlobalNamespace.Name n, String alias, Node parent, Node addAfter) {
            Preconditions.checkState((boolean)n.canCollapseUnannotatedChildNames(), (Object)n);
            Preconditions.checkArgument((boolean)NodeUtil.isStatementBlock(parent), (Object)parent);
            Preconditions.checkNotNull((Object)addAfter);
            if (n.props == null) {
                return;
            }
            for (GlobalNamespace.Name p : n.props) {
                if (!p.needsToBeStubbed()) continue;
                String propAlias = this.appendPropForAlias(alias, p.getBaseName());
                Node nameNode = IR.name(propAlias);
                Node newVar = IR.var(nameNode).srcrefTreeIfMissing(addAfter);
                newVar.insertAfter(addAfter);
                Node constPropNode = p.getFirstRef().getNode();
                nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, constPropNode.getBooleanProp(Node.IS_CONSTANT_NAME));
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(newVar);
                addAfter = newVar;
            }
        }

        private String appendPropForAlias(String root, String prop) {
            if (prop.indexOf(36) != -1) {
                prop = prop.replace("$", "$0");
            }
            String result = root + "$" + prop;
            int id = 1;
            while (this.nameMap.containsKey(result)) {
                result = root + "$" + prop + "$" + id;
                ++id;
            }
            return result;
        }

        class FindDynamicallyImportedModules
        extends NodeTraversal.AbstractPostOrderCallback {
            private final boolean processCommonJSModules;
            private final ModuleLoader.ResolutionMode moduleResolutionMode;

            FindDynamicallyImportedModules(boolean processCommonJSModules, ModuleLoader.ResolutionMode resolutionMode) {
                this.processCommonJSModules = processCommonJSModules;
                this.moduleResolutionMode = resolutionMode;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                Node moduleNamespace;
                if (this.processCommonJSModules && n.isGetProp() && n.isQualifiedName() && n.getParent() != null && n.getParent().isReturn() && n.getGrandparent().isBlock() && n.getGrandparent().hasOneChild() && n.getGrandparent().getParent().isFunction()) {
                    Node potentialCallback = NodeUtil.getEnclosingFunction(n);
                    if (potentialCallback != null && ProcessCommonJSModules.isCommonJsDynamicImportCallback(NodeUtil.getEnclosingFunction(potentialCallback), this.moduleResolutionMode)) {
                        CollapseProperties.this.dynamicallyImportedModules.add(NodeUtil.getRootOfQualifiedName(n.getQualifiedName()));
                    }
                } else if (ConvertChunksToESModules.isDynamicImportCallback(n) && (moduleNamespace = ConvertChunksToESModules.getDynamicImportCallbackModuleNamespace(InlineAndCollapseProperties.this.compiler, n)) != null) {
                    CollapseProperties.this.dynamicallyImportedModules.add(moduleNamespace.getQualifiedName());
                }
            }
        }
    }

    private static class RewriteSimpleDestructuringAliases
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteSimpleDestructuringAliases() {
        }

        public boolean isSimpleDestructuringAlias(Node n) {
            if (!NodeUtil.isStatement(n) || !n.isConst()) {
                return false;
            }
            Preconditions.checkState((boolean)n.hasOneChild());
            Node destructuringLhs = n.getFirstChild();
            if (!destructuringLhs.isDestructuringLhs()) {
                return false;
            }
            Node objectPattern = destructuringLhs.getFirstChild();
            if (!objectPattern.isObjectPattern()) {
                return false;
            }
            Node rhs = destructuringLhs.getLastChild();
            if (!rhs.isQualifiedName()) {
                return false;
            }
            for (Node key = objectPattern.getFirstChild(); key != null; key = key.getNext()) {
                if (!key.isStringKey() || key.isQuotedString()) {
                    return false;
                }
                Preconditions.checkState((boolean)key.hasOneChild());
                Node identifier = key.getFirstChild();
                if (identifier.isName()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!this.isSimpleDestructuringAlias(n)) {
                return;
            }
            Node insertionPoint = n;
            Node destructuringLhs = n.getFirstChild();
            Node objectPattern = destructuringLhs.getFirstChild();
            Node rhs = destructuringLhs.getLastChild();
            for (Node key = objectPattern.getFirstChild(); key != null; key = key.getNext()) {
                Node identifier = key.getFirstChild();
                Node newRhs = IR.getprop(rhs.cloneTree(), key.getString()).srcref(identifier);
                Node newConstNode = IR.constNode(identifier.detach(), newRhs).srcref(n);
                newConstNode.insertAfter(insertionPoint);
                insertionPoint = newConstNode;
            }
            n.detach();
            t.reportCodeChange();
        }
    }

    class AggressiveInlineAliases
    implements CompilerPass {
        private boolean codeChanged = true;

        AggressiveInlineAliases() {
        }

        @VisibleForTesting
        GlobalNamespace getLastUsedGlobalNamespace() {
            return InlineAndCollapseProperties.this.namespace;
        }

        @Override
        public void process(Node externs, Node root) {
            if (!InlineAndCollapseProperties.this.staticInheritanceUsed) {
                new StaticSuperPropReplacer(InlineAndCollapseProperties.this.compiler).replaceAll(root);
            }
            NodeTraversal.traverse(InlineAndCollapseProperties.this.compiler, root, new RewriteSimpleDestructuringAliases());
            InlineAndCollapseProperties.this.namespace = new GlobalNamespace(InlineAndCollapseProperties.this.decisionsLog, InlineAndCollapseProperties.this.compiler, root);
            while (this.codeChanged) {
                this.codeChanged = false;
                this.inlineAliases(InlineAndCollapseProperties.this.namespace);
            }
        }

        private void inlineAliases(GlobalNamespace namespace) {
            ArrayDeque<GlobalNamespace.Name> workList = new ArrayDeque<GlobalNamespace.Name>(namespace.getNameForest());
            while (!workList.isEmpty()) {
                GlobalNamespace.Name name = (GlobalNamespace.Name)workList.pop();
                if (name.isGetOrSetDefinition()) continue;
                if (!name.inExterns() && name.getGlobalSets() == 1 && name.getLocalSets() == 0) {
                    this.maybeInlineInnerName(name);
                    if (name.getAliasingGets() > 0 || name.getSubclassingGets() > 0) {
                        this.inlineAliasesForName(name, namespace);
                    }
                }
                InlineAndCollapseProperties.maybeAddPropertiesToWorklist(name, workList);
            }
        }

        private void inlineAliasesForName(GlobalNamespace.Name name, GlobalNamespace namespace) {
            ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(name.getRefs());
            for (GlobalNamespace.Ref ref : refs) {
                Scope hoistScope = (Scope)ref.scope.getClosestHoistScope();
                if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && !InlineAndCollapseProperties.mayBeGlobalAlias(ref) && ref.getTwin() == null) {
                    this.inlineAliasIfPossible(name, ref, namespace);
                    continue;
                }
                if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && hoistScope.isGlobal() && ref.getTwin() == null) {
                    this.inlineGlobalAliasIfPossible(name, ref, namespace);
                    continue;
                }
                if (!name.isClass() || ref.type != GlobalNamespace.Ref.Type.SUBCLASSING_GET || name.props == null) continue;
                for (GlobalNamespace.Name prop : name.props) {
                    this.rewriteAllSubclassInheritedAccesses(name, ref, prop, namespace);
                }
            }
        }

        private void maybeInlineInnerName(GlobalNamespace.Name globalName) {
            GlobalNamespace.Ref globalNameDeclaration = (GlobalNamespace.Ref)Preconditions.checkNotNull((Object)globalName.getDeclaration(), (Object)globalName);
            Node globalDeclarationNode = (Node)Preconditions.checkNotNull((Object)globalNameDeclaration.getNode(), (Object)globalNameDeclaration);
            Node valueNode = NodeUtil.getRValueOfLValue(globalDeclarationNode);
            if (valueNode == null) {
                return;
            }
            Node innerNameNode = InlineAndCollapseProperties.maybeGetInnerNameNode(valueNode);
            if (innerNameNode == null) {
                return;
            }
            String innerName = innerNameNode.getString();
            SyntacticScopeCreator syntacticScopeCreator = new SyntacticScopeCreator(InlineAndCollapseProperties.this.compiler);
            Scope innerScope = syntacticScopeCreator.createScope(valueNode, globalNameDeclaration.scope);
            Var innerNameVar = (Var)Preconditions.checkNotNull((Object)((Var)innerScope.getVar(innerName)));
            ReferenceCollector collector = new ReferenceCollector(InlineAndCollapseProperties.this.compiler, ReferenceCollector.DO_NOTHING_BEHAVIOR, syntacticScopeCreator, (Predicate<Var>)Predicates.equalTo((Object)innerNameVar));
            collector.processScope(innerScope);
            ReferenceCollection innerNameRefs = collector.getReferences(innerNameVar);
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            for (Reference innerNameRef : innerNameRefs) {
                Node innerNameRefNode = innerNameRef.getNode();
                if (!NodeUtil.isNormalGet(innerNameRefNode.getParent())) continue;
                newNodes.add(this.replaceAliasReference(globalNameDeclaration, innerNameRef));
            }
            InlineAndCollapseProperties.this.namespace.scanNewNodes(newNodes);
        }

        private boolean rewriteAllSubclassInheritedAccesses(GlobalNamespace.Name superclassNameObj, GlobalNamespace.Ref superclassRef, GlobalNamespace.Name prop, GlobalNamespace namespace) {
            if (!prop.canCollapse()) {
                return false;
            }
            Node subclass = InlineAndCollapseProperties.getSubclassForEs6Superclass(superclassRef.getNode());
            if (subclass == null || !subclass.isQualifiedName()) {
                return false;
            }
            String subclassName = subclass.getQualifiedName();
            String subclassQualifiedPropName = subclassName + "." + prop.getBaseName();
            GlobalNamespace.Name subclassPropNameObj = namespace.getOwnSlot(subclassQualifiedPropName);
            if (subclassPropNameObj != null && (subclassPropNameObj.getLocalSets() > 0 || subclassPropNameObj.getGlobalSets() > 0)) {
                return false;
            }
            GlobalNamespace.Name subclassNameObj = namespace.getOwnSlot(subclassName);
            if (subclassNameObj != null && subclassNameObj.subclassingGetCount() > 0) {
                for (GlobalNamespace.Ref ref : subclassNameObj.getRefs()) {
                    if (ref.type != GlobalNamespace.Ref.Type.SUBCLASSING_GET) continue;
                    this.rewriteAllSubclassInheritedAccesses(superclassNameObj, ref, prop, namespace);
                }
            }
            if (subclassPropNameObj != null) {
                LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
                Node superclassNameNode = superclassNameObj.getDeclaration().getNode();
                if (superclassNameNode.isName()) {
                    superclassNameNode = superclassNameNode.cloneNode();
                } else if (superclassNameNode.isGetProp()) {
                    superclassNameNode = superclassNameNode.cloneTree();
                } else {
                    return false;
                }
                this.rewriteNestedAliasReference(superclassNameNode, 0, newNodes, subclassPropNameObj);
                namespace.scanNewNodes(newNodes);
            }
            return true;
        }

        private void inlineAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
            Node aliasParent = alias.getNode().getParent();
            if (aliasParent.isName() || aliasParent.isAssign()) {
                Node aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
                String aliasVarName = aliasLhsNode.getString();
                Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
                Preconditions.checkState((aliasVar != null ? 1 : 0) != 0, (String)"Expected variable to be defined in scope (%s)", (Object)aliasVarName);
                ReferenceCollector collector = new ReferenceCollector(InlineAndCollapseProperties.this.compiler, ReferenceCollector.DO_NOTHING_BEHAVIOR, new SyntacticScopeCreator(InlineAndCollapseProperties.this.compiler), (Predicate<Var>)Predicates.equalTo((Object)aliasVar));
                Scope aliasScope = (Scope)aliasVar.getScope();
                collector.processScope(aliasScope);
                ReferenceCollection aliasRefs = collector.getReferences(aliasVar);
                LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
                if (aliasRefs.isWellDefined() && aliasRefs.isAssignedOnceInLifetime()) {
                    int firstRead;
                    int size = aliasRefs.references.size();
                    for (int i = firstRead = aliasRefs.references.get(0).isInitializingDeclaration() ? 1 : 2; i < size; ++i) {
                        Reference aliasRef = aliasRefs.references.get(i);
                        newNodes.add(this.replaceAliasReference(alias, aliasRef));
                    }
                    this.tryReplacingAliasingAssignment(alias, aliasLhsNode);
                    namespace.scanNewNodes(newNodes);
                    return;
                }
                if (name.isConstructor() && !this.partiallyInlineAlias(alias, namespace, aliasRefs, aliasLhsNode) && InlineAndCollapseProperties.referencesCollapsibleProperty(aliasRefs, name, namespace)) {
                    InlineAndCollapseProperties.this.compiler.report(JSError.make(aliasParent, UNSAFE_CTOR_ALIASING, aliasVarName));
                }
            }
        }

        private boolean partiallyInlineAlias(GlobalNamespace.Ref alias, GlobalNamespace namespace, ReferenceCollection aliasRefs, Node aliasLhsNode) {
            BasicBlock aliasBlock = null;
            for (Reference aliasRef : aliasRefs) {
                Node aliasRefNode = aliasRef.getNode();
                if (aliasRefNode == aliasLhsNode) {
                    aliasBlock = aliasRef.getBasicBlock();
                    continue;
                }
                if (!aliasRef.isLvalue()) continue;
                return false;
            }
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            boolean alreadySeenInitialAlias = false;
            boolean foundNonReplaceableAlias = false;
            for (Reference aliasRef : aliasRefs) {
                Node aliasRefNode = aliasRef.getNode();
                if (aliasRefNode == aliasLhsNode) {
                    alreadySeenInitialAlias = true;
                    continue;
                }
                if (aliasRef.isDeclaration()) continue;
                BasicBlock refBlock = aliasRef.getBasicBlock();
                if (refBlock != aliasBlock && aliasBlock.provablyExecutesBefore(refBlock) || refBlock == aliasBlock && alreadySeenInitialAlias) {
                    this.codeChanged = true;
                    newNodes.add(this.replaceAliasReference(alias, aliasRef));
                    continue;
                }
                foundNonReplaceableAlias = true;
            }
            if (!foundNonReplaceableAlias) {
                this.tryReplacingAliasingAssignment(alias, aliasLhsNode);
            }
            if (this.codeChanged) {
                namespace.scanNewNodes(newNodes);
            }
            return !foundNonReplaceableAlias;
        }

        private boolean tryReplacingAliasingAssignment(GlobalNamespace.Ref alias, Node aliasLhsNode) {
            Node assignment = aliasLhsNode.getParent();
            if (!NodeUtil.isNameDeclaration(assignment) && NodeUtil.isExpressionResultUsed(assignment)) {
                return false;
            }
            Node aliasParent = alias.getNode().getParent();
            alias.getNode().replaceWith(IR.nullNode());
            alias.name.removeRef(alias);
            this.codeChanged = true;
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(aliasParent);
            return true;
        }

        private GlobalNamespace.AstChange replaceAliasReference(GlobalNamespace.Ref alias, Reference aliasRef) {
            Node originalRefNode = alias.getNode();
            Node nodeToReplace = aliasRef.getNode();
            Preconditions.checkState((boolean)nodeToReplace.isQualifiedName(), (Object)nodeToReplace);
            Node newNode = originalRefNode.isName() ? originalRefNode.cloneNode() : originalRefNode.cloneTree();
            newNode.srcrefTree(nodeToReplace);
            nodeToReplace.replaceWith(newNode);
            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(newNode);
            return new GlobalNamespace.AstChange(aliasRef.getScope(), newNode);
        }

        private void inlineGlobalAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
            Node aliasParent = alias.getNode().getParent();
            if ((aliasParent.isAssign() || aliasParent.isName()) && NodeUtil.isExecutedExactlyOnce(aliasParent) || aliasParent.isName() && name.isConstructor()) {
                Node lvalue;
                Node node = lvalue = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
                if (!lvalue.isQualifiedName()) {
                    return;
                }
                if (lvalue.isName() && InlineAndCollapseProperties.this.compiler.getCodingConvention().isExported(lvalue.getString(), false)) {
                    return;
                }
                GlobalNamespace.Name aliasingName = namespace.getSlot(lvalue.getQualifiedName());
                if (aliasingName == null) {
                    return;
                }
                if (name.equals(aliasingName) && aliasParent.isAssign()) {
                    return;
                }
                GlobalNamespace.Inlinability aliasInlinability = aliasingName.calculateInlinability();
                if (!aliasInlinability.shouldInlineUsages()) {
                    return;
                }
                LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
                this.rewriteAliasReferences(aliasingName, alias, newNodes);
                this.rewriteAliasProps(aliasingName, alias.getNode(), 0, newNodes);
                if (aliasInlinability.shouldRemoveDeclaration()) {
                    GlobalNamespace.Ref aliasDeclaration = aliasingName.getDeclaration();
                    if (aliasDeclaration.getTwin() != null) {
                        Preconditions.checkState((boolean)aliasParent.isAssign(), (Object)aliasParent);
                        Node aliasGrandparent = aliasParent.getParent();
                        aliasParent.replaceWith(alias.getNode().detach());
                        aliasingName.removeTwinRefs(aliasDeclaration);
                        newNodes.add(new GlobalNamespace.AstChange(alias.scope, alias.getNode()));
                        InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(aliasGrandparent);
                    } else {
                        alias.getNode().replaceWith(IR.nullNode());
                        InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(aliasParent);
                    }
                    this.codeChanged = true;
                    name.removeRef(alias);
                }
                namespace.scanNewNodes(newNodes);
            }
        }

        private void rewriteAliasReferences(GlobalNamespace.Name aliasingName, GlobalNamespace.Ref aliasingRef, Set<GlobalNamespace.AstChange> newNodes) {
            ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(aliasingName.getRefs());
            block4: for (GlobalNamespace.Ref ref : refs) {
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        continue block4;
                    }
                    case DIRECT_GET: 
                    case ALIASING_GET: 
                    case PROTOTYPE_GET: 
                    case CALL_GET: 
                    case SUBCLASSING_GET: {
                        if (ref.getTwin() != null) {
                            Preconditions.checkState((ref.type == GlobalNamespace.Ref.Type.ALIASING_GET ? 1 : 0) != 0, (Object)ref);
                            continue block4;
                        }
                        if (ref.getNode().isStringKey()) {
                            DestructuringGlobalNameExtractor.reassignDestructringLvalue(ref.getNode(), aliasingRef.getNode().cloneTree(), newNodes, ref, InlineAndCollapseProperties.this.compiler);
                        } else {
                            Preconditions.checkState((ref.getNode().isGetProp() || ref.getNode().isName() ? 1 : 0) != 0);
                            Node newNode = aliasingRef.getNode().cloneTree();
                            Node node = ref.getNode();
                            newNode.srcref(node);
                            node.replaceWith(newNode);
                            InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(newNode);
                            newNodes.add(new GlobalNamespace.AstChange(ref.scope, newNode));
                        }
                        aliasingName.removeRef(ref);
                        continue block4;
                    }
                }
                throw new IllegalStateException();
            }
        }

        private void rewriteAliasProps(GlobalNamespace.Name name, Node value, int depth, Set<GlobalNamespace.AstChange> newNodes) {
            if (name.props == null) {
                return;
            }
            Preconditions.checkState((!value.matchesQualifiedName(name.getFullName()) ? 1 : 0) != 0, (String)"%s should not match name %s", (Object)value, (Object)name.getFullName());
            for (GlobalNamespace.Name prop : name.props) {
                this.rewriteNestedAliasReference(value, depth, newNodes, prop);
            }
        }

        private void rewriteNestedAliasReference(Node value, int depth, Set<GlobalNamespace.AstChange> newNodes, GlobalNamespace.Name prop) {
            this.rewriteAliasProps(prop, value, depth + 1, newNodes);
            ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(prop.getRefs());
            for (GlobalNamespace.Ref ref : refs) {
                Node target = ref.getNode();
                if (target.isStringKey() && target.getParent().isDestructuringPattern()) {
                    Preconditions.checkState((target.getGrandparent().isAssign() || target.getGrandparent().isDestructuringLhs() ? 1 : 0) != 0, (String)"Did not expect GlobalNamespace to create Ref for key in nested object pattern %s", (Object)target);
                    continue;
                }
                for (int i = 0; i <= depth; ++i) {
                    if (target.isGetProp()) {
                        target = target.getFirstChild();
                        continue;
                    }
                    if (NodeUtil.isObjectLitKey(target)) {
                        Node gparent = target.getGrandparent();
                        if (gparent.isAssign()) {
                            target = gparent.getFirstChild();
                            continue;
                        }
                        Preconditions.checkState((boolean)NodeUtil.isObjectLitKey(gparent));
                        target = gparent;
                        continue;
                    }
                    throw new IllegalStateException("unexpected node: " + target);
                }
                Preconditions.checkState((target.isGetProp() || target.isName() ? 1 : 0) != 0);
                Node newValue = value.cloneTree();
                target.replaceWith(newValue);
                InlineAndCollapseProperties.this.compiler.reportChangeToEnclosingScope(newValue);
                prop.removeRef(ref);
                newNodes.add(new GlobalNamespace.AstChange(ref.scope, ref.getNode()));
                this.codeChanged = true;
            }
        }
    }

    static final class Builder {
        final AbstractCompiler compiler;
        private CompilerOptions.PropertyCollapseLevel propertyCollapseLevel;
        private CompilerOptions.ChunkOutputType chunkOutputType;
        private boolean haveModulesBeenRewritten;
        private ModuleLoader.ResolutionMode moduleResolutionMode;
        private boolean testAggressiveInliningOnly = false;
        private Optional<Consumer<GlobalNamespace>> optionalGlobalNamespaceTester = Optional.empty();
        private boolean staticInheritanceUsed = false;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @CanIgnoreReturnValue
        public Builder setPropertyCollapseLevel(CompilerOptions.PropertyCollapseLevel propertyCollapseLevel) {
            this.propertyCollapseLevel = propertyCollapseLevel;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setChunkOutputType(CompilerOptions.ChunkOutputType chunkOutputType) {
            this.chunkOutputType = chunkOutputType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHaveModulesBeenRewritten(boolean haveModulesBeenRewritten) {
            this.haveModulesBeenRewritten = haveModulesBeenRewritten;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setModuleResolutionMode(ModuleLoader.ResolutionMode moduleResolutionMode) {
            this.moduleResolutionMode = moduleResolutionMode;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        public Builder testAggressiveInliningOnly(Consumer<GlobalNamespace> globalNamespaceTester) {
            this.testAggressiveInliningOnly = true;
            this.optionalGlobalNamespaceTester = Optional.of(globalNamespaceTester);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAssumeStaticInheritanceIsNotUsed(boolean assumeStaticInheritanceIsNotUsed) {
            this.staticInheritanceUsed = !assumeStaticInheritanceIsNotUsed;
            return this;
        }

        InlineAndCollapseProperties build() {
            return new InlineAndCollapseProperties(this);
        }
    }
}

