/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.TemplateType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

final class FunctionTypeBuilder {
    private final String fnName;
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final Node errorRoot;
    private FunctionContents contents = UnknownFunctionContents.get();
    private String syntacticFnName;
    private @Nullable JSType returnType = null;
    private boolean returnTypeInferred = false;
    private @Nullable List<ObjectType> implementedInterfaces = null;
    private @Nullable List<ObjectType> extendedInterfaces = null;
    private @Nullable ObjectType baseType = null;
    private @Nullable JSType thisType = null;
    private boolean isClass = false;
    private boolean isConstructor = false;
    private boolean makesStructs = false;
    private boolean makesUnrestricted = false;
    private boolean makesDicts = false;
    private boolean isInterface = false;
    private boolean isRecord = false;
    private boolean isAbstract = false;
    private boolean isKnownAmbiguous = false;
    private @Nullable ImmutableList<FunctionType.Parameter> parameters = null;
    private @Nullable ClosurePrimitive closurePrimitiveId = null;
    private ImmutableList<TemplateType> templateTypeNames = ImmutableList.of();
    private ImmutableList<TemplateType> constructorTemplateTypeNames = ImmutableList.of();
    private @Nullable TypedScope declarationScope = null;
    private StaticTypedScope templateScope;
    static final DiagnosticType EXTENDS_WITHOUT_TYPEDEF = DiagnosticType.warning("JSC_EXTENDS_WITHOUT_TYPEDEF", "@extends used without @constructor or @interface for {0}");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} @extends non-object type {1}");
    static final DiagnosticType RESOLVED_TAG_EMPTY = DiagnosticType.warning("JSC_RESOLVED_TAG_EMPTY", "Could not resolve type in {0} tag of {1}");
    static final DiagnosticType CONSTRUCTOR_REQUIRED = DiagnosticType.warning("JSC_CONSTRUCTOR_REQUIRED", "{0} used without @constructor for {1}");
    static final DiagnosticType VAR_ARGS_MUST_BE_LAST = DiagnosticType.warning("JSC_VAR_ARGS_MUST_BE_LAST", "variable length argument must be last");
    static final DiagnosticType OPTIONAL_ARG_AT_END = DiagnosticType.warning("JSC_OPTIONAL_ARG_AT_END", "optional arguments must be at the end");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType TYPE_REDEFINITION = DiagnosticType.warning("JSC_TYPE_REDEFINITION", "attempted re-definition of type {0}\nfound   : {1}\nexpected: {2}");
    static final DiagnosticType TEMPLATE_TRANSFORMATION_ON_CLASS = DiagnosticType.warning("JSC_TEMPLATE_TRANSFORMATION_ON_CLASS", "Template type transformation {0} not allowed on classes or interfaces");
    static final DiagnosticType TEMPLATE_TYPE_ILLEGAL_BOUND = DiagnosticType.error("JSC_TEMPLATE_TYPE_ILLEGAL_BOUND", "Illegal upper bound ''{0}'' on template type parameter {1}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(EXTENDS_WITHOUT_TYPEDEF, EXTENDS_NON_OBJECT, RESOLVED_TAG_EMPTY, CONSTRUCTOR_REQUIRED, VAR_ARGS_MUST_BE_LAST, OPTIONAL_ARG_AT_END, INEXISTENT_PARAM, TYPE_REDEFINITION, TEMPLATE_TRANSFORMATION_ON_CLASS, TEMPLATE_TYPE_ILLEGAL_BOUND, TypeCheck.SAME_INTERFACE_MULTIPLE_IMPLEMENTS);

    private ExtendedTypeValidator createExtendedTypeValidator() {
        return new ExtendedTypeValidator(this.errorRoot, this.compiler, this.formatFnName());
    }

    private ImplementedTypeValidator createImplementedTypeValidator() {
        return new ImplementedTypeValidator(this.errorRoot, this.compiler, this.formatFnName());
    }

    FunctionTypeBuilder(String fnName, AbstractCompiler compiler, Node errorRoot, TypedScope scope) {
        Preconditions.checkNotNull((Object)errorRoot);
        this.fnName = Strings.nullToEmpty((String)fnName);
        this.codingConvention = compiler.getCodingConvention();
        this.typeRegistry = compiler.getTypeRegistry();
        this.errorRoot = errorRoot;
        this.compiler = compiler;
        this.templateScope = scope;
    }

    String formatFnName() {
        return this.fnName.isEmpty() ? "<anonymous>" : this.fnName;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder setSyntacticFunctionName(String syntacticFnName) {
        this.syntacticFnName = Strings.nullToEmpty((String)syntacticFnName);
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder setContents(@Nullable FunctionContents contents) {
        if (contents != null) {
            this.contents = contents;
        }
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder setDeclarationScope(TypedScope declarationScope) {
        this.declarationScope = declarationScope;
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferFromOverriddenFunction(@Nullable FunctionType oldType, @Nullable Node paramsParent) {
        if (oldType == null) {
            return this;
        }
        this.templateTypeNames = oldType.getTemplateTypeMap().getTemplateKeys();
        this.returnType = oldType.getReturnType();
        this.returnTypeInferred = oldType.isReturnTypeInferred();
        if (paramsParent == null) {
            this.parameters = oldType.getParameters();
            if (this.parameters == null) {
                this.parameters = new FunctionParamBuilder(this.typeRegistry).build();
            }
        } else {
            FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.typeRegistry);
            UnmodifiableIterator oldParams = oldType.getParameters().iterator();
            boolean warnedAboutArgList = false;
            boolean oldParamsListHitOptArgs = false;
            for (Node currentParam = paramsParent.getFirstChild(); currentParam != null; currentParam = currentParam.getNext()) {
                if (oldParams.hasNext()) {
                    FunctionType.Parameter oldParam = (FunctionType.Parameter)oldParams.next();
                    oldParamsListHitOptArgs = oldParamsListHitOptArgs || oldParam.isVariadic() || oldParam.isOptional();
                    boolean isOptionalArg = oldParam.isOptional();
                    boolean isVarArgs = oldParam.isVariadic();
                    if (currentParam.getNext() != null && isVarArgs) {
                        isVarArgs = false;
                        isOptionalArg = true;
                    }
                    if (currentParam.isDefaultValue()) {
                        isOptionalArg = true;
                    }
                    paramBuilder.newParameterFrom(FunctionType.Parameter.create(oldParam.getJSType(), isOptionalArg, isVarArgs));
                    continue;
                }
                warnedAboutArgList |= this.addParameter(paramBuilder, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE), warnedAboutArgList, this.codingConvention.isOptionalParameter(currentParam) || oldParamsListHitOptArgs || currentParam.isDefaultValue(), this.codingConvention.isVarArgsParameter(currentParam));
            }
            while (oldParams.hasNext()) {
                paramBuilder.newOptionalParameterFrom((FunctionType.Parameter)oldParams.next());
            }
            this.parameters = paramBuilder.build();
        }
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferReturnType(@Nullable JSDocInfo info, boolean fromInlineDoc) {
        if (info != null) {
            JSTypeExpression returnTypeExpr;
            JSTypeExpression jSTypeExpression = returnTypeExpr = fromInlineDoc ? info.getType() : info.getReturnType();
            if (returnTypeExpr != null) {
                this.returnType = returnTypeExpr.evaluate(this.templateScope, this.typeRegistry);
                this.returnTypeInferred = false;
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder usingClassSyntax() {
        this.isClass = true;
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferKind(@Nullable JSDocInfo info) {
        if (info != null) {
            if (!NodeUtil.isMethodDeclaration(this.errorRoot)) {
                this.isConstructor = info.isConstructor();
                this.isInterface = info.isInterface();
                this.isRecord = info.usesImplicitMatch();
                this.makesStructs = info.makesStructs();
                this.makesUnrestricted = info.makesUnrestricted();
                this.makesDicts = info.makesDicts();
            }
            this.isAbstract = info.isAbstract();
        }
        if (this.isClass) {
            this.isConstructor = !this.isInterface;
            boolean bl = this.makesStructs = info == null || !this.makesDicts && !info.makesUnrestricted();
        }
        if (this.makesStructs && !this.isConstructor && !this.isInterface) {
            this.reportWarning(CONSTRUCTOR_REQUIRED, "@struct", this.formatFnName());
        } else if (this.makesDicts && !this.isConstructor) {
            this.reportWarning(CONSTRUCTOR_REQUIRED, "@dict", this.formatFnName());
        }
        return this;
    }

    private boolean maybeUseNativeClassTemplateNames(JSDocInfo info) {
        ImmutableList<TemplateType> nativeKeys = this.typeRegistry.maybeGetTemplateTypesOfBuiltin(this.declarationScope, this.fnName);
        if (nativeKeys != null && info.getTemplateTypeNames().size() == nativeKeys.size()) {
            this.templateTypeNames = nativeKeys;
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferInheritance(@Nullable JSDocInfo info, @Nullable ObjectType classExtendsType) {
        if (info != null && info.hasBaseType()) {
            if (this.isConstructor || this.isInterface) {
                JSType infoBaseType = info.getBaseType().evaluate(this.templateScope, this.typeRegistry);
                if (!FunctionTypeBuilder.areCompatibleExtendsTypes(infoBaseType.toMaybeObjectType(), classExtendsType)) {
                    this.isKnownAmbiguous = true;
                }
                if (infoBaseType.setValidator(this.createExtendedTypeValidator())) {
                    this.baseType = infoBaseType.toObjectType();
                }
            } else {
                this.reportWarning(EXTENDS_WITHOUT_TYPEDEF, this.formatFnName());
                this.isKnownAmbiguous = true;
            }
        } else if (classExtendsType != null && (this.isConstructor || this.isInterface)) {
            this.baseType = classExtendsType;
        }
        if (info != null && info.getImplementedInterfaceCount() > 0) {
            if (this.isConstructor) {
                this.implementedInterfaces = new ArrayList<ObjectType>();
                for (JSTypeExpression t : info.getImplementedInterfaces()) {
                    JSType maybeInterType = t.evaluate(this.templateScope, this.typeRegistry);
                    if (!maybeInterType.setValidator(this.createImplementedTypeValidator())) continue;
                    this.implementedInterfaces.add((ObjectType)maybeInterType);
                }
            } else if (this.isInterface) {
                this.reportWarning(TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, this.formatFnName());
            } else {
                this.reportWarning(CONSTRUCTOR_REQUIRED, "@implements", this.formatFnName());
            }
        }
        if (this.isInterface) {
            this.extendedInterfaces = new ArrayList<ObjectType>();
            if (info != null) {
                for (JSTypeExpression t : info.getExtendedInterfaces()) {
                    boolean isValid;
                    JSType maybeInterfaceType = t.evaluate(this.templateScope, this.typeRegistry);
                    if (maybeInterfaceType != null && (isValid = maybeInterfaceType.setValidator(this.createExtendedTypeValidator())) && maybeInterfaceType.toMaybeObjectType() != null) {
                        this.extendedInterfaces.add(maybeInterfaceType.toMaybeObjectType());
                    }
                    if (classExtendsType == null || !maybeInterfaceType.isSubtypeOf(classExtendsType)) continue;
                    classExtendsType = null;
                }
            }
            if (classExtendsType != null && classExtendsType.setValidator(this.createExtendedTypeValidator())) {
                this.extendedInterfaces.add(classExtendsType);
            }
        }
        return this;
    }

    private static boolean areCompatibleExtendsTypes(ObjectType annotated, @Nullable ObjectType extendsClause) {
        if (extendsClause == null || JSCompObjects.identical(annotated, extendsClause)) {
            return true;
        }
        return annotated.isTemplatizedType() && JSCompObjects.identical(annotated.toMaybeTemplatizedType().getReferencedType(), extendsClause);
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferThisType(JSDocInfo info, JSType type) {
        ObjectType objType;
        this.inferThisType(info);
        if (!(this.thisType != null || (objType = ObjectType.cast(type)) == null || info != null && info.hasType())) {
            this.thisType = objType;
        }
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferThisType(JSDocInfo info) {
        JSType maybeThisType;
        if (info != null && info.hasThisType() && (maybeThisType = info.getThisType().evaluate(this.templateScope, this.typeRegistry).restrictByNotNullOrUndefined()) != null) {
            this.thisType = maybeThisType;
        }
        return this;
    }

    FunctionTypeBuilder inferParameterTypes(JSDocInfo info) {
        Node lp = IR.paramList(new Node[0]);
        for (String name : info.getParameterNames()) {
            lp.addChildToBack(IR.name(name));
        }
        return this.inferParameterTypes(lp, info);
    }

    FunctionTypeBuilder inferParameterTypes(@Nullable Node paramsParent, @Nullable JSDocInfo info) {
        UnmodifiableIterator oldParameters;
        if (paramsParent == null) {
            if (info == null) {
                return this;
            }
            return this.inferParameterTypes(info);
        }
        FunctionType.Parameter oldParameterType = null;
        if (this.parameters != null) {
            oldParameters = this.parameters.iterator();
            oldParameterType = oldParameters.hasNext() ? (FunctionType.Parameter)oldParameters.next() : null;
        } else {
            oldParameters = Collections.emptyIterator();
        }
        FunctionParamBuilder builder = new FunctionParamBuilder(this.typeRegistry);
        boolean warnedAboutArgList = false;
        HashSet allJsDocParams = info == null ? new HashSet() : new HashSet<String>(info.getParameterNames());
        boolean isVarArgs = false;
        int paramIndex = 0;
        for (Node param = paramsParent.getFirstChild(); param != null; param = param.getNext()) {
            JSTypeExpression parameterTypeExpression;
            Node paramLhs;
            boolean isOptionalParam = false;
            if (param.isRest()) {
                isVarArgs = true;
                paramLhs = param.getOnlyChild();
            } else if (param.isDefaultValue()) {
                paramLhs = (Node)Preconditions.checkNotNull((Object)param.getFirstChild(), (Object)param);
                isOptionalParam = true;
            } else {
                isVarArgs = this.isVarArgsParameterByConvention(param);
                isOptionalParam = this.isOptionalParameterByConvention(param);
                paramLhs = param;
            }
            String paramName = null;
            if (paramLhs.isName()) {
                paramName = paramLhs.getString();
            } else {
                Preconditions.checkState((boolean)paramLhs.isDestructuringPattern());
                if (info != null) {
                    paramName = info.getParameterNameAt(paramIndex);
                }
            }
            allJsDocParams.remove(paramName);
            JSType parameterType = null;
            if (info != null && info.hasParameterType(paramName)) {
                parameterTypeExpression = info.getParameterType(paramName);
                parameterType = parameterTypeExpression.evaluate(this.templateScope, this.typeRegistry);
                isOptionalParam = isOptionalParam || parameterTypeExpression.isOptionalArg();
                isVarArgs = isVarArgs || parameterTypeExpression.isVarArgs();
            } else if (paramLhs.getJSDocInfo() != null && paramLhs.getJSDocInfo().hasType()) {
                parameterTypeExpression = paramLhs.getJSDocInfo().getType();
                parameterType = parameterTypeExpression.evaluate(this.templateScope, this.typeRegistry);
                isOptionalParam = parameterTypeExpression.isOptionalArg();
                isVarArgs = parameterTypeExpression.isVarArgs();
            } else if (oldParameterType != null && oldParameterType.getJSType() != null) {
                parameterType = oldParameterType.getJSType();
                isOptionalParam = oldParameterType.isOptional();
                isVarArgs = oldParameterType.isVariadic();
            } else {
                parameterType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            warnedAboutArgList |= this.addParameter(builder, parameterType, warnedAboutArgList, isOptionalParam, isVarArgs);
            oldParameterType = oldParameters.hasNext() ? (FunctionType.Parameter)oldParameters.next() : null;
            ++paramIndex;
        }
        if (!isVarArgs) {
            while (oldParameterType != null && !isVarArgs) {
                builder.newParameterFrom(oldParameterType);
                oldParameterType = oldParameters.hasNext() ? (FunctionType.Parameter)oldParameters.next() : null;
            }
        }
        for (String inexistentName : allJsDocParams) {
            this.reportWarning(INEXISTENT_PARAM, inexistentName, this.formatFnName());
        }
        this.parameters = builder.build();
        return this;
    }

    private void registerTemplates(Iterable<TemplateType> templates, @Nullable Node scopeRoot) {
        if (!Iterables.isEmpty(templates)) {
            this.templateScope = this.typeRegistry.createScopeWithTemplates(this.templateScope, templates);
            if (scopeRoot != null) {
                this.typeRegistry.registerTemplateTypeNamesInScope(templates, scopeRoot);
            }
        }
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferConstructorParameters(Node argsParent, @Nullable JSDocInfo info) {
        if (info != null) {
            this.setConstructorTemplateTypeNames((List<TemplateType>)this.buildTemplateTypesFromJSDocInfo(info, true), argsParent.getParent());
        }
        this.inferParameterTypes(argsParent, info);
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferImplicitConstructorParameters(ImmutableList<FunctionType.Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferClosurePrimitive(@Nullable JSDocInfo info) {
        if (info != null && info.hasClosurePrimitiveId()) {
            this.closurePrimitiveId = ClosurePrimitive.fromStringId(info.getClosurePrimitiveId());
        }
        return this;
    }

    private void setConstructorTemplateTypeNames(List<TemplateType> templates, @Nullable Node ctor) {
        if (!templates.isEmpty()) {
            this.constructorTemplateTypeNames = ImmutableList.copyOf(templates);
            this.templateTypeNames = this.templateTypeNames.isEmpty() ? ImmutableList.copyOf(templates) : ImmutableList.builder().addAll(this.templateTypeNames).addAll(this.constructorTemplateTypeNames).build();
            this.registerTemplates(templates, ctor);
        }
    }

    private boolean isOptionalParameterByConvention(Node param) {
        if (param.isDestructuringPattern()) {
            return false;
        }
        return this.codingConvention.isOptionalParameter(param);
    }

    private boolean isVarArgsParameterByConvention(Node param) {
        if (param.isDestructuringPattern()) {
            return false;
        }
        return this.codingConvention.isVarArgsParameter(param);
    }

    private ImmutableList<TemplateType> buildTemplateTypesFromJSDocInfo(JSDocInfo info, boolean allowTypeTransformations) {
        ImmutableMap<String, JSTypeExpression> infoTypeKeys = info.getTemplateTypes();
        ImmutableMap<String, Node> infoTypeTransformations = info.getTypeTransformations();
        if (infoTypeKeys.isEmpty() && infoTypeTransformations.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<TemplateType> unboundedTemplates = new ArrayList<TemplateType>();
        for (String templateKey : infoTypeKeys.keySet()) {
            unboundedTemplates.add(this.typeRegistry.createTemplateType(templateKey));
        }
        this.templateScope = this.typeRegistry.createScopeWithTemplates(this.templateScope, unboundedTemplates);
        ImmutableList.Builder templates = ImmutableList.builder();
        LinkedHashMap<TemplateType, JSType> templatesToBounds = new LinkedHashMap<TemplateType, JSType>();
        for (Map.Entry entry : infoTypeKeys.entrySet()) {
            TemplateType template;
            JSTypeExpression expr = (JSTypeExpression)entry.getValue();
            JSType typeBound = this.typeRegistry.evaluateTypeExpression((JSTypeExpression)entry.getValue(), this.templateScope);
            if (expr.isExplicitUnknownTemplateBound()) {
                this.reportError(TEMPLATE_TYPE_ILLEGAL_BOUND, String.valueOf(typeBound), (String)entry.getKey());
            }
            if ((template = this.typeRegistry.getType(this.templateScope, (String)entry.getKey()).toMaybeTemplateType()) != null) {
                templatesToBounds.put(template, typeBound);
                continue;
            }
            templatesToBounds.put(this.typeRegistry.createTemplateType((String)entry.getKey(), typeBound), typeBound);
        }
        for (Map.Entry entry : templatesToBounds.entrySet()) {
            TemplateType template = (TemplateType)entry.getKey();
            JSType bound = (JSType)entry.getValue();
            template.setBound(bound);
            templates.add((Object)template);
        }
        for (Map.Entry entry : infoTypeTransformations.entrySet()) {
            if (allowTypeTransformations) {
                templates.add((Object)this.typeRegistry.createTemplateTypeWithTransformation((String)entry.getKey(), (Node)entry.getValue()));
                continue;
            }
            this.reportWarning(TEMPLATE_TRANSFORMATION_ON_CLASS, (String)entry.getKey());
        }
        ImmutableList builtTemplates = templates.build();
        for (TemplateType template : builtTemplates) {
            if (!template.containsCycle()) continue;
            this.reportError(RhinoErrorReporter.CYCLIC_INHERITANCE_ERROR, "Cycle detected in inheritance chain of type " + template.getReferenceName());
        }
        return builtTemplates;
    }

    @CanIgnoreReturnValue
    FunctionTypeBuilder inferTemplateTypeName(@Nullable JSDocInfo info, @Nullable JSType ownerType) {
        ImmutableList<TemplateType> ownerTypeKeys;
        ImmutableList<TemplateType> templates;
        if (info != null && !this.maybeUseNativeClassTemplateNames(info) && !(templates = this.buildTemplateTypesFromJSDocInfo(info, !this.isConstructor && !this.isInterface)).isEmpty()) {
            this.templateTypeNames = templates;
        }
        ImmutableList<TemplateType> immutableList = ownerTypeKeys = ownerType != null ? ownerType.getTemplateTypeMap().getTemplateKeys() : ImmutableList.of();
        if (!this.templateTypeNames.isEmpty() || !ownerTypeKeys.isEmpty()) {
            this.registerTemplates(Iterables.concat(this.templateTypeNames, ownerTypeKeys), this.contents.getSourceNode());
        }
        return this;
    }

    private boolean addParameter(FunctionParamBuilder builder, JSType paramType, boolean warnedAboutArgList, boolean isOptional, boolean isVarArgs) {
        boolean emittedWarning = false;
        if (isOptional) {
            if (!builder.addOptionalParams(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (isVarArgs) {
            if (!builder.addVarArgs(paramType) && !warnedAboutArgList) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
                emittedWarning = true;
            }
        } else if (!builder.addRequiredParams(paramType) && !warnedAboutArgList) {
            if (builder.hasVarArgs()) {
                this.reportWarning(VAR_ARGS_MUST_BE_LAST, new String[0]);
            } else {
                this.reportWarning(OPTIONAL_ARG_AT_END, new String[0]);
            }
            emittedWarning = true;
        }
        return emittedWarning;
    }

    private void provideDefaultReturnType() {
        if (this.contents.getSourceNode() != null && this.contents.getSourceNode().isAsyncGeneratorFunction()) {
            ObjectType generatorType = this.typeRegistry.getNativeObjectType(JSTypeNative.ASYNC_GENERATOR_TYPE);
            this.returnType = this.typeRegistry.createTemplatizedType(generatorType, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            return;
        }
        if (this.contents.getSourceNode() != null && this.contents.getSourceNode().isGeneratorFunction()) {
            ObjectType generatorType = this.typeRegistry.getNativeObjectType(JSTypeNative.GENERATOR_TYPE);
            this.returnType = this.typeRegistry.createTemplatizedType(generatorType, this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            return;
        }
        JSType inferredReturnType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (!(this.contents.mayHaveNonEmptyReturns() || this.contents.mayHaveSingleThrow() || this.contents.mayBeFromExterns())) {
            inferredReturnType = this.typeRegistry.getNativeType(JSTypeNative.VOID_TYPE);
            this.returnTypeInferred = true;
        }
        if (this.contents.getSourceNode() != null && this.contents.getSourceNode().isAsyncFunction()) {
            ObjectType promiseType = this.typeRegistry.getNativeObjectType(JSTypeNative.PROMISE_TYPE);
            this.returnType = this.typeRegistry.createTemplatizedType(promiseType, inferredReturnType);
        } else {
            this.returnType = inferredReturnType;
        }
    }

    FunctionType buildAndRegister() {
        FunctionType fnType;
        if (this.returnType == null) {
            this.provideDefaultReturnType();
            Preconditions.checkNotNull((Object)this.returnType);
        }
        if (this.parameters == null) {
            throw new IllegalStateException("All Function types must have params and a return type");
        }
        if (this.isConstructor) {
            fnType = this.getOrCreateConstructor();
        } else if (this.isInterface) {
            fnType = this.getOrCreateInterface();
        } else {
            fnType = this.createDefaultBuilder().withParameters((List<FunctionType.Parameter>)this.parameters).withReturnType(this.returnType, this.returnTypeInferred).withTypeOfThis(this.thisType).withIsAbstract(this.isAbstract).withClosurePrimitiveId(this.closurePrimitiveId).build();
            this.maybeSetBaseType(fnType);
        }
        if (this.implementedInterfaces != null && fnType.isConstructor()) {
            fnType.setImplementedInterfaces(this.implementedInterfaces);
        }
        if (this.extendedInterfaces != null) {
            fnType.setExtendedInterfaces(this.extendedInterfaces);
        }
        if (this.isRecord) {
            fnType.setImplicitMatch(true);
        }
        return fnType;
    }

    private void maybeSetBaseType(FunctionType fnType) {
        if (!fnType.hasInstanceType() || this.baseType == null) {
            return;
        }
        fnType.setPrototypeBasedOn(this.baseType);
        fnType.getInstanceType().mergeSupertypeTemplateTypes(this.baseType);
    }

    private FunctionType.Builder createDefaultBuilder() {
        return FunctionType.builder(this.typeRegistry).withName(this.fnName).withSourceNode(this.contents.getSourceNode()).withTemplateKeys(this.templateTypeNames).setIsKnownAmbiguous(this.isKnownAmbiguous).setGoogModuleId(TypedScopeCreator.containingGoogModuleIdOf(this.declarationScope));
    }

    private FunctionType getOrCreateConstructor() {
        boolean isInstanceObject;
        FunctionType fnType = this.createDefaultBuilder().forConstructor().withParameters((List<FunctionType.Parameter>)this.parameters).withReturnType(this.returnType).withConstructorTemplateKeys((Iterable<TemplateType>)this.constructorTemplateTypeNames).withIsAbstract(this.isAbstract).build();
        if (this.makesStructs) {
            fnType.setStruct();
        } else if (this.makesDicts) {
            fnType.setDict();
        } else if (this.makesUnrestricted) {
            fnType.setExplicitUnrestricted();
        }
        JSType existingType = this.typeRegistry.getType(this.declarationScope, this.fnName);
        if (existingType != null && ((isInstanceObject = existingType.isInstanceType()) || this.fnName.equals("Function"))) {
            FunctionType existingFn;
            FunctionType functionType = existingFn = isInstanceObject ? existingType.toObjectType().getConstructor() : this.typeRegistry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            if (existingFn.getSource() == null) {
                existingFn.setSource(this.contents.getSourceNode());
            }
            if (!existingFn.hasEqualCallType(fnType)) {
                this.reportWarning(TYPE_REDEFINITION, this.formatFnName(), fnType.toString(), existingFn.toString());
            }
            if (existingFn.isNativeObjectType()) {
                this.maybeSetBaseType(existingFn);
            }
            return existingFn;
        }
        this.maybeSetBaseType(fnType);
        if (!this.syntacticFnName.isEmpty() && !this.syntacticFnName.startsWith("this.")) {
            this.typeRegistry.declareTypeForExactScope(this.declarationScope, this.syntacticFnName, fnType.getInstanceType());
        }
        return fnType;
    }

    private FunctionType getOrCreateInterface() {
        FunctionType ctor;
        FunctionType fnType = null;
        JSType type = this.typeRegistry.getType(this.declarationScope, this.syntacticFnName);
        if (type != null && type.isInstanceType() && (ctor = type.toMaybeObjectType().getConstructor()).isInterface()) {
            fnType = ctor;
            fnType.setSource(this.contents.getSourceNode());
        }
        if (fnType == null) {
            fnType = this.createDefaultBuilder().forInterface().withParameters().build();
            if (this.makesStructs) {
                fnType.setStruct();
            }
            if (!this.fnName.isEmpty()) {
                this.typeRegistry.declareTypeForExactScope(this.declarationScope, this.syntacticFnName, fnType.getInstanceType());
            }
            this.maybeSetBaseType(fnType);
        }
        return fnType;
    }

    private void reportWarning(DiagnosticType warning, String ... args) {
        this.compiler.report(JSError.make(this.errorRoot, warning, args));
    }

    private void reportError(DiagnosticType error, String ... args) {
        this.compiler.report(JSError.make(this.errorRoot, error, args));
    }

    static boolean isFunctionTypeDeclaration(JSDocInfo info) {
        return info.getParameterCount() > 0 || info.hasReturnType() || info.hasThisType() || info.isConstructor() || info.isInterface() || info.isAbstract();
    }

    private static boolean hasMoreTagsToResolve(ObjectType objectType) {
        Preconditions.checkArgument((boolean)objectType.isUnknownType());
        FunctionType ctor = objectType.getConstructor();
        if (ctor != null) {
            for (ObjectType interfaceType : ctor.getExtendedInterfaces()) {
                if (interfaceType.isResolved()) continue;
                return true;
            }
        }
        if (objectType.getImplicitPrototype() != null) {
            return !objectType.getImplicitPrototype().isResolved();
        }
        return false;
    }

    static class AstFunctionContents
    implements FunctionContents {
        private final Node n;
        private boolean hasNonEmptyReturns = false;

        AstFunctionContents(Node n) {
            this.n = n;
        }

        @Override
        public Node getSourceNode() {
            return this.n;
        }

        @Override
        public boolean mayBeFromExterns() {
            return this.n.isFromExterns();
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return this.hasNonEmptyReturns;
        }

        void recordNonEmptyReturn() {
            this.hasNonEmptyReturns = true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            Node block = this.n.getLastChild();
            return block.hasOneChild() && block.getFirstChild().isThrow();
        }
    }

    static class UnknownFunctionContents
    implements FunctionContents {
        private static final UnknownFunctionContents singleton = new UnknownFunctionContents();

        UnknownFunctionContents() {
        }

        static FunctionContents get() {
            return singleton;
        }

        @Override
        public Node getSourceNode() {
            return null;
        }

        @Override
        public boolean mayBeFromExterns() {
            return true;
        }

        @Override
        public boolean mayHaveNonEmptyReturns() {
            return true;
        }

        @Override
        public boolean mayHaveSingleThrow() {
            return true;
        }
    }

    static interface FunctionContents {
        public Node getSourceNode();

        public boolean mayBeFromExterns();

        public boolean mayHaveNonEmptyReturns();

        public boolean mayHaveSingleThrow();
    }

    private static class ImplementedTypeValidator
    extends ValidatorBase {
        private final String formattedFnName;

        ImplementedTypeValidator(Node errorRoot, AbstractCompiler compiler, String formattedFnName) {
            super(errorRoot, compiler);
            this.formattedFnName = formattedFnName;
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                this.reportError(TypeCheck.BAD_IMPLEMENTED_TYPE, this.formattedFnName);
                return false;
            }
            if (objectType.isEmptyType()) {
                this.reportWarning(RESOLVED_TAG_EMPTY, "@implements", this.formattedFnName);
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType)) {
                    return true;
                }
                this.reportWarning(RESOLVED_TAG_EMPTY, "@implements", this.formattedFnName);
                return false;
            }
            return true;
        }
    }

    private static class ExtendedTypeValidator
    extends ValidatorBase {
        private final String formattedFnName;

        ExtendedTypeValidator(Node errorRoot, AbstractCompiler compiler, String formattedFnName) {
            super(errorRoot, compiler);
            this.formattedFnName = formattedFnName;
        }

        public boolean apply(JSType type) {
            ObjectType objectType = ObjectType.cast(type);
            if (objectType == null) {
                this.reportWarning(EXTENDS_NON_OBJECT, this.formattedFnName, type.toString());
                return false;
            }
            if (objectType.isEmptyType()) {
                this.reportWarning(RESOLVED_TAG_EMPTY, "@extends", this.formattedFnName);
                return false;
            }
            if (objectType.isUnknownType()) {
                if (FunctionTypeBuilder.hasMoreTagsToResolve(objectType) || type.isTemplateType()) {
                    return true;
                }
                this.reportWarning(RESOLVED_TAG_EMPTY, "@extends", this.formattedFnName);
                return false;
            }
            return true;
        }
    }

    private static abstract class ValidatorBase
    implements Predicate<JSType> {
        private final AbstractCompiler compiler;
        private final Node errorRoot;

        ValidatorBase(Node errorRoot, AbstractCompiler compiler) {
            this.errorRoot = errorRoot;
            this.compiler = compiler;
        }

        void reportWarning(DiagnosticType warning, String ... args) {
            this.compiler.report(JSError.make(this.errorRoot, warning, args));
        }

        void reportError(DiagnosticType error, String ... args) {
            this.compiler.report(JSError.make(this.errorRoot, error, args));
        }
    }
}

