/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

public class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:((\\w+\\.)+prototype\\.||window\\.)*(setUpPage|setUp|shouldRunTests|tearDown|tearDownPage|test[\\w\\$]+))$");
    private static final String GOOG_TESTING_TEST_SUITE = "goog.testing.testSuite";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    ExportTestFunctions(AbstractCompiler compiler, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ExportTestFunctionsNodes());
    }

    private void exportTestFunctionAsSymbol(String testFunctionName, Node node) {
        Node exportCallTarget = NodeUtil.newQName(this.compiler, this.exportSymbolFunction, node, testFunctionName);
        Node call = IR.call(exportCallTarget, new Node[0]);
        if (exportCallTarget.isName()) {
            call.putBooleanProp(Node.FREE_CALL, true);
        }
        call.addChildToBack(IR.string(testFunctionName));
        call.addChildToBack(NodeUtil.newQName(this.compiler, testFunctionName, node, testFunctionName));
        Node expression = IR.exprResult(call).srcrefTreeIfMissing(node);
        expression.insertAfter(node);
        this.compiler.reportChangeToEnclosingScope(expression);
    }

    private void exportTestFunctionAsProperty(Node fullyQualifiedFunctionName, Node node) {
        Preconditions.checkState((boolean)fullyQualifiedFunctionName.isGetProp(), (Object)fullyQualifiedFunctionName);
        String testFunctionName = NodeUtil.getPrototypePropertyName(node.getFirstChild());
        if (node.getFirstChild().getQualifiedName().startsWith("window.")) {
            testFunctionName = node.getFirstChild().getQualifiedName().substring("window.".length());
        }
        Node exportCall = IR.call(NodeUtil.newQName(this.compiler, this.exportPropertyFunction), fullyQualifiedFunctionName.getOnlyChild().cloneTree(), IR.string(testFunctionName), fullyQualifiedFunctionName.cloneTree());
        exportCall.putBooleanProp(Node.FREE_CALL, exportCall.getFirstChild().isName());
        Node export = IR.exprResult(exportCall).srcrefTree(node);
        export.insertAfter(node.getParent());
        this.compiler.reportChangeToEnclosingScope(export);
    }

    private static boolean isTestSuiteArgument(Node n, NodeTraversal t) {
        return n.isObjectLit() && n.getParent().isCall() && n.isSecondChildOf(n.getParent()) && ExportTestFunctions.isGoogTestingTestSuite(t, n.getPrevious());
    }

    private static boolean isGoogTestingTestSuite(NodeTraversal t, Node qname) {
        if (!(qname = NodeUtil.getCallTargetResolvingIndirectCalls(qname.getParent())).isQualifiedName()) {
            return false;
        }
        Node root = NodeUtil.getRootOfQualifiedName(qname);
        String rootName = root.getString();
        Var rootVar = (Var)t.getScope().getSlot(rootName);
        if (rootVar == null || rootVar.isGlobal()) {
            return qname.matchesQualifiedName(GOOG_TESTING_TEST_SUITE);
        }
        if (((Scope)rootVar.getScope()).isModuleScope()) {
            Node originalValue = rootVar.getInitialValue();
            return originalValue != null && NodeUtil.isGoogRequireCall(originalValue) && originalValue.hasTwoChildren() && originalValue.getSecondChild().getString().equals(GOOG_TESTING_TEST_SUITE);
        }
        return false;
    }

    public static boolean isTestFunction(String functionName) {
        return functionName != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(functionName).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractShallowCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block13: {
                block16: {
                    String nodeName;
                    Node lastChild;
                    block17: {
                        block11: {
                            block15: {
                                block14: {
                                    block12: {
                                        if (parent == null) {
                                            return;
                                        }
                                        if (!parent.isScript() && !parent.isModuleBody()) break block11;
                                        if (!NodeUtil.isFunctionDeclaration(n)) break block12;
                                        String functionName = NodeUtil.getName(n);
                                        if (ExportTestFunctions.isTestFunction(functionName)) {
                                            ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName, n);
                                        }
                                        break block13;
                                    }
                                    if (!this.isNameDeclaredFunction(n)) break block14;
                                    Node functionNode = n.getFirstFirstChild();
                                    String functionName = NodeUtil.getName(functionNode);
                                    if (ExportTestFunctions.isTestFunction(functionName)) {
                                        ExportTestFunctions.this.exportTestFunctionAsSymbol(functionName, n);
                                    }
                                    break block13;
                                }
                                if (!this.isNameDeclaredClass(n)) break block15;
                                Node classNode = n.getFirstFirstChild();
                                String className = NodeUtil.getName(classNode);
                                this.exportClass(classNode, className, n);
                                break block13;
                            }
                            if (!n.isClass()) break block13;
                            this.exportClass(n);
                            break block13;
                        }
                        if (!NodeUtil.isExprAssign(parent)) break block16;
                        Node grandparent = parent.getParent();
                        if (grandparent == null || !grandparent.isScript() && !grandparent.isModuleBody()) break block13;
                        Node firstChild = n.getFirstChild();
                        lastChild = n.getLastChild();
                        nodeName = firstChild.getQualifiedName();
                        if (!lastChild.isFunction()) break block17;
                        if (ExportTestFunctions.isTestFunction(nodeName)) {
                            if (n.getFirstChild().isName()) {
                                ExportTestFunctions.this.exportTestFunctionAsSymbol(nodeName, parent);
                            } else {
                                ExportTestFunctions.this.exportTestFunctionAsProperty(firstChild, n);
                            }
                        }
                        break block13;
                    }
                    if (!lastChild.isClass()) break block13;
                    this.exportClass(lastChild, nodeName, parent);
                    break block13;
                }
                if (ExportTestFunctions.isTestSuiteArgument(n, t)) {
                    Node c = n.getFirstChild();
                    while (c != null) {
                        Node next = c.getNext();
                        if (c.isStringKey() && !c.isQuotedString()) {
                            c.setQuotedString();
                            ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(c);
                        } else if (c.isMemberFunctionDef()) {
                            this.rewriteMemberDefInObjLit(c, n);
                        }
                        c = next;
                    }
                }
            }
        }

        private void exportClass(Node classNode) {
            String className = NodeUtil.getName(classNode);
            this.exportClass(classNode, className, classNode);
        }

        private void exportClass(Node classNode, String className, Node addAfter) {
            Node classMembers = classNode.getLastChild();
            for (Node maybeMemberFunctionDef = classMembers.getFirstChild(); maybeMemberFunctionDef != null; maybeMemberFunctionDef = maybeMemberFunctionDef.getNext()) {
                String methodName;
                if (!maybeMemberFunctionDef.isMemberFunctionDef() || !ExportTestFunctions.isTestFunction(methodName = maybeMemberFunctionDef.getString())) continue;
                String functionRef = className + ".prototype." + methodName;
                String classRef = className + ".prototype";
                Node exportCallTarget = NodeUtil.newQName(ExportTestFunctions.this.compiler, ExportTestFunctions.this.exportPropertyFunction, maybeMemberFunctionDef, methodName);
                Node call = IR.call(exportCallTarget, new Node[0]);
                if (exportCallTarget.isName()) {
                    call.putBooleanProp(Node.FREE_CALL, true);
                }
                call.addChildToBack(NodeUtil.newQName(ExportTestFunctions.this.compiler, classRef, maybeMemberFunctionDef, classRef));
                call.addChildToBack(IR.string(methodName));
                call.addChildToBack(NodeUtil.newQName(ExportTestFunctions.this.compiler, functionRef, maybeMemberFunctionDef, functionRef));
                Node expression = IR.exprResult(call).srcrefTreeIfMissing(maybeMemberFunctionDef);
                expression.insertAfter(addAfter);
                ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(expression);
                addAfter = expression;
            }
        }

        private void rewriteMemberDefInObjLit(Node memberDef, Node objLit) {
            String name = memberDef.getString();
            Node stringKey = IR.stringKey(name, memberDef.removeFirstChild());
            memberDef.replaceWith(stringKey);
            stringKey.setQuotedString();
            stringKey.setJSDocInfo(memberDef.getJSDocInfo());
            ExportTestFunctions.this.compiler.reportChangeToEnclosingScope(objLit);
        }

        private @Nullable Node getNameDeclaredGrandchild(Node node) {
            if (!NodeUtil.isNameDeclaration(node)) {
                return null;
            }
            return node.getFirstFirstChild();
        }

        private boolean isNameDeclaredFunction(Node node) {
            Node grandchild = this.getNameDeclaredGrandchild(node);
            return grandchild != null && grandchild.isFunction();
        }

        private boolean isNameDeclaredClass(Node node) {
            Node grandchild = this.getNameDeclaredGrandchild(node);
            return grandchild != null && grandchild.isClass();
        }
    }
}

