/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSTypeNative;

public final class Es6RewriteClassExtendsExpressions
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final String CLASS_EXTENDS_VAR = "$classextends$var";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private int classExtendsVarCounter = 0;
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES);

    Es6RewriteClassExtendsExpressions(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, features, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.needsExtendsDecomposing(n)) {
            if (this.canDecomposeSimply(n)) {
                this.extractExtends(t, n);
            } else {
                this.decomposeInIIFE(t, n);
            }
        }
    }

    private boolean needsExtendsDecomposing(Node classNode) {
        Preconditions.checkArgument((boolean)classNode.isClass());
        Node superClassNode = classNode.getSecondChild();
        return !superClassNode.isEmpty() && !superClassNode.isQualifiedName();
    }

    private boolean canDecomposeSimply(Node classNode) {
        Node enclosingStatement = (Node)Preconditions.checkNotNull((Object)NodeUtil.getEnclosingStatement(classNode), (Object)classNode);
        if (enclosingStatement == classNode) {
            return true;
        }
        Node classNodeParent = classNode.getParent();
        if (NodeUtil.isNameDeclaration(enclosingStatement) && classNodeParent.isName() && classNodeParent.isFirstChildOf(enclosingStatement)) {
            return true;
        }
        if (enclosingStatement.isExprResult() && classNodeParent.isOnlyChildOf(enclosingStatement) && classNodeParent.isAssign() && classNode.isSecondChildOf(classNodeParent)) {
            Node lhsNode = classNodeParent.getFirstChild();
            return !this.compiler.getAstAnalyzer().mayHaveSideEffects(lhsNode);
        }
        return false;
    }

    private void extractExtends(NodeTraversal t, Node classNode) {
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_EXTENDS_VAR + this.classExtendsVarCounter++;
        Node statement = NodeUtil.getEnclosingStatement(classNode);
        Node originalExtends = classNode.getSecondChild();
        originalExtends.replaceWith(this.astFactory.createName(name, AstFactory.type(originalExtends)).srcref(originalExtends));
        Node extendsAlias = this.astFactory.createSingleConstNameDeclaration(name, originalExtends).srcrefTreeIfMissing(originalExtends);
        extendsAlias.insertBefore(statement);
        NodeUtil.addFeatureToScript(NodeUtil.getEnclosingScript(classNode), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        t.reportCodeChange(classNode);
    }

    private void decomposeInIIFE(NodeTraversal t, Node classNode) {
        Node functionBody = IR.block();
        Node function = this.astFactory.createFunction("", IR.paramList(new Node[0]), functionBody, AstFactory.type(JSTypeNative.FUNCTION_TYPE, StandardColors.TOP_OBJECT));
        Node call = this.astFactory.createCall(function, AstFactory.type(classNode), new Node[0]);
        classNode.replaceWith(call);
        functionBody.addChildToBack(IR.returnNode(classNode));
        call.srcrefTreeIfMissing(classNode);
        t.reportCodeChange(call);
        this.extractExtends(t, classNode);
    }
}

