/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.AutoValue_Es6RewriteClass_ClassDeclarationMetadata;
import com.google.javascript.jscomp.AutoValue_Es6RewriteClass_ClassProperty;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6ConvertSuperConstructorCalls;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public final class Es6RewriteClass
implements NodeTraversal.Callback,
CompilerPass {
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES, FeatureSet.Feature.CLASS_EXTENDS, FeatureSet.Feature.CLASS_GETTER_SETTER, FeatureSet.Feature.NEW_TARGET, FeatureSet.Feature.SUPER);
    static final String INHERITS = "$jscomp.inherits";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Es6ConvertSuperConstructorCalls convertSuperConstructorCalls;
    private final StaticScope transpilationNamespace;

    public Es6RewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.transpilationNamespace = compiler.getTranspilationNamespace();
        this.convertSuperConstructorCalls = new Es6ConvertSuperConstructorCalls(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this);
        TranspilationPasses.processTranspile(this.compiler, root, features, this);
        this.convertSuperConstructorCalls.setGlobalNamespace(new GlobalNamespace(this.compiler, externs, root));
        TranspilationPasses.processTranspile(this.compiler, root, features, this.convertSuperConstructorCalls);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, features);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) break;
                TranspilationUtil.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            this.visitClass(t, n, parent);
        }
    }

    private void visitClass(NodeTraversal t, Node classNode, Node parent) {
        Node var;
        Node definePropsCall;
        ClassDeclarationMetadata metadata = ClassDeclarationMetadata.create(classNode, parent, this.astFactory);
        if (metadata == null) {
            throw new IllegalStateException("Can only convert classes that are declarations or the right hand side of a simple assignment: " + classNode);
        }
        if (metadata.hasSuperClass()) {
            Preconditions.checkState((boolean)metadata.getSuperClassNameNode().isQualifiedName(), (String)"Expected Es6RewriteClassExtendsExpressions to make all extends clauses into qualified names, found %s", (Object)metadata.getSuperClassNameNode());
        }
        Preconditions.checkState((boolean)NodeUtil.isStatement(metadata.getInsertionPoint().getNode()), (String)"insertion point must be a statement: %s", (Object)metadata.getInsertionPoint().getNode());
        Node constructor = null;
        Node classMembers = classNode.getLastChild();
        Node member = classMembers.getFirstChild();
        while (member != null) {
            Node next = member.getNext();
            if (member.isComputedProp() && (member.getBooleanProp(Node.COMPUTED_PROP_GETTER) || member.getBooleanProp(Node.COMPUTED_PROP_SETTER)) || member.isGetterDef() || member.isSetterDef()) {
                this.visitNonMethodMember(member, metadata);
            } else if (NodeUtil.isEs6ConstructorMemberFunctionDef(member)) {
                constructor = member.removeFirstChild().setColor(classNode.getColor());
                if (!metadata.isAnonymous()) {
                    constructor.getFirstChild().replaceWith(metadata.getClassNameNode().cloneNode());
                }
            } else if (!member.isEmpty()) {
                Preconditions.checkState((member.isMemberFunctionDef() || member.isComputedProp() ? 1 : 0) != 0, (String)"Unexpected class member: (%s)", (Object)member);
                Preconditions.checkState((!member.getBooleanProp(Node.COMPUTED_PROP_VARIABLE) ? 1 : 0) != 0, (String)"Member variables should have been transpiled earlier: (%s)", (Object)member);
                this.visitMethod(member, metadata);
            }
            member = next;
        }
        Preconditions.checkNotNull(constructor, (Object)"Es6RewriteClasses expects all classes to have (possibly synthetic) constructors");
        if (metadata.getDefinePropertiesObjForPrototype().hasChildren()) {
            definePropsCall = IR.exprResult(this.astFactory.createCall(this.createObjectDotDefineProperties(), AstFactory.type(metadata.getClassPrototypeNode()), metadata.getClassPrototypeNode().cloneTree(), metadata.getDefinePropertiesObjForPrototype()));
            definePropsCall.srcrefTreeIfMissing(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        if (metadata.getDefinePropertiesObjForClass().hasChildren()) {
            definePropsCall = IR.exprResult(this.astFactory.createCall(this.createObjectDotDefineProperties(), AstFactory.type(metadata.getFullClassNameNode()), metadata.getFullClassNameNode().cloneTree(), metadata.getDefinePropertiesObjForClass()));
            definePropsCall.srcrefTreeIfMissing(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        JSDocInfo classJSDoc = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfo.Builder newInfo = JSDocInfo.Builder.maybeCopyFrom(classJSDoc);
        newInfo.recordConstructor();
        Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
        if (metadata.hasSuperClass() && !classNode.isFromExterns()) {
            Node inheritsCall = IR.exprResult(this.astFactory.createCall(this.astFactory.createQName(this.transpilationNamespace, INHERITS), AstFactory.type(StandardColors.NULL_OR_VOID), metadata.getFullClassNameNode().cloneTree(), metadata.getSuperClassNameNode().cloneTree())).srcrefTreeIfMissing(metadata.getSuperClassNameNode());
            inheritsCall.insertAfter(enclosingStatement);
        }
        this.addTypeDeclarations(metadata, enclosingStatement);
        if (NodeUtil.isStatement(classNode)) {
            constructor.getFirstChild().setString("");
            Node ctorVar = IR.let(metadata.getClassNameNode().cloneNode(), constructor);
            ctorVar.srcrefTreeIfMissing(classNode);
            classNode.replaceWith(ctorVar);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        } else {
            classNode.replaceWith(constructor);
        }
        NodeUtil.markFunctionsDeleted(classNode, this.compiler);
        if (NodeUtil.isStatement(constructor)) {
            constructor.setJSDocInfo(newInfo.build());
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(newInfo.build());
        } else if (constructor.getParent().isName()) {
            var = constructor.getGrandparent();
            var.setJSDocInfo(newInfo.build());
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(newInfo.build());
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        t.reportCodeChange();
    }

    private Node createObjectDotDefineProperties() {
        return this.astFactory.createJSCompDotGlobalAccess(this.transpilationNamespace, "Object.defineProperties");
    }

    private Node createObjectDotDefineProperty() {
        return this.astFactory.createJSCompDotGlobalAccess(this.transpilationNamespace, "Object.defineProperty");
    }

    private void addToDefinePropertiesObject(ClassDeclarationMetadata metadata, Node member) {
        Preconditions.checkArgument((!member.isComputedProp() ? 1 : 0) != 0);
        Node obj = member.isStaticMember() ? metadata.getDefinePropertiesObjForClass() : metadata.getDefinePropertiesObjForPrototype();
        Node prop = NodeUtil.getFirstPropMatchingKey(obj, member.getString());
        if (prop == null) {
            prop = this.createPropertyDescriptor();
            Node stringKey = this.astFactory.createStringKey(member.getString(), prop);
            if (member.isQuotedString()) {
                stringKey.putBooleanProp(Node.QUOTED_PROP, true);
            }
            obj.addChildToBack(stringKey);
        }
        Node function = member.getLastChild();
        JSDocInfo info = NodeUtil.getBestJSDocInfo(function);
        Node stringKey = this.astFactory.createStringKey(member.isGetterDef() ? "get" : "set", function.detach());
        stringKey.setJSDocInfo(info);
        prop.addChildToBack(stringKey);
        prop.srcrefTreeIfMissing(member);
    }

    private void extractComputedProperty(Node computedMember, ClassDeclarationMetadata metadata) {
        Node owner = computedMember.isStaticMember() ? metadata.getFullClassNameNode() : metadata.getClassPrototypeNode();
        Node property = computedMember.removeFirstChild();
        Node propertyValue = computedMember.removeFirstChild();
        Node propertyDescriptor = this.createPropertyDescriptor();
        Node stringKey = this.astFactory.createStringKey(computedMember.getBooleanProp(Node.COMPUTED_PROP_GETTER) ? "get" : "set", propertyValue);
        propertyDescriptor.addChildToBack(stringKey);
        Node objectDefinePropertyCall = this.astFactory.createCall(this.createObjectDotDefineProperty(), AstFactory.type(owner), owner.cloneTree(), property, propertyDescriptor);
        metadata.insertNodeAndAdvance(IR.exprResult(objectDefinePropertyCall).srcrefTreeIfMissing(computedMember));
    }

    private void visitNonMethodMember(Node member, ClassDeclarationMetadata metadata) {
        if (member.isComputedProp()) {
            this.extractComputedProperty(member.detach(), metadata);
            return;
        }
        this.addToDefinePropertiesObject(metadata, member);
        if (!member.isStaticMember()) {
            return;
        }
        Preconditions.checkState((!member.isComputedProp() ? 1 : 0) != 0, (Object)member);
        Map<String, ClassProperty> membersToDeclare = metadata.getClassMembersToDeclare();
        ClassProperty.Builder builder = ClassProperty.builder();
        String memberName = member.getString();
        if (member.isQuotedString()) {
            builder.kind(ClassProperty.PropertyKind.QUOTED_PROPERTY);
        } else {
            builder.kind(ClassProperty.PropertyKind.NORMAL_PROPERTY);
        }
        builder.propertyKey(memberName).propertyType(member.getColor());
        JSDocInfo.Builder jsDoc = JSDocInfo.builder();
        jsDoc.recordNoCollapse();
        builder.jsDocInfo(jsDoc.build());
        membersToDeclare.put(memberName, builder.build());
    }

    private void visitMethod(Node member, ClassDeclarationMetadata metadata) {
        Node qualifiedMemberAccess = this.getQualifiedMemberAccess(member, metadata);
        Node method = member.getLastChild().detach();
        Node assign = this.astFactory.createAssign(qualifiedMemberAccess, method).srcrefIfMissing(method);
        JSDocInfo info = member.getJSDocInfo();
        if (member.isStaticMember() && NodeUtil.referencesOwnReceiver(assign.getLastChild())) {
            JSDocInfo.Builder memberDoc = JSDocInfo.Builder.maybeCopyFrom(info);
            memberDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, new Node(Token.QMARK)).srcrefTree(member), member.getSourceFileName()));
            info = memberDoc.build();
        }
        if (info != null) {
            assign.setJSDocInfo(info);
        }
        Node newNode = NodeUtil.newExpr(assign);
        metadata.insertNodeAndAdvance(newNode);
    }

    private void addTypeDeclarations(ClassDeclarationMetadata metadata, Node insertionPoint) {
        for (ClassProperty property : metadata.getClassMembersToDeclare().values()) {
            Node declaration = property.getDeclaration(this.astFactory, metadata.getFullClassNameNode().cloneTree());
            declaration.srcrefTreeIfMissing(metadata.getClassNameNode());
            declaration.insertAfter(insertionPoint);
            insertionPoint = declaration;
        }
    }

    private Node getQualifiedMemberAccess(Node member, ClassDeclarationMetadata metadata) {
        Node context = member.isStaticMember() ? metadata.getFullClassNameNode().cloneTree() : metadata.getClassPrototypeNode().cloneTree();
        context.makeNonIndexableRecursive();
        if (member.isComputedProp()) {
            return this.astFactory.createGetElem(context, member.removeFirstChild()).srcrefTreeIfMissing(member);
        }
        Node methodName = member.getFirstFirstChild();
        return this.astFactory.createGetProp(context, member.getString(), AstFactory.type(member)).srcrefTree(methodName);
    }

    private Node createPropertyDescriptor() {
        return this.astFactory.createObjectLit(this.astFactory.createStringKey("configurable", this.astFactory.createBoolean(true)), this.astFactory.createStringKey("enumerable", this.astFactory.createBoolean(true)));
    }

    static class InsertionPoint {
        private Node insertionPoint;

        private InsertionPoint(Node insertionPoint) {
            this.insertionPoint = insertionPoint;
        }

        void insertNodeAndAdvance(Node newNode) {
            newNode.insertAfter(this.insertionPoint);
            this.insertionPoint = newNode;
        }

        static InsertionPoint from(Node start) {
            return new InsertionPoint(start);
        }

        Node getNode() {
            return this.insertionPoint;
        }
    }

    @AutoValue
    static abstract class ClassDeclarationMetadata {
        ClassDeclarationMetadata() {
        }

        abstract InsertionPoint getInsertionPoint();

        abstract Node getDefinePropertiesObjForPrototype();

        abstract Node getDefinePropertiesObjForClass();

        abstract Map<String, ClassProperty> getClassMembersToDeclare();

        abstract Node getFullClassNameNode();

        abstract Node getClassPrototypeNode();

        abstract boolean isAnonymous();

        abstract Node getClassNameNode();

        abstract Node getSuperClassNameNode();

        public static Builder builder() {
            return new AutoValue_Es6RewriteClass_ClassDeclarationMetadata.Builder().setClassMembersToDeclare(new LinkedHashMap<String, ClassProperty>());
        }

        static @Nullable ClassDeclarationMetadata create(Node classNode, Node parent) {
            return ClassDeclarationMetadata.create(classNode, parent, AstFactory.createFactoryWithoutTypes());
        }

        private static @Nullable ClassDeclarationMetadata create(Node classNode, Node parent, AstFactory astFactory) {
            Node classNameNode = classNode.getFirstChild();
            Node superClassNameNode = classNameNode.getNext();
            Builder builder = ClassDeclarationMetadata.builder().setSuperClassNameNode(superClassNameNode).setClassNameNode(classNameNode);
            if (NodeUtil.isClassDeclaration(classNode)) {
                builder.setInsertionPoint(InsertionPoint.from(classNode)).setFullClassNameNode(classNameNode).setAnonymous(false);
            } else if (parent.isAssign() && parent.getParent().isExprResult()) {
                Node fullClassNameNode = parent.getFirstChild();
                if (!fullClassNameNode.isQualifiedName()) {
                    return null;
                }
                builder.setInsertionPoint(InsertionPoint.from(parent.getParent())).setFullClassNameNode(fullClassNameNode).setAnonymous(true);
            } else if (parent.isExport()) {
                builder.setInsertionPoint(InsertionPoint.from(classNode)).setFullClassNameNode(classNameNode).setAnonymous(false);
            } else if (parent.isName()) {
                builder.setInsertionPoint(InsertionPoint.from(parent.getParent())).setFullClassNameNode(parent.cloneNode()).setAnonymous(true);
            } else {
                return null;
            }
            AstFactory.Type classType = AstFactory.type(builder.getFullClassNameNode());
            builder.setClassPrototypeNode(astFactory.createPrototypeAccess(builder.getFullClassNameNode().cloneTree()));
            builder.setDefinePropertiesObjForClass(astFactory.createObjectLit(classType, new Node[0]));
            builder.setDefinePropertiesObjForPrototype(astFactory.createObjectLit(classType, new Node[0]));
            return builder.build();
        }

        void insertNodeAndAdvance(Node newNode) {
            this.getInsertionPoint().insertNodeAndAdvance(newNode);
        }

        boolean hasSuperClass() {
            return !this.getSuperClassNameNode().isEmpty();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setInsertionPoint(InsertionPoint var1);

            abstract Builder setFullClassNameNode(Node var1);

            abstract Node getFullClassNameNode();

            abstract Builder setClassMembersToDeclare(Map<String, ClassProperty> var1);

            abstract Builder setAnonymous(boolean var1);

            abstract Builder setClassNameNode(Node var1);

            abstract Builder setSuperClassNameNode(Node var1);

            abstract Builder setClassPrototypeNode(Node var1);

            abstract Builder setDefinePropertiesObjForClass(Node var1);

            abstract Builder setDefinePropertiesObjForPrototype(Node var1);

            abstract ClassDeclarationMetadata build();
        }
    }

    @AutoValue
    static abstract class ClassProperty {
        ClassProperty() {
        }

        abstract String propertyKey();

        abstract PropertyKind kind();

        abstract JSDocInfo jsDocInfo();

        abstract @Nullable Color propertyType();

        final Node getDeclaration(AstFactory astFactory, Node toDeclareOn) {
            Node decl = null;
            switch (this.kind()) {
                case QUOTED_PROPERTY: {
                    decl = astFactory.createGetElem(toDeclareOn, astFactory.createString(this.propertyKey()));
                    break;
                }
                case COMPUTED_PROPERTY: {
                    throw new UnsupportedOperationException(this.toString());
                }
                case NORMAL_PROPERTY: {
                    decl = astFactory.createGetProp(toDeclareOn, this.propertyKey(), AstFactory.type(this.propertyType()));
                }
            }
            decl.setJSDocInfo(this.jsDocInfo());
            decl = astFactory.exprResult(decl);
            return decl;
        }

        static Builder builder() {
            return new AutoValue_Es6RewriteClass_ClassProperty.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder propertyKey(String var1);

            abstract Builder kind(PropertyKind var1);

            abstract Builder jsDocInfo(JSDocInfo var1);

            abstract Builder propertyType(@Nullable Color var1);

            abstract ClassProperty build();
        }

        static enum PropertyKind {
            QUOTED_PROPERTY,
            COMPUTED_PROPERTY,
            NORMAL_PROPERTY;

        }
    }
}

