/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import org.jspecify.nullness.Nullable;

final class Es6RenameReferences
extends NodeTraversal.AbstractPostOrderCallback {
    private final Table<Node, String, String> renameTable;
    private final boolean typesOnly;

    Es6RenameReferences(Table<Node, String, String> renameTable, boolean typesOnly) {
        this.renameTable = renameTable;
        this.typesOnly = typesOnly;
    }

    Es6RenameReferences(Table<Node, String, String> renameTable) {
        this(renameTable, false);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info;
        if (!this.typesOnly && NodeUtil.isReferenceName(n)) {
            this.renameNameReference(t, n);
        }
        if ((info = n.getJSDocInfo()) != null) {
            for (Node root : info.getTypeNodes()) {
                this.renameTypeNodeRecursive(t, root);
            }
        }
    }

    private void renameTypeNodeRecursive(NodeTraversal t, Node n) {
        if (n.isStringLit()) {
            this.renameTypeReference(t, n);
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            this.renameTypeNodeRecursive(t, child);
        }
    }

    private void renameNameReference(NodeTraversal t, Node n) {
        Preconditions.checkState((boolean)n.isName());
        String oldName = n.getString();
        this.renameReference(t, n, oldName, null, false);
    }

    private void renameTypeReference(NodeTraversal t, Node n) {
        String rest;
        String rootName;
        Preconditions.checkState((boolean)n.isStringLit());
        String fullName = n.getString();
        int endPos = fullName.indexOf(46);
        if (endPos == -1) {
            rootName = fullName;
            rest = null;
        } else {
            rootName = fullName.substring(0, endPos);
            rest = fullName.substring(endPos);
        }
        this.renameReference(t, n, rootName, rest, true);
    }

    private void renameReference(NodeTraversal t, Node n, String oldName, @Nullable String rest, boolean inJSDoc) {
        for (Scope current = t.getScope(); current != null; current = current.getParent()) {
            String newName = (String)this.renameTable.get((Object)current.getRootNode(), (Object)oldName);
            if (newName != null) {
                String newFullName = rest == null ? newName : newName + rest;
                n.setString(newFullName);
                if (!inJSDoc) {
                    t.reportCodeChange();
                }
                return;
            }
            if (!current.hasOwnSlot(oldName)) continue;
            return;
        }
    }
}

