/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;

public final class Es6CheckModule
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType ES6_MODULE_REFERENCES_THIS = DiagnosticType.warning("ES6_MODULE_REFERENCES_THIS", "The body of an ES6 module cannot reference 'this'.");
    static final DiagnosticType IMPORT_CANNOT_BE_REASSIGNED = DiagnosticType.error("JSC_IMPORT_CANNOT_BE_REASSIGNED", "Assignment to constant variable \"{0}\".");
    private final AbstractCompiler compiler;

    public Es6CheckModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case THIS: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, ES6_MODULE_REFERENCES_THIS, new String[0]);
                break;
            }
            case GETPROP: 
            case GETELEM: {
                Node nameNode;
                Var var;
                if (!NodeUtil.isLValue(n) || NodeUtil.isDeclarationLValue(n) || !n.getFirstChild().isName() || (var = (Var)t.getScope().getVar(n.getFirstChild().getString())) == null || (nameNode = var.getNameNode()) == null || !nameNode.isImportStar()) break;
                this.compiler.report(JSError.make(n, IMPORT_CANNOT_BE_REASSIGNED, nameNode.getString()));
                break;
            }
            case NAME: {
                Node nameNode;
                Var var;
                if (!NodeUtil.isLValue(n) || NodeUtil.isDeclarationLValue(n) || (var = (Var)t.getScope().getVar(n.getString())) == null || (nameNode = var.getNameNode()) == null || nameNode == n || !NodeUtil.isImportedName(nameNode)) break;
                this.compiler.report(JSError.make(n, IMPORT_CANNOT_BE_REASSIGNED, nameNode.getString()));
                break;
            }
        }
    }
}

