/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.AutoValue_DependencyOptions;
import com.google.javascript.jscomp.FlagUsageException;
import com.google.javascript.jscomp.ModuleIdentifier;
import java.io.Serializable;
import java.util.List;
import org.jspecify.nullness.Nullable;

@Immutable
@AutoValue
public abstract class DependencyOptions
implements Serializable {
    public abstract DependencyMode getMode();

    public abstract ImmutableList<ModuleIdentifier> getEntryPoints();

    public boolean needsManagement() {
        return this.getMode() != DependencyMode.NONE;
    }

    public boolean shouldSort() {
        return this.getMode() != DependencyMode.NONE;
    }

    public boolean shouldPrune() {
        return this.getMode() == DependencyMode.PRUNE_LEGACY || this.getMode() == DependencyMode.PRUNE;
    }

    public boolean shouldDropMoochers() {
        return this.getMode() == DependencyMode.PRUNE;
    }

    public static DependencyOptions none() {
        return new AutoValue_DependencyOptions(DependencyMode.NONE, (ImmutableList<ModuleIdentifier>)ImmutableList.of());
    }

    public static DependencyOptions sortOnly() {
        return new AutoValue_DependencyOptions(DependencyMode.SORT_ONLY, (ImmutableList<ModuleIdentifier>)ImmutableList.of());
    }

    @Deprecated
    public static DependencyOptions pruneLegacyForEntryPoints(Iterable<ModuleIdentifier> entryPoints) {
        return new AutoValue_DependencyOptions(DependencyMode.PRUNE_LEGACY, (ImmutableList<ModuleIdentifier>)ImmutableList.copyOf(entryPoints));
    }

    public static DependencyOptions pruneForEntryPoints(Iterable<ModuleIdentifier> entryPoints) {
        Preconditions.checkState((!Iterables.isEmpty(entryPoints) ? 1 : 0) != 0, (Object)"DependencyMode.PRUNE requires at least one entry point");
        return new AutoValue_DependencyOptions(DependencyMode.PRUNE, (ImmutableList<ModuleIdentifier>)ImmutableList.copyOf(entryPoints));
    }

    public static @Nullable DependencyOptions fromFlags(@Nullable DependencyMode dependencyModeFlag, List<String> entryPointFlag, List<String> closureEntryPointFlag, String commonJsEntryModuleFlag, boolean manageClosureDependenciesFlag, boolean onlyClosureDependenciesFlag) {
        DependencyMode dependencyMode;
        boolean hasEntryPoint;
        boolean bl = hasEntryPoint = commonJsEntryModuleFlag != null || !entryPointFlag.isEmpty() || !closureEntryPointFlag.isEmpty();
        if (!hasEntryPoint && onlyClosureDependenciesFlag) {
            throw new FlagUsageException("--only_closure_dependencies requires --entry_point.");
        }
        if (!hasEntryPoint && dependencyModeFlag == DependencyMode.PRUNE) {
            throw new FlagUsageException("--dependency_mode=PRUNE requires --entry_point.");
        }
        if (hasEntryPoint && (dependencyModeFlag == DependencyMode.NONE || dependencyModeFlag == DependencyMode.SORT_ONLY)) {
            throw new FlagUsageException("--dependency_mode=" + dependencyModeFlag + " cannot be used with --entry_point, --closure_entry_point or --common_js_entry_module.");
        }
        if (!entryPointFlag.isEmpty() && !closureEntryPointFlag.isEmpty()) {
            throw new FlagUsageException("--closure_entry_point cannot be used with --entry_point.");
        }
        if (!(commonJsEntryModuleFlag == null || entryPointFlag.isEmpty() && closureEntryPointFlag.isEmpty())) {
            throw new FlagUsageException("--common_js_entry_module cannot be used with either --entry_point or --closure_entry_point.");
        }
        if (manageClosureDependenciesFlag && onlyClosureDependenciesFlag) {
            throw new FlagUsageException("--only_closure_dependencies cannot be used with --manage_closure_dependencies.");
        }
        if (manageClosureDependenciesFlag && dependencyModeFlag != null) {
            throw new FlagUsageException("--manage_closure_dependencies cannot be used with --dependency_mode.");
        }
        if (onlyClosureDependenciesFlag && dependencyModeFlag != null) {
            throw new FlagUsageException("--only_closure_dependencies cannot be used with --dependency_mode.");
        }
        if (dependencyModeFlag == DependencyMode.PRUNE || onlyClosureDependenciesFlag) {
            dependencyMode = DependencyMode.PRUNE;
        } else if (dependencyModeFlag == DependencyMode.PRUNE_LEGACY || manageClosureDependenciesFlag || hasEntryPoint) {
            dependencyMode = DependencyMode.PRUNE_LEGACY;
        } else if (dependencyModeFlag != null) {
            dependencyMode = dependencyModeFlag;
        } else {
            return null;
        }
        ImmutableList.Builder entryPointsBuilder = ImmutableList.builder();
        if (commonJsEntryModuleFlag != null) {
            entryPointsBuilder.add((Object)ModuleIdentifier.forFile(commonJsEntryModuleFlag));
        }
        for (String entryPoint : entryPointFlag) {
            entryPointsBuilder.add((Object)ModuleIdentifier.forFlagValue(entryPoint));
        }
        for (String closureEntryPoint : closureEntryPointFlag) {
            entryPointsBuilder.add((Object)ModuleIdentifier.forClosure(closureEntryPoint));
        }
        switch (dependencyMode) {
            case NONE: {
                return DependencyOptions.none();
            }
            case SORT_ONLY: {
                return DependencyOptions.sortOnly();
            }
            case PRUNE_LEGACY: {
                return DependencyOptions.pruneLegacyForEntryPoints((Iterable<ModuleIdentifier>)entryPointsBuilder.build());
            }
            case PRUNE: {
                return DependencyOptions.pruneForEntryPoints((Iterable<ModuleIdentifier>)entryPointsBuilder.build());
            }
        }
        throw new AssertionError((Object)"Invalid DependencyMode");
    }

    public static enum DependencyMode {
        NONE,
        SORT_ONLY,
        PRUNE_LEGACY,
        PRUNE;

    }
}

