/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceCollector;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class Denormalize
implements CompilerPass,
NodeTraversal.Callback,
ReferenceCollector.Behavior {
    private final AbstractCompiler compiler;
    private final FeatureSet outputFeatureSet;

    Denormalize(AbstractCompiler compiler, FeatureSet outputFeatureSet) {
        this.compiler = compiler;
        this.outputFeatureSet = outputFeatureSet;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.compiler.getOptions().syntheticBlockStartMarker == null) {
            new ReferenceCollector(this.compiler, this, new SyntacticScopeCreator(this.compiler)).process(root);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
        Node scopeRoot = t.getScopeRoot();
        if (scopeRoot.isBlock() && scopeRoot.getParent().isFunction()) {
            boolean changed = false;
            for (Var v : t.getScope().getVarIterable()) {
                Node lhs;
                Node assignNode;
                ReferenceCollection references = referenceMap.getReferences(v);
                Reference declaration = null;
                Reference assign = null;
                for (Reference r : references) {
                    if (r.isVarDeclaration() && NodeUtil.isStatement(r.getNode().getParent()) && !r.isInitializingDeclaration()) {
                        declaration = r;
                        continue;
                    }
                    if (assign != null || !r.isSimpleAssignmentToName() || !((Scope)r.getScope().getClosestHoistScope()).equals(t.getScope())) continue;
                    assign = r;
                }
                if (declaration == null || assign == null || !(assignNode = (lhs = assign.getNode()).getParent()).getParent().isExprResult()) continue;
                Node rhs = lhs.getNext();
                assignNode.getParent().replaceWith(IR.var(lhs.detach(), rhs.detach()));
                Node var = declaration.getNode().getParent();
                Preconditions.checkState((boolean)var.isVar(), (Object)var);
                NodeUtil.removeChild(var, declaration.getNode());
                changed = true;
            }
            if (changed) {
                t.reportCodeChange();
            }
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.maybeCollapseIntoForStatements(n, parent);
        this.maybeCollapseLogicalAssignShorthand(t, n, parent);
        this.maybeCollapseAssignShorthand(n, parent);
    }

    private void maybeCollapseIntoForStatements(Node n, Node parent) {
        if (parent == null || !NodeUtil.isStatementBlock(parent)) {
            return;
        }
        if (!n.isExprResult() && !n.isVar()) {
            return;
        }
        Node nextSibling = n.getNext();
        if (nextSibling == null) {
            return;
        }
        if (nextSibling.isForIn() || nextSibling.isForOf()) {
            Node name;
            Node forNode = nextSibling;
            Node forVar = forNode.getFirstChild();
            if (forVar.isName() && n.isVar() && n.hasOneChild() && !(name = n.getFirstChild()).hasChildren() && forVar.getString().equals(name.getString())) {
                n.detach();
                forVar.replaceWith(n);
                this.compiler.reportChangeToEnclosingScope(parent);
            }
        } else if (nextSibling.isVanillaFor() && nextSibling.getFirstChild().isEmpty()) {
            Node newInitializer;
            if (NodeUtil.has(n, (Predicate<Node>)((Predicate)Node::isIn), (Predicate<Node>)Predicates.alwaysTrue())) {
                return;
            }
            Node forNode = nextSibling;
            Node oldInitializer = forNode.getFirstChild();
            n.detach();
            if (n.isVar()) {
                newInitializer = n;
            } else {
                Preconditions.checkState((boolean)n.hasOneChild(), (Object)n);
                newInitializer = n.getFirstChild();
                newInitializer.detach();
            }
            oldInitializer.replaceWith(newInitializer);
            this.compiler.reportChangeToEnclosingScope(forNode);
        }
    }

    private void maybeCollapseAssignShorthand(Node n, Node parent) {
        if (!this.isCollapsableAssign(n)) {
            return;
        }
        Node op = n.getLastChild();
        Token assignOp = this.getAssignOpFromOp(op);
        if (n.getFirstChild().getString().equals(op.getFirstChild().getString())) {
            op.setToken(assignOp);
            Node opDetached = op.detach();
            opDetached.setJSDocInfo(n.getJSDocInfo());
            n.replaceWith(opDetached);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private void maybeCollapseLogicalAssignShorthand(NodeTraversal t, Node n, Node parent) {
        if (!this.isCollapsableLogicalAssign(n)) {
            return;
        }
        Node op = n.getLastChild();
        Token assignOp = this.getAssignOpFromOp(n);
        if (n.getFirstChild().getString().equals(op.getFirstChild().getString())) {
            op.setToken(assignOp);
            Node opDetached = op.detach();
            opDetached.setJSDocInfo(n.getJSDocInfo());
            n.replaceWith(opDetached);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LOGICAL_ASSIGNMENT, this.compiler);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private boolean isCollapsableAssign(Node n) {
        return n.isAssign() && n.getFirstChild().isName() && this.hasCorrespondingAssignmentOp(n.getLastChild()) && n.getLastChild().getFirstChild().isName();
    }

    private boolean isCollapsableLogicalAssign(Node n) {
        return this.outputFeatureSet.has(FeatureSet.Feature.LOGICAL_ASSIGNMENT) && (n.isOr() || n.isAnd() || n.isNullishCoalesce()) && n.getFirstChild().isName() && n.getLastChild().isAssign() && n.getLastChild().getFirstChild().isName();
    }

    private Token getAssignOpFromOp(Node n) {
        switch (n.getToken()) {
            case BITOR: {
                return Token.ASSIGN_BITOR;
            }
            case BITXOR: {
                return Token.ASSIGN_BITXOR;
            }
            case BITAND: {
                return Token.ASSIGN_BITAND;
            }
            case LSH: {
                return Token.ASSIGN_LSH;
            }
            case RSH: {
                return Token.ASSIGN_RSH;
            }
            case URSH: {
                return Token.ASSIGN_URSH;
            }
            case ADD: {
                return Token.ASSIGN_ADD;
            }
            case SUB: {
                return Token.ASSIGN_SUB;
            }
            case MUL: {
                return Token.ASSIGN_MUL;
            }
            case EXPONENT: {
                return Token.ASSIGN_EXPONENT;
            }
            case DIV: {
                return Token.ASSIGN_DIV;
            }
            case MOD: {
                return Token.ASSIGN_MOD;
            }
            case OR: {
                return Token.ASSIGN_OR;
            }
            case AND: {
                return Token.ASSIGN_AND;
            }
            case COALESCE: {
                return Token.ASSIGN_COALESCE;
            }
        }
        throw new IllegalStateException("Unexpected operator: " + n);
    }

    private boolean hasCorrespondingAssignmentOp(Node n) {
        switch (n.getToken()) {
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case LSH: 
            case RSH: 
            case URSH: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: {
                return true;
            }
        }
        return false;
    }
}

