/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AngularPass;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckClosureImports;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingOverrideTypes;
import com.google.javascript.jscomp.CheckMissingRequires;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.ChromePass;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.ConvertChunksToESModules;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossChunkCodeMotion;
import com.google.javascript.jscomp.CrossChunkMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.DeadPropertyAssignmentElimination;
import com.google.javascript.jscomp.DeclaredGlobalExternsOnWindow;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizeMethods;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.Es6CheckModule;
import com.google.javascript.jscomp.Es6RewriteScriptsToModules;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.ForbidDynamicImportUsage;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InferConsts;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.InjectRuntimeLibraries;
import com.google.javascript.jscomp.InlineAndCollapseProperties;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.IsolatePolyfills;
import com.google.javascript.jscomp.J2clAssertRemovalPass;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.J2clClinitPrunerPass;
import com.google.javascript.jscomp.J2clConstantHoisterPass;
import com.google.javascript.jscomp.J2clEqualitySameRewriterPass;
import com.google.javascript.jscomp.J2clPass;
import com.google.javascript.jscomp.J2clPropertyInlinerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.J2clStringValueOfRewriterPass;
import com.google.javascript.jscomp.J2clUtilGetDefineRewriterPass;
import com.google.javascript.jscomp.LocaleDataPasses;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkUntranspilableFeaturesAsRemoved;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeConstructors;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.ParenthesizeFunctionsInChunks;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PassListBuilder;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReorderConstantExpression;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessClosureProvidesAndRequires;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveCastNodes;
import com.google.javascript.jscomp.RemoveUnnecessarySyntheticExterns;
import com.google.javascript.jscomp.RemoveUnusedCode;
import com.google.javascript.jscomp.RemoveWeakSources;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.RenamingMap;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RewriteDynamicImports;
import com.google.javascript.jscomp.RewriteGlobalDeclarationsForTryCatchWrapping;
import com.google.javascript.jscomp.RewriteGoogJsImports;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SubstituteEs6Syntax;
import com.google.javascript.jscomp.SyncCompilerFeatures;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WhitespaceWrapGoogModules;
import com.google.javascript.jscomp.disambiguate.AmbiguateProperties;
import com.google.javascript.jscomp.disambiguate.DisambiguateProperties;
import com.google.javascript.jscomp.ijs.ConvertToTypedInterface;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationPass;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckConstPrivateProperties;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckDefaultExportOfGoogModule;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckEs6ModuleFileStructure;
import com.google.javascript.jscomp.lint.CheckEs6Modules;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.jscomp.lint.CheckGoogModuleTypeScriptName;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNestedNames;
import com.google.javascript.jscomp.lint.CheckNoMutatedEs6Exports;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.lint.CheckVar;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.serialization.ConvertTypesToColors;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.SerializeTypedAstPass;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;

public final class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private final transient PreprocessorSymbolTable.CachedInstanceFactory preprocessorSymbolTableFactory = new PreprocessorSymbolTable.CachedInstanceFactory();
    private final PassFactory syncCompilerFeatures = PassFactory.builder().setName("syncCompilerFeatures").setInternalFactory(SyncCompilerFeatures::new).build();
    private final PassFactory checkSideEffects = PassFactory.builder().setName("checkSideEffects").setInternalFactory(compiler -> new CheckSideEffects((AbstractCompiler)compiler, this.options.checkSuspiciousCode, this.options.shouldProtectHiddenSideEffects())).build();
    private final PassFactory stripSideEffectProtection = PassFactory.builder().setName("stripSideEffectProtection").setInternalFactory(CheckSideEffects.StripProtection::new).build();
    private final PassFactory suspiciousCode = PassFactory.builder().setName("suspiciousCode").setInternalFactory(compiler -> {
        ArrayList<NodeTraversal.Callback> sharedCallbacks = new ArrayList<NodeTraversal.Callback>();
        if (this.options.checkSuspiciousCode) {
            sharedCallbacks.add(new CheckSuspiciousCode());
            sharedCallbacks.add(new CheckDuplicateCase((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
            sharedCallbacks.add(new CheckGlobalThis((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            sharedCallbacks.add(new CheckDebuggerStatement((AbstractCompiler)compiler));
        }
        return DefaultPassConfig.combineChecks(compiler, sharedCallbacks);
    }).build();
    private final PassFactory extraRequires = PassFactory.builder().setName("checkExtraRequires").setInternalFactory(compiler -> new CheckExtraRequires((AbstractCompiler)compiler, this.options.getUnusedImportsToRemove())).build();
    private final PassFactory checkMissingRequires = PassFactory.builder().setName("checkMissingRequires").setInternalFactory(compiler -> new CheckMissingRequires((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).build();
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory checkJsDocAndEs6Modules = PassFactory.builder().setName("checkJsDocAndEs6Modules").setInternalFactory(compiler -> DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckJSDoc((AbstractCompiler)compiler), (Object)new Es6CheckModule((AbstractCompiler)compiler)))).build();
    private final PassFactory generateExports = PassFactory.builder().setName("generateExports").setInternalFactory(compiler -> {
        CodingConvention convention = compiler.getCodingConvention();
        final GenerateExports pass = new GenerateExports((AbstractCompiler)compiler, this.options.exportLocalPropertyDefinitions, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.addExportedNames(pass.getExportedVariableNames());
            }
        };
    }).build();
    private final PassFactory generateIjs = PassFactory.builder().setName("generateIjs").setInternalFactory(ConvertToTypedInterface::new).build();
    private final PassFactory exportTestFunctions = PassFactory.builder().setName("exportTestFunctions").setInternalFactory(compiler -> {
        CodingConvention convention = compiler.getCodingConvention();
        if (convention.getExportSymbolFunction() != null) {
            return new ExportTestFunctions((AbstractCompiler)compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
        }
        return new ErrorPass((AbstractCompiler)compiler, GENERATE_EXPORTS_ERROR);
    }).build();
    private final PassFactory gatherRawExports = PassFactory.builder().setName("gatherRawExports").setInternalFactory(compiler -> {
        final GatherRawExports pass = new GatherRawExports((AbstractCompiler)compiler);
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.addExportedNames(pass.getExportedVariableNames());
            }
        };
    }).build();
    private final PassFactory closurePrimitives = PassFactory.builder().setName("closurePrimitives").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        ProcessClosurePrimitives pass = new ProcessClosurePrimitives((AbstractCompiler)compiler);
        return (externs, root) -> {
            pass.process(externs, root);
            compiler.addExportedNames(pass.getExportedVariableNames());
        };
    }).build();
    private final PassFactory closureProvidesRequires = PassFactory.builder().setName("closureProvidesRequires").setInternalFactory(compiler -> new ProcessClosureProvidesAndRequires((AbstractCompiler)compiler, this.options.shouldPreservesGoogProvidesAndRequires())).build();
    private final PassFactory angularPass = PassFactory.builder().setName("angularPass").setInternalFactory(AngularPass::new).build();
    private final PassFactory replaceMessagesForChrome = PassFactory.builder().setName("replaceMessages").setInternalFactory(compiler -> new ReplaceMessagesForChrome((AbstractCompiler)compiler, new GoogleJsMessageIdGenerator(this.options.tcProjectId))).build();
    private final PassFactory closureGoogScopeAliasesForIjs = PassFactory.builder().setName("closureGoogScopeAliasesForIjs").setInternalFactory(compiler -> ScopedAliases.builder(compiler).build()).build();
    private final PassFactory closureGoogScopeAliases = PassFactory.builder().setName("closureGoogScopeAliases").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        return ScopedAliases.builder(compiler).setPreprocessorSymbolTable(this.preprocessorSymbolTableFactory.getInstanceOrNull()).setAliasTransformationHandler(this.options.getAliasTransformationHandler()).setModuleMetadataMap(compiler.getModuleMetadataMap()).setInvalidModuleGetHandling(ScopedAliases.InvalidModuleGetHandling.DELETE).build();
    }).build();
    private final PassFactory injectRuntimeLibrariesForChecks = PassFactory.builder().setName("InjectRuntimeLibraries").setInternalFactory(InjectRuntimeLibraries::forChecks).build();
    private final PassFactory injectRuntimeLibrariesForOptimizations = PassFactory.builder().setName("InjectRuntimeLibraries").setInternalFactory(InjectRuntimeLibraries::forOptimizations).build();
    private final PassFactory markUntranspilableFeaturesAsRemoved = PassFactory.builder().setName("markUntranspilableFeaturesAsRemoved").setInternalFactory(compiler -> new MarkUntranspilableFeaturesAsRemoved((AbstractCompiler)compiler, this.options.getOutputFeatureSet())).build();
    private final PassFactory removeWeakSources = PassFactory.builder().setName("removeWeakSources").setInternalFactory(RemoveWeakSources::new).build();
    private final PassFactory declaredGlobalExternsOnWindow = PassFactory.builder().setName("declaredGlobalExternsOnWindow").setInternalFactory(DeclaredGlobalExternsOnWindow::new).build();
    private final PassFactory checkTypeImportCodeReferences = PassFactory.builder().setName("checkTypeImportCodeReferences").setInternalFactory(CheckTypeImportCodeReferences::new).build();
    private final PassFactory closureRewriteClass = PassFactory.builder().setName("closureRewriteClass").setInternalFactory(ClosureRewriteClass::new).build();
    private final PassFactory closureCheckModule = PassFactory.builder().setName("closureCheckModule").setInternalFactory(compiler -> new ClosureCheckModule((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).build();
    private final PassFactory closureRewriteModule = PassFactory.builder().setName("closureRewriteModule").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        return new ClosureRewriteModule((AbstractCompiler)compiler, this.preprocessorSymbolTableFactory.getInstanceOrNull(), compiler.getTopScope());
    }).build();
    private final PassFactory checkClosureImports = PassFactory.builder().setName("checkGoogRequires").setInternalFactory(compiler -> new CheckClosureImports((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).build();
    private final PassFactory rewriteGoogJsImports = PassFactory.builder().setName("rewriteGoogJsImports").setInternalFactory(compiler -> new RewriteGoogJsImports((AbstractCompiler)compiler, RewriteGoogJsImports.Mode.LINT_AND_REWRITE, compiler.getModuleMap())).build();
    private final PassFactory closureReplaceGetCssName = PassFactory.builder().setName("closureReplaceGetCssName").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            LinkedHashMap<String, Integer> newCssNames = null;
            if (DefaultPassConfig.this.options.gatherCssNames) {
                newCssNames = new LinkedHashMap<String, Integer>();
            }
            ReplaceCssNames pass = new ReplaceCssNames(this.val$compiler, newCssNames, DefaultPassConfig.this.options.cssRenamingSkiplist);
            pass.process(externs, jsRoot);
            this.val$compiler.setCssNames(newCssNames);
        }
    }).build();
    private final PassFactory createSyntheticBlocks = PassFactory.builder().setName("createSyntheticBlocks").setInternalFactory(compiler -> new CreateSyntheticBlocks((AbstractCompiler)compiler, this.options.syntheticBlockStartMarker, this.options.syntheticBlockEndMarker)).build();
    private final PassFactory earlyPeepholeOptimizations = PassFactory.builder().setName("earlyPeepholeOptimizations").setInternalFactory(compiler -> {
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<AbstractPeepholeOptimization> peepholeOptimizations = new ArrayList<AbstractPeepholeOptimization>();
        peepholeOptimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            peepholeOptimizations.add(new J2clEqualitySameRewriterPass(useTypesForOptimization));
        }
        return new PeepholeOptimizationsPass((AbstractCompiler)compiler, "earlyPeepholeOptimizations", (List<AbstractPeepholeOptimization>)peepholeOptimizations);
    }).build();
    private final PassFactory earlyInlineVariables = PassFactory.builder().setName("earlyInlineVariables").setInternalFactory(compiler -> {
        InlineVariables.Mode mode;
        if (this.options.inlineVariables) {
            mode = InlineVariables.Mode.ALL;
        } else if (this.options.inlineLocalVariables) {
            mode = InlineVariables.Mode.LOCALS_ONLY;
        } else {
            throw new IllegalStateException("No variable inlining option set.");
        }
        return new InlineVariables((AbstractCompiler)compiler, mode);
    }).build();
    private final PassFactory peepholeOptimizations = PassFactory.builder().setName("peepholeOptimizations").setRunInFixedPointLoop(true).setInternalFactory(compiler -> DefaultPassConfig.createPeepholeOptimizationsPass(compiler, "peepholeOptimizations")).build();
    private final PassFactory peepholeOptimizationsOnce = PassFactory.builder().setName("peepholeOptimizations").setInternalFactory(compiler -> DefaultPassConfig.createPeepholeOptimizationsPass(compiler, "peepholeOptimizations")).build();
    private final PassFactory latePeepholeOptimizations = PassFactory.builder().setName("latePeepholeOptimizations").setInternalFactory(compiler -> {
        boolean late = true;
        boolean useTypesForOptimization = this.options.useTypesForLocalOptimization;
        return new PeepholeOptimizationsPass((AbstractCompiler)compiler, "latePeepholeOptimizations", new StatementFusion(), new PeepholeRemoveDeadCode(), new PeepholeMinimizeConditions(true), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true, useTypesForOptimization), new PeepholeFoldConstants(true, useTypesForOptimization), new PeepholeReorderConstantExpression());
    }).build();
    private final PassFactory checkVars = PassFactory.builder().setName("checkVars").setInternalFactory(VarCheck::new).build();
    private final PassFactory inferConsts = PassFactory.builder().setName("inferConsts").setInternalFactory(InferConsts::new).build();
    private final PassFactory checkRegExp = PassFactory.builder().setName("checkRegExp").setInternalFactory(compiler -> {
        final CheckRegExp pass = new CheckRegExp((AbstractCompiler)compiler, true);
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
            }
        };
    }).build();
    private final PassFactory checkRegExpForOptimizations = PassFactory.builder().setName("checkRegExpForOptimizations").setInternalFactory(compiler -> {
        final CheckRegExp regExpCheck = new CheckRegExp((AbstractCompiler)compiler, false);
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                regExpCheck.process(externs, root);
                this.val$compiler.setHasRegExpGlobalReferences(regExpCheck.isGlobalRegExpPropertiesUsed());
            }
        };
    }).build();
    private final PassFactory checkVariableReferences = PassFactory.builder().setName("checkVariableReferences").setInternalFactory(VariableReferenceCheck::new).build();
    private final PassFactory checkSuper = PassFactory.builder().setName("checkSuper").setInternalFactory(CheckSuper::new).build();
    private final PassFactory clearTypedScopeCreatorPass = PassFactory.builder().setName("clearTypedScopeCreatorPass").setInternalFactory(compiler -> (externs, root) -> compiler.clearTypedScopeCreator()).build();
    private final PassFactory clearTopTypedScopePass = PassFactory.builder().setName("clearTopTypedScopePass").setInternalFactory(compiler -> (externs, root) -> {
        compiler.setTopScope(null);
        for (CompilerInput compilerInput : compiler.getInputsInOrder()) {
            compilerInput.setTypedScope(null);
        }
    }).build();
    final PassFactory inferTypes = PassFactory.builder().setName("inferTypes").setInternalFactory(compiler -> (unused, srcRoot) -> {
        Node globalRoot = srcRoot.getParent();
        TypeInferencePass inferencePass = new TypeInferencePass((AbstractCompiler)compiler, compiler.getReverseAbstractInterpreter(), (TypedScopeCreator)compiler.getTypedScopeCreator());
        compiler.setTypeCheckingHasRun(true);
        compiler.setTopScope(inferencePass.inferAllScopes(globalRoot));
    }).build();
    private final PassFactory checkMissingOverrideTypes = PassFactory.builder().setName("checkMissingOverrideTypes").setInternalFactory(CheckMissingOverrideTypes::new).build();
    private final PassFactory inferJsDocInfo = PassFactory.builder().setName("inferJsDocInfo").setInternalFactory(InferJSDocInfo::new).build();
    private final PassFactory checkTypes = PassFactory.builder().setName("checkTypes").setInternalFactory(compiler -> (externs, root) -> {
        TypeCheck check = new TypeCheck((AbstractCompiler)compiler, compiler.getReverseAbstractInterpreter(), compiler.getTypeRegistry(), compiler.getTopScope(), (TypedScopeCreator)compiler.getTypedScopeCreator()).reportUnknownTypes(this.options.enables(DiagnosticGroup.forType(TypeCheck.UNKNOWN_EXPR_TYPE))).reportMissingProperties(!this.options.disables(DiagnosticGroup.forType(TypeCheck.INEXISTENT_PROPERTY)));
        check.process(externs, root);
        compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
    }).build();
    private final PassFactory checkControlFlow = PassFactory.builder().setName("checkControlFlow").setInternalFactory(compiler -> {
        ArrayList<NodeTraversal.Callback> callbacks = new ArrayList<NodeTraversal.Callback>();
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE)) {
            callbacks.add(new CheckUnreachableCode((AbstractCompiler)compiler));
        }
        if (!this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            callbacks.add(new CheckMissingReturn((AbstractCompiler)compiler));
        }
        return DefaultPassConfig.combineChecks(compiler, callbacks);
    }).build();
    private final PassFactory checkAccessControls = PassFactory.builder().setName("checkAccessControls").setInternalFactory(CheckAccessControls::new).build();
    private final PassFactory lintChecks = PassFactory.builder().setName("lintChecks").setInternalFactory(compiler -> {
        ImmutableList.Builder callbacks = ImmutableList.builder().add((Object)new CheckConstPrivateProperties((AbstractCompiler)compiler)).add((Object)new CheckConstantCaseNames((AbstractCompiler)compiler)).add((Object)new CheckDefaultExportOfGoogModule((AbstractCompiler)compiler)).add((Object)new CheckEmptyStatements((AbstractCompiler)compiler)).add((Object)new CheckEnums((AbstractCompiler)compiler)).add((Object)new CheckEs6ModuleFileStructure((AbstractCompiler)compiler)).add((Object)new CheckEs6Modules((AbstractCompiler)compiler)).add((Object)new CheckNoMutatedEs6Exports((AbstractCompiler)compiler)).add((Object)new CheckGoogModuleTypeScriptName((AbstractCompiler)compiler)).add((Object)new CheckInterfaces((AbstractCompiler)compiler)).add((Object)new CheckJSDocStyle((AbstractCompiler)compiler)).add((Object)new CheckMissingSemicolon((AbstractCompiler)compiler)).add((Object)new CheckNullabilityModifiers((AbstractCompiler)compiler)).add((Object)new CheckPrimitiveAsObject((AbstractCompiler)compiler)).add((Object)new CheckPrototypeProperties((AbstractCompiler)compiler)).add((Object)new CheckUnusedPrivateProperties((AbstractCompiler)compiler)).add((Object)new CheckUnusedLabels((AbstractCompiler)compiler)).add((Object)new CheckUselessBlocks((AbstractCompiler)compiler)).add((Object)new CheckVar((AbstractCompiler)compiler));
        return DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)callbacks.build());
    }).build();
    private final PassFactory analyzerChecks = PassFactory.builder().setName("analyzerChecks").setInternalFactory(compiler -> {
        ImmutableList callbacks = ImmutableList.of((Object)new CheckArrayWithGoogObject((AbstractCompiler)compiler), (Object)new ImplicitNullabilityCheck((AbstractCompiler)compiler), (Object)new CheckNestedNames((AbstractCompiler)compiler));
        return DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)callbacks);
    }).build();
    private final PassFactory checkRequiresAndProvidesSorted = PassFactory.builder().setName("checkRequiresAndProvidesSorted").setInternalFactory(compiler -> DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)ImmutableList.of((Object)new CheckProvidesSorted(CheckProvidesSorted.Mode.COLLECT_AND_REPORT), (Object)new CheckRequiresSorted(CheckRequiresSorted.Mode.COLLECT_AND_REPORT)))).build();
    private final PassFactory checkStrictMode = PassFactory.builder().setName("checkStrictMode").setInternalFactory(compiler -> {
        CheckLevel defaultLevel = this.options.expectStrictModeInput() ? CheckLevel.ERROR : CheckLevel.OFF;
        return new StrictModeCheck((AbstractCompiler)compiler, defaultLevel);
    }).build();
    private final PassFactory processTweaks = PassFactory.builder().setName("processTweaks").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            new ProcessTweaks(this.val$compiler, DefaultPassConfig.this.options.getTweakProcessing().shouldStrip()).process(externs, jsRoot);
        }
    }).build();
    private final PassFactory processDefinesCheck = this.createProcessDefines(ProcessDefines.Mode.CHECK);
    private final PassFactory processDefinesOptimize = this.createProcessDefines(ProcessDefines.Mode.OPTIMIZE);
    private final PassFactory stripCode = PassFactory.builder().setName("stripCode").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            CompilerOptions options = this.val$compiler.getOptions();
            StripCode pass = new StripCode(this.val$compiler, options.stripTypes, options.stripNameSuffixes, options.stripNamePrefixes, options.getTweakProcessing().shouldStrip());
            pass.process(externs, jsRoot);
        }
    }).build();
    private final PassFactory checkConsts = PassFactory.builder().setName("checkConsts").setInternalFactory(ConstCheck::new).build();
    private final PassFactory checkConstParams = PassFactory.builder().setName("checkConstParams").setInternalFactory(ConstParamCheck::new).build();
    private final PassFactory replaceIdGenerators = PassFactory.builder().setName("replaceIdGenerators").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            ReplaceIdGenerators pass = new ReplaceIdGenerators(this.val$compiler, (Map<String, RenamingMap>)DefaultPassConfig.this.options.idGenerators, DefaultPassConfig.this.options.generatePseudoNames, DefaultPassConfig.this.options.idGeneratorsMapSerialized, DefaultPassConfig.this.options.xidHashFunction);
            pass.process(externs, root);
            this.val$compiler.setIdGeneratorMap(pass.getSerializedIdMappings());
        }
    }).build();
    private final PassFactory replaceStrings = PassFactory.builder().setName("replaceStrings").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            ReplaceStrings pass = new ReplaceStrings(this.val$compiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions);
            pass.process(externs, root);
            this.val$compiler.setStringMap(pass.getStringMap());
        }
    }).build();
    private final PassFactory optimizeArgumentsArray = PassFactory.builder().setName("optimizeArgumentsArray").setInternalFactory(OptimizeArgumentsArray::new).build();
    private final PassFactory closureCodeRemoval = PassFactory.builder().setName("closureCodeRemoval").setInternalFactory(compiler -> new ClosureCodeRemoval((AbstractCompiler)compiler, this.options.removeAbstractMethods, this.options.removeClosureAsserts)).build();
    private final PassFactory closureOptimizePrimitives = PassFactory.builder().setName("closureOptimizePrimitives").setInternalFactory(compiler -> new ClosureOptimizePrimitives((AbstractCompiler)compiler, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED, compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.ES2015))).build();
    private final PassFactory rescopeGlobalSymbols = PassFactory.builder().setName("rescopeGlobalSymbols").setInternalFactory(compiler -> new RescopeGlobalSymbols((AbstractCompiler)compiler, this.options.renamePrefixNamespace, this.options.renamePrefixNamespaceAssumeCrossChunkNames)).build();
    private final PassFactory convertChunksToESModules = PassFactory.builder().setName("convertChunksToESModules").setInternalFactory(ConvertChunksToESModules::new).build();
    private final PassFactory inlineAndCollapseProperties = PassFactory.builder().setName("inlineAndCollapseProperties").setInternalFactory(compiler -> InlineAndCollapseProperties.builder(compiler).setPropertyCollapseLevel(this.options.getPropertyCollapseLevel()).setChunkOutputType(this.options.getChunkOutputType()).setHaveModulesBeenRewritten(this.options.getProcessCommonJSModules()).setModuleResolutionMode(this.options.getModuleResolutionMode()).setAssumeStaticInheritanceIsNotUsed(this.options.getAssumeStaticInheritanceIsNotUsed()).build()).build();
    private final PassFactory collapseObjectLiterals = PassFactory.builder().setName("collapseObjectLiterals").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineObjectLiterals((AbstractCompiler)compiler, compiler.getUniqueNameIdSupplier())).build();
    private final PassFactory disambiguateProperties = PassFactory.builder().setName("disambiguateProperties").setInternalFactory(compiler -> new DisambiguateProperties((AbstractCompiler)compiler, this.options.getPropertiesThatMustDisambiguate())).build();
    private final PassFactory parenthesizeFunctionsInChunks = PassFactory.builder().setName("parenthesizeFunctionsInChunks").setInternalFactory(compiler -> new ParenthesizeFunctionsInChunks((AbstractCompiler)compiler, (Set<String>)new HashSet<String>(this.options.parenthesizeFunctionsInChunks))).build();
    private final PassFactory devirtualizeMethods = PassFactory.builder().setName("devirtualizeMethods").setInternalFactory(compiler -> OptimizeCalls.builder().setCompiler((AbstractCompiler)compiler).setConsiderExterns(false).addPass(new DevirtualizeMethods((AbstractCompiler)compiler)).build()).build();
    private final PassFactory optimizeCalls = PassFactory.builder().setName("optimizeCalls").setRunInFixedPointLoop(true).setInternalFactory(compiler -> OptimizeCalls.builder().setCompiler((AbstractCompiler)compiler).setConsiderExterns(false).addPass(new OptimizeReturns((AbstractCompiler)compiler)).addPass(new OptimizeParameters((AbstractCompiler)compiler)).build()).build();
    private final PassFactory optimizeConstructors = PassFactory.builder().setName("optimizeConstructors").setRunInFixedPointLoop(false).setInternalFactory(compiler -> OptimizeCalls.builder().setCompiler((AbstractCompiler)compiler).setConsiderExterns(false).addPass(new OptimizeConstructors((AbstractCompiler)compiler)).build()).build();
    private final PassFactory markPureFunctions = PassFactory.builder().setName("markPureFunctions").setInternalFactory(PureFunctionIdentifier.Driver::new).build();
    private final PassFactory inlineVariables = PassFactory.builder().setName("inlineVariables").setRunInFixedPointLoop(true).setInternalFactory(compiler -> {
        InlineVariables.Mode mode;
        if (this.options.inlineVariables) {
            mode = InlineVariables.Mode.ALL;
        } else if (this.options.inlineLocalVariables) {
            mode = InlineVariables.Mode.LOCALS_ONLY;
        } else {
            throw new IllegalStateException("No variable inlining option set.");
        }
        return new InlineVariables((AbstractCompiler)compiler, mode);
    }).build();
    private final PassFactory inlineConstants = PassFactory.builder().setName("inlineConstants").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineVariables((AbstractCompiler)compiler, InlineVariables.Mode.CONSTANTS_ONLY)).build();
    private final PassFactory removeUnreachableCode = PassFactory.builder().setName("removeUnreachableCode").setRunInFixedPointLoop(true).setInternalFactory(UnreachableCodeElimination::new).build();
    private final PassFactory inlineSimpleMethods = PassFactory.builder().setName("inlineSimpleMethods").setRunInFixedPointLoop(true).setInternalFactory(InlineSimpleMethods::new).build();
    private final PassFactory deadAssignmentsElimination = PassFactory.builder().setName("deadAssignmentsElimination").setRunInFixedPointLoop(true).setInternalFactory(DeadAssignmentsElimination::new).build();
    private final PassFactory deadPropertyAssignmentElimination = PassFactory.builder().setName("deadPropertyAssignmentElimination").setRunInFixedPointLoop(true).setInternalFactory(DeadPropertyAssignmentElimination::new).build();
    private final PassFactory inlineFunctions = PassFactory.builder().setName("inlineFunctions").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineFunctions((AbstractCompiler)compiler, compiler.getUniqueNameIdSupplier(), this.options.getInlineFunctionsLevel(), this.options.assumeStrictThis() || this.options.expectStrictModeInput(), this.options.assumeClosuresOnlyCaptureReferences, this.options.maxFunctionSizeAfterInlining)).build();
    private final PassFactory inlineProperties = PassFactory.builder().setName("inlineProperties").setRunInFixedPointLoop(true).setInternalFactory(InlineProperties::new).build();
    private final PassFactory isolatePolyfills = PassFactory.builder().setName("IsolatePolyfills").setInternalFactory(IsolatePolyfills::new).build();
    private final PassFactory removeUnusedCode = PassFactory.builder().setName("removeUnusedCode").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new RemoveUnusedCode.Builder((AbstractCompiler)compiler).removeLocalVars(this.options.removeUnusedLocalVars).removeGlobals(this.options.removeUnusedVars).preserveFunctionExpressionNames(false).removeUnusedPrototypeProperties(this.options.removeUnusedPrototypeProperties).removeUnusedThisProperties(this.options.isRemoveUnusedClassProperties()).removeUnusedObjectDefinePropertiesDefinitions(this.options.isRemoveUnusedClassProperties()).removeUnusedPolyfills(this.options.forceLibraryInjection.isEmpty()).assumeGettersArePure(this.options.getAssumeGettersArePure()).build()).build();
    private final PassFactory removeUnusedCodeOnce = this.removeUnusedCode.toBuilder().setRunInFixedPointLoop(false).build();
    private final PassFactory crossModuleCodeMotion = PassFactory.builder().setName("crossChunkCodeMotion").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new CrossChunkCodeMotion((AbstractCompiler)compiler, compiler.getModuleGraph(), this.options.parentChunkCanSeeSymbolsDeclaredInChildren)).build();
    private final PassFactory crossModuleMethodMotion = PassFactory.builder().setName("crossChunkMethodMotion").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new CrossChunkMethodMotion((AbstractCompiler)compiler, compiler.getCrossModuleIdGenerator(), false, this.options.crossChunkCodeMotionNoStubMethods)).build();
    private final PassFactory flowSensitiveInlineVariables = PassFactory.builder().setName("flowSensitiveInlineVariables").setInternalFactory(FlowSensitiveInlineVariables::new).build();
    private final PassFactory coalesceVariableNames = PassFactory.builder().setName("coalesceVariableNames").setInternalFactory(compiler -> new CoalesceVariableNames((AbstractCompiler)compiler, this.options.generatePseudoNames)).build();
    private final PassFactory exploitAssign = PassFactory.builder().setName("exploitAssign").setInternalFactory(compiler -> new PeepholeOptimizationsPass((AbstractCompiler)compiler, "exploitAssign", new ExploitAssigns())).build();
    private final PassFactory collapseVariableDeclarations = PassFactory.builder().setName("collapseVariableDeclarations").setInternalFactory(CollapseVariableDeclarations::new).build();
    private final PassFactory extractPrototypeMemberDeclarations = PassFactory.builder().setName("extractPrototypeMemberDeclarations").setInternalFactory(compiler -> {
        ExtractPrototypeMemberDeclarations.Pattern pattern;
        switch (this.options.extractPrototypeMemberDeclarations) {
            case USE_GLOBAL_TEMP: {
                pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP;
                break;
            }
            case USE_CHUNK_TEMP: {
                pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_CHUNK_TEMP;
                break;
            }
            case USE_IIFE: {
                pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_IIFE;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
        return new ExtractPrototypeMemberDeclarations((AbstractCompiler)compiler, pattern);
    }).build();
    private final PassFactory rewriteFunctionExpressions = PassFactory.builder().setName("rewriteFunctionExpressions").setInternalFactory(FunctionRewriter::new).build();
    private final PassFactory collapseAnonymousFunctions = PassFactory.builder().setName("collapseAnonymousFunctions").setInternalFactory(CollapseAnonymousFunctions::new).build();
    private final PassFactory rewriteGlobalDeclarationsForTryCatchWrapping = PassFactory.builder().setName("rewriteGlobalDeclarationsForTryCatchWrapping").setInternalFactory(RewriteGlobalDeclarationsForTryCatchWrapping::new).build();
    private final PassFactory aliasStrings = PassFactory.builder().setName("aliasStrings").setInternalFactory(compiler -> new AliasStrings((AbstractCompiler)compiler, compiler.getModuleGraph(), this.options.outputJsStringUsage, this.options.getAliasStringsMode())).build();
    private final PassFactory ambiguateProperties = PassFactory.builder().setName("ambiguateProperties").setInternalFactory(compiler -> new AmbiguateProperties((AbstractCompiler)compiler, this.options.getPropertyReservedNamingFirstChars(), this.options.getPropertyReservedNamingNonFirstChars(), (Set<String>)compiler.getExternProperties())).build();
    private final PassFactory markUnnormalized = PassFactory.builder().setName("markUnnormalized").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            this.val$compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
        }
    }).build();
    private final PassFactory normalize = PassFactory.builder().setName("normalize").setInternalFactory(compiler -> new Normalize((AbstractCompiler)compiler, false)).build();
    private final PassFactory externExports = PassFactory.builder().setName("externExports").setInternalFactory(ExternExportsPass::new).build();
    private final PassFactory denormalize = PassFactory.builder().setName("denormalize").setInternalFactory(compiler -> new Denormalize((AbstractCompiler)compiler, this.options.getOutputFeatureSet())).build();
    private final PassFactory invertContextualRenaming = PassFactory.builder().setName("invertContextualRenaming").setInternalFactory(MakeDeclaredNamesUnique::getContextualRenameInverter).build();
    private final PassFactory renameProperties = PassFactory.builder().setName("renameProperties").setInternalFactory(compiler -> {
        Preconditions.checkState((this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED ? 1 : 0) != 0);
        VariableMap prevPropertyMap = this.options.inputPropertyMap;
        return new CompilerPass((AbstractCompiler)compiler, prevPropertyMap){
            final /* synthetic */ AbstractCompiler val$compiler;
            final /* synthetic */ VariableMap val$prevPropertyMap;
            {
                this.val$compiler = abstractCompiler;
                this.val$prevPropertyMap = variableMap;
            }

            @Override
            public void process(Node externs, Node root) {
                RenameProperties rprop = new RenameProperties(this.val$compiler, DefaultPassConfig.this.options.generatePseudoNames, this.val$prevPropertyMap, DefaultPassConfig.this.options.getPropertyReservedNamingFirstChars(), DefaultPassConfig.this.options.getPropertyReservedNamingNonFirstChars(), DefaultPassConfig.this.options.nameGenerator);
                rprop.process(externs, root);
                this.val$compiler.setPropertyMap(rprop.getPropertyMap());
            }
        };
    }).build();
    private final PassFactory renameVars = PassFactory.builder().setName("renameVars").setInternalFactory(compiler -> {
        VariableMap prevVariableMap = this.options.inputVariableMap;
        return new CompilerPass((AbstractCompiler)compiler, prevVariableMap){
            final /* synthetic */ AbstractCompiler val$compiler;
            final /* synthetic */ VariableMap val$prevVariableMap;
            {
                this.val$compiler = abstractCompiler;
                this.val$prevVariableMap = variableMap;
            }

            @Override
            public void process(Node externs, Node root) {
                this.val$compiler.setVariableMap(DefaultPassConfig.this.runVariableRenaming(this.val$compiler, this.val$prevVariableMap, externs, root));
            }
        };
    }).build();
    private final PassFactory renameLabels = PassFactory.builder().setName("renameLabels").setInternalFactory(RenameLabels::new).build();
    private final PassFactory convertToDottedProperties = PassFactory.builder().setName("convertToDottedProperties").setInternalFactory(ConvertToDottedProperties::new).build();
    private final PassFactory checkAstValidity = PassFactory.builder().setName("checkAstValidity").setInternalFactory(AstValidator::new).build();
    private final PassFactory varCheckValidity = PassFactory.builder().setName("varCheckValidity").setInternalFactory(compiler -> new VarCheck((AbstractCompiler)compiler, true)).build();
    private final PassFactory instrumentForCodeCoverage = PassFactory.builder().setName("instrumentForCodeCoverage").setInternalFactory(compiler -> new CoverageInstrumentationPass((AbstractCompiler)compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL, this.options.getInstrumentForCoverageOption(), this.options.getProductionInstrumentationArrayName())).build();
    private final PassFactory gatherExternPropertiesCheck = this.createGatherExternProperties(GatherExternProperties.Mode.CHECK);
    private final PassFactory gatherExternPropertiesOptimize = this.createGatherExternProperties(GatherExternProperties.Mode.OPTIMIZE);
    private final PassFactory polymerPass = PassFactory.builder().setName("polymerPass").setInternalFactory(compiler -> new PolymerPass((AbstractCompiler)compiler, compiler.getOptions().polymerVersion, compiler.getOptions().polymerExportPolicy, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED)).build();
    private final PassFactory chromePass = PassFactory.builder().setName("chromePass").setInternalFactory(ChromePass::new).build();
    private final PassFactory j2clConstantHoisterPass = PassFactory.builder().setName("j2clConstantHoisterPass").setRunInFixedPointLoop(true).setInternalFactory(J2clConstantHoisterPass::new).build();
    private final PassFactory j2clClinitPass = PassFactory.builder().setName("j2clClinitPass").setRunInFixedPointLoop(true).setInternalFactory(compiler -> {
        List<Node> changedScopeNodes = compiler.getChangedScopeNodesForPass("j2clClinitPass");
        return new J2clClinitPrunerPass((AbstractCompiler)compiler, changedScopeNodes);
    }).build();
    private final PassFactory j2clPropertyInlinerPass = PassFactory.builder().setName("j2clPropertyInlinerPass").setInternalFactory(J2clPropertyInlinerPass::new).build();
    private final PassFactory j2clPass = PassFactory.builder().setName("j2clPass").setInternalFactory(J2clPass::new).build();
    private final PassFactory j2clUtilGetDefineRewriterPass = PassFactory.builder().setName("j2clUtilGetDefineRewriterPass").setInternalFactory(J2clUtilGetDefineRewriterPass::new).build();
    private final PassFactory j2clAssertRemovalPass = PassFactory.builder().setName("j2clAssertRemovalPass").setInternalFactory(J2clAssertRemovalPass::new).build();
    private final PassFactory j2clSourceFileChecker = PassFactory.builder().setName("j2clSourceFileChecker").setInternalFactory(J2clSourceFileChecker::new).build();
    private final PassFactory j2clChecksPass = PassFactory.builder().setName("j2clChecksPass").setInternalFactory(J2clChecksPass::new).build();
    private final PassFactory checkConformance = PassFactory.builder().setName("checkConformance").setInternalFactory(compiler -> new CheckConformance((AbstractCompiler)compiler, this.options.getConformanceConfigs())).build();
    private final PassFactory removeCastNodes = PassFactory.builder().setName("removeCastNodes").setInternalFactory(RemoveCastNodes::new).build();
    private final PassFactory typesToColors = PassFactory.builder().setName("typesToColors").setInternalFactory(compiler -> (externs, js) -> {
        new ConvertTypesToColors((AbstractCompiler)compiler, compiler.isDebugLoggingEnabled() ? SerializationOptions.INCLUDE_DEBUG_INFO : SerializationOptions.SKIP_DEBUG_INFO).process(externs, js);
        compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.COLORS_AND_SIMPLIFIED_JSDOC);
    }).build();
    private final PassFactory serializeTypedAst = PassFactory.builder().setName("serializeTypedAst").setInternalFactory(compiler -> SerializeTypedAstPass.createFromPath(compiler, this.options.getTypedAstOutputFile())).build();
    private final PassFactory removeUnnecessarySyntheticExterns = PassFactory.builder().setName("removeUnnecessarySyntheticExterns").setInternalFactory(RemoveUnnecessarySyntheticExterns::new).build();
    private final PassFactory optimizeToEs6 = PassFactory.builder().setName("optimizeToEs6").setInternalFactory(SubstituteEs6Syntax::new).build();
    private final PassFactory whitespaceWrapGoogModules = PassFactory.builder().setName("whitespaceWrapGoogModules").setInternalFactory(WhitespaceWrapGoogModules::new).build();
    private final PassFactory rewriteCommonJsModules = PassFactory.builder().setName("rewriteCommonJsModules").setInternalFactory(ProcessCommonJSModules::new).build();
    private final PassFactory rewriteScriptsToEs6Modules = PassFactory.builder().setName("rewriteScriptsToEs6Modules").setInternalFactory(Es6RewriteScriptsToModules::new).build();
    private final PassFactory gatherModuleMetadataPass = PassFactory.builder().setName("gatherModuleMetadata").setInternalFactory(compiler -> {
        compiler.getSynthesizedExternsInput();
        return new GatherModuleMetadata((AbstractCompiler)compiler, this.options.getProcessCommonJSModules(), this.options.moduleResolutionMode);
    }).build();
    private final PassFactory createModuleMapPass = PassFactory.builder().setName("createModuleMap").setInternalFactory(compiler -> new ModuleMapCreator((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).build();
    private final PassFactory gatherGettersAndSetters = PassFactory.builder().setName("gatherGettersAndSetters").setInternalFactory(GatherGetterAndSetterProperties::new).build();
    private final PassFactory addSyntheticScript = PassFactory.builder().setName("ADD_SYNTHETIC_SCRIPT").setInternalFactory(compiler -> (externs, js) -> compiler.initializeSyntheticCodeInput()).build();
    private final PassFactory removeSyntheticScript = PassFactory.builder().setName("REMOVE_SYNTHETIC_SCRIPT").setInternalFactory(compiler -> (externs, js) -> compiler.removeSyntheticCodeInput()).build();
    private final PassFactory mergeSyntheticScript = PassFactory.builder().setName("MERGE_SYNTHETIC_SCRIPT").setInternalFactory(compiler -> (externs, js) -> compiler.mergeSyntheticCodeInput()).build();
    private static final PassFactory forbidDynamicImportUsage = PassFactory.builder().setName("FORBID_DYNAMIC_IMPORT").setInternalFactory(ForbidDynamicImportUsage::new).build();
    private static final PassFactory rewriteDynamicImports = PassFactory.builder().setName("REWRITE_DYNAMIC_IMPORT").setInternalFactory(compiler -> new RewriteDynamicImports((AbstractCompiler)compiler, compiler.getOptions().getDynamicImportAlias(), compiler.getOptions().getChunkOutputType())).build();
    private final PassFactory protectLocaleData = PassFactory.builder().setName("protectLocaleData").setInternalFactory(compiler -> (externs, root) -> new LocaleDataPasses.ProtectGoogLocale((AbstractCompiler)compiler).process(externs, root)).build();
    private final PassFactory substituteLocaleData = PassFactory.builder().setName("SubstituteLocaleData").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            new LocaleDataPasses.LocaleSubstitutions(this.val$compiler, this.val$compiler.getOptions().locale).process(externs, root);
        }
    }).build();

    public DefaultPassConfig(CompilerOptions options) {
        super(options);
    }

    @Nullable PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTableFactory.getInstanceOrNull();
    }

    @Override
    protected PassListBuilder getTranspileOnlyPasses() {
        PassListBuilder passes = new PassListBuilder(this.options);
        passes.maybeAdd(this.markUntranspilableFeaturesAsRemoved);
        passes.maybeAdd(this.checkVariableReferences);
        passes.maybeAdd(this.checkVars);
        passes.maybeAdd(this.gatherModuleMetadataPass);
        passes.maybeAdd(this.createModuleMapPass);
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.maybeAdd(this.rewriteGoogJsImports);
            switch (this.options.getEs6ModuleTranspilation()) {
                case COMPILE: {
                    TranspilationPasses.addEs6ModulePass(passes, this.preprocessorSymbolTableFactory);
                    break;
                }
                case TO_COMMON_JS_LIKE_MODULES: {
                    TranspilationPasses.addEs6ModuleToCjsPass(passes);
                    break;
                }
                case RELATIVIZE_IMPORT_PATHS: {
                    TranspilationPasses.addEs6RewriteImportPathPass(passes);
                    break;
                }
            }
        }
        passes.maybeAdd(this.checkSuper);
        TranspilationPasses.addTranspilationRuntimeLibraries(passes);
        TranspilationPasses.addEarlyOptimizationTranspilationPasses(passes, this.options);
        if (this.options.needsTranspilationFrom(FeatureSet.ES2015) && this.options.getRewritePolyfills()) {
            if (this.options.getIsolatePolyfills()) {
                throw new IllegalStateException("Polyfill isolation cannot be used in transpileOnly mode");
            }
            TranspilationPasses.addRewritePolyfillPass(passes);
        }
        passes.maybeAdd(this.injectRuntimeLibrariesForChecks);
        passes.maybeAdd(this.injectRuntimeLibrariesForOptimizations);
        passes.assertAllOneTimePasses();
        this.assertValidOrderForChecks(passes);
        return passes;
    }

    @Override
    protected PassListBuilder getWhitespaceOnlyPasses() {
        PassListBuilder passes = new PassListBuilder(this.options);
        if (this.options.getProcessCommonJSModules()) {
            passes.maybeAdd(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.maybeAdd(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.wrapGoogModulesForWhitespaceOnly) {
            passes.maybeAdd(this.whitespaceWrapGoogModules);
        }
        return passes;
    }

    private void addModuleRewritingPasses(PassListBuilder checks, CompilerOptions options) {
        if (options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.maybeAdd(this.rewriteGoogJsImports);
            TranspilationPasses.addEs6ModulePass(checks, this.preprocessorSymbolTableFactory);
        }
        if (options.closurePass) {
            checks.maybeAdd(this.closureRewriteModule);
        }
    }

    @Override
    protected PassListBuilder getChecks() {
        PassListBuilder checks = new PassListBuilder(this.options);
        Preconditions.checkState((!this.options.skipNonTranspilationPasses ? 1 : 0) != 0, (Object)"options.skipNonTranspilationPasses cannot be mixed with PassConfig::getChecks. Call PassConfig::getTranspileOnlyPasses instead.");
        checks.maybeAdd(this.syncCompilerFeatures);
        if (this.options.isPropertyRenamingOnlyCompilationMode()) {
            checks.maybeAdd(this.addSyntheticScript);
            checks.maybeAdd(this.gatherGettersAndSetters);
            checks.maybeAdd(this.gatherModuleMetadataPass);
            checks.maybeAdd(this.createModuleMapPass);
            checks.maybeAdd(this.declaredGlobalExternsOnWindow);
            checks.maybeAdd(this.closureRewriteClass);
            checks.maybeAdd(this.checkSideEffects);
            checks.maybeAdd(this.angularPass);
            checks.maybeAdd(this.closureGoogScopeAliases);
            this.addModuleRewritingPasses(checks, this.options);
            checks.maybeAdd(this.closurePrimitives);
            checks.maybeAdd(this.injectRuntimeLibrariesForChecks);
            checks.maybeAdd(this.clearTypedScopeCreatorPass);
            checks.maybeAdd(this.clearTopTypedScopePass);
            checks.maybeAdd(this.generateExports);
            checks.maybeAdd(PassFactory.createEmptyPass("afterStandardChecks"));
            checks.maybeAdd(this.mergeSyntheticScript);
            checks.maybeAdd(this.gatherExternPropertiesCheck);
            checks.maybeAdd(PassFactory.createEmptyPass("beforeSerialization"));
            return checks;
        }
        if (this.options.shouldGenerateTypedExterns()) {
            checks.maybeAdd(this.addSyntheticScript);
            checks.maybeAdd(this.closureGoogScopeAliasesForIjs);
            checks.maybeAdd(this.closureRewriteClass);
            checks.maybeAdd(this.generateIjs);
            if (this.options.wrapGoogModulesForWhitespaceOnly) {
                checks.maybeAdd(this.whitespaceWrapGoogModules);
            }
            checks.maybeAdd(this.removeSyntheticScript);
            return checks;
        }
        checks.maybeAdd(this.addSyntheticScript);
        if (!this.options.checksOnly) {
            checks.maybeAdd(this.markUntranspilableFeaturesAsRemoved);
        }
        checks.maybeAdd(this.gatherGettersAndSetters);
        if (this.options.getLanguageIn().toFeatureSet().contains(FeatureSet.Feature.DYNAMIC_IMPORT) && !this.options.shouldAllowDynamicImport()) {
            checks.maybeAdd(forbidDynamicImportUsage);
        }
        checks.maybeAdd(PassFactory.createEmptyPass("beforeStandardChecks"));
        if (!this.options.getProcessCommonJSModules() && this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.maybeAdd(this.rewriteScriptsToEs6Modules);
        }
        checks.maybeAdd(this.gatherModuleMetadataPass);
        checks.maybeAdd(this.createModuleMapPass);
        if (this.options.getProcessCommonJSModules()) {
            checks.maybeAdd(this.rewriteCommonJsModules);
        }
        if (this.options.isChromePassEnabled()) {
            checks.maybeAdd(this.chromePass);
        }
        checks.maybeAdd(this.checkJsDocAndEs6Modules);
        checks.maybeAdd(this.checkTypeImportCodeReferences);
        if (this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.maybeAdd(this.lintChecks);
        }
        if (this.options.closurePass && this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.maybeAdd(this.checkRequiresAndProvidesSorted);
        }
        if (this.options.enables(DiagnosticGroups.EXTRA_REQUIRE)) {
            checks.maybeAdd(this.extraRequires);
        }
        if (this.options.enables(DiagnosticGroups.MISSING_REQUIRE)) {
            checks.maybeAdd(this.checkMissingRequires);
        }
        checks.maybeAdd(this.declaredGlobalExternsOnWindow);
        if (!this.options.getProcessCommonJSModules()) {
            checks.maybeAdd(this.checkVariableReferences);
            checks.maybeAdd(this.checkVars);
        }
        if (this.options.closurePass) {
            checks.maybeAdd(this.checkClosureImports);
        }
        checks.maybeAdd(this.checkStrictMode);
        if (this.options.closurePass) {
            checks.maybeAdd(this.closureCheckModule);
        }
        checks.maybeAdd(this.checkSuper);
        if (this.options.closurePass) {
            checks.maybeAdd(this.closureRewriteClass);
        }
        checks.maybeAdd(this.checkSideEffects);
        if (this.options.angularPass) {
            checks.maybeAdd(this.angularPass);
        }
        if (this.options.closurePass) {
            checks.maybeAdd(this.closureGoogScopeAliases);
        }
        if (this.options.shouldRewriteModulesBeforeTypechecking()) {
            this.addModuleRewritingPasses(checks, this.options);
        }
        if (this.options.closurePass) {
            checks.maybeAdd(this.closurePrimitives);
        }
        if (this.options.polymerVersion != null) {
            checks.maybeAdd(this.polymerPass);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            checks.maybeAdd(this.createSyntheticBlocks);
        }
        if (this.options.getProcessCommonJSModules()) {
            checks.maybeAdd(this.checkVariableReferences);
            checks.maybeAdd(this.checkVars);
        }
        if (this.options.inferConsts) {
            checks.maybeAdd(this.inferConsts);
        }
        if (this.options.computeFunctionSideEffects) {
            checks.maybeAdd(this.checkRegExp);
        }
        checks.maybeAdd(PassFactory.createEmptyPass("beforePreTypeCheckTranspilation"));
        checks.maybeAdd(this.injectRuntimeLibrariesForChecks);
        checks.maybeAdd(PassFactory.createEmptyPass("beforeTypeChecking"));
        if (this.options.checkTypes || this.options.inferTypes) {
            checks.maybeAdd(this.inferTypes);
            if (this.options.checkTypes) {
                checks.maybeAdd(this.checkTypes);
            } else {
                checks.maybeAdd(this.inferJsDocInfo);
            }
        }
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS) && this.options.isTypecheckingEnabled()) {
            checks.maybeAdd(this.analyzerChecks);
        }
        if (this.options.isTypecheckingEnabled() && this.options.isCheckingMissingOverrideTypes()) {
            checks.maybeAdd(this.checkMissingOverrideTypes);
        }
        if (!this.options.preservesDetailedSourceInfo()) {
            checks.maybeAdd(this.clearTypedScopeCreatorPass);
        }
        if (this.options.shouldRewriteModulesAfterTypechecking()) {
            this.addModuleRewritingPasses(checks, this.options);
        }
        if (this.options.shouldAllowDynamicImport() && this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.DYNAMIC_IMPORT)) {
            checks.maybeAdd(rewriteDynamicImports);
        }
        if (!this.options.preservesDetailedSourceInfo()) {
            checks.maybeAdd(this.clearTopTypedScopePass);
        }
        if (this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            checks.maybeAdd(this.suspiciousCode);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.maybeAdd(this.j2clSourceFileChecker);
        }
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE) || !this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            checks.maybeAdd(this.checkControlFlow);
        }
        if (this.options.isTypecheckingEnabled() && (!this.options.disables(DiagnosticGroups.ACCESS_CONTROLS) || this.options.enables(DiagnosticGroups.CONSTANT_PROPERTY))) {
            checks.maybeAdd(this.checkAccessControls);
        }
        checks.maybeAdd(this.checkConsts);
        if (!this.options.getConformanceConfigs().isEmpty()) {
            checks.maybeAdd(this.checkConformance);
        }
        if (this.options.closurePass && !this.options.shouldPreserveGoogLibraryPrimitives()) {
            checks.maybeAdd(this.closureReplaceGetCssName);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.maybeAdd(this.processTweaks);
        }
        checks.maybeAdd(this.processDefinesCheck);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.maybeAdd(this.j2clChecksPass);
        }
        if (this.options.shouldRunTypeSummaryChecksLate()) {
            checks.maybeAdd(this.generateIjs);
        }
        if (this.options.generateExports) {
            checks.maybeAdd(this.generateExports);
        }
        checks.maybeAdd(PassFactory.createEmptyPass("afterStandardChecks"));
        if (this.options.checksOnly) {
            checks.maybeAdd(this.removeSyntheticScript);
        } else if (!this.options.checksOnly) {
            checks.maybeAdd(this.mergeSyntheticScript);
            if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
                checks.maybeAdd(this.j2clPass);
            }
            if (this.options.exportTestFunctions) {
                checks.maybeAdd(this.exportTestFunctions);
            }
        }
        if (this.options.getExternExportsPath() != null) {
            checks.maybeAdd(this.externExports);
        }
        if (!this.options.checksOnly) {
            checks.maybeAdd(this.removeWeakSources);
        }
        checks.maybeAdd(this.gatherExternPropertiesCheck);
        checks.assertAllOneTimePasses();
        this.assertValidOrderForChecks(checks);
        checks.maybeAdd(PassFactory.createEmptyPass("beforeSerialization"));
        if (this.options.getTypedAstOutputFile() != null) {
            checks.maybeAdd(this.serializeTypedAst);
        }
        return checks;
    }

    @Override
    protected PassListBuilder getOptimizations() {
        PassListBuilder passes = new PassListBuilder(this.options);
        if (this.options.isPropertyRenamingOnlyCompilationMode()) {
            TranspilationPasses.addTranspilationRuntimeLibraries(passes);
            passes.maybeAdd(this.closureProvidesRequires);
            passes.maybeAdd(this.processDefinesOptimize);
            TranspilationPasses.addEarlyOptimizationTranspilationPasses(passes, this.options);
            passes.maybeAdd(this.normalize);
            passes.maybeAdd(this.gatherExternPropertiesOptimize);
            passes.maybeAdd(PassFactory.createEmptyPass("beforeStandardOptimizations"));
            passes.maybeAdd(this.inlineAndCollapseProperties);
            passes.maybeAdd(this.closureOptimizePrimitives);
            return passes;
        }
        if (this.options.skipNonTranspilationPasses) {
            return passes;
        }
        if (this.options.getMergedPrecompiledLibraries()) {
            passes.maybeAdd(this.removeWeakSources);
            passes.maybeAdd(this.checkRegExpForOptimizations);
            if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
                passes.maybeAdd(this.j2clSourceFileChecker);
            }
        } else {
            this.addNonTypedAstNormalizationPasses(passes);
        }
        passes.maybeAdd(this.removeUnnecessarySyntheticExterns);
        TranspilationPasses.addTranspilationRuntimeLibraries(passes);
        if (this.options.rewritePolyfills || this.options.getIsolatePolyfills()) {
            TranspilationPasses.addRewritePolyfillPass(passes);
        }
        passes.maybeAdd(this.injectRuntimeLibrariesForOptimizations);
        if (this.options.closurePass) {
            passes.maybeAdd(this.closureProvidesRequires);
        }
        if (this.options.shouldRunReplaceMessagesForChrome()) {
            passes.maybeAdd(this.replaceMessagesForChrome);
        } else if (this.options.shouldRunReplaceMessagesPass()) {
            if (this.options.doLateLocalization()) {
                passes.maybeAdd(this.getProtectMessagesPass());
            } else {
                passes.maybeAdd(this.getFullReplaceMessagesPass());
            }
        }
        if (this.options.doLateLocalization()) {
            passes.maybeAdd(this.protectLocaleData);
        }
        passes.maybeAdd(this.processDefinesOptimize);
        TranspilationPasses.addEarlyOptimizationTranspilationPasses(passes, this.options);
        passes.maybeAdd(this.normalize);
        passes.maybeAdd(this.gatherGettersAndSetters);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.maybeAdd(this.j2clUtilGetDefineRewriterPass);
        }
        if (this.options.getInstrumentForCoverageOption() != CompilerOptions.InstrumentOption.NONE) {
            passes.maybeAdd(this.instrumentForCodeCoverage);
        }
        passes.maybeAdd(this.gatherExternPropertiesOptimize);
        passes.maybeAdd(PassFactory.createEmptyPass("beforeStandardOptimizations"));
        if (this.options.optimizeArgumentsArray) {
            passes.maybeAdd(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.maybeAdd(this.closureCodeRemoval);
        }
        if (this.options.removeJ2clAsserts) {
            passes.maybeAdd(this.j2clAssertRemovalPass);
        }
        passes.maybeAdd(this.inlineAndCollapseProperties);
        if (this.options.getTweakProcessing().shouldStrip() || !this.options.stripTypes.isEmpty() || !this.options.stripNameSuffixes.isEmpty() || !this.options.stripNamePrefixes.isEmpty()) {
            passes.maybeAdd(this.stripCode);
        }
        if (this.options.replaceIdGenerators) {
            passes.maybeAdd(this.replaceIdGenerators);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses() && this.options.getPropertyCollapseLevel() == CompilerOptions.PropertyCollapseLevel.ALL) {
            passes.maybeAdd(this.j2clPropertyInlinerPass);
        }
        if (this.options.inferConsts) {
            passes.maybeAdd(this.inferConsts);
        }
        passes.maybeAdd(this.checkConstParams);
        if (this.options.smartNameRemoval) {
            if (this.options.foldConstants && (this.options.inlineVariables || this.options.inlineLocalVariables)) {
                passes.maybeAdd(this.earlyInlineVariables);
                passes.maybeAdd(this.earlyPeepholeOptimizations);
            }
            passes.maybeAdd(this.removeUnusedCodeOnce);
        }
        if (this.options.shouldDisambiguateProperties() && this.options.isTypecheckingEnabled()) {
            passes.maybeAdd(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            passes.maybeAdd(this.markPureFunctions);
        }
        passes.assertAllOneTimePasses();
        if (this.options.smartNameRemoval) {
            passes.maybeAdd(PassFactory.createEmptyPass("beforeEarlyOptimizationLoop"));
            passes.addAll(this.getEarlyOptimizationLoopPasses());
            passes.maybeAdd(PassFactory.createEmptyPass("afterEarlyOptimizationLoop"));
        }
        if (this.options.closurePass) {
            passes.maybeAdd(this.closureOptimizePrimitives);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.maybeAdd(this.replaceStrings);
        }
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.maybeAdd(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizeMethods) {
            passes.maybeAdd(this.devirtualizeMethods);
        }
        if (this.options.customPasses != null) {
            passes.maybeAdd(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.maybeAdd(PassFactory.createEmptyPass("beforeMainOptimizations"));
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.maybeAdd(this.flowSensitiveInlineVariables);
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.maybeAdd(PassFactory.createEmptyPass("afterMainOptimizations"));
        if (this.options.customPasses != null) {
            passes.maybeAdd(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        this.assertValidOrderForOptimizations(passes);
        return passes;
    }

    @Override
    protected PassListBuilder getFinalizations() {
        PassListBuilder passes = new PassListBuilder(this.options);
        if (this.options.isPropertyRenamingOnlyCompilationMode()) {
            if (this.options.rewriteGlobalDeclarationsForTryCatchWrapping || this.options.renamePrefixNamespace != null) {
                passes.maybeAdd(this.rewriteGlobalDeclarationsForTryCatchWrapping);
            }
            passes.maybeAdd(this.renameProperties);
            if (this.options.renamePrefixNamespace != null && this.options.chunkOutputType == CompilerOptions.ChunkOutputType.GLOBAL_NAMESPACE) {
                if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                    throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
                }
                passes.maybeAdd(this.rescopeGlobalSymbols);
            }
            return passes;
        }
        if (this.options.doLateLocalization()) {
            if (this.options.shouldRunReplaceMessagesPass()) {
                passes.maybeAdd(this.getReplaceProtectedMessagesPass());
            }
            passes.maybeAdd(this.substituteLocaleData);
            passes.maybeAdd(this.peepholeOptimizationsOnce);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.maybeAdd(this.flowSensitiveInlineVariables);
            if (!this.options.doLateLocalization() && this.shouldRunRemoveUnusedCode()) {
                passes.maybeAdd(this.removeUnusedCodeOnce);
            }
        }
        if (this.options.doLateLocalization()) {
            passes.addAll(this.getPostL10nOptimizations());
        }
        passes.maybeAdd(PassFactory.createEmptyPass("beforeModuleMotion"));
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.maybeAdd(this.crossModuleCodeMotion);
        }
        if (this.options.shouldRunCrossChunkMethodMotion()) {
            passes.maybeAdd(this.crossModuleMethodMotion);
        }
        passes.maybeAdd(PassFactory.createEmptyPass("afterModuleMotion"));
        if (this.options.optimizeESClassConstructors && this.options.getOutputFeatureSet().contains(FeatureSet.ES2015)) {
            passes.maybeAdd(this.optimizeConstructors);
        }
        if (this.options.getIsolatePolyfills()) {
            passes.maybeAdd(this.isolatePolyfills);
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.maybeAdd(this.collapseAnonymousFunctions);
        }
        if (this.options.rewriteGlobalDeclarationsForTryCatchWrapping || this.options.renamePrefixNamespace != null) {
            passes.maybeAdd(this.rewriteGlobalDeclarationsForTryCatchWrapping);
        }
        if (this.options.extractPrototypeMemberDeclarations != CompilerOptions.ExtractPrototypeMemberDeclarationsMode.OFF) {
            passes.maybeAdd(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.shouldAmbiguateProperties() && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED && this.options.isTypecheckingEnabled()) {
            passes.maybeAdd(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.maybeAdd(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.maybeAdd(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.maybeAdd(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.maybeAdd(this.rewriteFunctionExpressions);
        }
        if (this.options.getAliasStringsMode() != CompilerOptions.AliasStringsMode.NONE) {
            passes.maybeAdd(this.aliasStrings);
        }
        if (this.options.coalesceVariableNames) {
            passes.maybeAdd(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.maybeAdd(this.peepholeOptimizationsOnce);
            }
        }
        passes.maybeAdd(this.markUnnormalized);
        if (this.options.collapseVariableDeclarations) {
            passes.maybeAdd(this.exploitAssign);
            passes.maybeAdd(this.collapseVariableDeclarations);
        }
        passes.maybeAdd(this.denormalize);
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.maybeAdd(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.maybeAdd(this.renameVars);
        }
        if (this.options.labelRenaming) {
            passes.maybeAdd(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.maybeAdd(this.latePeepholeOptimizations);
        }
        if (this.options.shouldProtectHiddenSideEffects()) {
            passes.maybeAdd(this.stripSideEffectProtection);
        }
        if (this.options.renamePrefixNamespace != null && this.options.chunkOutputType == CompilerOptions.ChunkOutputType.GLOBAL_NAMESPACE) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.maybeAdd(this.rescopeGlobalSymbols);
        }
        if (this.options.getOutputFeatureSet().contains(FeatureSet.ES2015)) {
            passes.maybeAdd(this.optimizeToEs6);
        }
        if (!this.options.parenthesizeFunctionsInChunks.isEmpty()) {
            passes.maybeAdd(this.parenthesizeFunctionsInChunks);
        }
        if (this.options.chunkOutputType == CompilerOptions.ChunkOutputType.ES_MODULES) {
            passes.maybeAdd(this.convertChunksToESModules);
        }
        passes.maybeAdd(this.checkAstValidity);
        passes.maybeAdd(this.varCheckValidity);
        return passes;
    }

    private PassListBuilder getEarlyOptimizationLoopPasses() {
        PassListBuilder earlyLoopPasses = new PassListBuilder(this.options);
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            earlyLoopPasses.maybeAdd(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            earlyLoopPasses.maybeAdd(this.inlineConstants);
        }
        if (this.options.collapseObjectLiterals) {
            earlyLoopPasses.maybeAdd(this.collapseObjectLiterals);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            earlyLoopPasses.maybeAdd(this.removeUnusedCode);
        }
        if (this.options.foldConstants) {
            earlyLoopPasses.maybeAdd(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            earlyLoopPasses.maybeAdd(this.removeUnreachableCode);
        }
        earlyLoopPasses.assertAllLoopablePasses();
        return earlyLoopPasses;
    }

    private PassListBuilder getPostL10nOptimizations() {
        PassListBuilder loopPasses = new PassListBuilder(this.options);
        if (this.options.optimizeCalls) {
            loopPasses.maybeAdd(this.optimizeCalls);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            loopPasses.maybeAdd(this.j2clConstantHoisterPass);
            loopPasses.maybeAdd(this.j2clClinitPass);
        }
        if (this.options.getInlineFunctionsLevel() != CompilerOptions.Reach.NONE) {
            loopPasses.maybeAdd(this.inlineFunctions);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            loopPasses.maybeAdd(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            loopPasses.maybeAdd(this.inlineConstants);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            loopPasses.maybeAdd(this.removeUnusedCode);
        }
        if (this.options.foldConstants) {
            loopPasses.maybeAdd(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            loopPasses.maybeAdd(this.removeUnreachableCode);
        }
        loopPasses.assertAllLoopablePasses();
        return loopPasses;
    }

    private PassListBuilder getMainOptimizationLoop() {
        boolean shouldRunDeadPropertyAssignmentElimination;
        PassListBuilder passes = new PassListBuilder(this.options);
        if (this.options.inlineGetters) {
            passes.maybeAdd(this.inlineSimpleMethods);
        }
        if (this.options.shouldInlineProperties() && this.options.isTypecheckingEnabled()) {
            passes.maybeAdd(this.inlineProperties);
        }
        boolean shouldRunDeadAssignmentElimination = (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) && this.options.deadAssignmentElimination;
        boolean bl = shouldRunDeadPropertyAssignmentElimination = shouldRunDeadAssignmentElimination && this.options.polymerVersion == null;
        if (shouldRunDeadPropertyAssignmentElimination) {
            passes.maybeAdd(this.deadPropertyAssignmentElimination);
        }
        if (this.options.optimizeCalls) {
            passes.maybeAdd(this.optimizeCalls);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.maybeAdd(this.j2clConstantHoisterPass);
            passes.maybeAdd(this.j2clClinitPass);
        }
        if (this.options.getInlineFunctionsLevel() != CompilerOptions.Reach.NONE) {
            passes.maybeAdd(this.inlineFunctions);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.maybeAdd(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.maybeAdd(this.inlineConstants);
        }
        if (shouldRunDeadAssignmentElimination) {
            passes.maybeAdd(this.deadAssignmentsElimination);
        }
        if (this.options.collapseObjectLiterals) {
            passes.maybeAdd(this.collapseObjectLiterals);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            passes.maybeAdd(this.removeUnusedCode);
        }
        if (this.options.foldConstants) {
            passes.maybeAdd(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.maybeAdd(this.removeUnreachableCode);
        }
        passes.assertAllLoopablePasses();
        return passes;
    }

    private void addNonTypedAstNormalizationPasses(PassListBuilder passes) {
        passes.maybeAdd(this.removeCastNodes);
        passes.maybeAdd(this.typesToColors);
    }

    private boolean shouldRunRemoveUnusedCode() {
        return this.options.removeUnusedVars || this.options.removeUnusedLocalVars || this.options.removeUnusedPrototypeProperties || this.options.isRemoveUnusedClassProperties() || this.options.rewritePolyfills;
    }

    private void assertValidOrderForChecks(PassListBuilder checks) {
        checks.assertPassOrder(this.declaredGlobalExternsOnWindow, this.checkVars, "declaredGlobalExternsOnWindow must happen before VarCheck, which adds synthetic externs");
        checks.assertPassOrder(this.chromePass, this.checkJsDocAndEs6Modules, "The ChromePass must run before after JsDoc and Es6 module checking.");
        checks.assertPassOrder(this.closureRewriteModule, this.processDefinesCheck, "Must rewrite goog.module before processing @define's, so that @defines in modules work.");
        checks.assertPassOrder(this.closurePrimitives, this.polymerPass, "The Polymer pass must run after goog.provide processing.");
        checks.assertPassOrder(this.chromePass, this.polymerPass, "The Polymer pass must run after ChromePass processing.");
        checks.assertPassOrder(this.polymerPass, this.suspiciousCode, "The Polymer pass must run before suspiciousCode processing.");
        checks.assertPassOrder(this.addSyntheticScript, this.gatherModuleMetadataPass, "Cannot add a synthetic script node after module metadata creation.");
        checks.assertPassOrder(this.closureRewriteModule, this.removeSyntheticScript, "Synthetic script node should be removed only after module rewriting.");
        if (checks.contains(this.closureGoogScopeAliases)) {
            Preconditions.checkState((boolean)checks.contains(this.checkVariableReferences), (Object)"goog.scope processing requires variable checking");
        }
        checks.assertPassOrder(this.gatherModuleMetadataPass, this.closureCheckModule, "Need to gather module metadata before checking closure modules.");
        checks.assertPassOrder(this.gatherModuleMetadataPass, this.createModuleMapPass, "Need to gather module metadata before scanning modules.");
        checks.assertPassOrder(this.createModuleMapPass, this.rewriteCommonJsModules, "Need to gather module information before rewriting CommonJS modules.");
        checks.assertPassOrder(this.rewriteScriptsToEs6Modules, this.gatherModuleMetadataPass, "Need to gather module information after rewriting scripts to modules.");
        checks.assertPassOrder(this.gatherModuleMetadataPass, this.checkMissingRequires, "Need to gather module information before checking for missing requires.");
        checks.assertPassOrder(this.j2clPass, TranspilationPasses.rewriteGenerators, "J2CL normalization should be done before generator re-writing.");
    }

    private void assertValidOrderForOptimizations(PassListBuilder optimizations) {
        optimizations.assertPassOrder(TranspilationPasses.rewritePolyfills, this.processDefinesOptimize, "Polyfill injection must be done before processDefines as some polyfills reference goog.defines.");
        optimizations.assertPassOrder(TranspilationPasses.injectTranspilationRuntimeLibraries, this.processDefinesOptimize, "Runtime library injection must be done before processDefines some runtime libraries reference goog.defines.");
        optimizations.assertPassOrder(this.processDefinesOptimize, this.j2clUtilGetDefineRewriterPass, "J2CL define re-writing should be done after processDefines since it relies on collectDefines which has side effects.");
        optimizations.assertPassOrder(this.removeUnusedCode, this.isolatePolyfills, "Polyfill isolation should be done after RemovedUnusedCode. Otherwise unused polyfill removal will not find any polyfill usages and will delete all polyfills.");
    }

    private PassFactory getFullReplaceMessagesPass() {
        return PassFactory.builder().setName("replaceMessages").setInternalFactory(compiler -> new ReplaceMessages((AbstractCompiler)compiler, this.options.messageBundle, this.options.getStrictMessageReplacement()).getFullReplacementPass()).build();
    }

    private PassFactory getProtectMessagesPass() {
        return PassFactory.builder().setName("protectMessages").setInternalFactory(compiler -> new ReplaceMessages((AbstractCompiler)compiler, this.options.messageBundle, this.options.getStrictMessageReplacement()).getMsgProtectionPass()).build();
    }

    private PassFactory getReplaceProtectedMessagesPass() {
        return PassFactory.builder().setName("replaceProtectedMessages").setInternalFactory(compiler -> new ReplaceMessages((AbstractCompiler)compiler, this.options.messageBundle, this.options.getStrictMessageReplacement()).getReplacementCompletionPass()).build();
    }

    private static CompilerPass createPeepholeOptimizationsPass(AbstractCompiler compiler, String passName) {
        boolean late = false;
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<AbstractPeepholeOptimization> optimizations = new ArrayList<AbstractPeepholeOptimization>();
        optimizations.add(new MinimizeExitPoints());
        optimizations.add(new PeepholeMinimizeConditions(false));
        optimizations.add(new PeepholeSubstituteAlternateSyntax(false));
        optimizations.add(new PeepholeReplaceKnownMethods(false, useTypesForOptimization));
        optimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            optimizations.add(new J2clEqualitySameRewriterPass(useTypesForOptimization));
            optimizations.add(new J2clStringValueOfRewriterPass());
        }
        optimizations.add(new PeepholeFoldConstants(false, useTypesForOptimization));
        optimizations.add(new PeepholeCollectPropertyAssignments());
        return new PeepholeOptimizationsPass(compiler, passName, optimizations);
    }

    private static CompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument((!callbacks.isEmpty() ? 1 : 0) != 0);
        return new CombinedCompilerPass(compiler, callbacks);
    }

    private PassFactory createProcessDefines(ProcessDefines.Mode mode) {
        return PassFactory.builder().setName("processDefines_" + mode.name()).setInternalFactory(compiler -> new ProcessDefines.Builder((AbstractCompiler)compiler).putReplacements(DefaultPassConfig.getAdditionalReplacements(this.options)).putReplacements((Map<String, Node>)this.options.getDefineReplacements()).setMode(mode).setRecognizeClosureDefines(compiler.getOptions().closurePass).build()).build();
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = null;
        HashSet<String> reservedNames = new HashSet<String>();
        if (this.options.renamePrefixNamespace != null) {
            reservedNames.add(this.options.renamePrefixNamespace);
        }
        reservedNames.addAll(compiler.getExportedNames());
        reservedNames.addAll((Collection<String>)ParserRunner.getReservedVars());
        RenameVars rn = new RenameVars(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, this.options.generatePseudoNames, this.options.preferStableNames, prevVariableMap, reservedChars, reservedNames, this.options.nameGenerator);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    private final PassFactory createGatherExternProperties(GatherExternProperties.Mode mode) {
        return PassFactory.builder().setName("gatherExternProperties").setInternalFactory(compiler -> new GatherExternProperties((AbstractCompiler)compiler, mode)).build();
    }

    private PassFactory getCustomPasses(CustomPassExecutionTime executionTime) {
        return PassFactory.builder().setName("runCustomPasses").setInternalFactory(compiler -> DefaultPassConfig.runInSerial(this.options.customPasses.get((Object)executionTime))).build();
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            @Override
            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap<String, Node> additionalReplacements = new HashMap<String, Node>();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null && !options.doLateLocalization()) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string(options.locale));
        }
        return additionalReplacements;
    }
}

