/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public abstract class AbstractScope<S extends AbstractScope<S, V>, V extends AbstractVar<S, V>>
implements StaticScope,
Serializable {
    private Map<String, V> vars = ImmutableMap.of();
    private Map<ImplicitVar, V> implicitVars = ImmutableMap.of();
    private final Node rootNode;

    AbstractScope(Node rootNode) {
        this.rootNode = (Node)Preconditions.checkNotNull((Object)rootNode);
    }

    public abstract int getDepth();

    public abstract S getParent();

    public final String toString() {
        return "Scope@" + this.rootNode;
    }

    public Scope untyped() {
        throw new IllegalStateException("untyped() called, but not an untyped scope.");
    }

    public TypedScope typed() {
        throw new IllegalStateException("typed() called, but not a typed scope.");
    }

    final boolean contains(S other) {
        for (AbstractScope<S, V> s = (AbstractScope)Preconditions.checkNotNull(other); s != null; s = s.getParent()) {
            if (s != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Node getRootNode() {
        return this.rootNode;
    }

    public final S getGlobalScope() {
        S result = this.thisScope();
        while (((AbstractScope)result).getParent() != null) {
            result = ((AbstractScope)result).getParent();
        }
        return result;
    }

    public final S getParentScope() {
        return this.getParent();
    }

    abstract V makeImplicitVar(ImplicitVar var1);

    final void undeclare(V var) {
        Preconditions.checkState((((AbstractVar)var).getScope() == this ? 1 : 0) != 0);
        Preconditions.checkState((boolean)((AbstractVar)this.vars.get(((AbstractVar)var).getName())).equals(var));
        this.undeclareInteral(var);
    }

    final void undeclareInteral(V var) {
        this.vars.remove(((AbstractVar)var).getName());
    }

    final void declareInternal(String name, V var) {
        Preconditions.checkState((this.hasOwnSlot(name) || this.canDeclare(name) ? 1 : 0) != 0, (String)"Illegal shadow: %s", (Object)((AbstractVar)var).getNode());
        ImmutableMap emptySentinel = ImmutableMap.of();
        if (this.vars == emptySentinel) {
            this.vars = Maps.newLinkedHashMapWithExpectedSize((int)1);
        }
        this.vars.put(name, var);
    }

    final void clearVarsInternal() {
        if (!this.vars.isEmpty()) {
            this.vars.clear();
        }
    }

    protected boolean hasOwnImplicitSlot(@Nullable ImplicitVar name) {
        return name != null && name.isMadeByScope(this);
    }

    public final boolean hasOwnSlot(String name) {
        return this.vars.containsKey(name) || this.hasOwnImplicitSlot(ImplicitVar.of(name));
    }

    public final boolean hasSlot(String name) {
        for (S scope = this.thisScope(); scope != null; scope = ((AbstractScope)scope).getParent()) {
            if (!((AbstractScope)scope).hasOwnSlot(name)) continue;
            return true;
        }
        return false;
    }

    private final @Nullable V getOwnImplicitSlot(@Nullable ImplicitVar name) {
        if (!this.hasOwnImplicitSlot(name)) {
            return null;
        }
        ImmutableMap emptySentinel = ImmutableMap.of();
        if (this.implicitVars == emptySentinel) {
            this.implicitVars = new EnumMap(ImplicitVar.class);
        }
        return (V)this.implicitVars.computeIfAbsent(name, this::makeImplicitVar);
    }

    public final V getOwnSlot(String name) {
        AbstractVar var = (AbstractVar)this.vars.get(name);
        if (var != null) {
            return (V)var;
        }
        return this.getOwnImplicitSlot(ImplicitVar.of(name));
    }

    public final V getSlot(String name) {
        return this.getVar(name);
    }

    public V getVar(String name) {
        for (S scope = this.thisScope(); scope != null; scope = ((AbstractScope)scope).getParent()) {
            @Nullable StaticSlot var = ((AbstractScope)scope).getOwnSlot(name);
            if (var == null) continue;
            return (V)var;
        }
        return null;
    }

    public final V getArgumentsVar() {
        for (S scope = this.thisScope(); scope != null; scope = ((AbstractScope)scope).getParent()) {
            @Nullable V arguments = ((AbstractScope)scope).getOwnImplicitSlot(ImplicitVar.ARGUMENTS);
            if (arguments == null) continue;
            return arguments;
        }
        return null;
    }

    final boolean canDeclare(String name) {
        return !this.hasOwnSlot(name) && (!this.isFunctionBlockScope() || !((AbstractScope)this.getParent()).hasOwnSlot(name) || this.isBleedingFunctionName(name));
    }

    private boolean isBleedingFunctionName(String name) {
        V var = this.getVar(name);
        return var != null && ((AbstractVar)var).getNode() != null && ((AbstractVar)var).getNode().getParent().isFunction();
    }

    public final Iterable<V> getVarIterable() {
        return this.vars.values();
    }

    public final Iterable<V> getAllAccessibleVariables() {
        LinkedHashMap<String, AbstractVar> accessibleVars = new LinkedHashMap<String, AbstractVar>();
        for (S s = this.thisScope(); s != null; s = ((AbstractScope)s).getParent()) {
            for (AbstractVar v : ((AbstractScope)s).getVarIterable()) {
                accessibleVars.putIfAbsent(v.getName(), v);
            }
        }
        return accessibleVars.values();
    }

    public final Iterable<V> getAllSymbols() {
        return Collections.unmodifiableCollection(this.vars.values());
    }

    public final int getVarCount() {
        return this.vars.size();
    }

    public final boolean isGlobal() {
        return this.getParent() == null;
    }

    public final boolean isLocal() {
        return this.getParent() != null;
    }

    public final boolean isBlockScope() {
        return NodeUtil.createsBlockScope(this.rootNode);
    }

    public final boolean isStaticBlockScope() {
        return NodeUtil.isClassStaticBlock(this.getRootNode());
    }

    public final boolean isFunctionBlockScope() {
        return NodeUtil.isFunctionBlock(this.getRootNode());
    }

    public final boolean isFunctionScope() {
        return this.getRootNode().isFunction();
    }

    public final boolean isModuleScope() {
        return this.getRootNode().isModuleBody();
    }

    public final boolean isMemberFieldDefScope() {
        return this.getRootNode().isMemberFieldDef();
    }

    public final boolean isComputedFieldDefRhsScope() {
        return this.getRootNode().isComputedFieldDef();
    }

    public final boolean isCatchScope() {
        return this.getRootNode().isBlock() && this.getRootNode().hasOneChild() && this.getRootNode().getFirstChild().isCatch();
    }

    public final boolean isCfgRootScope() {
        return NodeUtil.isValidCfgRoot(this.rootNode);
    }

    final boolean isHoistScope() {
        return this.isFunctionScope() || this.isFunctionBlockScope() || this.isGlobal() || this.isModuleScope() || this.isStaticBlockScope();
    }

    public final S getClosestHoistScope() {
        for (S current = this.thisScope(); current != null; current = ((AbstractScope)current).getParent()) {
            if (!((AbstractScope)current).isHoistScope()) continue;
            return current;
        }
        return null;
    }

    public final S getClosestCfgRootScope() {
        S current = this.thisScope();
        while (!((AbstractScope)current).isCfgRootScope()) {
            current = ((AbstractScope)current).getParent();
        }
        return current;
    }

    public final S getClosestContainerScope() {
        S scope = this.getClosestHoistScope();
        if (((AbstractScope)scope).isFunctionBlockScope()) {
            Preconditions.checkState((!((AbstractScope)(scope = ((AbstractScope)scope).getParent())).isBlockScope() ? 1 : 0) != 0, scope);
        }
        return scope;
    }

    private S thisScope() {
        return (S)this;
    }

    final void checkChildScope(S parent) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkArgument((boolean)NodeUtil.createsScope(this.rootNode), (Object)this.rootNode);
        Preconditions.checkArgument((this.rootNode != ((AbstractScope)parent).getRootNode() ? 1 : 0) != 0, (String)"rootNode should not be the parent's root node: %s", (Object)this.rootNode);
    }

    final void checkRootScope() {
        Preconditions.checkArgument((NodeUtil.createsScope(this.rootNode) || this.rootNode.isScript() || this.rootNode.isRoot() ? 1 : 0) != 0, (Object)this.rootNode);
    }

    S getCommonParent(S other) {
        S left = this.thisScope();
        S right = other;
        while (left != null && right != null && left != right) {
            int rightDepth;
            int leftDepth = ((AbstractScope)left).getDepth();
            if (leftDepth >= (rightDepth = ((AbstractScope)right).getDepth())) {
                left = ((AbstractScope)left).getParent();
            }
            if (leftDepth > rightDepth) continue;
            right = ((AbstractScope)right).getParent();
        }
        Preconditions.checkState((left != null && left == right ? 1 : 0) != 0);
        return left;
    }

    boolean hasSameContainerScope(S other) {
        return this == other || this.getClosestContainerScope() == ((AbstractScope)other).getClosestContainerScope();
    }

    final S getScopeOfThis() {
        S scope = this.getClosestContainerScope();
        while (!((AbstractScope)scope).isGlobal() && !NodeUtil.isNonArrowFunction(((AbstractScope)scope).getRootNode())) {
            scope = ((AbstractScope)((AbstractScope)scope).getParent()).getClosestContainerScope();
        }
        return scope;
    }

    static enum ImplicitVar {
        ARGUMENTS("arguments"),
        EXPORTS("exports"),
        SUPER("super"),
        THIS("this");

        final String name;

        private ImplicitVar(String name) {
            this.name = name;
        }

        boolean isMadeByScope(AbstractScope<?, ?> scope) {
            switch (this) {
                case EXPORTS: {
                    return scope.isModuleScope() && scope.getRootNode().getParent().getBooleanProp(Node.GOOG_MODULE);
                }
                case SUPER: 
                case THIS: {
                    return scope.isStaticBlockScope() || NodeUtil.isNonArrowFunction(scope.getRootNode()) || scope.isMemberFieldDefScope() || scope.isComputedFieldDefRhsScope();
                }
                case ARGUMENTS: {
                    return NodeUtil.isNonArrowFunction(scope.getRootNode());
                }
            }
            throw new AssertionError();
        }

        static @Nullable ImplicitVar of(String name) {
            switch (name) {
                case "arguments": {
                    return ARGUMENTS;
                }
                case "super": {
                    return SUPER;
                }
                case "this": {
                    return THIS;
                }
                case "exports": {
                    return EXPORTS;
                }
            }
            return null;
        }
    }
}

