

package com.google.javascript.jscomp.instrumentation.reporter;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ProfilingReport_FileProfilingResult extends ProfilingReport.FileProfilingResult {

  private final String fileName;
  private final float percentOfFunctionsExecuted;
  private final float percentOfBranchesExecuted;
  private final ImmutableMap<String, List<ProfilingReport.ProfilingResult>> profilingResultPerFunction;

  AutoValue_ProfilingReport_FileProfilingResult(
      String fileName,
      float percentOfFunctionsExecuted,
      float percentOfBranchesExecuted,
      ImmutableMap<String, List<ProfilingReport.ProfilingResult>> profilingResultPerFunction) {
    if (fileName == null) {
      throw new NullPointerException("Null fileName");
    }
    this.fileName = fileName;
    this.percentOfFunctionsExecuted = percentOfFunctionsExecuted;
    this.percentOfBranchesExecuted = percentOfBranchesExecuted;
    if (profilingResultPerFunction == null) {
      throw new NullPointerException("Null profilingResultPerFunction");
    }
    this.profilingResultPerFunction = profilingResultPerFunction;
  }

  @Override
  String fileName() {
    return fileName;
  }

  @Override
  float percentOfFunctionsExecuted() {
    return percentOfFunctionsExecuted;
  }

  @Override
  float percentOfBranchesExecuted() {
    return percentOfBranchesExecuted;
  }

  @Override
  ImmutableMap<String, List<ProfilingReport.ProfilingResult>> profilingResultPerFunction() {
    return profilingResultPerFunction;
  }

  @Override
  public String toString() {
    return "FileProfilingResult{"
         + "fileName=" + fileName + ", "
         + "percentOfFunctionsExecuted=" + percentOfFunctionsExecuted + ", "
         + "percentOfBranchesExecuted=" + percentOfBranchesExecuted + ", "
         + "profilingResultPerFunction=" + profilingResultPerFunction
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProfilingReport.FileProfilingResult) {
      ProfilingReport.FileProfilingResult that = (ProfilingReport.FileProfilingResult) o;
      return (this.fileName.equals(that.fileName()))
           && (Float.floatToIntBits(this.percentOfFunctionsExecuted) == Float.floatToIntBits(that.percentOfFunctionsExecuted()))
           && (Float.floatToIntBits(this.percentOfBranchesExecuted) == Float.floatToIntBits(that.percentOfBranchesExecuted()))
           && (this.profilingResultPerFunction.equals(that.profilingResultPerFunction()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fileName.hashCode();
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(percentOfFunctionsExecuted);
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(percentOfBranchesExecuted);
    h$ *= 1000003;
    h$ ^= profilingResultPerFunction.hashCode();
    return h$;
  }

}
