/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.refactoring.AutoValue_SuggestedFix_MatchedNodeInfo;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.Matchers;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.RefactoringUtils;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class SuggestedFix {
    private final MatchedNodeInfo matchedNodeInfo;
    private final SetMultimap<String, CodeReplacement> replacements;
    @Nullable
    private final String description;
    private final ImmutableList<SuggestedFix> alternatives;

    private SuggestedFix(MatchedNodeInfo matchedNodeInfo, SetMultimap<String, CodeReplacement> replacements, @Nullable String description, ImmutableList<SuggestedFix> alternatives) {
        this.matchedNodeInfo = matchedNodeInfo;
        this.replacements = replacements;
        this.description = description;
        this.alternatives = ImmutableList.builder().add((Object)this).addAll(alternatives).build();
    }

    public MatchedNodeInfo getMatchedNodeInfo() {
        return this.matchedNodeInfo;
    }

    public SetMultimap<String, CodeReplacement> getReplacements() {
        return this.replacements;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ImmutableList<SuggestedFix> getAlternatives() {
        return this.alternatives;
    }

    public ImmutableList<SuggestedFix> getNonDefaultAlternatives() {
        return this.alternatives.subList(1, this.alternatives.size());
    }

    boolean isNoOp() {
        return this.replacements.isEmpty();
    }

    public String toString() {
        if (this.isNoOp()) {
            return "<no-op SuggestedFix>";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.replacements.asMap().entrySet()) {
            sb.append("Replacements for file: ").append((String)entry.getKey()).append("\n");
            Joiner.on((String)"\n\n").appendTo(sb, (Iterable)entry.getValue());
        }
        return sb.toString();
    }

    static String getShortNameForRequire(String namespace) {
        int lastDot = namespace.lastIndexOf(46);
        if (lastDot == -1) {
            return namespace;
        }
        String rightmostName = namespace.substring(lastDot + 1);
        switch (Ascii.toUpperCase((String)rightmostName)) {
            case "ARRAY": 
            case "MAP": 
            case "MATH": 
            case "OBJECT": 
            case "PROMISE": 
            case "SET": 
            case "STRING": {
                int secondToLastDot = namespace.lastIndexOf(46, lastDot - 1);
                String secondToLastName = namespace.substring(secondToLastDot + 1, lastDot);
                boolean capitalize = Character.isUpperCase(rightmostName.charAt(0));
                if (capitalize) {
                    secondToLastName = SuggestedFix.upperCaseFirstLetter(secondToLastName);
                }
                return secondToLastName + SuggestedFix.upperCaseFirstLetter(rightmostName);
            }
        }
        return rightmostName;
    }

    static String upperCaseFirstLetter(String w) {
        return Character.toUpperCase(w.charAt(0)) + w.substring(1);
    }

    private static class HasAliasedRequireOrModuleCallback
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean usesAliasedRequires = false;
        final NodeMetadata metadata;

        public HasAliasedRequireOrModuleCallback(NodeMetadata metadata) {
            this.metadata = metadata;
        }

        boolean getUsesAliasedRequires() {
            return this.usesAliasedRequires;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (Matchers.googModule().matches(n, this.metadata) || HasAliasedRequireOrModuleCallback.isAliasedRequire(n, this.metadata)) {
                this.usesAliasedRequires = true;
                return false;
            }
            return true;
        }

        private static boolean isAliasedRequire(Node node, NodeMetadata metadata) {
            return NodeUtil.isNameDeclaration(node) && node.getFirstFirstChild() != null && Matchers.googRequire().matches(node.getFirstFirstChild(), metadata);
        }
    }

    public static abstract class MatchedNodeInfo {
        static MatchedNodeInfo create(Node node, boolean closurized) {
            return new AutoValue_SuggestedFix_MatchedNodeInfo(NodeUtil.getSourceName(node), node.getLineno(), node.getCharno(), closurized);
        }

        public abstract String getSourceFilename();

        public abstract int getLineno();

        public abstract int getCharno();

        public abstract boolean isInClosurizedFile();
    }

    public static final class Builder {
        private MatchedNodeInfo matchedNodeInfo = null;
        private final ImmutableSetMultimap.Builder<String, CodeReplacement> replacements = ImmutableSetMultimap.builder();
        private final ImmutableList.Builder<SuggestedFix> alternatives = ImmutableList.builder();
        private String description = null;

        public Builder attachMatchedNodeInfo(Node node, AbstractCompiler compiler) {
            this.matchedNodeInfo = MatchedNodeInfo.create(node, RefactoringUtils.isInClosurizedFile(node, new NodeMetadata(compiler)));
            return this;
        }

        public Builder addAlternative(SuggestedFix alternative) {
            Preconditions.checkState((boolean)alternative.getNonDefaultAlternatives().isEmpty(), (Object)"Alternative SuggestedFix must have no alternatives of their own.");
            this.alternatives.add((Object)alternative);
            return this;
        }

        Builder replaceText(Node node, int length, String newContent) {
            int startPosition = node.getSourceOffset();
            this.replacements.put((Object)node.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, newContent));
            return this;
        }

        public Builder addChildToFront(Node parentNode, String content) {
            Preconditions.checkState((boolean)parentNode.isBlock(), (Object)"addChildToFront is only supported for BLOCK statements.");
            int startPosition = parentNode.getSourceOffset() + 1;
            this.replacements.put((Object)parentNode.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, "\n" + content));
            return this;
        }

        public Builder insertAfter(Node node, String text) {
            int position = node.getSourceOffset() + node.getLength();
            this.replacements.put((Object)node.getSourceFileName(), (Object)CodeReplacement.create(position, 0, text));
            return this;
        }

        public Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler) {
            return this.insertBefore(nodeToInsertBefore, n, compiler, "");
        }

        Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler, String sortKey) {
            return this.insertBefore(nodeToInsertBefore, this.generateCode(compiler, n), sortKey);
        }

        public Builder insertBefore(Node nodeToInsertBefore, String content) {
            return this.insertBefore(nodeToInsertBefore, content, "");
        }

        private Builder insertBefore(Node nodeToInsertBefore, String content, String sortKey) {
            int startPosition = nodeToInsertBefore.getSourceOffset();
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(nodeToInsertBefore);
            if (jsDoc != null && jsDoc.getOriginalCommentString() != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            Preconditions.checkNotNull((Object)nodeToInsertBefore.getSourceFileName(), (String)"No source file name for node: %s", (Object)nodeToInsertBefore);
            this.replacements.put((Object)nodeToInsertBefore.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, content, sortKey));
            return this;
        }

        public Builder delete(Node n) {
            return this.delete(n, true);
        }

        private Builder delete(Node n, boolean deleteWhitespaceBefore) {
            Node previousSibling;
            int startPosition = n.getSourceOffset();
            int length = n.getNext() != null && NodeUtil.getBestJSDocInfo(n.getNext()) == null ? n.getNext().getSourceOffset() - startPosition : n.getLength();
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                length += startPosition - jsDoc.getOriginalCommentPosition();
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            if (n.isName() && NodeUtil.isNameDeclaration(n.getParent()) || n.isStringKey()) {
                if (n.getNext() != null) {
                    length = n.getNext().getSourceOffset() - startPosition;
                } else if (n.hasChildren()) {
                    Node child = n.getFirstChild();
                    length = child.getSourceOffset() + child.getLength() - startPosition;
                }
                if (n.getParent().getLastChild() == n && n != n.getParent().getFirstChild()) {
                    Node previousSibling2 = n.getPrevious();
                    if (previousSibling2.hasChildren()) {
                        Node child = previousSibling2.getFirstChild();
                        int startPositionDiff = startPosition - (child.getSourceOffset() + child.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    } else {
                        int startPositionDiff = startPosition - (previousSibling2.getSourceOffset() + previousSibling2.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    }
                }
            }
            Node parent = n.getParent();
            if (deleteWhitespaceBefore && parent != null && (parent.isScript() || parent.isBlock()) && (previousSibling = n.getPrevious()) != null) {
                int previousSiblingEndPosition = previousSibling.getSourceOffset() + previousSibling.getLength();
                length += startPosition - previousSiblingEndPosition;
                startPosition = previousSiblingEndPosition;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, ""));
            return this;
        }

        public Builder deleteWithoutRemovingWhitespaceBefore(Node n) {
            return this.delete(n, false);
        }

        public Builder deleteWithoutRemovingWhitespace(Node n) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset(), n.getLength(), ""));
            return this;
        }

        public Builder rename(Node n, String name) {
            return this.rename(n, name, false);
        }

        public Builder rename(Node n, String name, boolean replaceEntireName) {
            Node nodeToRename = null;
            if (n.isCall() || n.isTaggedTemplateLit()) {
                Node child;
                nodeToRename = child = n.getFirstChild();
                if (!replaceEntireName && child.isGetProp()) {
                    nodeToRename = child.getLastChild();
                }
            } else if (n.isGetProp()) {
                nodeToRename = n.getLastChild();
                if (replaceEntireName) {
                    while (nodeToRename.getParent().isGetProp()) {
                        nodeToRename = nodeToRename.getParent();
                    }
                }
            } else if (n.isStringKey()) {
                nodeToRename = n;
            } else if (n.isString()) {
                Preconditions.checkState((boolean)n.getParent().isGetProp(), (Object)n);
                nodeToRename = n;
            } else {
                throw new UnsupportedOperationException("Rename is not implemented for this node type: " + n);
            }
            this.replacements.put((Object)nodeToRename.getSourceFileName(), (Object)CodeReplacement.create(nodeToRename.getSourceOffset(), nodeToRename.getLength(), name));
            return this;
        }

        public Builder replaceRange(Node first, Node last, String newContent) {
            Preconditions.checkState((first.getParent() == last.getParent() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(first);
            int start = jsdoc == null ? first.getSourceOffset() : jsdoc.getOriginalCommentPosition();
            int end = last.getSourceOffset() + last.getLength();
            int length = end - start;
            this.replacements.put((Object)first.getSourceFileName(), (Object)CodeReplacement.create(start, length, newContent));
            return this;
        }

        public Builder replace(Node original, Node newNode, AbstractCompiler compiler) {
            boolean needsSemicolon;
            String newCode;
            Node parent = original.getParent();
            if (parent != null && parent.isExprResult()) {
                original = parent;
            }
            if ((newCode = this.generateCode(compiler, newNode)).endsWith("\n")) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            boolean bl = needsSemicolon = parent != null && (parent.isExprResult() || parent.isBlock() || parent.isScript() || parent.isModuleBody());
            if (newCode.endsWith(";") && !needsSemicolon) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            if (parent != null && IR.mayBeExpression(parent)) {
                Node replacement = newNode;
                while ((replacement.isBlock() || replacement.isScript() || replacement.isModuleBody()) && replacement.hasOneChild()) {
                    replacement = replacement.getOnlyChild();
                }
                if (replacement.isExprResult()) {
                    replacement = replacement.getOnlyChild();
                }
                if (IR.mayBeExpression(replacement)) {
                    int outer = NodeUtil.precedence(parent.getToken());
                    int inner = NodeUtil.precedence(original.getToken());
                    int newInner = NodeUtil.precedence(replacement.getToken());
                    if (newInner < NodeUtil.precedence(Token.CALL) && newInner <= outer && inner >= outer) {
                        newCode = "(" + newCode + ")";
                    }
                }
            }
            this.replacements.put((Object)original.getSourceFileName(), (Object)CodeReplacement.create(original.getSourceOffset(), original.getLength(), newCode));
            return this;
        }

        public Builder addCast(Node n, AbstractCompiler compiler, String type) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset(), n.getLength(), "/** @type {" + type + "} */ (" + this.generateCode(compiler, n) + ")"));
            return this;
        }

        public Builder removeCast(Node n, AbstractCompiler compiler) {
            Preconditions.checkArgument((boolean)n.isCast());
            JSDocInfo jsDoc = n.getJSDocInfo();
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(jsDoc.getOriginalCommentPosition(), n.getFirstChild().getSourceOffset() - jsDoc.getOriginalCommentPosition(), ""));
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(n.getSourceOffset() + n.getLength() - 1, 1, ""));
            return this;
        }

        public Builder addOrReplaceJsDoc(Node n, String newJsDoc) {
            int startPosition = n.getSourceOffset();
            int length = 0;
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
                length = n.getSourceOffset() - jsDoc.getOriginalCommentPosition();
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, length, newJsDoc));
            return this;
        }

        public Builder changeJsDocType(Node n, AbstractCompiler compiler, String type) {
            Node typeNode = JsDocInfoParser.parseTypeString(type);
            Preconditions.checkNotNull((Object)typeNode, (String)"Invalid type: %s", (Object)type);
            JSTypeExpression typeExpr = new JSTypeExpression(typeNode, "jsflume");
            JSType newJsType = typeExpr.evaluate(null, compiler.getTypeRegistry());
            if (newJsType == null) {
                throw new RuntimeException("JS Compiler does not recognize type: " + type);
            }
            this.replaceTypePattern(n, type, Pattern.compile("@(type) *\\{?[^@\\s}]+\\}?"));
            this.replaceTypePattern(n, type, Pattern.compile("@(export|package|private|protected|public|const|return) *\\{[^}]+\\}"));
            return this;
        }

        private void replaceTypePattern(Node n, String type, Pattern pattern) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            Preconditions.checkNotNull((Object)info, (String)"Node %s does not have JS Doc associated with it.", (Object)n);
            String originalComment = info.getOriginalCommentString();
            int originalPosition = info.getOriginalCommentPosition();
            if (originalComment != null) {
                Matcher m = pattern.matcher(originalComment);
                while (m.find()) {
                    this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(originalPosition + m.start(), m.end() - m.start(), "@" + m.group(1) + " {" + type + "}"));
                }
            }
        }

        public Builder insertArguments(Node n, int position, String ... args) {
            int startPosition;
            int i;
            Preconditions.checkArgument((boolean)n.isCall(), (Object)"insertArguments is only applicable to function call nodes.");
            Node argument = n.getSecondChild();
            for (i = 0; argument != null && i < position; argument = argument.getNext(), ++i) {
            }
            if (argument == null) {
                Preconditions.checkArgument((position == i ? 1 : 0) != 0, (Object)"The specified position must be less than the number of arguments.");
                startPosition = n.getSourceOffset() + n.getLength() - 1;
            } else {
                JSDocInfo jsDoc = argument.getJSDocInfo();
                startPosition = jsDoc != null ? jsDoc.getOriginalCommentPosition() : argument.getSourceOffset();
            }
            String newContent = Joiner.on((String)", ").join((Object[])args);
            if (argument != null) {
                newContent = newContent + ", ";
            } else if (i > 0) {
                newContent = ", " + newContent;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, newContent));
            return this;
        }

        public Builder deleteArgument(Node n, int position) {
            Preconditions.checkArgument((boolean)n.isCall(), (Object)"deleteArgument is only applicable to function call nodes.");
            int numArguments = n.getChildCount() - 1;
            Preconditions.checkState((numArguments > 0 ? 1 : 0) != 0, (Object)"deleteArgument() cannot be used on a function call with no arguments");
            Preconditions.checkArgument((position >= 0 && position < numArguments ? 1 : 0) != 0, (Object)"The specified position must be less than the number of arguments.");
            Node argument = n.getSecondChild();
            int startOfArgumentToRemove = -1;
            int endOfArgumentToRemove = -1;
            int i = 0;
            while (argument != null) {
                if (i < position) {
                    startOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i == position) {
                    if (position == 0) {
                        int jsDocPosition;
                        startOfArgumentToRemove = argument.getSourceOffset();
                        JSDocInfo jsDoc = argument.getJSDocInfo();
                        if (jsDoc != null && (jsDocPosition = jsDoc.getOriginalCommentPosition()) < startOfArgumentToRemove) {
                            startOfArgumentToRemove = jsDocPosition;
                        }
                    }
                    endOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i > position) {
                    if (position != 0) break;
                    endOfArgumentToRemove = argument.getSourceOffset();
                    break;
                }
                argument = argument.getNext();
                ++i;
            }
            int lengthOfArgumentToRemove = endOfArgumentToRemove - startOfArgumentToRemove;
            this.replacements.put((Object)n.getSourceFileName(), (Object)CodeReplacement.create(startOfArgumentToRemove, lengthOfArgumentToRemove, ""));
            return this;
        }

        public Builder addLhsToGoogRequire(Match m, String namespace) {
            Node existingNode = Builder.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            Preconditions.checkState((boolean)existingNode.isExprResult(), (Object)existingNode);
            Preconditions.checkState((boolean)existingNode.getFirstChild().isCall(), (Object)existingNode.getFirstChild());
            String shortName = SuggestedFix.getShortNameForRequire(namespace);
            Node newNode = IR.constNode(IR.name(shortName), existingNode.getFirstChild().cloneTree());
            this.replace(existingNode, newNode, m.getMetadata().getCompiler());
            return this;
        }

        public Builder addGoogRequire(Match m, String namespace) {
            Node node = m.getNode();
            NodeMetadata metadata = m.getMetadata();
            Node existingNode = Builder.findGoogRequireNode(m.getNode(), metadata, namespace);
            if (existingNode != null) {
                return this;
            }
            Node script = NodeUtil.getEnclosingScript(node);
            if (script == null) {
                return this;
            }
            if (script.getFirstChild().isModuleBody()) {
                script = script.getFirstChild();
            }
            Node googRequireNode = IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(namespace));
            String shortName = SuggestedFix.getShortNameForRequire(namespace);
            boolean useAliasedRequire = this.usesConstGoogRequires(metadata, script);
            googRequireNode = useAliasedRequire ? IR.constNode(IR.name(shortName), googRequireNode) : IR.exprResult(googRequireNode);
            Node lastModuleOrProvideNode = null;
            Node lastGoogRequireNode = null;
            Node nodeToInsertBefore = null;
            for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                if (Matchers.googModule().matches(child, metadata)) {
                    lastModuleOrProvideNode = child;
                }
                if (NodeUtil.isExprCall(child)) {
                    Node grandchild = child.getFirstChild();
                    if (Matchers.googModuleOrProvide().matches(grandchild, metadata)) {
                        lastModuleOrProvideNode = grandchild;
                        continue;
                    }
                    if (!Matchers.googRequire().matches(grandchild, metadata)) continue;
                    lastGoogRequireNode = grandchild;
                    if (!grandchild.getLastChild().isString() || namespace.compareTo(grandchild.getLastChild().getString()) >= 0) continue;
                    nodeToInsertBefore = child;
                    break;
                }
                if (!NodeUtil.isNameDeclaration(child) || child.getFirstFirstChild() == null || !Matchers.googRequire().matches(child.getFirstFirstChild(), metadata)) continue;
                lastGoogRequireNode = child.getFirstFirstChild();
                String requireName = child.getFirstChild().getString();
                String originalName = child.getFirstChild().getOriginalName();
                if (originalName != null) {
                    requireName = originalName;
                }
                if (shortName.compareTo(requireName) >= 0) continue;
                nodeToInsertBefore = child;
                break;
            }
            if (nodeToInsertBefore == null) {
                if (lastModuleOrProvideNode != null || lastGoogRequireNode != null) {
                    Node nodeToInsertAfter = lastGoogRequireNode != null ? lastGoogRequireNode : lastModuleOrProvideNode;
                    int startPosition = nodeToInsertAfter.getSourceOffset() + nodeToInsertAfter.getLength() + 2;
                    this.replacements.put((Object)nodeToInsertAfter.getSourceFileName(), (Object)CodeReplacement.create(startPosition, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode), namespace));
                    return this;
                }
                if (script.hasChildren()) {
                    nodeToInsertBefore = script.getFirstChild();
                } else {
                    this.replacements.put((Object)script.getSourceFileName(), (Object)CodeReplacement.create(0, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode), namespace));
                    return this;
                }
            }
            return this.insertBefore(nodeToInsertBefore, googRequireNode, m.getMetadata().getCompiler(), namespace);
        }

        public String getRequireName(Match m, String namespace) {
            Node existingNode = Builder.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            if (existingNode != null && (existingNode.isConst() || existingNode.isVar())) {
                Node lhsAssign = existingNode.getFirstChild();
                String originalName = lhsAssign.getOriginalName();
                if (originalName != null) {
                    return originalName;
                }
                return lhsAssign.getQualifiedName();
            }
            Node script = NodeUtil.getEnclosingScript(m.getNode());
            if (script != null && this.usesConstGoogRequires(m.getMetadata(), script)) {
                return SuggestedFix.getShortNameForRequire(namespace);
            }
            return namespace;
        }

        private boolean usesConstGoogRequires(NodeMetadata metadata, Node script) {
            if (script.isModuleBody()) {
                return true;
            }
            HasAliasedRequireOrModuleCallback callback = new HasAliasedRequireOrModuleCallback(metadata);
            NodeTraversal.traverse(metadata.getCompiler(), script, callback);
            return callback.getUsesAliasedRequires();
        }

        Builder mergeGoogRequire(Node requireToMergeFrom, NodeMetadata m, String namespace, AbstractCompiler compiler) {
            Preconditions.checkArgument((boolean)requireToMergeFrom.getFirstChild().isDestructuringLhs(), (Object)requireToMergeFrom);
            Preconditions.checkArgument((boolean)requireToMergeFrom.getFirstFirstChild().isObjectPattern(), (Object)requireToMergeFrom);
            Node googRequireNode = Builder.findGoogRequireNode(requireToMergeFrom, m, namespace);
            if (googRequireNode == null) {
                return this;
            }
            if (googRequireNode.isExprResult()) {
                return this;
            }
            if (googRequireNode.getFirstChild().isDestructuringLhs()) {
                Node objectPattern = googRequireNode.getFirstFirstChild();
                Node newObjectPattern = objectPattern.cloneTree();
                for (Node name : requireToMergeFrom.getFirstFirstChild().children()) {
                    newObjectPattern.addChildToBack(name.cloneTree());
                }
                this.replace(objectPattern, newObjectPattern, compiler);
                this.deleteWithoutRemovingWhitespace(requireToMergeFrom);
            }
            return this;
        }

        public Builder removeGoogRequire(Match m, String namespace) {
            Node googRequireNode = Builder.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            if (googRequireNode != null) {
                return this.deleteWithoutRemovingWhitespaceBefore(googRequireNode);
            }
            return this;
        }

        @Nullable
        private static Node findGoogRequireNode(Node n, NodeMetadata metadata, String namespace) {
            Node script = NodeUtil.getEnclosingScript(n);
            if (script.getFirstChild().isModuleBody()) {
                script = script.getFirstChild();
            }
            for (Node child : script.children()) {
                if (!NodeUtil.isExprCall(child) || !Matchers.googRequire(namespace).matches(child.getFirstChild(), metadata)) continue;
                return child;
            }
            for (Node child : script.children()) {
                if (!NodeUtil.isNameDeclaration(child) || child.getFirstChild().getLastChild() == null || !Matchers.googRequire(namespace).matches(child.getFirstChild().getLastChild(), metadata)) continue;
                return child;
            }
            return null;
        }

        public String generateCode(AbstractCompiler compiler, Node node) {
            if (node.isBlock()) {
                node.setToken(Token.SCRIPT);
            }
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.setPreferSingleQuotes(true);
            compilerOptions.setUseOriginalNamesInOutput(true);
            compilerOptions.setTrustedStrings(true);
            return new CodePrinter.Builder(node).setCompilerOptions(compilerOptions).setTypeRegistry(compiler.getTypeRegistry()).setPrettyPrint(true).setLineBreak(true).setOutputTypes(true).build();
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public SuggestedFix build() {
            return new SuggestedFix(this.matchedNodeInfo, (SetMultimap)this.replacements.build(), this.description, this.alternatives.build());
        }
    }
}

