/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.bundle;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.bundle.AutoValue_Source;
import com.google.javascript.jscomp.deps.DependencyInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Immutable
@GwtIncompatible
public abstract class Source {
    private static final Path DEV_NULL = Paths.get("/dev/null", new String[0]);

    public abstract Path path();

    public abstract String sourceMap();

    public abstract String sourceUrl();

    public abstract String sourceMappingUrl();

    public abstract ImmutableSet<String> runtimes();

    public abstract ImmutableMap<String, String> loadFlags();

    public abstract int estimatedSize();

    public final String code() {
        return (String)this.codeSupplier().get();
    }

    public final String originalCode() {
        return (String)this.originalCodeSupplier().get();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Source.Builder().setPath(DEV_NULL).setCode("").setOriginalCodeSupplier(null).setSourceMap("").setSourceUrl("").setSourceMappingUrl("").setRuntimes((ImmutableSet<String>)ImmutableSet.of()).setLoadFlags((ImmutableMap<String, String>)ImmutableMap.of()).setEstimatedSize(0);
    }

    abstract Lazy<String> codeSupplier();

    @Nullable
    abstract Lazy<String> originalCodeSupplier();

    @Immutable
    @GwtIncompatible
    static abstract class Lazy<T>
    implements Supplier<T> {
        Lazy() {
        }

        public boolean equals(Object other) {
            return other instanceof Lazy && Objects.equals(this.get(), ((Lazy)other).get());
        }

        public int hashCode() {
            return Objects.hashCode(this.get());
        }

        static <T> Lazy<T> ofInstance(final T instance) {
            return new Lazy<T>(){

                public T get() {
                    return instance;
                }
            };
        }

        static <T> Lazy<T> memoize(Supplier<T> supplier) {
            final Supplier memoized = Suppliers.memoize(supplier);
            return new Lazy<T>(){

                public T get() {
                    return memoized.get();
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Transformer {
        public Source transform(Source var1);

        public static Transformer of(Function<Source, Source> function) {
            return function::apply;
        }

        public static Transformer identity() {
            return x -> x;
        }

        default public Function<Source, Source> asFunction() {
            return this::transform;
        }

        @CheckReturnValue
        default public Transformer andThen(Transformer after) {
            Transformer before = this;
            return x -> after.transform(before.transform(x));
        }

        @CheckReturnValue
        default public Transformer compose(Transformer before) {
            Transformer after = this;
            return x -> after.transform(before.transform(x));
        }
    }

    @GwtIncompatible
    public static abstract class Builder {
        public abstract Builder setPath(Path var1);

        public abstract Builder setSourceMap(String var1);

        public abstract Builder setSourceUrl(String var1);

        public abstract Builder setSourceMappingUrl(String var1);

        public abstract Builder setRuntimes(ImmutableSet<String> var1);

        public abstract Builder setLoadFlags(ImmutableMap<String, String> var1);

        public abstract Builder setEstimatedSize(int var1);

        public final Builder setCode(Supplier<String> code) {
            return this.setCodeSupplier(Lazy.memoize(code));
        }

        public final Builder setCode(String code) {
            return this.setCodeSupplier(Lazy.ofInstance(code));
        }

        public final Builder setOriginalCode(String code) {
            return this.setOriginalCodeSupplier(Lazy.ofInstance(code));
        }

        public final Builder addRuntime(String ... runtimes) {
            return this.setRuntimes((ImmutableSet<String>)ImmutableSet.builder().addAll(this.runtimes()).addAll(Arrays.asList(runtimes)).build());
        }

        public final Builder setDependencyInfo(DependencyInfo info) {
            return this.setLoadFlags(info.getLoadFlags());
        }

        public final Source build() {
            if (this.originalCodeSupplier() == null) {
                this.setOriginalCodeSupplier(this.codeSupplier());
            }
            return this.autoBuild();
        }

        abstract Builder setCodeSupplier(Lazy<String> var1);

        abstract Builder setOriginalCodeSupplier(@Nullable Lazy<String> var1);

        abstract ImmutableSet<String> runtimes();

        abstract Lazy<String> codeSupplier();

        abstract Source autoBuild();

        @Nullable
        abstract Lazy<String> originalCodeSupplier();
    }
}

