/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

class VariableVisibilityAnalysis
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<Node, VariableVisibility> visibilityByDeclaringNameNode;

    public VariableVisibilityAnalysis(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.visibilityByDeclaringNameNode = new HashMap<Node, VariableVisibility>();
    }

    public VariableVisibility getVariableVisibility(Node declaringNameNode) {
        Node parent = declaringNameNode.getParent();
        Preconditions.checkArgument((parent.isVar() || parent.isFunction() || parent.isParamList() ? 1 : 0) != 0);
        return this.visibilityByDeclaringNameNode.get(declaringNameNode);
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(this.compiler));
        callback.process(root);
        for (Var variable : callback.getAllSymbols()) {
            VariableVisibility visibility;
            ReferenceCollection referenceCollection = callback.getReferences(variable);
            if (VariableVisibilityAnalysis.variableIsParameter(variable)) {
                visibility = VariableVisibility.PARAMETER;
            } else if (variable.isLocal()) {
                visibility = referenceCollection.isEscaped() ? VariableVisibility.CAPTURED_LOCAL : VariableVisibility.LOCAL;
            } else if (variable.isGlobal()) {
                visibility = VariableVisibility.GLOBAL;
            } else {
                throw new IllegalStateException("Un-handled variable visibility for " + variable);
            }
            this.visibilityByDeclaringNameNode.put(variable.getNameNode(), visibility);
        }
    }

    private static boolean variableIsParameter(Var variable) {
        Node variableParent = variable.getParentNode();
        return variableParent != null && variableParent.isParamList();
    }

    static enum VariableVisibility {
        LOCAL,
        CAPTURED_LOCAL,
        PARAMETER,
        GLOBAL;

    }
}

