/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeMatchingStrategy;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TemplateAstMatcher {
    private static final Token TEMPLATE_TYPE_PARAM = Token.PLACEHOLDER1;
    private static final Token TEMPLATE_LOCAL_NAME = Token.PLACEHOLDER2;
    private static final Token TEMPLATE_STRING_LITERAL = Token.PLACEHOLDER3;
    private final JSTypeRegistry typeRegistry;
    private final Node templateStart;
    private final List<String> templateParams = new ArrayList<String>();
    private final ArrayList<Node> paramNodeMatches = new ArrayList();
    private final List<String> templateLocals = new ArrayList<String>();
    private final ArrayList<String> localVarMatches = new ArrayList();
    private final HashMap<String, Node> stringLiteralMatches = new HashMap();
    private boolean isLooseMatch = false;
    private final TypeMatchingStrategy typeMatchingStrategy;

    public TemplateAstMatcher(JSTypeRegistry typeRegistry, Node templateFunctionNode, TypeMatchingStrategy typeMatchingStrategy) {
        Preconditions.checkNotNull((Object)typeRegistry);
        Preconditions.checkState((boolean)templateFunctionNode.isFunction(), (String)"Template node must be a function node. Received: %s", (Object)templateFunctionNode);
        this.typeRegistry = typeRegistry;
        this.templateStart = this.initTemplate(templateFunctionNode);
        this.typeMatchingStrategy = (TypeMatchingStrategy)((Object)Preconditions.checkNotNull((Object)((Object)typeMatchingStrategy)));
    }

    public boolean matches(Node n) {
        if (this.matchesTemplateShape(this.templateStart, n)) {
            if (this.paramNodeMatches.isEmpty() && this.localVarMatches.isEmpty()) {
                return true;
            }
            this.reset();
            return this.matchesTemplate(this.templateStart, n);
        }
        return false;
    }

    public boolean isLooseMatch() {
        return this.isLooseMatch;
    }

    public Map<String, Node> getTemplateNodeToMatchMap() {
        String name;
        int i;
        HashMap<String, Node> map = new HashMap<String, Node>(this.stringLiteralMatches);
        for (i = 0; i < this.templateParams.size(); ++i) {
            name = this.templateParams.get(i);
            map.put(name, this.paramNodeMatches.get(i));
        }
        for (i = 0; i < this.templateLocals.size(); ++i) {
            name = this.templateLocals.get(i);
            map.put(name, IR.name(this.localVarMatches.get(i)));
        }
        return map;
    }

    private Node initTemplate(Node templateFunctionNode) {
        int i;
        Node prepped = templateFunctionNode.cloneTree();
        this.prepTemplatePlaceholders(prepped);
        Node body = prepped.getLastChild();
        Node startNode = body.hasOneChild() && body.getFirstChild().isExprResult() ? body.getFirstFirstChild() : body.getFirstChild();
        for (i = 0; i < this.templateLocals.size(); ++i) {
            this.localVarMatches.add(null);
        }
        for (i = 0; i < this.templateParams.size(); ++i) {
            this.paramNodeMatches.add(null);
        }
        return startNode;
    }

    private void prepTemplatePlaceholders(Node fn) {
        final List<String> locals = this.templateLocals;
        final List<String> params = this.templateParams;
        final HashMap<String, JSType> paramTypes = new HashMap<String, JSType>();
        String fnName = fn.getFirstChild().getString();
        fn.getFirstChild().setString("");
        Node templateParametersNode = fn.getSecondChild();
        JSDocInfo info = NodeUtil.getBestJSDocInfo(fn);
        if (templateParametersNode.hasChildren()) {
            Preconditions.checkNotNull((Object)info, (String)"Missing JSDoc declaration for template function %s", (Object)fnName);
        }
        for (Node paramNode : templateParametersNode.children()) {
            String name = paramNode.getString();
            JSTypeExpression expression = info.getParameterType(name);
            Preconditions.checkNotNull((Object)expression, (String)"Missing JSDoc for parameter %s of template function %s", (Object)name, (Object)fnName);
            JSType type = this.typeRegistry.evaluateTypeExpressionInGlobalScope(expression);
            Preconditions.checkNotNull((Object)type);
            params.add(name);
            paramTypes.put(name, type);
        }
        this.traverse(fn, new Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isName()) {
                    Node parent = n.getParent();
                    String name = n.getString();
                    if (!name.isEmpty() && parent.isVar() && !locals.contains(name)) {
                        locals.add(n.getString());
                    }
                    if (params.contains(name)) {
                        JSType type = (JSType)paramTypes.get(name);
                        boolean isStringLiteral = type.isStringValueType() && name.startsWith("string_literal");
                        TemplateAstMatcher.this.replaceNodeInPlace(n, TemplateAstMatcher.this.createTemplateParameterNode(params.indexOf(name), type, isStringLiteral));
                    } else if (locals.contains(name)) {
                        TemplateAstMatcher.this.replaceNodeInPlace(n, TemplateAstMatcher.this.createTemplateLocalNameNode(locals.indexOf(name)));
                    }
                }
            }
        });
    }

    void replaceNodeInPlace(Node n, Node replacement) {
        Node parent = n.getParent();
        if (n.hasChildren()) {
            Node children = n.removeChildren();
            replacement.addChildrenToFront(children);
        }
        parent.replaceChild(n, replacement);
    }

    private void traverse(Node n, Visitor callback) {
        Node next = null;
        Node c = n.getFirstChild();
        while (c != null) {
            next = c.getNext();
            this.traverse(c, callback);
            c = next;
        }
        callback.visit(n);
    }

    private void reset() {
        this.isLooseMatch = false;
        Collections.fill(this.localVarMatches, null);
        for (int i = 0; i < this.paramNodeMatches.size(); ++i) {
            this.paramNodeMatches.set(i, null);
        }
    }

    private boolean isTemplateParameterNode(Node n) {
        return n.getToken() == TEMPLATE_TYPE_PARAM;
    }

    private boolean isTemplateParameterStringLiteralNode(Node n) {
        return n.getToken() == TEMPLATE_STRING_LITERAL;
    }

    private Node createTemplateParameterNode(int index, JSType type, boolean isStringLiteral) {
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)type);
        Node n = Node.newNumber(index);
        if (isStringLiteral) {
            n.setToken(TEMPLATE_STRING_LITERAL);
        } else {
            n.setToken(TEMPLATE_TYPE_PARAM);
        }
        n.setJSType(type);
        return n;
    }

    private boolean isTemplateLocalNameNode(Node n) {
        return n.getToken() == TEMPLATE_LOCAL_NAME;
    }

    private Node createTemplateLocalNameNode(int index) {
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
        Node n = Node.newNumber(index);
        n.setToken(TEMPLATE_LOCAL_NAME);
        return n;
    }

    private boolean matchesTemplateShape(Node template, Node ast) {
        while (template != null) {
            if (ast == null || !this.matchesNodeShape(template, ast)) {
                return false;
            }
            template = template.getNext();
            ast = ast.getNext();
        }
        return true;
    }

    private boolean matchesNodeShape(Node template, Node ast) {
        if (this.isTemplateParameterNode(template)) {
            return !NodeUtil.isStatement(ast);
        }
        if (this.isTemplateLocalNameNode(template)) {
            if (!ast.isName()) {
                return false;
            }
        } else {
            if (this.isTemplateParameterStringLiteralNode(template)) {
                return NodeUtil.isSomeCompileTimeConstStringValue(ast);
            }
            if (template.isCall() ? ast == null || !ast.isCall() || ast.getChildCount() != template.getChildCount() : !template.isEquivalentToShallow(ast)) {
                return false;
            }
        }
        Node templateChild = template.getFirstChild();
        Node astChild = ast.getFirstChild();
        while (templateChild != null) {
            if (!this.matchesNodeShape(templateChild, astChild)) {
                return false;
            }
            templateChild = templateChild.getNext();
            astChild = astChild.getNext();
        }
        return true;
    }

    private boolean matchesTemplate(Node template, Node ast) {
        while (template != null) {
            if (ast == null || !this.matchesNode(template, ast)) {
                return false;
            }
            template = template.getNext();
            ast = ast.getNext();
        }
        return true;
    }

    private boolean matchesNode(Node template, Node ast) {
        if (this.isTemplateParameterNode(template)) {
            int paramIndex = (int)template.getDouble();
            Node previousMatch = this.paramNodeMatches.get(paramIndex);
            if (previousMatch != null) {
                return ast.isEquivalentTo(previousMatch);
            }
            JSType templateType = template.getJSType();
            Preconditions.checkNotNull((Object)templateType, (Object)"null template parameter type.");
            if (this.isUnresolvedType(templateType)) {
                return false;
            }
            TypeMatchingStrategy.MatchResult matchResult = this.typeMatchingStrategy.match(templateType, ast.getJSType());
            this.isLooseMatch = matchResult.isLooseMatch();
            boolean isMatch = matchResult.isMatch();
            if (isMatch && previousMatch == null) {
                this.paramNodeMatches.set(paramIndex, ast);
            }
            return isMatch;
        }
        if (this.isTemplateLocalNameNode(template)) {
            boolean previouslyMatched;
            int paramIndex = (int)template.getDouble();
            boolean bl = previouslyMatched = this.localVarMatches.get(paramIndex) != null;
            if (previouslyMatched) {
                return ast.getString().equals(this.localVarMatches.get(paramIndex));
            }
            String originalName = ast.getOriginalName();
            String name = originalName != null ? originalName : ast.getString();
            this.localVarMatches.set(paramIndex, name);
        } else if (this.isTemplateParameterStringLiteralNode(template)) {
            int paramIndex = (int)template.getDouble();
            Node previousMatch = this.paramNodeMatches.get(paramIndex);
            if (previousMatch != null) {
                return ast.isEquivalentTo(previousMatch);
            }
            if (NodeUtil.isSomeCompileTimeConstStringValue(ast)) {
                this.paramNodeMatches.set(paramIndex, ast);
                return true;
            }
            return false;
        }
        Node templateChild = template.getFirstChild();
        Node astChild = ast.getFirstChild();
        while (templateChild != null) {
            if (!this.matchesNode(templateChild, astChild)) {
                return false;
            }
            templateChild = templateChild.getNext();
            astChild = astChild.getNext();
        }
        return true;
    }

    private boolean isUnresolvedType(JSType type) {
        if (type.isUnresolvedOrResolvedUnknown()) {
            return true;
        }
        if (type.isUnionType()) {
            for (JSType alternate : type.getUnionMembers()) {
                if (!this.isUnresolvedType(alternate)) continue;
                return true;
            }
        }
        return false;
    }

    private static interface Visitor {
        public void visit(Node var1);
    }
}

