/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;
    private final boolean allowNonGlobalExports;
    private final Set<String> exportedVariables = new HashSet<String>();

    GenerateExports(AbstractCompiler compiler, boolean allowNonGlobalExports, String exportSymbolFunction, String exportPropertyFunction) {
        Preconditions.checkNotNull((Object)compiler);
        Preconditions.checkNotNull((Object)exportSymbolFunction);
        Preconditions.checkNotNull((Object)exportPropertyFunction);
        this.compiler = compiler;
        this.allowNonGlobalExports = allowNonGlobalExports;
        this.exportSymbolFunction = exportSymbolFunction;
        this.exportPropertyFunction = exportPropertyFunction;
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler, this.allowNonGlobalExports);
        NodeTraversal.traverse(this.compiler, root, findExportableNodes);
        LinkedHashMap<String, Node> exports = findExportableNodes.getExports();
        LinkedHashMap<Node, String> es6Exports = findExportableNodes.getEs6ClassExports();
        LinkedHashSet<String> localExports = findExportableNodes.getLocalExports();
        for (Map.Entry entry : es6Exports.entrySet()) {
            this.addExportForEs6Method((Node)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : exports.entrySet()) {
            String export = (String)entry.getKey();
            Node context = (Node)entry.getValue();
            this.addExportMethod(exports, export, context);
        }
        for (String export : localExports) {
            this.addExtern(export);
        }
    }

    private void addExtern(String export) {
        Node objectPrototype = NodeUtil.newQName(this.compiler, "Object.prototype");
        JSType objCtor = this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE);
        objectPrototype.getFirstChild().setJSType(objCtor);
        Node propstmt = IR.exprResult(IR.getprop(objectPrototype, IR.string(export)));
        propstmt.useSourceInfoFromForTree(this.getSynthesizedExternsRoot());
        propstmt.setOriginalName(export);
        this.getSynthesizedExternsRoot().addChildToBack(propstmt);
        this.compiler.reportChangeToEnclosingScope(propstmt);
    }

    private void recordExportSymbol(String qname) {
        int dot = qname.indexOf(46);
        if (dot == -1) {
            this.exportedVariables.add(qname);
        } else {
            this.exportedVariables.add(qname.substring(0, dot));
        }
    }

    private void addExportForEs6Method(Node memberFunction, String ownerName) {
        Preconditions.checkArgument((boolean)memberFunction.isMemberFunctionDef(), (Object)memberFunction);
        Preconditions.checkArgument((!ownerName.isEmpty() ? 1 : 0) != 0, (Object)ownerName);
        String fullExport = ownerName + "." + memberFunction.getString();
        this.addExportPropertyCall(ownerName, memberFunction, fullExport, memberFunction.getString());
    }

    private void addExportMethod(Map<String, Node> exports, String export, Node context) {
        String methodOwnerName = null;
        boolean isEs5StylePrototypeAssignment = false;
        String propertyName = null;
        if (context.getFirstChild().isGetProp()) {
            Node node = context.getFirstChild();
            Node ownerNode = node.getFirstChild();
            methodOwnerName = ownerNode.getQualifiedName();
            if (ownerNode.isGetProp() && ownerNode.getLastChild().getString().equals(PROTOTYPE_PROPERTY)) {
                isEs5StylePrototypeAssignment = true;
            }
            propertyName = node.getSecondChild().getString();
        }
        boolean useExportSymbol = true;
        if (isEs5StylePrototypeAssignment) {
            useExportSymbol = false;
        } else if (methodOwnerName != null && exports.containsKey(methodOwnerName)) {
            useExportSymbol = false;
        }
        if (useExportSymbol) {
            this.addExportSymbolCall(export, context);
        } else {
            this.addExportPropertyCall(methodOwnerName, context, export, propertyName);
        }
    }

    private void addExportPropertyCall(String methodOwnerName, Node context, String export, String propertyName) {
        Preconditions.checkNotNull((Object)methodOwnerName);
        Node call = IR.call(NodeUtil.newQName(this.compiler, this.exportPropertyFunction, context, this.exportPropertyFunction), NodeUtil.newQName(this.compiler, methodOwnerName, context, this.exportPropertyFunction), IR.string(propertyName), NodeUtil.newQName(this.compiler, export, context, this.exportPropertyFunction));
        Node expression = IR.exprResult(call).useSourceInfoIfMissingFromForTree(context);
        this.annotate(expression);
        this.addStatement(context, expression);
    }

    private void addExportSymbolCall(String export, Node context) {
        this.recordExportSymbol(export);
        Node call = IR.call(NodeUtil.newQName(this.compiler, this.exportSymbolFunction, context, export), IR.string(export), NodeUtil.newQName(this.compiler, export, context, export));
        Node expression = IR.exprResult(call).useSourceInfoIfMissingFromForTree(context);
        this.annotate(expression);
        this.addStatement(context, expression);
    }

    private void addStatement(Node context, Node stmt) {
        Node next;
        Node n;
        CodingConvention convention = this.compiler.getCodingConvention();
        Node exprRoot = n = context;
        while (!NodeUtil.isStatementBlock(exprRoot.getParent())) {
            exprRoot = exprRoot.getParent();
        }
        while ((next = exprRoot.getNext()) != null && NodeUtil.isExprCall(next) && convention.getClassesDefinedByCall(next.getFirstChild()) != null) {
            exprRoot = next;
        }
        Node block = exprRoot.getParent();
        block.addChildAfter(stmt, exprRoot);
        this.compiler.reportChangeToEnclosingScope(stmt);
    }

    private void annotate(Node node) {
        NodeTraversal.traverse(this.compiler, node, new PrepareAst.PrepareAnnotations());
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }
}

