/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public class VoidType
extends ValueType {
    private static final long serialVersionUID = 1L;

    VoidType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        return this.registry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        if (TernaryValue.UNKNOWN.equals((Object)super.testForEquality(that))) {
            return TernaryValue.UNKNOWN;
        }
        if (that.isSubtype(this) || that.isSubtype(this.getNativeType(JSTypeNative.NULL_TYPE))) {
            return TernaryValue.TRUE;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean matchesNumberContext() {
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean isVoidType() {
        return true;
    }

    @Override
    public boolean isVoidable() {
        return true;
    }

    @Override
    public boolean isExplicitlyVoidable() {
        return true;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(this.getDisplayName());
    }

    @Override
    public String getDisplayName() {
        return "undefined";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.FALSE;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseVoidType();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

