/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte JSDOC_INFO_PROP = 29;
    public static final byte VAR_ARGS_NAME = 30;
    public static final byte INCRDECR_PROP = 32;
    public static final byte QUOTED_PROP = 36;
    public static final byte OPT_ARG_NAME = 37;
    public static final byte SYNTHETIC_BLOCK_PROP = 38;
    public static final byte ADDED_BLOCK = 39;
    public static final byte ORIGINALNAME_PROP = 40;
    public static final byte SIDE_EFFECT_FLAGS = 42;
    public static final byte IS_CONSTANT_NAME = 43;
    public static final byte IS_NAMESPACE = 46;
    public static final byte DIRECTIVES = 48;
    public static final byte DIRECT_EVAL = 49;
    public static final byte FREE_CALL = 50;
    public static final byte STATIC_SOURCE_FILE = 51;
    public static final byte INPUT_ID = 53;
    public static final byte SLASH_V = 54;
    public static final byte INFERRED_FUNCTION = 55;
    public static final byte CHANGE_TIME = 56;
    public static final byte REFLECTED_OBJECT = 57;
    public static final byte STATIC_MEMBER = 58;
    public static final byte GENERATOR_FN = 59;
    public static final byte ARROW_FN = 60;
    public static final byte ASYNC_FN = 61;
    public static final byte YIELD_ALL = 62;
    public static final byte EXPORT_DEFAULT = 63;
    public static final byte EXPORT_ALL_FROM = 64;
    public static final byte IS_CONSTANT_VAR = 65;
    public static final byte GENERATOR_MARKER = 66;
    public static final byte GENERATOR_SAFE = 67;
    public static final byte RAW_STRING_VALUE = 71;
    public static final byte COMPUTED_PROP_METHOD = 72;
    public static final byte COMPUTED_PROP_GETTER = 73;
    public static final byte COMPUTED_PROP_SETTER = 74;
    public static final byte COMPUTED_PROP_VARIABLE = 75;
    public static final byte ANALYZED_DURING_GTI = 76;
    public static final byte CONSTANT_PROPERTY_DEF = 77;
    public static final byte DECLARED_TYPE_EXPR = 78;
    public static final byte TYPE_BEFORE_CAST = 79;
    public static final byte OPT_ES6_TYPED = 80;
    public static final byte GENERIC_TYPE_LIST = 81;
    public static final byte IMPLEMENTS = 82;
    public static final byte CONSTRUCT_SIGNATURE = 83;
    public static final byte ACCESS_MODIFIER = 84;
    public static final byte NON_INDEXABLE = 85;
    public static final byte PARSE_RESULTS = 86;
    public static final byte GOOG_MODULE = 87;
    public static final byte GOOG_MODULE_REQUIRE = 88;
    public static final byte FEATURE_SET = 89;
    public static final byte IS_MODULE_NAME = 90;
    public static final byte WAS_PREVIOUSLY_PROVIDED = 91;
    public static final byte IS_ES6_CLASS = 92;
    public static final byte TRANSPILED = 93;
    public static final byte DELETED = 94;
    public static final byte GOOG_MODULE_ALIAS = 95;
    transient Token token;
    @Nullable
    transient Node next;
    @Nullable
    transient Node previous;
    @Nullable
    transient Node first;
    @Nullable
    private transient PropListItem propListHead;
    public static final int COLUMN_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    public static final int COLUMN_MASK = 4095;
    private transient int sourcePosition;
    private transient int length;
    @Nullable
    private transient TypeI typei;
    @Nullable
    protected transient Node parent;
    public static final int FLAG_GLOBAL_STATE_UNMODIFIED = 1;
    public static final int FLAG_THIS_UNMODIFIED = 2;
    public static final int FLAG_ARGUMENTS_UNMODIFIED = 4;
    public static final int FLAG_NO_THROWS = 8;
    public static final int FLAG_LOCAL_RESULTS = 16;
    public static final int SIDE_EFFECTS_FLAGS_MASK = 31;
    public static final int SIDE_EFFECTS_ALL = 0;
    public static final int NO_SIDE_EFFECTS = 15;

    private static final String propToString(byte propType) {
        switch (propType) {
            case 30: {
                return "var_args_name";
            }
            case 29: {
                return "jsdoc_info";
            }
            case 32: {
                return "incrdecr";
            }
            case 36: {
                return "quoted";
            }
            case 37: {
                return "opt_arg";
            }
            case 38: {
                return "synthetic";
            }
            case 39: {
                return "added_block";
            }
            case 40: {
                return "originalname";
            }
            case 42: {
                return "side_effect_flags";
            }
            case 43: {
                return "is_constant_name";
            }
            case 46: {
                return "is_namespace";
            }
            case 48: {
                return "directives";
            }
            case 49: {
                return "direct_eval";
            }
            case 50: {
                return "free_call";
            }
            case 51: {
                return "source_file";
            }
            case 53: {
                return "input_id";
            }
            case 54: {
                return "slash_v";
            }
            case 55: {
                return "inferred";
            }
            case 56: {
                return "change_time";
            }
            case 57: {
                return "reflected_object";
            }
            case 58: {
                return "static_member";
            }
            case 59: {
                return "generator_fn";
            }
            case 60: {
                return "arrow_fn";
            }
            case 61: {
                return "async_fn";
            }
            case 62: {
                return "yield_all";
            }
            case 63: {
                return "export_default";
            }
            case 64: {
                return "export_all_from";
            }
            case 65: {
                return "is_constant_var";
            }
            case 66: {
                return "is_generator_marker";
            }
            case 67: {
                return "is_generator_safe";
            }
            case 71: {
                return "raw_string_value";
            }
            case 72: {
                return "computed_prop_method";
            }
            case 73: {
                return "computed_prop_getter";
            }
            case 74: {
                return "computed_prop_setter";
            }
            case 75: {
                return "computed_prop_variable";
            }
            case 76: {
                return "analyzed_during_gti";
            }
            case 77: {
                return "constant_property_def";
            }
            case 78: {
                return "declared_type_expr";
            }
            case 79: {
                return "type_before_cast";
            }
            case 80: {
                return "opt_es6_typed";
            }
            case 81: {
                return "generic_type";
            }
            case 82: {
                return "implements";
            }
            case 83: {
                return "construct_signature";
            }
            case 84: {
                return "access_modifier";
            }
            case 85: {
                return "non_indexable";
            }
            case 86: {
                return "parse_results";
            }
            case 87: {
                return "goog_module";
            }
            case 88: {
                return "goog_module_require";
            }
            case 89: {
                return "feature_set";
            }
            case 90: {
                return "is_module_name";
            }
            case 91: {
                return "was_previously_provided";
            }
            case 92: {
                return "is_es6_class";
            }
            case 93: {
                return "transpiled";
            }
            case 94: {
                return "DELETED";
            }
            case 95: {
                return "goog_module_alias";
            }
        }
        throw new IllegalStateException("unexpected prop id " + propType);
    }

    public Node(Token nodeType) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (Object)"new child has existing parent");
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0, (Object)"new child has existing next sibling");
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0, (Object)"new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = child;
        child.next = null;
        child.previous = this.first;
        child.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0, (Object)"first new child has existing parent");
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0, (Object)"first new child has existing next sibling");
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0, (Object)"first new child has existing previous sibling");
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0, (Object)"second new child has existing parent");
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0, (Object)"second new child has existing next sibling");
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0, (Object)"second new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = right;
        left.previous = right;
        left.parent = this;
        right.next = null;
        right.previous = left;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node mid, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = right;
        mid.previous = left;
        mid.parent = this;
        right.next = null;
        right.previous = mid;
        right.parent = this;
        this.sourcePosition = -1;
    }

    Node(Token nodeType, Node left, Node mid, Node mid2, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = mid2;
        mid.previous = left;
        mid.parent = this;
        mid2.next = right;
        mid2.previous = mid;
        mid2.parent = this;
        right.next = null;
        right.previous = mid2;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, int lineno, int charno) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(Token nodeType, Node child, int lineno, int charno) {
        this(nodeType, child);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newNumber(double number, int lineno, int charno) {
        return new NumberNode(number, lineno, charno);
    }

    public static Node newString(String str) {
        return new StringNode(Token.STRING, str);
    }

    public static Node newString(Token token, String str) {
        return new StringNode(token, str);
    }

    public static Node newString(String str, int lineno, int charno) {
        return new StringNode(Token.STRING, str, lineno, charno);
    }

    public static Node newString(Token token, String str, int lineno, int charno) {
        return new StringNode(token, str, lineno, charno);
    }

    public final Token getToken() {
        return this.token;
    }

    public final void setToken(Token token) {
        this.token = token;
    }

    public final boolean hasChildren() {
        return this.first != null;
    }

    @Nullable
    public final Node getFirstChild() {
        return this.first;
    }

    @Nullable
    public final Node getFirstFirstChild() {
        return this.first.first;
    }

    @Nullable
    public final Node getSecondChild() {
        return this.first.next;
    }

    @Nullable
    public final Node getLastChild() {
        return this.first != null ? this.first.previous : null;
    }

    @Nullable
    public final Node getNext() {
        return this.next;
    }

    @Nullable
    public final Node getPrevious() {
        return this == this.parent.first ? null : this.previous;
    }

    @Nullable
    private final Node getPrevious(@Nullable Node firstSibling) {
        return this == firstSibling ? null : this.previous;
    }

    @Nullable
    public final Node getChildBefore(Node child) {
        return child.getPrevious(this.first);
    }

    public final Node getChildAtIndex(int i) {
        Node n = this.first;
        while (i > 0) {
            n = n.next;
            --i;
        }
        return n;
    }

    public final int getIndexOfChild(Node child) {
        Node n = this.first;
        int i = 0;
        while (n != null) {
            if (child == n) {
                return i;
            }
            n = n.next;
            ++i;
        }
        return -1;
    }

    public final void addChildToFront(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        child.parent = this;
        child.next = this.first;
        if (this.first == null) {
            child.previous = child;
        } else {
            Node last;
            child.previous = last = this.first.previous;
            child.next = this.first;
            this.first.previous = child;
        }
        this.first = child;
    }

    public final void addChildToBack(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (String)"Cannot add already-owned child node.\nChild: %s\nExisting parent: %s\nNew parent: %s", (Object)child, (Object)this.parent, (Object)this);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        if (this.first == null) {
            child.previous = child;
            this.first = child;
        } else {
            Node last = this.first.previous;
            last.next = child;
            child.previous = last;
            this.first.previous = child;
        }
        child.parent = this;
    }

    public final void addChildrenToFront(Node children) {
        if (children == null) {
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSib = children.previous;
        if (this.first != null) {
            Node last;
            children.previous = last = this.first.previous;
            lastSib.next = this.first;
            this.first.previous = lastSib;
        }
        this.first = children;
    }

    public final void addChildrenToBack(Node children) {
        this.addChildrenAfter(children, this.getLastChild());
    }

    public final void addChildBefore(Node newChild, Node node) {
        Preconditions.checkArgument((node.parent == this ? 1 : 0) != 0, (Object)"The existing child node of the parent should not be null.");
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        if (this.first == node) {
            Node last = this.first.previous;
            newChild.parent = this;
            newChild.next = this.first;
            newChild.previous = last;
            this.first.previous = newChild;
            this.first = newChild;
        } else {
            this.addChildAfter(newChild, node.previous);
        }
    }

    public final void addChildAfter(Node newChild, Node node) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        newChild.previous = newChild;
        this.addChildrenAfter(newChild, node);
    }

    public final void addChildrenAfter(@Nullable Node children, @Nullable Node node) {
        Node nodeAfter;
        if (children == null) {
            return;
        }
        Preconditions.checkArgument((node == null || node.parent == this ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)children.previous);
        if (node == null) {
            this.addChildrenToFront(children);
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSibling = children.previous;
        lastSibling.next = nodeAfter = node.next;
        if (nodeAfter == null) {
            this.first.previous = lastSibling;
        } else {
            nodeAfter.previous = lastSibling;
        }
        node.next = children;
        children.previous = node;
    }

    public final void removeChild(Node child) {
        Preconditions.checkState((child.parent == this ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)child.previous);
        Node last = this.first.previous;
        Node prevSibling = child.previous;
        Node nextSibling = child.next;
        if (this.first == child) {
            this.first = nextSibling;
            if (nextSibling != null) {
                nextSibling.previous = last;
            }
        } else if (child == last) {
            this.first.previous = prevSibling;
            prevSibling.next = null;
        } else {
            prevSibling.next = nextSibling;
            nextSibling.previous = prevSibling;
        }
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public final void replaceWith(Node newNode) {
        this.parent.replaceChild(this, newNode);
    }

    public final void replaceChild(Node child, Node newChild) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        Preconditions.checkState((child.parent == this ? 1 : 0) != 0, (String)"", (Object)child, (Object)this.parent);
        newChild.useSourceInfoIfMissingFrom(child);
        newChild.parent = this;
        Node nextSibling = child.next;
        Node prevSibling = child.previous;
        Node last = this.first.previous;
        if (child == prevSibling) {
            this.first = newChild;
            this.first.previous = newChild;
        } else {
            if (child == this.first) {
                this.first = newChild;
            } else {
                prevSibling.next = newChild;
            }
            if (child == last) {
                this.first.previous = newChild;
            } else {
                nextSibling.previous = newChild;
            }
            newChild.previous = prevSibling;
        }
        newChild.next = nextSibling;
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public final void replaceChildAfter(Node prevChild, Node newChild) {
        Preconditions.checkNotNull((Object)prevChild.next, (Object)"prev doesn't have a sibling to replace.");
        this.replaceChild(prevChild.next, newChild);
    }

    public final void replaceFirstOrChildAfter(@Nullable Node prev, Node newChild) {
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"prev doesn't have a sibling to replace.");
        this.replaceChild(target, newChild);
    }

    @Nullable
    @VisibleForTesting
    final PropListItem lookupProperty(byte propType) {
        PropListItem x = this.propListHead;
        while (x != null && propType != x.propType) {
            x = x.next;
        }
        return x;
    }

    public final Node clonePropsFrom(Node other) {
        Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)"Node has existing properties.");
        this.propListHead = other.propListHead;
        return this;
    }

    public final void removeProp(byte propType) {
        PropListItem result = this.removeProp(this.propListHead, propType);
        if (result != this.propListHead) {
            this.propListHead = result;
        }
    }

    public final boolean hasProps() {
        return this.propListHead != null;
    }

    @Nullable
    private final PropListItem removeProp(@Nullable PropListItem item, byte propType) {
        if (item == null) {
            return null;
        }
        if (item.propType == propType) {
            return item.next;
        }
        PropListItem result = this.removeProp(item.next, propType);
        if (result != item.next) {
            return item.chain(result);
        }
        return item;
    }

    @Nullable
    public final Object getProp(byte propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.getObjectValue();
    }

    public final boolean getBooleanProp(byte propType) {
        return this.getIntProp(propType) != 0;
    }

    public final int getIntProp(byte propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return 0;
        }
        return item.getIntValue();
    }

    public final int getExistingIntProp(byte propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            throw new IllegalStateException("missing prop: " + propType);
        }
        return item.getIntValue();
    }

    public final void putProp(byte propType, @Nullable Object value) {
        this.removeProp(propType);
        if (value != null) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public final void putBooleanProp(byte propType, boolean value) {
        this.putIntProp(propType, value ? 1 : 0);
    }

    public final void putIntProp(byte propType, int value) {
        this.removeProp(propType);
        if (value != 0) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public final void setDeclaredTypeExpression(TypeDeclarationNode typeExpression) {
        this.putProp((byte)78, typeExpression);
    }

    @Nullable
    public final TypeDeclarationNode getDeclaredTypeExpression() {
        return (TypeDeclarationNode)this.getProp((byte)78);
    }

    final PropListItem createProp(byte propType, Object value, @Nullable PropListItem next) {
        return new ObjectPropListItem(propType, value, next);
    }

    final PropListItem createProp(byte propType, int value, @Nullable PropListItem next) {
        return new IntPropListItem(propType, value, next);
    }

    @Nullable
    public final JSType getJSTypeBeforeCast() {
        return (JSType)this.getTypeIBeforeCast();
    }

    @Nullable
    public final TypeI getTypeIBeforeCast() {
        return (TypeI)this.getProp((byte)79);
    }

    private byte[] getSortedPropTypes() {
        int count = 0;
        PropListItem x = this.propListHead;
        while (x != null) {
            ++count;
            x = x.next;
        }
        byte[] keys = new byte[count];
        PropListItem x2 = this.propListHead;
        while (x2 != null) {
            keys[--count] = x2.propType;
            x2 = x2.next;
        }
        Arrays.sort(keys);
        return keys;
    }

    public double getDouble() {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public void setDouble(double value) {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getString() {
        if (this.token == Token.STRING) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String value) {
        if (this.token == Token.STRING || this.token == Token.NAME) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public final String toString() {
        return this.toString(true, true, true);
    }

    public final String toString(boolean printSource, boolean printAnnotations, boolean printType) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, printSource, printAnnotations, printType);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printSource, boolean printAnnotations, boolean printType) {
        String typeString;
        sb.append((Object)this.token);
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else if (this.token == Token.FUNCTION) {
            sb.append(' ');
            if (this.first == null || this.first.token != Token.NAME) {
                sb.append("<invalid>");
            } else {
                sb.append(this.first.getString());
            }
        } else if (this.token == Token.NUMBER) {
            sb.append(' ');
            sb.append(this.getDouble());
        }
        if (printSource) {
            int lineno = this.getLineno();
            if (lineno != -1) {
                sb.append(' ');
                sb.append(lineno);
            }
            if (this.length != 0) {
                sb.append(" [length: ");
                sb.append(this.length);
                sb.append(']');
            }
        }
        if (printAnnotations) {
            byte[] keys = this.getSortedPropTypes();
            for (int i = 0; i < keys.length; ++i) {
                byte type = keys[i];
                PropListItem x = this.lookupProperty(type);
                sb.append(" [");
                sb.append(Node.propToString(type));
                sb.append(": ");
                sb.append(x);
                sb.append(']');
            }
        }
        if (printType && this.typei != null && (typeString = this.typei.toString()) != null) {
            sb.append(" : ");
            sb.append(typeString);
        }
    }

    @CheckReturnValue
    public final String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder s = new StringBuilder();
            this.appendStringTree(s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    public final void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node n, int level, Appendable sb) throws IOException {
        for (int i = 0; i != level; ++i) {
            sb.append("    ");
        }
        sb.append(n.toString());
        sb.append('\n');
        Node cursor = n.first;
        while (cursor != null) {
            Node.toStringTreeHelper(cursor, level + 1, sb);
            cursor = cursor.next;
        }
    }

    public final void setStaticSourceFileFrom(Node other) {
        if (other.propListHead != null && (this.propListHead == null || this.propListHead.propType == 51 && this.propListHead.next == null)) {
            PropListItem tail = other.propListHead;
            while (tail.next != null) {
                tail = tail.next;
            }
            if (tail.propType == 51) {
                this.propListHead = tail;
                return;
            }
        }
        this.setStaticSourceFile(other.getStaticSourceFile());
    }

    public final void setStaticSourceFile(@Nullable StaticSourceFile file) {
        this.putProp((byte)51, file);
    }

    public final void setSourceFileForTesting(String name) {
        this.putProp((byte)51, new SimpleSourceFile(name, false));
    }

    @Nullable
    public String getSourceFileName() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public StaticSourceFile getStaticSourceFile() {
        return (StaticSourceFile)this.getProp((byte)51);
    }

    public void setInputId(InputId inputId) {
        this.putProp((byte)53, inputId);
    }

    @Nullable
    public InputId getInputId() {
        return (InputId)this.getProp((byte)53);
    }

    @Nullable
    public String getOriginalName() {
        return (String)this.getProp((byte)40);
    }

    public void setOriginalName(String originalName) {
        this.putProp((byte)40, originalName);
    }

    public final boolean isIndexable() {
        return !this.getBooleanProp((byte)85);
    }

    public final void makeNonIndexable() {
        this.putBooleanProp((byte)85, true);
    }

    public final boolean isFromExterns() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? false : file.isExtern();
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public final int getLineno() {
        return Node.extractLineno(this.sourcePosition);
    }

    public final int getCharno() {
        return Node.extractCharno(this.sourcePosition);
    }

    public int getSourceOffset() {
        StaticSourceFile file = this.getStaticSourceFile();
        if (file == null) {
            return -1;
        }
        int lineno = this.getLineno();
        if (lineno == -1) {
            return -1;
        }
        return file.getLineOffset(lineno) + this.getCharno();
    }

    public final int getSourcePosition() {
        return this.sourcePosition;
    }

    public final void setLineno(int lineno) {
        int charno = this.getCharno();
        if (charno == -1) {
            charno = 0;
        }
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public final void setCharno(int charno) {
        this.sourcePosition = Node.mergeLineCharNo(this.getLineno(), charno);
    }

    public final void setSourceEncodedPosition(int sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public final void setSourceEncodedPositionForTree(int sourcePosition) {
        this.sourcePosition = sourcePosition;
        Node child = this.first;
        while (child != null) {
            child.setSourceEncodedPositionForTree(sourcePosition);
            child = child.next;
        }
    }

    protected static int mergeLineCharNo(int lineno, int charno) {
        if (lineno < 0 || charno < 0) {
            return -1;
        }
        if ((charno & 0xFFFFF000) != 0) {
            return lineno << 12 | 0xFFF;
        }
        return lineno << 12 | charno & 0xFFF;
    }

    protected static int extractLineno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo >>> 12;
    }

    protected static int extractCharno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo & 0xFFF;
    }

    public final Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    public final Iterable<Node> siblings() {
        return new SiblingNodeIterable(this);
    }

    @Nullable
    final PropListItem getPropListHeadForTesting() {
        return this.propListHead;
    }

    final void setPropListHead(@Nullable PropListItem propListHead) {
        this.propListHead = propListHead;
    }

    @Nullable
    public final Node getParent() {
        return this.parent;
    }

    @Nullable
    public final Node getGrandparent() {
        return this.parent == null ? null : this.parent.parent;
    }

    @Nullable
    public final Node getAncestor(int level) {
        Node node;
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        for (node = this; node != null && level-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public final boolean isDescendantOf(Node node) {
        Node n = this;
        while (n != null) {
            if (n == node) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    public final AncestorIterable getAncestors() {
        return new AncestorIterable((Node)Preconditions.checkNotNull((Object)this.getParent()));
    }

    public final boolean hasOneChild() {
        return this.first != null && this.first.next == null;
    }

    public final boolean hasTwoChildren() {
        return this.first != null && this.first.next != null && this.first.next == this.getLastChild();
    }

    public final boolean hasZeroOrOneChild() {
        return this.first == this.getLastChild();
    }

    public final boolean hasMoreThanOneChild() {
        return this.first != null && this.first.next != null;
    }

    public final boolean hasXChildren(int x) {
        int c;
        Node n = this.first;
        for (c = 0; n != null && c <= x; ++c) {
            n = n.next;
        }
        return c == x;
    }

    public final int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public final boolean hasChild(Node child) {
        Node n = this.first;
        while (n != null) {
            if (child == n) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    public final String checkTreeEquals(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual);
        if (diff != null) {
            return "Node tree inequality:\nTree1:\n" + this.toStringTree() + "\n\nTree2:\n" + actual.toStringTree() + "\n\nSubtree1: " + diff.nodeExpected.toStringTree() + "\n\nSubtree2: " + diff.nodeActual.toStringTree();
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    public final String checkTreeEqualsIncludingJsDoc(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual, true);
        if (diff != null) {
            if (diff.nodeActual.isEquivalentTo(diff.nodeExpected, false, true, false)) {
                String jsDocActual = diff.nodeActual.getJSDocInfo() == null ? "(none)" : diff.nodeActual.getJSDocInfo().toStringVerbose();
                String jsDocExpected = diff.nodeExpected.getJSDocInfo() == null ? "(none)" : diff.nodeExpected.getJSDocInfo().toStringVerbose();
                return "Node tree inequality:\nTree:\n" + this.toStringTree() + "\n\nJSDoc differs on subtree: " + diff.nodeExpected + "\nExpected JSDoc: " + jsDocExpected + "\nActual JSDoc  : " + jsDocActual;
            }
            return "Node tree inequality:\nExpected tree:\n" + this.toStringTree() + "\n\nActual tree:\n" + actual.toStringTree() + "\n\nExpected subtree: " + diff.nodeExpected.toStringTree() + "\n\nActual subtree: " + diff.nodeActual.toStringTree();
        }
        return null;
    }

    @Nullable
    final NodeMismatch checkTreeEqualsImpl(Node actual) {
        return this.checkTreeEqualsImpl(actual, false);
    }

    @Nullable
    private NodeMismatch checkTreeEqualsImpl(Node actual, boolean jsDoc) {
        if (!this.isEquivalentTo(actual, false, false, jsDoc)) {
            return new NodeMismatch(this, actual);
        }
        Node expectedChild = this.first;
        Node actualChild = actual.first;
        while (expectedChild != null) {
            NodeMismatch res = expectedChild.checkTreeEqualsImpl(actualChild, jsDoc);
            if (res != null) {
                return res;
            }
            expectedChild = expectedChild.next;
            actualChild = actualChild.next;
        }
        return null;
    }

    public final boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, false);
    }

    public final boolean isEquivalentToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, false);
    }

    public final boolean isEquivalentWithSideEffectsTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, true);
    }

    public final boolean isEquivalentWithSideEffectsToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, true);
    }

    public final boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true, true, false);
    }

    final boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc) {
        return this.isEquivalentTo(node, compareType, recurse, jsDoc, false);
    }

    public boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc, boolean sideEffect) {
        if (this.token != node.token || this.getChildCount() != node.getChildCount() || this.getClass() != node.getClass()) {
            return false;
        }
        if (compareType && !JSType.isEquivalent(this.getJSType(), node.getJSType())) {
            return false;
        }
        if (jsDoc && !JSDocInfo.areEquivalent(this.getJSDocInfo(), node.getJSDocInfo())) {
            return false;
        }
        TypeDeclarationNode thisTDN = this.getDeclaredTypeExpression();
        TypeDeclarationNode thatTDN = node.getDeclaredTypeExpression();
        if (!(thisTDN == null && thatTDN == null || thisTDN != null && thatTDN != null && thisTDN.isEquivalentTo(thatTDN, compareType, recurse, jsDoc))) {
            return false;
        }
        if (this.token == Token.INC || this.token == Token.DEC) {
            int post2;
            int post1 = this.getIntProp((byte)32);
            if (post1 != (post2 = node.getIntProp((byte)32))) {
                return false;
            }
        } else if (this.token == Token.STRING || this.token == Token.STRING_KEY) {
            int slashV2;
            int quoted2;
            int quoted1;
            if (this.token == Token.STRING_KEY && (quoted1 = this.getIntProp((byte)36)) != (quoted2 = node.getIntProp((byte)36))) {
                return false;
            }
            int slashV1 = this.getIntProp((byte)54);
            if (slashV1 != (slashV2 = node.getIntProp((byte)54))) {
                return false;
            }
        } else if (this.token == Token.CALL ? this.getBooleanProp((byte)50) != node.getBooleanProp((byte)50) : this.token == Token.FUNCTION && this.isArrowFunction() != node.isArrowFunction()) {
            return false;
        }
        if (sideEffect && this.getSideEffectFlags() != node.getSideEffectFlags()) {
            return false;
        }
        if (recurse) {
            Node n = this.first;
            Node n2 = node.first;
            while (n != null) {
                if (!n.isEquivalentTo(n2, compareType, recurse, jsDoc, sideEffect)) {
                    return false;
                }
                n = n.next;
                n2 = n2.next;
            }
        }
        return true;
    }

    @Nullable
    public final String getQualifiedName() {
        switch (this.token) {
            case NAME: {
                String name = this.getString();
                return name.isEmpty() ? null : name;
            }
            case GETPROP: {
                StringBuilder builder = this.getQualifiedNameForGetProp(0);
                return builder != null ? builder.toString() : null;
            }
            case THIS: {
                return "this";
            }
            case SUPER: {
                return "super";
            }
        }
        return null;
    }

    @Nullable
    private StringBuilder getQualifiedNameForGetProp(int reserve) {
        StringBuilder builder;
        String propName = this.getLastChild().getString();
        reserve += 1 + propName.length();
        if (this.first.isGetProp()) {
            builder = this.first.getQualifiedNameForGetProp(reserve);
            if (builder == null) {
                return null;
            }
        } else {
            String left = this.first.getQualifiedName();
            if (left == null) {
                return null;
            }
            builder = new StringBuilder(left.length() + reserve);
            builder.append(left);
        }
        builder.append('.').append(propName);
        return builder;
    }

    @Nullable
    public final String getOriginalQualifiedName() {
        if (this.token == Token.NAME || this.getBooleanProp((byte)90)) {
            String name = this.getOriginalName();
            if (name == null) {
                name = this.getString();
            }
            return name.isEmpty() ? null : name;
        }
        if (this.token == Token.GETPROP) {
            String left = this.getFirstChild().getOriginalQualifiedName();
            if (left == null) {
                return null;
            }
            String right = this.getLastChild().getOriginalName();
            if (right == null) {
                right = this.getLastChild().getString();
            }
            return left + "." + right;
        }
        if (this.token == Token.THIS) {
            return "this";
        }
        if (this.token == Token.SUPER) {
            return "super";
        }
        return null;
    }

    public final boolean isQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public final boolean matchesQualifiedName(String name) {
        return name != null && this.matchesQualifiedName(name, name.length());
    }

    private boolean matchesQualifiedName(String qname, int endIndex) {
        int start = qname.lastIndexOf(46, endIndex - 1) + 1;
        switch (this.getToken()) {
            case NAME: 
            case MEMBER_FUNCTION_DEF: {
                String name = this.getString();
                return start == 0 && !name.isEmpty() && name.length() == endIndex && qname.startsWith(name);
            }
            case THIS: {
                return start == 0 && 4 == endIndex && qname.startsWith("this");
            }
            case SUPER: {
                return start == 0 && 5 == endIndex && qname.startsWith("super");
            }
            case GETPROP: {
                String prop = this.getLastChild().getString();
                return start > 1 && prop.length() == endIndex - start && prop.regionMatches(0, qname, start, endIndex - start) && this.getFirstChild().matchesQualifiedName(qname, start - 1);
            }
        }
        return false;
    }

    public final boolean matchesQualifiedName(Node n) {
        if (n == null || n.token != this.token) {
            return false;
        }
        switch (this.token) {
            case NAME: {
                return !this.getString().isEmpty() && this.getString().equals(n.getString());
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getLastChild().getString().equals(n.getLastChild().getString()) && this.getFirstChild().matchesQualifiedName(n.getFirstChild());
            }
        }
        return false;
    }

    public final boolean isUnscopedQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case GETPROP: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public final boolean isValidAssignmentTarget() {
        switch (this.getToken()) {
            case NAME: 
            case GETPROP: 
            case GETELEM: 
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return true;
            }
        }
        return false;
    }

    public final Node detachFromParent() {
        return this.detach();
    }

    public final Node detach() {
        Preconditions.checkNotNull((Object)this.parent);
        this.parent.removeChild(this);
        return this;
    }

    @Nullable
    public final Node removeFirstChild() {
        Node child = this.first;
        if (child != null) {
            this.removeChild(child);
        }
        return child;
    }

    @Nullable
    public final Node removeChildren() {
        Node children = this.first;
        Node child = this.first;
        while (child != null) {
            child.parent = null;
            child = child.next;
        }
        this.first = null;
        return children;
    }

    public final void detachChildren() {
        Node child = this.first;
        while (child != null) {
            Node nextChild = child.next;
            child.parent = null;
            child.next = null;
            child.previous = null;
            child = nextChild;
        }
        this.first = null;
    }

    public final Node removeChildAfter(Node prev) {
        Node target = prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"no next sibling.");
        this.removeChild(target);
        return target;
    }

    public final Node removeFirstOrChildAfter(@Nullable Node prev) {
        Preconditions.checkArgument((prev == null || prev.parent == this ? 1 : 0) != 0, (Object)"invalid node.");
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"no next sibling.");
        this.removeChild(target);
        return target;
    }

    public final Node cloneNode() {
        return this.cloneNode(false);
    }

    protected Node cloneNode(boolean cloneTypeExprs) {
        return this.copyNodeFields(new Node(this.token), cloneTypeExprs);
    }

    final <T extends Node> T copyNodeFields(T dst, boolean cloneTypeExprs) {
        JSDocInfo info;
        dst.setSourceEncodedPosition(this.sourcePosition);
        dst.setLength(this.getLength());
        dst.setTypeI(this.typei);
        dst.setPropListHead(this.propListHead);
        if (cloneTypeExprs && (info = this.getJSDocInfo()) != null) {
            this.setJSDocInfo(info.clone(true));
        }
        return dst;
    }

    public final Node cloneTree() {
        return this.cloneTree(false);
    }

    public final Node cloneTree(boolean cloneTypeExprs) {
        Node result = this.cloneNode(cloneTypeExprs);
        Node firstChild = null;
        Node lastChild = null;
        if (this.hasChildren()) {
            Node n2 = this.getFirstChild();
            while (n2 != null) {
                Node n2clone = n2.cloneTree(cloneTypeExprs);
                n2clone.parent = result;
                if (firstChild == null) {
                    lastChild = firstChild = n2clone;
                } else {
                    lastChild.next = n2clone;
                    n2clone.previous = lastChild;
                    lastChild = n2clone;
                }
                n2 = n2.next;
            }
            firstChild.previous = lastChild;
            lastChild.next = null;
            result.first = firstChild;
        }
        return result;
    }

    @Deprecated
    public final Node useSourceInfoWithoutLengthIfMissingFrom(Node other) {
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFileFrom(other);
            this.sourcePosition = other.sourcePosition;
        }
        if (this.getProp((byte)40) == null) {
            this.putProp((byte)40, other.getProp((byte)40));
        }
        return this;
    }

    @Deprecated
    public final Node useSourceInfoWithoutLengthIfMissingFromForTree(Node other) {
        this.useSourceInfoWithoutLengthIfMissingFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoWithoutLengthIfMissingFromForTree(other);
            child = child.next;
        }
        return this;
    }

    public final Node useSourceInfoFrom(Node other) {
        this.setStaticSourceFileFrom(other);
        this.putProp((byte)40, other.getProp((byte)40));
        this.sourcePosition = other.sourcePosition;
        this.length = other.length;
        return this;
    }

    public final Node srcref(Node other) {
        return this.useSourceInfoFrom(other);
    }

    public final Node useSourceInfoFromForTree(Node other) {
        this.useSourceInfoFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoFromForTree(other);
            child = child.next;
        }
        return this;
    }

    public final Node srcrefTree(Node other) {
        return this.useSourceInfoFromForTree(other);
    }

    public final Node useSourceInfoIfMissingFrom(Node other) {
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFileFrom(other);
            this.sourcePosition = other.sourcePosition;
            this.length = other.length;
        }
        if (this.getProp((byte)40) == null) {
            this.putProp((byte)40, other.getProp((byte)40));
        }
        return this;
    }

    public final Node useSourceInfoIfMissingFromForTree(Node other) {
        this.useSourceInfoIfMissingFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoIfMissingFromForTree(other);
            child = child.next;
        }
        return this;
    }

    @Nullable
    public JSType getJSType() {
        return this.typei instanceof JSType ? (JSType)this.typei : null;
    }

    public final void setJSType(@Nullable JSType jsType) {
        this.typei = jsType;
    }

    @Nullable
    public final TypeI getTypeI() {
        return this.typei;
    }

    public final void setTypeI(@Nullable TypeI type) {
        this.typei = type;
    }

    @Nullable
    public final TypeI getTypeIIfOld() {
        return this.typei instanceof JSType ? this.typei : null;
    }

    @Nullable
    public final JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp((byte)29);
    }

    public final Node setJSDocInfo(JSDocInfo info) {
        this.putProp((byte)29, info);
        return this;
    }

    public final void setChangeTime(int time) {
        this.putIntProp((byte)56, time);
    }

    public final int getChangeTime() {
        return this.getIntProp((byte)56);
    }

    public final void setDeleted(boolean deleted) {
        this.putBooleanProp((byte)94, deleted);
    }

    public final boolean isDeleted() {
        return this.getBooleanProp((byte)94);
    }

    public final void setVarArgs(boolean varArgs) {
        this.putBooleanProp((byte)30, varArgs);
    }

    public final boolean isVarArgs() {
        return this.getBooleanProp((byte)30);
    }

    public final void setOptionalArg(boolean optionalArg) {
        this.putBooleanProp((byte)37, optionalArg);
    }

    public final boolean isOptionalArg() {
        return this.getBooleanProp((byte)37);
    }

    public final boolean isOptionalEs6Typed() {
        return this.getBooleanProp((byte)80);
    }

    public final void setIsSyntheticBlock(boolean val) {
        Preconditions.checkState((this.token == Token.BLOCK ? 1 : 0) != 0);
        this.putBooleanProp((byte)38, val);
    }

    public final boolean isSyntheticBlock() {
        return this.getBooleanProp((byte)38);
    }

    public final void setDirectives(Set<String> val) {
        this.putProp((byte)48, val);
    }

    @Nullable
    public final Set<String> getDirectives() {
        return (Set)this.getProp((byte)48);
    }

    public final void setIsAddedBlock(boolean val) {
        this.putBooleanProp((byte)39, val);
    }

    public final boolean isAddedBlock() {
        return this.getBooleanProp((byte)39);
    }

    public final void setStaticMember(boolean isStatic) {
        this.putBooleanProp((byte)58, isStatic);
    }

    public final boolean isStaticMember() {
        return this.getBooleanProp((byte)58);
    }

    public final void setIsGeneratorFunction(boolean isGenerator) {
        this.putBooleanProp((byte)59, isGenerator);
    }

    public final boolean isGeneratorFunction() {
        return this.getBooleanProp((byte)59);
    }

    public final void setGeneratorMarker(boolean isGeneratorMarker) {
        this.putBooleanProp((byte)66, isGeneratorMarker);
    }

    public final boolean isGeneratorMarker() {
        return this.getBooleanProp((byte)66);
    }

    public final void setGeneratorSafe(boolean isGeneratorSafe) {
        this.putBooleanProp((byte)67, isGeneratorSafe);
    }

    public final boolean isGeneratorSafe() {
        return this.getBooleanProp((byte)67);
    }

    public final void setIsArrowFunction(boolean isArrow) {
        Preconditions.checkState((boolean)this.isFunction());
        this.putBooleanProp((byte)60, isArrow);
    }

    public final boolean isArrowFunction() {
        return this.isFunction() && this.getBooleanProp((byte)60);
    }

    public void setIsAsyncFunction(boolean isAsync) {
        Preconditions.checkState((boolean)this.isFunction());
        this.putBooleanProp((byte)61, isAsync);
    }

    public final boolean isAsyncFunction() {
        return this.isFunction() && this.getBooleanProp((byte)61);
    }

    public final void setYieldAll(boolean isGenerator) {
        this.putBooleanProp((byte)62, isGenerator);
    }

    public final boolean isYieldAll() {
        return this.getBooleanProp((byte)62);
    }

    public final void setSideEffectFlags(int flags) {
        Preconditions.checkArgument((this.isCall() || this.isNew() ? 1 : 0) != 0, (String)"setIsNoSideEffectsCall only supports CALL and NEW nodes, got %s", (Object)((Object)this.getToken()));
        this.putIntProp((byte)42, flags);
    }

    public final void setSideEffectFlags(SideEffectFlags flags) {
        this.setSideEffectFlags(flags.valueOf());
    }

    public final int getSideEffectFlags() {
        return this.getIntProp((byte)42);
    }

    public final boolean isOnlyModifiesThisCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 13);
    }

    public final boolean isOnlyModifiesArgumentsCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 11);
    }

    public final boolean isNoSideEffectsCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags(), 15);
    }

    public final boolean isLocalResultCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags(), 16);
    }

    public final boolean mayMutateArguments() {
        return !Node.areBitFlagsSet(this.getSideEffectFlags(), 4);
    }

    public final boolean mayMutateGlobalStateOrThrow() {
        return !Node.areBitFlagsSet(this.getSideEffectFlags(), 9);
    }

    private static boolean areBitFlagsSet(int value, int flags) {
        return (value & flags) == flags;
    }

    public boolean isQuotedString() {
        return false;
    }

    public void setQuotedString() {
        throw new IllegalStateException(this + " is not a StringNode");
    }

    public final boolean isAdd() {
        return this.token == Token.ADD;
    }

    public final boolean isSub() {
        return this.token == Token.SUB;
    }

    public final boolean isAnd() {
        return this.token == Token.AND;
    }

    public final boolean isArrayLit() {
        return this.token == Token.ARRAYLIT;
    }

    public final boolean isArrayPattern() {
        return this.token == Token.ARRAY_PATTERN;
    }

    public final boolean isAssign() {
        return this.token == Token.ASSIGN;
    }

    public final boolean isAssignAdd() {
        return this.token == Token.ASSIGN_ADD;
    }

    public final boolean isNormalBlock() {
        return this.token == Token.BLOCK;
    }

    public final boolean isRoot() {
        return this.token == Token.ROOT;
    }

    public final boolean isBreak() {
        return this.token == Token.BREAK;
    }

    public final boolean isCall() {
        return this.token == Token.CALL;
    }

    public final boolean isCase() {
        return this.token == Token.CASE;
    }

    public final boolean isCast() {
        return this.token == Token.CAST;
    }

    public final boolean isCatch() {
        return this.token == Token.CATCH;
    }

    public final boolean isClass() {
        return this.token == Token.CLASS;
    }

    public final boolean isClassMembers() {
        return this.token == Token.CLASS_MEMBERS;
    }

    public final boolean isComma() {
        return this.token == Token.COMMA;
    }

    public final boolean isComputedProp() {
        return this.token == Token.COMPUTED_PROP;
    }

    public final boolean isContinue() {
        return this.token == Token.CONTINUE;
    }

    public final boolean isConst() {
        return this.token == Token.CONST;
    }

    public final boolean isDebugger() {
        return this.token == Token.DEBUGGER;
    }

    public final boolean isDec() {
        return this.token == Token.DEC;
    }

    public final boolean isDefaultCase() {
        return this.token == Token.DEFAULT_CASE;
    }

    public final boolean isDefaultValue() {
        return this.token == Token.DEFAULT_VALUE;
    }

    public final boolean isDelProp() {
        return this.token == Token.DELPROP;
    }

    public final boolean isDestructuringLhs() {
        return this.token == Token.DESTRUCTURING_LHS;
    }

    public final boolean isDestructuringPattern() {
        return this.isObjectPattern() || this.isArrayPattern();
    }

    public final boolean isDo() {
        return this.token == Token.DO;
    }

    public final boolean isEmpty() {
        return this.token == Token.EMPTY;
    }

    public final boolean isExport() {
        return this.token == Token.EXPORT;
    }

    public final boolean isExportSpec() {
        return this.token == Token.EXPORT_SPEC;
    }

    public final boolean isExprResult() {
        return this.token == Token.EXPR_RESULT;
    }

    public final boolean isFalse() {
        return this.token == Token.FALSE;
    }

    @Deprecated
    public final boolean isFor() {
        return this.isVanillaFor() || this.isForIn();
    }

    public final boolean isVanillaFor() {
        return this.token == Token.FOR;
    }

    public final boolean isForIn() {
        return this.token == Token.FOR_IN;
    }

    public final boolean isForOf() {
        return this.token == Token.FOR_OF;
    }

    public final boolean isFunction() {
        return this.token == Token.FUNCTION;
    }

    public final boolean isGetterDef() {
        return this.token == Token.GETTER_DEF;
    }

    public final boolean isGetElem() {
        return this.token == Token.GETELEM;
    }

    public final boolean isGetProp() {
        return this.token == Token.GETPROP;
    }

    public final boolean isHook() {
        return this.token == Token.HOOK;
    }

    public final boolean isIf() {
        return this.token == Token.IF;
    }

    public final boolean isImport() {
        return this.token == Token.IMPORT;
    }

    public final boolean isImportStar() {
        return this.token == Token.IMPORT_STAR;
    }

    public final boolean isImportSpec() {
        return this.token == Token.IMPORT_SPEC;
    }

    public final boolean isImportSpecs() {
        return this.token == Token.IMPORT_SPECS;
    }

    public final boolean isIn() {
        return this.token == Token.IN;
    }

    public final boolean isInc() {
        return this.token == Token.INC;
    }

    public final boolean isInstanceOf() {
        return this.token == Token.INSTANCEOF;
    }

    public final boolean isInterfaceMembers() {
        return this.token == Token.INTERFACE_MEMBERS;
    }

    public final boolean isRecordType() {
        return this.token == Token.RECORD_TYPE;
    }

    public final boolean isCallSignature() {
        return this.token == Token.CALL_SIGNATURE;
    }

    public final boolean isIndexSignature() {
        return this.token == Token.INDEX_SIGNATURE;
    }

    public final boolean isLabel() {
        return this.token == Token.LABEL;
    }

    public final boolean isLabelName() {
        return this.token == Token.LABEL_NAME;
    }

    public final boolean isLet() {
        return this.token == Token.LET;
    }

    public final boolean isMemberFunctionDef() {
        return this.token == Token.MEMBER_FUNCTION_DEF;
    }

    public final boolean isMemberVariableDef() {
        return this.token == Token.MEMBER_VARIABLE_DEF;
    }

    public final boolean isModuleBody() {
        return this.token == Token.MODULE_BODY;
    }

    public final boolean isName() {
        return this.token == Token.NAME;
    }

    public final boolean isNE() {
        return this.token == Token.NE;
    }

    public final boolean isNew() {
        return this.token == Token.NEW;
    }

    public final boolean isNot() {
        return this.token == Token.NOT;
    }

    public final boolean isNull() {
        return this.token == Token.NULL;
    }

    public final boolean isNumber() {
        return this.token == Token.NUMBER;
    }

    public final boolean isObjectLit() {
        return this.token == Token.OBJECTLIT;
    }

    public final boolean isObjectPattern() {
        return this.token == Token.OBJECT_PATTERN;
    }

    public final boolean isOr() {
        return this.token == Token.OR;
    }

    public final boolean isParamList() {
        return this.token == Token.PARAM_LIST;
    }

    public final boolean isRegExp() {
        return this.token == Token.REGEXP;
    }

    public final boolean isRest() {
        return this.token == Token.REST;
    }

    public final boolean isReturn() {
        return this.token == Token.RETURN;
    }

    public final boolean isScript() {
        return this.token == Token.SCRIPT;
    }

    public final boolean isSetterDef() {
        return this.token == Token.SETTER_DEF;
    }

    public final boolean isSpread() {
        return this.token == Token.SPREAD;
    }

    public final boolean isString() {
        return this.token == Token.STRING;
    }

    public final boolean isStringKey() {
        return this.token == Token.STRING_KEY;
    }

    public final boolean isSuper() {
        return this.token == Token.SUPER;
    }

    public final boolean isSwitch() {
        return this.token == Token.SWITCH;
    }

    public final boolean isTaggedTemplateLit() {
        return this.token == Token.TAGGED_TEMPLATELIT;
    }

    public final boolean isTemplateLit() {
        return this.token == Token.TEMPLATELIT;
    }

    public final boolean isTemplateLitSub() {
        return this.token == Token.TEMPLATELIT_SUB;
    }

    public final boolean isThis() {
        return this.token == Token.THIS;
    }

    public final boolean isThrow() {
        return this.token == Token.THROW;
    }

    public final boolean isTrue() {
        return this.token == Token.TRUE;
    }

    public final boolean isTry() {
        return this.token == Token.TRY;
    }

    public final boolean isTypeOf() {
        return this.token == Token.TYPEOF;
    }

    public final boolean isVar() {
        return this.token == Token.VAR;
    }

    public final boolean isVoid() {
        return this.token == Token.VOID;
    }

    public final boolean isWhile() {
        return this.token == Token.WHILE;
    }

    public final boolean isWith() {
        return this.token == Token.WITH;
    }

    public final boolean isYield() {
        return this.token == Token.YIELD;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void writeObject(ObjectOutputStream out) throws Exception {
        Preconditions.checkState((Token.values().length < 255 ? 1 : 0) != 0);
        out.writeByte(this.token.ordinal());
        this.writeEncodedInt(out, this.sourcePosition);
        this.writeEncodedInt(out, this.length);
        Node currentChild = this.first;
        while (currentChild != null) {
            out.writeObject(currentChild);
            currentChild = currentChild.next;
        }
        out.writeObject(null);
        out.writeObject(this.typei);
        out.writeObject(this.propListHead);
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        this.token = Token.values()[in.readUnsignedByte()];
        this.sourcePosition = this.readEncodedInt(in);
        this.length = this.readEncodedInt(in);
        this.first = (Node)in.readObject();
        if (this.first != null) {
            Node currentChild;
            Preconditions.checkState((this.first.parent == null ? 1 : 0) != 0);
            this.first.parent = this;
            Node lastChild = this.first;
            while ((currentChild = (Node)in.readObject()) != null) {
                Preconditions.checkState((currentChild.parent == null ? 1 : 0) != 0);
                currentChild.parent = this;
                Preconditions.checkState((currentChild.previous == null ? 1 : 0) != 0);
                currentChild.previous = lastChild;
                Preconditions.checkState((lastChild.next == null ? 1 : 0) != 0);
                lastChild.next = currentChild;
                lastChild = currentChild;
            }
            Preconditions.checkState((this.first.previous == null ? 1 : 0) != 0);
            this.first.previous = lastChild;
        }
        this.typei = (TypeI)in.readObject();
        this.propListHead = (PropListItem)in.readObject();
    }

    @GwtIncompatible(value="ObjectOutput")
    private void writeEncodedInt(ObjectOutput out, int value) throws IOException {
        while (value > 127 || value < 0) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value);
    }

    @GwtIncompatible(value="ObjectInput")
    private int readEncodedInt(ObjectInput in) throws IOException {
        byte current;
        int value = 0;
        int shift = 0;
        while ((current = in.readByte()) < 0) {
            value |= (current & 0x7F) << shift;
            shift += 7;
        }
        return value |= current << shift;
    }

    static final class NodeMismatch {
        final Node nodeExpected;
        final Node nodeActual;

        NodeMismatch(Node nodeExpected, Node nodeActual) {
            this.nodeExpected = nodeExpected;
            this.nodeActual = nodeActual;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof NodeMismatch) {
                NodeMismatch that = (NodeMismatch)object;
                return that.nodeExpected.equals(this.nodeExpected) && that.nodeActual.equals(this.nodeActual);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.nodeExpected, this.nodeActual});
        }
    }

    public static final class SideEffectFlags {
        private int value = 0;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int value) {
            this.value = value;
        }

        public int valueOf() {
            return this.value;
        }

        public SideEffectFlags setAllFlags() {
            this.value = 0;
            return this;
        }

        public SideEffectFlags clearAllFlags() {
            this.value = 31;
            return this;
        }

        public void clearSideEffectFlags() {
            this.value |= 0xF;
        }

        public SideEffectFlags setMutatesGlobalState() {
            this.removeFlag(1);
            this.removeFlag(4);
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setThrows() {
            this.removeFlag(8);
            return this;
        }

        public SideEffectFlags setMutatesThis() {
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setMutatesArguments() {
            this.removeFlag(4);
            return this;
        }

        public SideEffectFlags setReturnsTainted() {
            this.removeFlag(16);
            return this;
        }

        private void removeFlag(int flag) {
            this.value &= ~flag;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Side effects: ");
            if ((this.value & 2) == 0) {
                builder.append("this ");
            }
            if ((this.value & 1) == 0) {
                builder.append("global ");
            }
            if ((this.value & 8) == 0) {
                builder.append("throw ");
            }
            if ((this.value & 4) == 0) {
                builder.append("args ");
            }
            if ((this.value & 0x10) == 0) {
                builder.append("return ");
            }
            return builder.toString();
        }
    }

    public static final class AncestorIterable
    implements Iterable<Node> {
        @Nullable
        private Node cur;

        AncestorIterable(Node cur) {
            this.cur = cur;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node n = cur;
                    cur = cur.getParent();
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterator
    implements Iterator<Node> {
        @Nullable
        private Node current;

        SiblingNodeIterator(Node start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node n = this.current;
            this.current = this.current.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node> {
        private final Node start;

        SiblingNodeIterable(Node start) {
            this.start = start;
        }

        @Override
        public Iterator<Node> iterator() {
            return new SiblingNodeIterator(this.start);
        }
    }

    private static final class IntPropListItem
    extends PropListItem {
        final int intValue;

        IntPropListItem(byte propType, int intValue, @Nullable PropListItem next) {
            super(propType, next);
            this.intValue = intValue;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Object getObjectValue() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new IntPropListItem(this.propType, this.intValue, next);
        }
    }

    private static final class ObjectPropListItem
    extends PropListItem {
        private final Object objectValue;

        ObjectPropListItem(byte propType, Object objectValue, @Nullable PropListItem next) {
            super(propType, next);
            this.objectValue = objectValue;
        }

        @Override
        public int getIntValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return String.valueOf(this.objectValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new ObjectPropListItem(this.propType, this.objectValue, next);
        }
    }

    private static abstract class PropListItem
    implements Serializable {
        @Nullable
        final PropListItem next;
        final byte propType;

        PropListItem(byte propType, @Nullable PropListItem next) {
            this.propType = propType;
            this.next = next;
        }

        public abstract int getIntValue();

        public abstract Object getObjectValue();

        public abstract PropListItem chain(@Nullable PropListItem var1);
    }

    private static final class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        StringNode(Token token, String str) {
            super(token);
            this.setString(str);
        }

        StringNode(Token token, String str, int lineno, int charno) {
            super(token, lineno, charno);
            this.setString(str);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str.intern();
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.str.equals(((StringNode)node).str);
        }

        @Override
        public boolean isQuotedString() {
            return this.getBooleanProp((byte)36);
        }

        @Override
        public void setQuotedString() {
            this.putBooleanProp((byte)36, true);
        }

        @Override
        public StringNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new StringNode(this.token, this.str), cloneTypeExprs);
        }

        @Override
        @GwtIncompatible(value="ObjectInputStream")
        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.str = this.str.intern();
        }
    }

    private static final class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double number) {
            super(Token.NUMBER);
            this.number = number;
        }

        public NumberNode(double number, int lineno, int charno) {
            super(Token.NUMBER, lineno, charno);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public void setDouble(double d) {
            this.number = d;
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            double thatValue;
            double thisValue;
            boolean equiv = super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect);
            if (equiv && (thisValue = this.getDouble()) == (thatValue = ((NumberNode)node).getDouble())) {
                return thisValue != 0.0 || 1.0 / thisValue == 1.0 / thatValue;
            }
            return false;
        }

        @Override
        public NumberNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new NumberNode(this.number), cloneTypeExprs);
        }
    }

    public static final class TypeDeclarationNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        public TypeDeclarationNode(Token nodeType, String str) {
            super(nodeType);
            this.str = str;
        }

        public TypeDeclarationNode(Token nodeType) {
            super(nodeType);
        }

        public TypeDeclarationNode(Token nodeType, Node child) {
            super(nodeType, child);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public TypeDeclarationNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new TypeDeclarationNode(this.token, this.str), cloneTypeExprs);
        }
    }
}

