/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.resources;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

@GwtIncompatible(value="getResource, java.io.InputStreamReader")
public final class ResourceLoader {
    public static String loadTextResource(Class<?> clazz, String path) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(clazz.getResourceAsStream(path), StandardCharsets.UTF_8));
        }
        catch (NullPointerException e) {
            if (!ResourceLoader.resourceExists(clazz, path)) {
                throw new RuntimeException("No such resource: " + path);
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean resourceExists(Class<?> clazz, String path) {
        return clazz.getResource(path) != null;
    }

    public static String[] resourceList(Class<?> clazz) {
        throw new UnsupportedOperationException("resourceList only available in GWT code");
    }
}

