/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Immutable
public final class FeatureSet
implements Serializable {
    private final ImmutableSet<Feature> features;
    public static final FeatureSet BARE_MINIMUM = new FeatureSet((Set<Feature>)ImmutableSet.of());
    public static final FeatureSet ES3 = BARE_MINIMUM.with(LangVersion.access$000(LangVersion.ES3));
    public static final FeatureSet ES5 = ES3.with(LangVersion.access$000(LangVersion.ES5));
    public static final FeatureSet ES6_MODULES = ES5.with(LangVersion.access$000(LangVersion.ES6));
    public static final FeatureSet ES6 = ES6_MODULES.without(Feature.MODULES);
    public static final FeatureSet ES7_MODULES = ES6_MODULES.with(LangVersion.access$000(LangVersion.ES7));
    public static final FeatureSet ES7 = ES7_MODULES.without(Feature.MODULES);
    public static final FeatureSet ES8_MODULES = ES7_MODULES.with(LangVersion.access$000(LangVersion.ES8));
    public static final FeatureSet ES8 = ES8_MODULES.without(Feature.MODULES);
    public static final FeatureSet TYPESCRIPT = ES8_MODULES.with(LangVersion.access$000(LangVersion.TYPESCRIPT));
    public static final FeatureSet NTI_SUPPORTED = ES5.with((Set<Feature>)ImmutableSet.of((Object)((Object)Feature.COMPUTED_PROPERTIES), (Object)((Object)Feature.EXPONENT_OP), (Object)((Object)Feature.EXTENDED_OBJECT_LITERALS), (Object)((Object)Feature.FOR_OF), (Object)((Object)Feature.GENERATORS), (Object)((Object)Feature.MEMBER_DECLARATIONS), (Object[])new Feature[]{Feature.TEMPLATE_LITERALS}));

    private FeatureSet(Set<Feature> features) {
        this.features = ImmutableSet.copyOf(features);
    }

    public String version() {
        if (ES3.contains(this)) {
            return "es3";
        }
        if (ES5.contains(this)) {
            return "es5";
        }
        if (ES6_MODULES.contains(this)) {
            return "es6";
        }
        if (NTI_SUPPORTED.contains(this)) {
            return "ntiSupported";
        }
        if (ES7_MODULES.contains(this)) {
            return "es7";
        }
        if (ES8_MODULES.contains(this)) {
            return "es8";
        }
        if (TYPESCRIPT.contains(this)) {
            return "ts";
        }
        throw new IllegalStateException(this.toString());
    }

    public FeatureSet without(Feature feature) {
        return new FeatureSet((Set<Feature>)Sets.difference(this.features, (Set)ImmutableSet.of((Object)((Object)feature))));
    }

    public FeatureSet withoutTypes() {
        return new FeatureSet((Set<Feature>)Sets.difference(this.features, (Set)LangVersion.TYPESCRIPT.features()));
    }

    public FeatureSet union(FeatureSet other) {
        return new FeatureSet((Set<Feature>)Sets.union(this.features, other.features));
    }

    public boolean contains(FeatureSet other) {
        return this.features.containsAll(other.features);
    }

    public FeatureSet with(Feature ... newFeatures) {
        return new FeatureSet((Set<Feature>)Sets.union(this.features, (Set)ImmutableSet.copyOf((Object[])newFeatures)));
    }

    public FeatureSet with(Set<Feature> newFeatures) {
        return new FeatureSet((Set<Feature>)Sets.union(this.features, newFeatures));
    }

    public boolean has(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean equals(Object other) {
        return other instanceof FeatureSet && ((FeatureSet)other).features.equals(this.features);
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public String toString() {
        return this.features.toString();
    }

    public static FeatureSet valueOf(String name) {
        switch (name) {
            case "es3": {
                return ES3;
            }
            case "es5": {
                return ES5;
            }
            case "es6-impl": 
            case "es6": {
                return ES6;
            }
            case "es7": {
                return ES7;
            }
            case "es8": {
                return ES8;
            }
            case "ts": {
                return TYPESCRIPT;
            }
        }
        throw new IllegalArgumentException("No such FeatureSet: " + name);
    }

    public static FeatureSet latest() {
        return TYPESCRIPT;
    }

    public static enum Feature {
        BLOCK_SCOPED_FUNCTION_DECLARATION("block function", LangVersion.ES3),
        ES3_KEYWORDS_AS_IDENTIFIERS("ES3 keywords as identifiers", LangVersion.ES5),
        GETTER("getters", LangVersion.ES5),
        KEYWORDS_AS_PROPERTIES("reserved words as properties", LangVersion.ES5),
        SETTER("setters", LangVersion.ES5),
        STRING_CONTINUATION("string continuation", LangVersion.ES5),
        TRAILING_COMMA("trailing comma", LangVersion.ES5),
        ARROW_FUNCTIONS("arrow function", LangVersion.ES6),
        BINARY_LITERALS("binary literal", LangVersion.ES6),
        OCTAL_LITERALS("octal literal", LangVersion.ES6),
        CLASSES("class", LangVersion.ES6),
        COMPUTED_PROPERTIES("computed property", LangVersion.ES6),
        EXTENDED_OBJECT_LITERALS("extended object literal", LangVersion.ES6),
        FOR_OF("for-of loop", LangVersion.ES6),
        GENERATORS("generator", LangVersion.ES6),
        LET_DECLARATIONS("let declaration", LangVersion.ES6),
        MEMBER_DECLARATIONS("member declaration", LangVersion.ES6),
        REGEXP_FLAG_Y("RegExp flag 'y'", LangVersion.ES6),
        ARRAY_PATTERN_REST("array pattern rest", LangVersion.ES6),
        REST_PARAMETERS("rest parameter", LangVersion.ES6),
        SPREAD_EXPRESSIONS("spread expression", LangVersion.ES6),
        SUPER("super", LangVersion.ES6),
        TEMPLATE_LITERALS("template literal", LangVersion.ES6),
        CONST_DECLARATIONS("const declaration", LangVersion.ES6),
        DESTRUCTURING("destructuring", LangVersion.ES6),
        NEW_TARGET("new.target", LangVersion.ES6),
        REGEXP_FLAG_U("RegExp flag 'u'", LangVersion.ES6),
        DEFAULT_PARAMETERS("default parameter", LangVersion.ES6),
        MODULES("modules", LangVersion.ES6),
        EXPONENT_OP("exponent operator (**)", LangVersion.ES7),
        ASYNC_FUNCTIONS("async function", LangVersion.ES8),
        TRAILING_COMMA_IN_PARAM_LIST("trailing comma in param list", LangVersion.ES8),
        ACCESSIBILITY_MODIFIER("accessibility modifier", LangVersion.TYPESCRIPT),
        AMBIENT_DECLARATION("ambient declaration", LangVersion.TYPESCRIPT),
        CALL_SIGNATURE("call signature", LangVersion.TYPESCRIPT),
        CONSTRUCTOR_SIGNATURE("constructor signature", LangVersion.TYPESCRIPT),
        ENUM("enum", LangVersion.TYPESCRIPT),
        GENERICS("generics", LangVersion.TYPESCRIPT),
        IMPLEMENTS("implements", LangVersion.TYPESCRIPT),
        INDEX_SIGNATURE("index signature", LangVersion.TYPESCRIPT),
        INTERFACE("interface", LangVersion.TYPESCRIPT),
        MEMBER_VARIABLE_IN_CLASS("member variable in class", LangVersion.TYPESCRIPT),
        NAMESPACE_DECLARATION("namespace declaration", LangVersion.TYPESCRIPT),
        OPTIONAL_PARAMETER("optional parameter", LangVersion.TYPESCRIPT),
        TYPE_ALIAS("type alias", LangVersion.TYPESCRIPT),
        TYPE_ANNOTATION("type annotation", LangVersion.TYPESCRIPT);

        private final String name;
        private final LangVersion version;

        private Feature(String name, LangVersion version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum LangVersion {
        ES3,
        ES5,
        ES6,
        ES7,
        ES8,
        TYPESCRIPT;


        private Set<Feature> features() {
            HashSet<Feature> set = new HashSet<Feature>();
            for (Feature feature : Feature.values()) {
                if (feature.version != this) continue;
                set.add(feature);
            }
            return set;
        }
    }
}

