/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.FunctionNamespace;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class Namespace
implements Serializable {
    private Map<String, Namespace> namespaces = ImmutableMap.of();
    private Map<String, Typedef> typedefs = ImmutableMap.of();
    protected PersistentMap<String, Property> otherProps = PersistentMap.create();
    protected final String name;
    protected final JSTypes commonTypes;
    protected JSType namespaceType;
    private boolean duringComputeJSType = false;
    protected final Node defSite;

    protected Namespace(JSTypes commonTypes, String name, Node defSite) {
        this.name = name;
        this.commonTypes = commonTypes;
        this.defSite = (Node)Preconditions.checkNotNull((Object)defSite);
    }

    protected abstract JSType computeJSType();

    public final String getName() {
        return this.name;
    }

    public Node getDefSite() {
        return this.defSite;
    }

    private boolean isDefined(String name) {
        return this.namespaces.containsKey(name) || this.typedefs.containsKey(name) || this.otherProps.containsKey(name);
    }

    public final boolean isDefined(QualifiedName qname) {
        Namespace ns;
        String name;
        if (qname.isIdentifier()) {
            name = qname.getLeftmostName();
            ns = this;
        } else {
            name = qname.getRightmostName();
            ns = this.getSubnamespace(qname.getAllButRightmost());
            if (ns == null) {
                return false;
            }
        }
        return ns.isDefined(name);
    }

    public void addNamespace(QualifiedName qname, Namespace ns) {
        String name;
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        Namespace subns = this.getReceiverNamespace(qname);
        if (subns.namespaces.isEmpty()) {
            subns.namespaces = new LinkedHashMap<String, Namespace>();
        }
        Preconditions.checkState((!subns.namespaces.containsKey(name = qname.getRightmostName()) ? 1 : 0) != 0);
        subns.namespaces.put(name, ns);
    }

    void updateNamespaceType(JSType t) {
        Preconditions.checkNotNull((Object)t);
        Preconditions.checkNotNull((Object)this.namespaceType);
        this.namespaceType = t;
    }

    public final Declaration getDeclaration(QualifiedName qname) {
        Namespace recv = this.getReceiverNamespace(qname);
        if (recv == null) {
            return null;
        }
        String name = qname.getRightmostName();
        if (!recv.isDefined(name)) {
            return null;
        }
        Namespace ns = recv.namespaces.get(name);
        DeclaredTypeRegistry scope = ns instanceof FunctionNamespace ? ((FunctionNamespace)ns).getScope() : null;
        return new Declaration(recv.getPropDeclaredType(name), recv.typedefs.get(name), ns, scope, false, false);
    }

    public final void addTypedef(QualifiedName qname, Typedef td) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.typedefs.isEmpty()) {
            ns.typedefs = new LinkedHashMap<String, Typedef>();
        }
        String name = qname.getRightmostName();
        ns.typedefs.put(name, td);
    }

    private Namespace getReceiverNamespace(QualifiedName qname) {
        if (qname.isIdentifier()) {
            return this;
        }
        return this.getSubnamespace(qname.getAllButRightmost());
    }

    public final Namespace getSubnamespace(QualifiedName qname) {
        String leftmost = qname.getLeftmostName();
        Namespace firstNamespace = this.namespaces.get(leftmost);
        if (firstNamespace == null || qname.isIdentifier()) {
            return firstNamespace;
        }
        return firstNamespace.getSubnamespace(qname.getAllButLeftmost());
    }

    public final boolean hasSubnamespace(QualifiedName qname) {
        return this.getSubnamespace(qname) != null;
    }

    public final boolean hasStaticProp(String pname) {
        Property prop = (Property)this.otherProps.get(pname);
        if (prop == null) {
            return false;
        }
        Preconditions.checkState((!prop.isOptional() ? 1 : 0) != 0);
        return true;
    }

    public final void addProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = this.commonTypes.UNKNOWN;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
    }

    public final void addUndeclaredProperty(String pname, Node defSite, JSType t, boolean isConstant) {
        Preconditions.checkState((this.namespaceType == null ? 1 : 0) != 0);
        if (this.otherProps.containsKey(pname) && ((Property)this.otherProps.get(pname)).isDeclared()) {
            return;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(defSite, t, null) : Property.makeWithDefsite(defSite, t, null));
    }

    public final JSType getPropDeclaredType(String pname) {
        Property p = (Property)this.otherProps.get(pname);
        return p == null ? null : p.getDeclaredType();
    }

    final Property getNsProp(String pname) {
        NominalType maybeWin;
        if (this.namespaces.containsKey(pname)) {
            Namespace subns = this.namespaces.get(pname);
            Preconditions.checkState((subns.namespaceType != null ? 1 : 0) != 0);
            return Property.makeWithDefsite(subns.getDefSite(), subns.namespaceType, subns.namespaceType);
        }
        if (this.otherProps.containsKey(pname)) {
            return (Property)this.otherProps.get(pname);
        }
        if (this instanceof NamespaceLit && (maybeWin = ((NamespaceLit)this).getWindowType()) != null) {
            return maybeWin.getProp(pname, RawNominalType.PropAccess.EXCLUDE_STRAY_PROPS);
        }
        return null;
    }

    final Set<String> getAllPropsOfNamespace() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.addAll(this.namespaces.keySet());
        s.addAll(this.otherProps.keySet());
        return s;
    }

    public final JSType toJSType() {
        if (this.namespaceType == null) {
            Preconditions.checkNotNull((Object)this.commonTypes);
            for (Namespace ns : this.namespaces.values()) {
                if (this.duringComputeJSType) {
                    return null;
                }
                this.duringComputeJSType = true;
                ns.toJSType();
                this.duringComputeJSType = false;
            }
            this.namespaceType = (JSType)Preconditions.checkNotNull((Object)this.computeJSType());
        }
        return this.namespaceType;
    }

    public final void copyWindowProperties(JSTypes commonTypes, RawNominalType win) {
        Preconditions.checkArgument((boolean)win.getName().equals("Window"));
        Preconditions.checkNotNull(this.namespaces, (Object)"The built-in types are missing from window. Perhaps you forgot to run DeclaredGlobalExternsOnWindow?");
        for (Map.Entry<String, Namespace> entry : this.namespaces.entrySet()) {
            RawNominalType rawType;
            Namespace ns = entry.getValue();
            if (ns instanceof RawNominalType && !(rawType = (RawNominalType)ns).isFrozen()) {
                Preconditions.checkState((boolean)rawType.getName().equals("Window"), (String)"Unexpected unfrozen type %s", (Object)rawType.getName());
                continue;
            }
            win.addProtoProperty(entry.getKey(), null, ns.toJSType(), true);
        }
        for (Map.Entry<String, Namespace> entry : this.otherProps.entrySet()) {
            win.addProtoProperty(entry.getKey(), null, ((Property)((Object)entry.getValue())).getType(), true);
        }
    }

    public String toString() {
        return this.name;
    }
}

