/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.JSType;

public class MismatchInfo {
    private final Kind kind;
    private String propName;
    private int argIndex = -1;
    private JSType expected;
    private JSType found;

    private MismatchInfo(Kind kind) {
        this.kind = kind;
    }

    static MismatchInfo makeUnionTypeMismatch(JSType found) {
        MismatchInfo info = new MismatchInfo(Kind.UNION_TYPE_MISMATCH);
        info.found = found;
        return info;
    }

    static MismatchInfo makePropTypeMismatch(String propName, JSType expected, JSType found) {
        MismatchInfo info = new MismatchInfo(Kind.PROPERTY_TYPE_MISMATCH);
        info.propName = propName;
        info.expected = expected;
        info.found = found;
        return info;
    }

    static MismatchInfo makeMissingPropMismatch(String propName) {
        MismatchInfo info = new MismatchInfo(Kind.MISSING_PROPERTY);
        info.propName = propName;
        return info;
    }

    static MismatchInfo makeMaybeMissingPropMismatch(String propName) {
        MismatchInfo info = new MismatchInfo(Kind.WANTED_REQUIRED_PROP_FOUND_OPTIONAL);
        info.propName = propName;
        return info;
    }

    static MismatchInfo makeArgTypeMismatch(int argIndex, JSType expected, JSType found) {
        MismatchInfo info = new MismatchInfo(Kind.ARGUMENT_TYPE_MISMATCH);
        info.argIndex = argIndex;
        info.expected = expected;
        info.found = found;
        return info;
    }

    static MismatchInfo makeRetTypeMismatch(JSType expected, JSType found) {
        MismatchInfo info = new MismatchInfo(Kind.RETURN_TYPE_MISMATCH);
        info.expected = expected;
        info.found = found;
        return info;
    }

    public String getPropName() {
        return (String)Preconditions.checkNotNull((Object)this.propName);
    }

    public JSType getFoundType() {
        return (JSType)Preconditions.checkNotNull((Object)this.found);
    }

    public JSType getExpectedType() {
        return (JSType)Preconditions.checkNotNull((Object)this.expected);
    }

    public int getArgIndex() {
        Preconditions.checkState((this.argIndex >= 0 ? 1 : 0) != 0);
        return this.argIndex;
    }

    public boolean isPropMismatch() {
        return this.kind == Kind.PROPERTY_TYPE_MISMATCH;
    }

    public boolean isMissingProp() {
        return this.kind == Kind.MISSING_PROPERTY;
    }

    public boolean wantedRequiredFoundOptional() {
        return this.kind == Kind.WANTED_REQUIRED_PROP_FOUND_OPTIONAL;
    }

    public boolean isArgTypeMismatch() {
        return this.kind == Kind.ARGUMENT_TYPE_MISMATCH;
    }

    public boolean isRetTypeMismatch() {
        return this.kind == Kind.RETURN_TYPE_MISMATCH;
    }

    public boolean isUnionTypeMismatch() {
        return this.kind == Kind.UNION_TYPE_MISMATCH;
    }

    private static enum Kind {
        PROPERTY_TYPE_MISMATCH,
        MISSING_PROPERTY,
        WANTED_REQUIRED_PROP_FOUND_OPTIONAL,
        ARGUMENT_TYPE_MISMATCH,
        RETURN_TYPE_MISMATCH,
        UNION_TYPE_MISMATCH;

    }
}

