/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

public final class CheckUnusedLabels
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    public static final DiagnosticType UNUSED_LABEL = DiagnosticType.disabled("JSC_UNUSED_LABEL", "Unused label {0}.");
    private final AbstractCompiler compiler;
    private LabelContext currentContext;

    public CheckUnusedLabels(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case BREAK: 
            case CONTINUE: {
                if (n.hasChildren()) {
                    LabelContext temp = this.currentContext;
                    while (temp != null) {
                        if (temp.name.equals(n.getFirstChild().getString())) {
                            temp.used = true;
                            break;
                        }
                        temp = temp.parent;
                    }
                }
                return false;
            }
            case LABEL: {
                this.currentContext = new LabelContext(n.getFirstChild().getString(), this.currentContext);
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isLabel() && this.currentContext != null) {
            if (!this.currentContext.used) {
                t.report(n, UNUSED_LABEL, n.getFirstChild().getString());
            }
            this.currentContext = this.currentContext.parent;
        }
    }

    private static class LabelContext {
        private final String name;
        private final LabelContext parent;
        private boolean used;

        private LabelContext(String name, LabelContext parent) {
            this.name = name;
            this.parent = parent;
        }
    }
}

