/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class CheckRequiresAndProvidesSorted
extends NodeTraversal.AbstractShallowCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType REQUIRES_NOT_SORTED = DiagnosticType.warning("JSC_REQUIRES_NOT_SORTED", "goog.require() statements are not sorted. The correct order is:\n\n{0}\n");
    public static final DiagnosticType PROVIDES_NOT_SORTED = DiagnosticType.warning("JSC_PROVIDES_NOT_SORTED", "goog.provide() statements are not sorted. The correct order is:\n\n{0}\n");
    public static final DiagnosticType PROVIDES_AFTER_REQUIRES = DiagnosticType.warning("JSC_PROVIDES_AFTER_REQUIRES", "goog.provide() statements should be before goog.require() statements.");
    public static final DiagnosticType DUPLICATE_REQUIRE = DiagnosticType.warning("JSC_DUPLICATE_REQUIRE", "''{0}'' required more than once.");
    private final List<Node> requires;
    private final List<Node> provides;
    private final AbstractCompiler compiler;
    public static final Function<Node, String> getSortKey = new Function<Node, String>(){

        public String apply(Node n) {
            String key = null;
            boolean isForwardDeclare = false;
            if (NodeUtil.isNameDeclaration(n)) {
                if (n.getFirstChild().isName()) {
                    key = n.getFirstChild().getString();
                    if (n.getFirstFirstChild().getFirstChild().matchesQualifiedName("goog.forwardDeclare")) {
                        isForwardDeclare = true;
                    }
                } else if (n.getFirstChild().isDestructuringLhs()) {
                    Node pattern = n.getFirstFirstChild();
                    Preconditions.checkState((boolean)pattern.isObjectPattern(), (Object)pattern);
                    Node call = n.getFirstChild().getLastChild();
                    Preconditions.checkState((boolean)call.isCall(), (Object)call);
                    Preconditions.checkState((boolean)call.getFirstChild().matchesQualifiedName("goog.require"), (Object)call.getFirstChild());
                    key = !pattern.hasChildren() ? "{" : "{" + pattern.getFirstChild().getString();
                }
            } else if (n.isExprResult()) {
                key = "|" + n.getFirstChild().getLastChild().getString();
                if (n.getFirstFirstChild().matchesQualifiedName("goog.forwardDeclare")) {
                    isForwardDeclare = true;
                }
            } else {
                throw new IllegalArgumentException("Unexpected node " + n);
            }
            return (isForwardDeclare ? "z" : "a") + (String)Preconditions.checkNotNull((Object)key);
        }
    };
    private final Ordering<Node> alphabetical = Ordering.natural().onResultOf(getSortKey);

    public CheckRequiresAndProvidesSorted(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.requires = new ArrayList<Node>();
        this.provides = new ArrayList<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    private static final String getNamespace(Node requireStatement) {
        if (requireStatement.isExprResult()) {
            return requireStatement.getFirstChild().getLastChild().getString();
        }
        if (NodeUtil.isNameDeclaration(requireStatement)) {
            if (requireStatement.getFirstChild().isName()) {
                return requireStatement.getFirstFirstChild().getLastChild().getString();
            }
            if (requireStatement.getFirstChild().isDestructuringLhs()) {
                return requireStatement.getFirstChild().getLastChild().getLastChild().getString();
            }
        }
        throw new IllegalArgumentException("Unexpected node " + requireStatement);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.checkForDuplicates(this.requires);
                this.reportIfOutOfOrder(this.requires, REQUIRES_NOT_SORTED);
                this.reportIfOutOfOrder(this.provides, PROVIDES_NOT_SORTED);
                this.reset();
                break;
            }
            case CALL: {
                Node callee = n.getFirstChild();
                if (!(callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.forwardDeclare") || callee.matchesQualifiedName("goog.provide") || callee.matchesQualifiedName("goog.module"))) {
                    return;
                }
                if (parent.isExprResult() && NodeUtil.isTopLevel(parent.getParent())) {
                    Node namespaceNode = n.getLastChild();
                    if (!namespaceNode.isString()) {
                        return;
                    }
                    String namespace = namespaceNode.getString();
                    if (namespace == null) {
                        return;
                    }
                    if (callee.matchesQualifiedName("goog.require") || callee.matchesQualifiedName("goog.forwardDeclare")) {
                        this.requires.add(parent);
                        break;
                    }
                    if (!this.requires.isEmpty()) {
                        t.report(n, PROVIDES_AFTER_REQUIRES, new String[0]);
                    }
                    if (!callee.matchesQualifiedName("goog.provide")) break;
                    this.provides.add(parent);
                    break;
                }
                if (!NodeUtil.isNameDeclaration(parent.getParent()) || !callee.matchesQualifiedName("goog.require") && !callee.matchesQualifiedName("goog.forwardDeclare")) break;
                this.requires.add(parent.getParent());
                break;
            }
        }
    }

    private void reportIfOutOfOrder(List<Node> requiresOrProvides, DiagnosticType warning) {
        if (!this.alphabetical.isOrdered(requiresOrProvides)) {
            StringBuilder correctOrder = new StringBuilder();
            for (Node require : this.alphabetical.sortedCopy(requiresOrProvides)) {
                CodePrinter.Builder builder = new CodePrinter.Builder(require);
                CompilerOptions options = new CompilerOptions();
                options.setPrettyPrint(true);
                options.setPreferSingleQuotes(true);
                options.setPreserveTypeAnnotations(true);
                builder.setCompilerOptions(options);
                correctOrder.append(builder.build());
            }
            this.compiler.report(JSError.make(requiresOrProvides.get(0), warning, correctOrder.toString()));
        }
    }

    private void checkForDuplicates(List<Node> requires) {
        HashSet<String> namespaces = new HashSet<String>();
        for (Node require : requires) {
            String namespace = CheckRequiresAndProvidesSorted.getNamespace(require);
            if (namespaces.add(namespace)) continue;
            this.compiler.report(JSError.make(require, DUPLICATE_REQUIRE, namespace));
        }
    }

    private void reset() {
        this.requires.clear();
        this.provides.clear();
    }
}

