/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SourceCodeEscapers;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClosureBundler {
    private final Transpiler transpiler;
    private final EvalMode mode;
    private final String sourceUrl;
    private final String path;
    private final Map<String, String> sourceMapCache;

    public ClosureBundler() {
        this(Transpiler.NULL);
    }

    public ClosureBundler(Transpiler transpiler) {
        this(transpiler, EvalMode.NORMAL, null, "unknown_source", new ConcurrentHashMap<String, String>());
    }

    private ClosureBundler(Transpiler transpiler, EvalMode mode, String sourceUrl, String path, Map<String, String> sourceMapCache) {
        this.transpiler = transpiler;
        this.mode = mode;
        this.sourceUrl = sourceUrl;
        this.path = path;
        this.sourceMapCache = sourceMapCache;
    }

    public final ClosureBundler useEval(boolean useEval) {
        EvalMode newMode = useEval ? EvalMode.EVAL : EvalMode.NORMAL;
        return new ClosureBundler(this.transpiler, newMode, this.sourceUrl, this.path, this.sourceMapCache);
    }

    public final ClosureBundler withSourceUrl(String newSourceUrl) {
        return new ClosureBundler(this.transpiler, this.mode, newSourceUrl, this.path, this.sourceMapCache);
    }

    public final ClosureBundler withPath(String newPath) {
        return new ClosureBundler(this.transpiler, this.mode, this.sourceUrl, newPath, this.sourceMapCache);
    }

    public static void appendInput(Appendable out, DependencyInfo info, String contents) throws IOException {
        new ClosureBundler().appendTo(out, info, contents);
    }

    public void appendTo(Appendable out, DependencyInfo info, String content) throws IOException {
        this.appendTo(out, info, CharSource.wrap((CharSequence)content));
    }

    public void appendTo(Appendable out, DependencyInfo info, File content, Charset contentCharset) throws IOException {
        this.appendTo(out, info, Files.asCharSource((File)content, (Charset)contentCharset));
    }

    public void appendTo(Appendable out, DependencyInfo info, CharSource content) throws IOException {
        if (info.isModule()) {
            this.mode.appendGoogModule(this.transpile(content.read()), out, this.sourceUrl);
        } else {
            this.mode.appendTraditional(this.transpile(content.read()), out, this.sourceUrl);
        }
    }

    public void appendRuntimeTo(Appendable out) throws IOException {
        String runtime = this.transpiler.runtime();
        if (!runtime.isEmpty()) {
            this.mode.appendTraditional(runtime, out, null);
        }
    }

    public String getSourceMap(String path) {
        return Strings.nullToEmpty((String)this.sourceMapCache.get(path));
    }

    private String transpile(String s) {
        TranspileResult result = this.transpiler.transpile(Paths.get(this.path, new String[0]), s);
        this.sourceMapCache.put(this.path, result.sourceMap());
        return result.transpiled();
    }

    private static void appendSourceUrl(Appendable out, EscapeMode mode, String sourceUrl) throws IOException {
        if (sourceUrl == null) {
            return;
        }
        String toAppend = "\n//# sourceURL=" + sourceUrl + "\n";
        mode.append(toAppend, out);
    }

    private static enum EscapeMode {
        ESCAPED{

            @Override
            void append(String s, Appendable out) throws IOException {
                out.append(SourceCodeEscapers.javascriptEscaper().escape(s));
            }
        }
        ,
        NORMAL{

            @Override
            void append(String s, Appendable out) throws IOException {
                out.append(s);
            }
        };


        abstract void append(String var1, Appendable var2) throws IOException;
    }

    private static enum EvalMode {
        EVAL{

            @Override
            void appendTraditional(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("(0,eval(\"");
                EscapeMode.ESCAPED.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.ESCAPED, sourceUrl);
                out.append("\"));\n");
            }

            @Override
            void appendGoogModule(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("goog.loadModule(\"");
                EscapeMode.ESCAPED.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.ESCAPED, sourceUrl);
                out.append("\");\n");
            }
        }
        ,
        NORMAL{

            @Override
            void appendTraditional(String s, Appendable out, String sourceUrl) throws IOException {
                EscapeMode.NORMAL.append(s, out);
                ClosureBundler.appendSourceUrl(out, EscapeMode.NORMAL, sourceUrl);
            }

            @Override
            void appendGoogModule(String s, Appendable out, String sourceUrl) throws IOException {
                out.append("goog.loadModule(function(exports) {'use strict';");
                EscapeMode.NORMAL.append(s, out);
                out.append("\n;return exports;});\n");
                ClosureBundler.appendSourceUrl(out, EscapeMode.NORMAL, sourceUrl);
            }
        };


        abstract void appendTraditional(String var1, Appendable var2, String var3) throws IOException;

        abstract void appendGoogModule(String var1, Appendable var2, String var3) throws IOException;
    }
}

