/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;

public class Var
implements StaticSlot,
StaticRef {
    final String name;
    final Node nameNode;
    final CompilerInput input;
    final int index;
    final Scope scope;
    private static final ImmutableSet<Token> DECLARATION_TYPES = Sets.immutableEnumSet((Enum)Token.VAR, (Enum[])new Token[]{Token.LET, Token.CONST, Token.FUNCTION, Token.CLASS, Token.CATCH, Token.IMPORT, Token.PARAM_LIST});

    Var(String name, Node nameNode, Scope scope, int index, CompilerInput input) {
        this.name = name;
        this.nameNode = nameNode;
        this.scope = scope;
        this.index = index;
        this.input = input;
    }

    static Var makeArgumentsVar(Scope scope) {
        Preconditions.checkArgument((!(scope instanceof TypedScope) ? 1 : 0) != 0);
        return new Arguments(scope);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this.nameNode;
    }

    CompilerInput getInput() {
        return this.input;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.nameNode.getStaticSourceFile();
    }

    @Override
    public Var getSymbol() {
        return this;
    }

    @Override
    public Var getDeclaration() {
        return this.nameNode == null ? null : this;
    }

    public Node getParentNode() {
        return this.nameNode == null ? null : this.nameNode.getParent();
    }

    public boolean isBleedingFunction() {
        return NodeUtil.isFunctionExpression(this.getParentNode());
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isGlobal() {
        return this.scope.isGlobal();
    }

    public boolean isLocal() {
        return this.scope.isLocal();
    }

    boolean isExtern() {
        return this.input == null || this.input.isExtern();
    }

    public boolean isInferredConst() {
        if (this.nameNode == null) {
            return false;
        }
        return this.nameNode.getBooleanProp((byte)65) || this.nameNode.getBooleanProp((byte)43);
    }

    public boolean isDefine() {
        JSDocInfo info = this.getJSDocInfo();
        return info != null && info.isDefine();
    }

    public Node getInitialValue() {
        return NodeUtil.getRValueOfLValue(this.nameNode);
    }

    public Node getNameNode() {
        return this.nameNode;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.nameNode == null ? null : NodeUtil.getBestJSDocInfo(this.nameNode);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Var)) {
            return false;
        }
        Var otherVar = (Var)other;
        return otherVar.nameNode == this.nameNode;
    }

    public int hashCode() {
        return this.nameNode.hashCode();
    }

    public String toString() {
        return "Var " + this.name + " @ " + this.nameNode;
    }

    boolean isVar() {
        return this.declarationType() == Token.VAR;
    }

    boolean isCatch() {
        return this.declarationType() == Token.CATCH;
    }

    boolean isLet() {
        return this.declarationType() == Token.LET;
    }

    boolean isConst() {
        return this.declarationType() == Token.CONST;
    }

    boolean isClass() {
        return this.declarationType() == Token.CLASS;
    }

    boolean isParam() {
        return this.declarationType() == Token.PARAM_LIST;
    }

    boolean isDefaultParam() {
        Node parent = this.nameNode.getParent();
        return parent.getParent().isParamList() && parent.isDefaultValue() && parent.getFirstChild() == this.nameNode;
    }

    public boolean isArguments() {
        return false;
    }

    protected Token declarationType() {
        for (Node current = this.nameNode; current != null; current = current.getParent()) {
            if (!DECLARATION_TYPES.contains((Object)current.getToken())) continue;
            return current.getToken();
        }
        throw new IllegalStateException("The nameNode for " + this + " must be a descendant of one of: " + DECLARATION_TYPES);
    }

    private static class Arguments
    extends Var {
        Arguments(Scope scope) {
            super("arguments", null, scope, -1, null);
        }

        @Override
        public boolean isArguments() {
            return true;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.scope.getRootNode().getStaticSourceFile();
        }

        @Override
        public boolean isBleedingFunction() {
            return false;
        }

        @Override
        protected Token declarationType() {
            return null;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Arguments)) {
                return false;
            }
            Arguments otherVar = (Arguments)other;
            return otherVar.scope.getRootNode() == this.scope.getRootNode();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

