/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

final class TypeInfoCheck
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private boolean requiresTypes = false;

    TypeInfoCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public void setCheckSubTree(Node root) {
        this.requiresTypes = true;
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void process(Node externs, Node root) {
        this.requiresTypes = false;
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresTypes = true;
        } else if (n.isParamList()) {
            this.requiresTypes = false;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isScript()) {
            this.requiresTypes = false;
        } else if (this.requiresTypes && TypeInfoCheck.shouldHaveTypeInformation(n)) {
            if (n.isString() && (parent.isGetProp() || parent.isGetElem())) {
                return;
            }
            if (n.isParamList()) {
                return;
            }
            if (n.isName() && parent.isFunction()) {
                return;
            }
            if (n.getTypeI() == null) {
                throw new IllegalStateException("No type information associated with " + n + " Most likely a Node has been created after type checking without setting the type.");
            }
        }
    }

    private static boolean shouldHaveTypeInformation(Node node) {
        return node.isFunction() || !IR.mayBeStatement(node);
    }
}

