/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.EarlyEs6ToEs3Converter;
import com.google.javascript.jscomp.Es6ConvertSuper;
import com.google.javascript.jscomp.Es6ConvertSuperConstructorCalls;
import com.google.javascript.jscomp.Es6ExtractClasses;
import com.google.javascript.jscomp.Es6RenameVariablesInParamLists;
import com.google.javascript.jscomp.Es6RewriteArrowFunction;
import com.google.javascript.jscomp.Es6RewriteBlockScopedDeclaration;
import com.google.javascript.jscomp.Es6RewriteClass;
import com.google.javascript.jscomp.Es6RewriteDestructuring;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6SplitVariableDeclarations;
import com.google.javascript.jscomp.Es6SuperCheck;
import com.google.javascript.jscomp.Es7ToEs6Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.LateEs6ToEs3Converter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.RewriteAsyncFunctions;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.List;

public class TranspilationPasses {
    private static final PassFactory.HotSwapPassFactory es6RewriteModule = new PassFactory.HotSwapPassFactory("es6RewriteModule", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteModules(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private static final PassFactory rewriteAsyncFunctions = new PassFactory("rewriteAsyncFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RewriteAsyncFunctions(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private static final PassFactory convertEs7ToEs6 = new PassFactory("convertEs7ToEs6", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es7ToEs6Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private static final PassFactory es6SuperCheck = new PassFactory("es6SuperCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6SuperCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ExtractClasses = new PassFactory.HotSwapPassFactory("Es6ExtractClasses", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ExtractClasses(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteClass = new PassFactory.HotSwapPassFactory("Es6RewriteClass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteClass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteDestructuring = new PassFactory.HotSwapPassFactory("Es6RewriteDestructuring", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteDestructuring(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RenameVariablesInParamLists = new PassFactory.HotSwapPassFactory("Es6RenameVariablesInParamLists", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RenameVariablesInParamLists(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteArrowFunction = new PassFactory.HotSwapPassFactory("Es6RewriteArrowFunction", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteArrowFunction(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewritePolyfills = new PassFactory.HotSwapPassFactory("RewritePolyfills", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewritePolyfills(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6SplitVariableDeclarations = new PassFactory.HotSwapPassFactory("Es6SplitVariableDeclarations", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6SplitVariableDeclarations(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuperConstructorCalls = new PassFactory.HotSwapPassFactory("es6ConvertSuperConstructorCalls", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuperConstructorCalls(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuper = new PassFactory.HotSwapPassFactory("es6ConvertSuper", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuper(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory earlyConvertEs6ToEs3 = new PassFactory.HotSwapPassFactory("earlyConvertEs6", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new EarlyEs6ToEs3Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory lateConvertEs6ToEs3 = new PassFactory.HotSwapPassFactory("lateConvertEs6", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new LateEs6ToEs3Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteBlockScopedDeclaration = new PassFactory.HotSwapPassFactory("Es6RewriteBlockScopedDeclaration", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteBlockScopedDeclaration(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteGenerators = new PassFactory.HotSwapPassFactory("rewriteGenerators", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteGenerators(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };

    private TranspilationPasses() {
    }

    public static void addEs6ModulePass(List<PassFactory> passes) {
        passes.add(es6RewriteModule);
    }

    public static void addEs2017Passes(List<PassFactory> passes) {
        passes.add(rewriteAsyncFunctions);
    }

    public static void addEs2016Passes(List<PassFactory> passes) {
        passes.add(convertEs7ToEs6);
    }

    public static void addEs6EarlyPasses(List<PassFactory> passes) {
        passes.add(es6SuperCheck);
        passes.add(es6ConvertSuper);
        passes.add(es6RenameVariablesInParamLists);
        passes.add(es6SplitVariableDeclarations);
        passes.add(es6RewriteDestructuring);
        passes.add(es6RewriteArrowFunction);
    }

    public static void addEs6LatePasses(List<PassFactory> passes) {
        passes.add(es6ExtractClasses);
        passes.add(es6RewriteClass);
        passes.add(earlyConvertEs6ToEs3);
        passes.add(lateConvertEs6ToEs3);
        passes.add(rewriteBlockScopedDeclaration);
        passes.add(rewriteGenerators);
    }

    public static void addEs6PassesBeforeNTI(List<PassFactory> passes) {
        passes.add(es6ExtractClasses);
        passes.add(es6RewriteClass);
        passes.add(earlyConvertEs6ToEs3);
        passes.add(rewriteBlockScopedDeclaration);
    }

    public static void addEs6PassesAfterNTI(List<PassFactory> passes) {
        passes.add(lateConvertEs6ToEs3);
        passes.add(rewriteGenerators);
    }

    public static void addRewritePolyfillPass(List<PassFactory> passes) {
        passes.add(rewritePolyfills);
    }

    static boolean isScriptEs6OrHigher(Node script) {
        FeatureSet features = (FeatureSet)script.getProp((byte)89);
        return features != null && !FeatureSet.ES5.contains(features);
    }

    static void processCheck(AbstractCompiler compiler, Node combinedRoot, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().getLanguageIn().toFeatureSet().contains(FeatureSet.ES6)) {
            for (Node singleRoot : combinedRoot.children()) {
                if (!TranspilationPasses.isScriptEs6OrHigher(singleRoot)) continue;
                for (NodeTraversal.Callback callback : callbacks) {
                    NodeTraversal.traverseEs6(compiler, singleRoot, callback);
                }
            }
        }
    }

    static void hotSwapCheck(AbstractCompiler compiler, Node scriptRoot, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().getLanguageIn().toFeatureSet().contains(FeatureSet.ES6) && TranspilationPasses.isScriptEs6OrHigher(scriptRoot)) {
            for (NodeTraversal.Callback callback : callbacks) {
                NodeTraversal.traverseEs6(compiler, scriptRoot, callback);
            }
        }
    }

    static void processTranspile(AbstractCompiler compiler, Node combinedRoot, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6)) {
            for (Node singleRoot : combinedRoot.children()) {
                if (!TranspilationPasses.isScriptEs6OrHigher(singleRoot)) continue;
                for (NodeTraversal.Callback callback : callbacks) {
                    singleRoot.putBooleanProp((byte)93, true);
                    NodeTraversal.traverseEs6(compiler, singleRoot, callback);
                }
            }
        }
    }

    static void hotSwapTranspile(AbstractCompiler compiler, Node scriptRoot, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6) && TranspilationPasses.isScriptEs6OrHigher(scriptRoot)) {
            for (NodeTraversal.Callback callback : callbacks) {
                scriptRoot.putBooleanProp((byte)93, true);
                NodeTraversal.traverseEs6(compiler, scriptRoot, callback);
            }
        }
    }

    public static void addPostCheckPasses(List<PassFactory> passes) {
        passes.add(es6ConvertSuperConstructorCalls);
    }
}

