/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import com.google.javascript.jscomp.SourceFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import javax.annotation.Nullable;

@GwtIncompatible(value="Accesses the file system")
public class SourceMapResolver {
    private static final String BASE64_URL_PREFIX = "data:application/json;base64,";

    static SourceFile extractSourceMap(SourceFile jsFile, String sourceMapURL, boolean parseInlineSourceMaps) {
        if (parseInlineSourceMaps && sourceMapURL.startsWith(BASE64_URL_PREFIX)) {
            byte[] data = BaseEncoding.base64().decode((CharSequence)sourceMapURL.substring(BASE64_URL_PREFIX.length()));
            String source = new String(data, StandardCharsets.UTF_8);
            return SourceFile.fromCode(jsFile.getName() + ".inline.map", source);
        }
        if (SourceMapResolver.isAbsolute(sourceMapURL)) {
            return null;
        }
        return SourceMapResolver.getRelativePath(jsFile.getName(), sourceMapURL);
    }

    @VisibleForTesting
    private static boolean isAbsolute(String url) {
        try {
            return new URI(url).isAbsolute() || url.startsWith("/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Sourcemap url was invalid: " + url, e);
        }
    }

    @Nullable
    static SourceFile getRelativePath(String baseFilePath, String relativePath) {
        return SourceFile.fromPath(FileSystems.getDefault().getPath(baseFilePath, new String[0]).resolveSibling(relativePath).normalize(), StandardCharsets.UTF_8);
    }
}

