/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.MinimizedCondition;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.TernaryValue;

class PeepholeMinimizeConditions
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(Token.AND);
    private final boolean late;
    private final boolean useTypes;

    PeepholeMinimizeConditions(boolean late, boolean useTypes) {
        this.late = late;
        this.useTypes = useTypes;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getToken()) {
            case THROW: 
            case RETURN: {
                Node result = this.tryRemoveRedundantExit(node);
                if (result != node) {
                    return result;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case NOT: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case IF: {
                this.performCoercionSubstitutions(node.getFirstChild());
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case EXPR_RESULT: {
                this.performCoercionSubstitutions(node.getFirstChild());
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeExprResult(node);
            }
            case HOOK: {
                this.performCoercionSubstitutions(node.getFirstChild());
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeHook(node);
            }
            case WHILE: 
            case DO: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case FOR: {
                this.tryJoinForCondition(node);
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case BLOCK: {
                return this.tryReplaceIf(node);
            }
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return this.tryReplaceComparisonWithCoercion(node, true);
            }
        }
        return node;
    }

    private void tryJoinForCondition(Node n) {
        Node thenBlock;
        Node maybeBreak;
        if (!this.late) {
            return;
        }
        Node block = n.getLastChild();
        Node maybeIf = block.getFirstChild();
        if (maybeIf != null && maybeIf.isIf() && (maybeBreak = (thenBlock = maybeIf.getSecondChild()).getFirstChild()) != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            if (maybeIf.getChildCount() == 3) {
                block.replaceChild(maybeIf, maybeIf.getLastChild().detach());
            } else {
                NodeUtil.redeclareVarsInsideBranch(thenBlock);
                block.removeFirstChild();
            }
            Node ifCondition = maybeIf.removeFirstChild();
            Node fixedIfCondition = IR.not(ifCondition).srcref(ifCondition);
            Node forCondition = NodeUtil.getConditionExpression(n);
            if (forCondition.isEmpty()) {
                n.replaceChild(forCondition, fixedIfCondition);
            } else {
                Node replacement = new Node(Token.AND);
                n.replaceChild(forCondition, replacement);
                replacement.addChildToBack(forCondition);
                replacement.addChildToBack(fixedIfCondition);
            }
            this.reportCodeChange();
        }
    }

    private Node tryReplaceIf(Node n) {
        Node next = null;
        Node child = n.getFirstChild();
        while (child != null) {
            next = child.getNext();
            if (child.isIf()) {
                Node cond = child.getFirstChild();
                Node thenBranch = cond.getNext();
                Node elseBranch = thenBranch.getNext();
                Node nextNode = child.getNext();
                if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && nextNode.isIf()) {
                    Node newCond;
                    Node nextCond = nextNode.getFirstChild();
                    Node nextThen = nextCond.getNext();
                    Node nextElse = nextThen.getNext();
                    if (thenBranch.isEquivalentToTyped(nextThen)) {
                        child.detach();
                        child.detachChildren();
                        newCond = new Node(Token.OR, cond);
                        nextNode.replaceChild(nextCond, newCond);
                        newCond.addChildToBack(nextCond);
                        this.reportCodeChange();
                    } else if (nextElse != null && thenBranch.isEquivalentToTyped(nextElse)) {
                        child.detach();
                        child.detachChildren();
                        newCond = new Node(Token.AND, IR.not(cond).srcref(cond));
                        nextNode.replaceChild(nextCond, newCond);
                        newCond.addChildToBack(nextCond);
                        this.reportCodeChange();
                    }
                } else {
                    if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpression(nextNode)) {
                        Node thenExpr = null;
                        if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch)) {
                            thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
                            thenExpr.detach();
                        } else {
                            thenExpr = NodeUtil.newUndefinedNode(child);
                        }
                        Node elseExpr = nextNode.getFirstChild();
                        cond.detach();
                        elseExpr.detach();
                        Node returnNode = IR.returnNode(IR.hook(cond, thenExpr, elseExpr).srcref(child));
                        n.replaceChild(child, returnNode);
                        n.removeChild(nextNode);
                        this.reportCodeChange();
                        break;
                    }
                    if (elseBranch != null && PeepholeMinimizeConditions.statementMustExitParent(thenBranch)) {
                        child.removeChild(elseBranch);
                        n.addChildAfter(elseBranch, child);
                        this.reportCodeChange();
                    }
                }
            }
            child = next;
        }
        return n;
    }

    private static boolean statementMustExitParent(Node n) {
        switch (n.getToken()) {
            case THROW: 
            case RETURN: {
                return true;
            }
            case BLOCK: {
                if (n.hasChildren()) {
                    Node child = n.getLastChild();
                    return PeepholeMinimizeConditions.statementMustExitParent(child);
                }
                return false;
            }
        }
        return false;
    }

    private Node tryReplaceExitWithBreak(Node n) {
        Node result = n.getFirstChild();
        Node breakTarget = n;
        while (!ControlFlowAnalysis.isBreakTarget(breakTarget, null)) {
            if (breakTarget.isFunction() || breakTarget.isScript()) {
                return n;
            }
            breakTarget = breakTarget.getParent();
        }
        Node follow = ControlFlowAnalysis.computeFollowNode(breakTarget);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = PeepholeMinimizeConditions.skipFinallyNodes(follow)) && !this.isPure(result)) {
            return n;
        }
        if (follow == null && (n.isThrow() || result != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            Node replacement = IR.breakNode();
            n.replaceWith(replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryRemoveRedundantExit(Node n) {
        Node exitExpr = n.getFirstChild();
        Node follow = ControlFlowAnalysis.computeFollowNode(n);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = PeepholeMinimizeConditions.skipFinallyNodes(follow)) && !this.isPure(exitExpr)) {
            return n;
        }
        if (follow == null && (n.isThrow() || exitExpr != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            n.detach();
            this.reportCodeChange();
            return null;
        }
        return n;
    }

    boolean isPure(Node n) {
        return n == null || !NodeUtil.canBeSideEffected(n) && !this.mayHaveSideEffects(n);
    }

    static Node skipFinallyNodes(Node n) {
        while (n != null && NodeUtil.isTryFinallyNode(n.getParent(), n)) {
            n = ControlFlowAnalysis.computeFollowNode(n);
        }
        return n;
    }

    boolean areMatchingExits(Node nodeThis, Node nodeThat) {
        return nodeThis.isEquivalentTo(nodeThat) && (!PeepholeMinimizeConditions.isExceptionPossible(nodeThis) || PeepholeMinimizeConditions.getExceptionHandler(nodeThis) == PeepholeMinimizeConditions.getExceptionHandler(nodeThat));
    }

    static boolean isExceptionPossible(Node n) {
        Preconditions.checkState((n.isReturn() || n.isThrow() ? 1 : 0) != 0, (Object)n);
        return n.isThrow() || n.hasChildren() && !NodeUtil.isLiteralValue(n.getLastChild(), true);
    }

    static Node getExceptionHandler(Node n) {
        return ControlFlowAnalysis.getExceptionHandler(n);
    }

    private Node tryMinimizeNot(Node n) {
        Token complementOperator;
        Preconditions.checkArgument((boolean)n.isNot());
        Node parent = n.getParent();
        Node notChild = n.getFirstChild();
        switch (notChild.getToken()) {
            case EQ: {
                complementOperator = Token.NE;
                break;
            }
            case NE: {
                complementOperator = Token.EQ;
                break;
            }
            case SHEQ: {
                complementOperator = Token.SHNE;
                break;
            }
            case SHNE: {
                complementOperator = Token.SHEQ;
                break;
            }
            default: {
                return n;
            }
        }
        Node newOperator = n.removeFirstChild();
        newOperator.setToken(complementOperator);
        parent.replaceChild(n, newOperator);
        this.reportCodeChange();
        return newOperator;
    }

    private Node tryMinimizeExprResult(Node n) {
        Node originalExpr = n.getFirstChild();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalExpr);
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (mNode.isNot()) {
            this.replaceNode(originalExpr, mNode.withoutNot());
        } else {
            this.replaceNode(originalExpr, mNode);
        }
        return n;
    }

    private Node tryMinimizeHook(Node n) {
        Node originalCond = n.getFirstChild();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalCond);
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (mNode.isNot()) {
            Node thenBranch = n.getSecondChild();
            this.replaceNode(originalCond, mNode.withoutNot());
            n.removeChild(thenBranch);
            n.addChildToBack(thenBranch);
            this.reportCodeChange();
        } else {
            this.replaceNode(originalCond, mNode);
        }
        return n;
    }

    private Node tryMinimizeIf(Node n) {
        Node parent = n.getParent();
        Node originalCond = n.getFirstChild();
        if (NodeUtil.isLiteralValue(originalCond, true)) {
            return n;
        }
        Node thenBranch = originalCond.getNext();
        Node elseBranch = thenBranch.getNext();
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(originalCond);
        MinimizedCondition.MeasuredNode unnegatedCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED);
        MinimizedCondition.MeasuredNode shortCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (elseBranch == null) {
            Node innerCond;
            Node innerThenBranch;
            Node innerElseBranch;
            Node innerIf;
            if (PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch)) {
                Node expr = PeepholeMinimizeConditions.getBlockExpression(thenBranch);
                if (!this.late && PeepholeMinimizeConditions.isPropertyAssignmentInExpression(expr)) {
                    this.replaceNode(originalCond, unnegatedCond);
                    return n;
                }
                if (shortCond.isNot()) {
                    Node replacementCond = this.replaceNode(originalCond, shortCond.withoutNot()).detach();
                    Node or = IR.or(replacementCond, expr.removeFirstChild()).srcref(n);
                    Node newExpr = NodeUtil.newExpr(or);
                    parent.replaceChild(n, newExpr);
                    this.reportCodeChange();
                    return newExpr;
                }
                if (shortCond.isLowerPrecedenceThan(AND_PRECEDENCE) && PeepholeMinimizeConditions.isLowerPrecedence(expr.getFirstChild(), AND_PRECEDENCE)) {
                    this.replaceNode(originalCond, shortCond);
                    return n;
                }
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node and = IR.and(replacementCond, expr.removeFirstChild()).srcref(n);
                Node newExpr = NodeUtil.newExpr(and);
                parent.replaceChild(n, newExpr);
                this.reportCodeChange();
                return newExpr;
            }
            if (NodeUtil.isStatementBlock(thenBranch) && thenBranch.hasOneChild() && (innerIf = thenBranch.getFirstChild()).isIf() && (innerElseBranch = (innerThenBranch = (innerCond = innerIf.getFirstChild()).getNext()).getNext()) == null && (!unnegatedCond.isLowerPrecedenceThan(AND_PRECEDENCE) || !PeepholeMinimizeConditions.isLowerPrecedence(innerCond, AND_PRECEDENCE))) {
                Node replacementCond = this.replaceNode(originalCond, unnegatedCond).detach();
                n.detachChildren();
                n.addChildToBack(IR.and(replacementCond, innerCond.detach()).srcref(originalCond));
                n.addChildToBack(innerThenBranch.detach());
                this.reportCodeChange();
                return n;
            }
            this.replaceNode(originalCond, unnegatedCond);
            return n;
        }
        this.tryRemoveRepeatedStatements(n);
        if (shortCond.isNot() && !PeepholeMinimizeConditions.consumesDanglingElse(elseBranch)) {
            this.replaceNode(originalCond, shortCond.withoutNot());
            n.removeChild(thenBranch);
            n.addChildToBack(thenBranch);
            this.reportCodeChange();
            return n;
        }
        if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpressBlock(elseBranch)) {
            Node thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
            Node elseExpr = PeepholeMinimizeConditions.getBlockReturnExpression(elseBranch);
            Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
            thenExpr.detach();
            elseExpr.detach();
            Node returnNode = IR.returnNode(IR.hook(replacementCond, thenExpr, elseExpr).srcref(n));
            parent.replaceChild(n, returnNode);
            this.reportCodeChange();
            return returnNode;
        }
        boolean thenBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch);
        boolean elseBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(elseBranch);
        if (thenBranchIsExpressionBlock && elseBranchIsExpressionBlock) {
            Node lhs;
            Node thenOp = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node elseOp = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            if (thenOp.getToken() == elseOp.getToken() && NodeUtil.isAssignmentOp(thenOp) && this.areNodesEqualForInlining(lhs = thenOp.getFirstChild(), elseOp.getFirstChild()) && !this.mayEffectMutableState(lhs) && (!this.mayHaveSideEffects(originalCond) || thenOp.isAssign() && thenOp.getFirstChild().isName())) {
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node assignName = thenOp.removeFirstChild();
                Node thenExpr = thenOp.removeFirstChild();
                Node elseExpr = elseOp.getLastChild();
                elseOp.removeChild(elseExpr);
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                Node assign = new Node(thenOp.getToken(), assignName, hookNode).srcref(thenOp);
                Node expr = NodeUtil.newExpr(assign);
                parent.replaceChild(n, expr);
                this.reportCodeChange();
                return expr;
            }
            Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
            thenOp.detach();
            elseOp.detach();
            Node expr = IR.exprResult(IR.hook(replacementCond, thenOp, elseOp).srcref(n));
            parent.replaceChild(n, expr);
            this.reportCodeChange();
            return expr;
        }
        boolean thenBranchIsVar = PeepholeMinimizeConditions.isVarBlock(thenBranch);
        boolean elseBranchIsVar = PeepholeMinimizeConditions.isVarBlock(elseBranch);
        if (thenBranchIsVar && elseBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(thenBranch);
            Node elseAssign = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            Node name1 = var.getFirstChild();
            Node maybeName2 = elseAssign.getFirstChild();
            if (name1.hasChildren() && maybeName2.isName() && name1.getString().equals(maybeName2.getString())) {
                Preconditions.checkState((boolean)name1.hasOneChild());
                Node thenExpr = name1.removeFirstChild();
                Node elseExpr = elseAssign.getLastChild().detach();
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                var.detach();
                name1.addChildToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        } else if (elseBranchIsVar && thenBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(elseBranch);
            Node thenAssign = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node maybeName1 = thenAssign.getFirstChild();
            Node name2 = var.getFirstChild();
            if (name2.hasChildren() && maybeName1.isName() && maybeName1.getString().equals(name2.getString())) {
                Node thenExpr = thenAssign.getLastChild().detach();
                Preconditions.checkState((boolean)name2.hasOneChild());
                Node elseExpr = name2.removeFirstChild();
                Node replacementCond = this.replaceNode(originalCond, shortCond).detach();
                Node hookNode = IR.hook(replacementCond, thenExpr, elseExpr).srcref(n);
                var.detach();
                name2.addChildToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        }
        this.replaceNode(originalCond, unnegatedCond);
        return n;
    }

    private void tryRemoveRepeatedStatements(Node n) {
        Preconditions.checkState((boolean)n.isIf(), (Object)n);
        Node parent = n.getParent();
        if (!NodeUtil.isStatementBlock(parent)) {
            return;
        }
        Node cond = n.getFirstChild();
        Node trueBranch = cond.getNext();
        Node falseBranch = trueBranch.getNext();
        Preconditions.checkNotNull((Object)trueBranch);
        Preconditions.checkNotNull((Object)falseBranch);
        while (true) {
            Node lastTrue = trueBranch.getLastChild();
            Node lastFalse = falseBranch.getLastChild();
            if (lastTrue == null || lastFalse == null || !this.areNodesEqualForInlining(lastTrue, lastFalse)) break;
            lastTrue.detach();
            lastFalse.detach();
            parent.addChildAfter(lastTrue, n);
            this.reportCodeChange();
        }
    }

    private static boolean isFoldableExpressBlock(Node n) {
        if (n.isNormalBlock() && n.hasOneChild()) {
            Node maybeExpr = n.getFirstChild();
            if (maybeExpr.isExprResult()) {
                if (maybeExpr.getFirstChild().isCall()) {
                    Node calledFn = maybeExpr.getFirstFirstChild();
                    if (calledFn.isGetElem()) {
                        return false;
                    }
                    if (calledFn.isGetProp() && calledFn.getLastChild().getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static Node getBlockExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isFoldableExpressBlock(n));
        return n.getFirstChild();
    }

    private static boolean isReturnBlock(Node n) {
        if (n.isNormalBlock() && n.hasOneChild()) {
            Node first = n.getFirstChild();
            return first.isReturn();
        }
        return false;
    }

    private static boolean isReturnExpressBlock(Node n) {
        Node first;
        if (n.isNormalBlock() && n.hasOneChild() && (first = n.getFirstChild()).isReturn()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static boolean isReturnExpression(Node n) {
        if (n.isReturn()) {
            return n.hasOneChild();
        }
        return false;
    }

    private static Node getBlockReturnExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isReturnExpressBlock(n));
        return n.getFirstFirstChild();
    }

    private static boolean isVarBlock(Node n) {
        Node first;
        if (n.isNormalBlock() && n.hasOneChild() && (first = n.getFirstChild()).isVar()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static Node getBlockVar(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isVarBlock(n));
        return n.getFirstChild();
    }

    private static boolean consumesDanglingElse(Node n) {
        block5: while (true) {
            switch (n.getToken()) {
                case IF: {
                    if (n.getChildCount() < 3) {
                        return true;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case BLOCK: {
                    if (!n.hasOneChild()) {
                        return false;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case WHILE: 
                case FOR: 
                case WITH: 
                case FOR_IN: {
                    n = n.getLastChild();
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    static boolean isLowerPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getToken()) < precedence;
    }

    private static boolean isPropertyAssignmentInExpression(Node n) {
        Predicate<Node> isPropertyAssignmentInExpressionPredicate = new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.isGetProp() && input.getParent().isAssign();
            }
        };
        return NodeUtil.has(n, isPropertyAssignmentInExpressionPredicate, NodeUtil.MATCH_NOT_FUNCTION);
    }

    private Node tryMinimizeCondition(Node n) {
        n = this.performCoercionSubstitutions(n);
        n = this.performConditionSubstitutions(n);
        MinimizedCondition minCond = MinimizedCondition.fromConditionNode(n);
        return this.replaceNode(n, minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED));
    }

    private Node performCoercionSubstitutions(Node n) {
        if (!this.useTypes) {
            return n;
        }
        switch (n.getToken()) {
            case OR: 
            case AND: {
                this.performCoercionSubstitutions(n.getFirstChild());
                this.performCoercionSubstitutions(n.getLastChild());
                break;
            }
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return this.tryReplaceComparisonWithCoercion(n, false);
            }
        }
        return n;
    }

    private Node tryReplaceComparisonWithCoercion(Node n, boolean booleanResult) {
        if (!this.useTypes) {
            return n;
        }
        Token op = n.getToken();
        boolean isShallow = op == Token.SHEQ || op == Token.SHNE;
        Preconditions.checkArgument((op == Token.EQ || op == Token.NE || isShallow ? 1 : 0) != 0);
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        BooleanCoercability booleanCoercability = this.canConvertComparisonToBooleanCoercion(left, right, isShallow);
        if (booleanCoercability != BooleanCoercability.NONE) {
            Node objExpression;
            n.detachChildren();
            Node node = objExpression = booleanCoercability == BooleanCoercability.LEFT ? left : right;
            Node replacement = n.getToken() == Token.EQ || n.getToken() == Token.SHEQ ? IR.not(objExpression) : (booleanResult ? IR.not(IR.not(objExpression)).srcrefTree(n) : objExpression);
            n.replaceWith(replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private BooleanCoercability canConvertComparisonToBooleanCoercion(Node left, Node right, boolean isShallow) {
        boolean leftIsNull = left.isNull();
        boolean rightIsNull = right.isNull();
        boolean leftIsUndefined = NodeUtil.isUndefined(left);
        boolean rightIsUndefined = NodeUtil.isUndefined(right);
        boolean leftIsNullOrUndefined = leftIsNull || leftIsUndefined;
        boolean rightIsNullOrUndefined = rightIsNull || rightIsUndefined;
        boolean leftIsObjectType = PeepholeMinimizeConditions.isObjectType(left);
        boolean rightIsObjectType = PeepholeMinimizeConditions.isObjectType(right);
        if (isShallow ? leftIsObjectType && !left.getTypeI().isNullable() && rightIsUndefined || rightIsObjectType && !right.getTypeI().isNullable() && leftIsUndefined : leftIsObjectType && rightIsNullOrUndefined || rightIsObjectType && leftIsNullOrUndefined) {
            return leftIsNullOrUndefined ? BooleanCoercability.RIGHT : BooleanCoercability.LEFT;
        }
        return BooleanCoercability.NONE;
    }

    private static boolean isObjectType(Node n) {
        TypeI type = n.getTypeI();
        if (type == null) {
            return false;
        }
        return !(type = type.restrictByNotNullOrUndefined()).isUnknownType() && !type.isBottom() && !type.isTop() && type.isObjectType();
    }

    private Node replaceNode(Node original, MinimizedCondition.MeasuredNode measuredNodeReplacement) {
        if (measuredNodeReplacement.willChange(original)) {
            Node replacement = measuredNodeReplacement.applyTo(original);
            this.reportCodeChange();
            return replacement;
        }
        return original;
    }

    private Node performConditionSubstitutions(Node n) {
        Node parent = n.getParent();
        switch (n.getToken()) {
            case OR: 
            case AND: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                left = this.performConditionSubstitutions(left);
                right = this.performConditionSubstitutions(right);
                TernaryValue rightVal = NodeUtil.getPureBooleanValue(right);
                if (NodeUtil.getPureBooleanValue(right) != TernaryValue.UNKNOWN) {
                    Token type = n.getToken();
                    Node replacement = null;
                    boolean rval = rightVal.toBoolean(true);
                    if (type == Token.OR && !rval || type == Token.AND && rval) {
                        replacement = left;
                    } else if (!this.mayHaveSideEffects(left)) {
                        replacement = right;
                    } else {
                        n.detachChildren();
                        replacement = IR.comma(left, right);
                    }
                    if (replacement != null) {
                        n.detachChildren();
                        parent.replaceChild(n, replacement);
                        this.reportCodeChange();
                        return replacement;
                    }
                }
                return n;
            }
            case HOOK: {
                Node condition = n.getFirstChild();
                Node trueNode = n.getSecondChild();
                Node falseNode = n.getLastChild();
                trueNode = this.performConditionSubstitutions(trueNode);
                falseNode = this.performConditionSubstitutions(falseNode);
                Node replacement = null;
                TernaryValue trueNodeVal = NodeUtil.getPureBooleanValue(trueNode);
                TernaryValue falseNodeVal = NodeUtil.getPureBooleanValue(falseNode);
                if (trueNodeVal == TernaryValue.TRUE && falseNodeVal == TernaryValue.FALSE) {
                    condition.detach();
                    replacement = condition;
                } else if (trueNodeVal == TernaryValue.FALSE && falseNodeVal == TernaryValue.TRUE) {
                    condition.detach();
                    replacement = IR.not(condition);
                } else if (trueNodeVal == TernaryValue.TRUE) {
                    n.detachChildren();
                    replacement = IR.or(condition, falseNode);
                } else if (falseNodeVal == TernaryValue.FALSE) {
                    n.detachChildren();
                    replacement = IR.and(condition, trueNode);
                } else if (!this.mayHaveSideEffects(condition) && !this.mayHaveSideEffects(trueNode) && condition.isEquivalentTo(trueNode)) {
                    n.detachChildren();
                    replacement = IR.or(trueNode, falseNode);
                }
                if (replacement != null) {
                    parent.replaceChild(n, replacement);
                    n = replacement;
                    this.reportCodeChange();
                }
                return n;
            }
        }
        TernaryValue nVal = NodeUtil.getPureBooleanValue(n);
        if (nVal != TernaryValue.UNKNOWN) {
            boolean result = nVal.toBoolean(true);
            int equivalentResult = result ? 1 : 0;
            return this.maybeReplaceChildWithNumber(n, parent, equivalentResult);
        }
        return n;
    }

    private Node maybeReplaceChildWithNumber(Node n, Node parent, int num) {
        Node newNode = IR.number(num);
        if (!newNode.isEquivalentTo(n)) {
            parent.replaceChild(n, newNode);
            NodeUtil.markFunctionsDeleted(n, this.compiler);
            this.reportCodeChange();
            return newNode;
        }
        return n;
    }

    private static enum BooleanCoercability {
        NONE,
        LEFT,
        RIGHT;

    }
}

