/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.TernaryValue;
import javax.annotation.Nullable;

class MinimizeExitPoints
extends AbstractPeepholeOptimization {
    AbstractCompiler compiler;

    MinimizeExitPoints(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @VisibleForTesting
    final CompilerPass asCompilerPass() {
        return new PeepholeOptimizationsPass(this.compiler, this.getClass().getSimpleName(), this);
    }

    @Override
    Node optimizeSubtree(Node n) {
        switch (n.getToken()) {
            case LABEL: {
                this.tryMinimizeExits(n.getLastChild(), Token.BREAK, n.getFirstChild().getString());
                break;
            }
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case WHILE: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(n), Token.CONTINUE, null);
                break;
            }
            case DO: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(n), Token.CONTINUE, null);
                Node cond = NodeUtil.getConditionExpression(n);
                if (NodeUtil.getPureBooleanValue(cond) != TernaryValue.FALSE) break;
                this.tryMinimizeExits(n.getFirstChild(), Token.BREAK, null);
                break;
            }
            case BLOCK: {
                if (n.getParent() == null || !n.getParent().isFunction()) break;
                this.tryMinimizeExits(n, Token.RETURN, null);
                break;
            }
            case SWITCH: {
                this.tryMinimizeSwitchExits(n, Token.BREAK, null);
                break;
            }
        }
        return n;
    }

    void tryMinimizeExits(Node n, Token exitType, @Nullable String labelName) {
        Node c;
        if (MinimizeExitPoints.matchingExitNode(n, exitType, labelName)) {
            this.compiler.reportChangeToEnclosingScope(n);
            NodeUtil.removeChild(n.getParent(), n);
            return;
        }
        if (n.isIf()) {
            Node ifBlock = n.getSecondChild();
            this.tryMinimizeExits(ifBlock, exitType, labelName);
            Node elseBlock = ifBlock.getNext();
            if (elseBlock != null) {
                this.tryMinimizeExits(elseBlock, exitType, labelName);
            }
            return;
        }
        if (n.isTry()) {
            Node tryBlock = n.getFirstChild();
            this.tryMinimizeExits(tryBlock, exitType, labelName);
            Node allCatchNodes = NodeUtil.getCatchBlock(n);
            if (NodeUtil.hasCatchHandler(allCatchNodes)) {
                Preconditions.checkState((boolean)allCatchNodes.hasOneChild());
                Node catchNode = allCatchNodes.getFirstChild();
                Node catchCodeBlock = catchNode.getLastChild();
                this.tryMinimizeExits(catchCodeBlock, exitType, labelName);
            }
        }
        if (n.isLabel()) {
            Node labelBlock = n.getLastChild();
            this.tryMinimizeExits(labelBlock, exitType, labelName);
        }
        if (n.isSwitch() && (exitType != Token.BREAK || labelName != null)) {
            this.tryMinimizeSwitchExits(n, exitType, labelName);
            return;
        }
        if (!n.isNormalBlock() || !n.hasChildren()) {
            return;
        }
        for (c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isIf()) {
                Node ifTree = c;
                Node trueBlock = ifTree.getSecondChild();
                Node falseBlock = trueBlock.getNext();
                this.tryMinimizeIfBlockExits(trueBlock, falseBlock, ifTree, exitType, labelName);
                trueBlock = ifTree.getSecondChild();
                falseBlock = trueBlock.getNext();
                if (falseBlock != null) {
                    this.tryMinimizeIfBlockExits(falseBlock, trueBlock, ifTree, exitType, labelName);
                }
            }
            if (c == n.getLastChild()) break;
        }
        c = n.getLastChild();
        while (c != null) {
            this.tryMinimizeExits(c, exitType, labelName);
            if (c == n.getLastChild()) break;
            c = n.getLastChild();
        }
    }

    void tryMinimizeSwitchExits(Node n, Token exitType, @Nullable String labelName) {
        Preconditions.checkState((boolean)n.isSwitch());
        for (Node c = n.getSecondChild(); c != null; c = c.getNext()) {
            if (c != n.getLastChild()) {
                this.tryMinimizeSwitchCaseExits(c, exitType, labelName);
                continue;
            }
            this.tryMinimizeExits(c.getLastChild(), exitType, labelName);
        }
    }

    void tryMinimizeSwitchCaseExits(Node n, Token exitType, @Nullable String labelName) {
        Preconditions.checkState((boolean)NodeUtil.isSwitchCase(n));
        Preconditions.checkState((n != n.getParent().getLastChild() ? 1 : 0) != 0);
        Node block = n.getLastChild();
        Node maybeBreak = block.getLastChild();
        if (maybeBreak == null || !maybeBreak.isBreak() || maybeBreak.hasChildren()) {
            return;
        }
        Node childBeforeBreak = maybeBreak.getPrevious();
        while (childBeforeBreak != null) {
            Node c = childBeforeBreak;
            this.tryMinimizeExits(c, exitType, labelName);
            childBeforeBreak = maybeBreak.getPrevious();
            if (c != childBeforeBreak) continue;
            break;
        }
    }

    private void tryMinimizeIfBlockExits(Node srcBlock, Node destBlock, Node ifNode, Token exitType, @Nullable String labelName) {
        Node exitNodeParent = null;
        Node exitNode = null;
        if (srcBlock.isNormalBlock()) {
            if (!srcBlock.hasChildren()) {
                return;
            }
            exitNodeParent = srcBlock;
            exitNode = exitNodeParent.getLastChild();
        } else {
            exitNodeParent = ifNode;
            exitNode = srcBlock;
        }
        if (!MinimizeExitPoints.matchingExitNode(exitNode, exitType, labelName)) {
            return;
        }
        if (ifNode.getNext() != null) {
            Node newDestBlock = IR.block().srcref(ifNode);
            if (destBlock == null) {
                ifNode.addChildToBack(newDestBlock);
            } else if (destBlock.isEmpty()) {
                ifNode.replaceChild(destBlock, newDestBlock);
            } else if (destBlock.isNormalBlock()) {
                newDestBlock = destBlock;
            } else {
                ifNode.replaceChild(destBlock, newDestBlock);
                newDestBlock.addChildToBack(destBlock);
            }
            MinimizeExitPoints.moveAllFollowing(ifNode, ifNode.getParent(), newDestBlock);
            this.compiler.reportChangeToEnclosingScope(ifNode);
        }
    }

    private static boolean matchingExitNode(Node n, Token type, @Nullable String labelName) {
        if (n.getToken() == type) {
            if (type == Token.RETURN) {
                return !n.hasChildren();
            }
            if (labelName == null) {
                return !n.hasChildren();
            }
            return n.hasChildren() && labelName.equals(n.getFirstChild().getString());
        }
        return false;
    }

    private static void moveAllFollowing(Node start, Node srcParent, Node destParent) {
        Node n = start.getNext();
        while (n != null) {
            boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(n);
            srcParent.removeChild(n);
            if (isFunctionDeclaration) {
                destParent.addChildToFront(n);
            } else {
                destParent.addChildToBack(n);
            }
            n = start.getNext();
        }
    }
}

