/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.LintPassConfig;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.FixingErrorManager;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Linter {
    @Option(name="--fix", usage="Fix lint warnings automatically")
    private boolean fix = false;
    @Argument
    private List<String> files = new ArrayList<String>();

    public static void main(String[] args) throws IOException, CmdLineException {
        new Linter().run(args);
    }

    private void run(String[] args) throws IOException, CmdLineException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.parseArgument(args);
        for (String filename : this.files) {
            if (this.fix) {
                Linter.fix(filename);
                continue;
            }
            Linter.lint(filename);
        }
    }

    static void lint(String filename) throws IOException {
        Linter.lint(Paths.get(filename, new String[0]), new Compiler(System.out));
    }

    static void fix(String filename) throws IOException {
        Compiler compiler = new Compiler(System.out);
        FixingErrorManager errorManager = new FixingErrorManager();
        compiler.setErrorManager(errorManager);
        errorManager.setCompiler(compiler);
        Linter.lint(Paths.get(filename, new String[0]), compiler);
        ApplySuggestedFixes.applySuggestedFixesToFiles(errorManager.getAllFixes());
    }

    static void lint(Path path, Compiler compiler) throws IOException {
        SourceFile file = SourceFile.fromFile(path.toString());
        CompilerOptions options = new CompilerOptions();
        options.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
        options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_DESCRIPTIONS_WITH_WHITESPACE);
        options.setCodingConvention(new GoogleCodingConvention());
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.JSDOC_MISSING_TYPE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.MISPLACED_MSG_ANNOTATION, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNNECESSARY_ESCAPE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNUSED_LOCAL_VARIABLE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.STRICT_MISSING_REQUIRE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.ERROR);
        options.setWarningLevel(DiagnosticGroups.USE_OF_GOOG_BASE, CheckLevel.WARNING);
        options.setSummaryDetailLevel(0);
        compiler.setPassConfig(new LintPassConfig(options));
        compiler.disableThreads();
        SourceFile externs = SourceFile.fromCode("<Linter externs>", "");
        compiler.compile(ImmutableList.of((Object)externs), ImmutableList.of((Object)file), options);
    }
}

