/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class FunctionToBlockMutator {
    private AbstractCompiler compiler;
    private Supplier<String> safeNameIdSupplier;

    FunctionToBlockMutator(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier) {
        this.compiler = compiler;
        this.safeNameIdSupplier = safeNameIdSupplier;
    }

    Node mutate(String fnName, Node fnNode, Node callNode, String resultName, boolean needsDefaultResult, boolean isCallInLoop) {
        return this.mutateInternal(fnName, fnNode, callNode, resultName, needsDefaultResult, isCallInLoop, true);
    }

    Node unwrapIifeInModule(String fnName, Node fnNode, Node callNode) {
        return this.mutateInternal(fnName, fnNode, callNode, null, false, false, false);
    }

    private Node mutateInternal(String fnName, Node fnNode, Node callNode, String resultName, boolean needsDefaultResult, boolean isCallInLoop, boolean renameLocals) {
        String labelName;
        Node injectableBlock;
        boolean hasArgs;
        Node newFnNode = fnNode.cloneTree();
        if (renameLocals) {
            this.makeLocalNamesUnique(newFnNode, isCallInLoop);
            FunctionToBlockMutator.rewriteFunctionDeclarations(newFnNode.getLastChild());
        }
        Set<String> namesToAlias = FunctionArgumentInjector.findModifiedParameters(newFnNode);
        LinkedHashMap<String, Node> args = FunctionArgumentInjector.getFunctionCallParameterMap(newFnNode, callNode, this.safeNameIdSupplier);
        boolean bl = hasArgs = !args.isEmpty();
        if (hasArgs) {
            FunctionArgumentInjector.maybeAddTempsForCallArguments(newFnNode, args, namesToAlias, this.compiler.getCodingConvention());
        }
        Node newBlock = NodeUtil.getFunctionBody(newFnNode);
        newBlock.detach();
        if (hasArgs) {
            Node inlineResult = this.aliasAndInlineArguments(newBlock, args, namesToAlias);
            Preconditions.checkState((newBlock == inlineResult ? 1 : 0) != 0);
        }
        if (isCallInLoop) {
            FunctionToBlockMutator.fixUninitializedVarDeclarations(newBlock, newBlock);
        }
        Preconditions.checkState(((injectableBlock = FunctionToBlockMutator.replaceReturns(newBlock, resultName, labelName = this.getLabelNameForFunction(fnName), needsDefaultResult)) != null ? 1 : 0) != 0);
        return injectableBlock;
    }

    private static Node rewriteFunctionDeclarations(Node n) {
        if (n.isFunction()) {
            if (NodeUtil.isFunctionDeclaration(n)) {
                Node fnNameNode = n.getFirstChild();
                Node name = IR.name(fnNameNode.getString()).srcref(fnNameNode);
                Node var = IR.var(name).srcref(n);
                fnNameNode.setString("");
                n.replaceWith(var);
                name.addChildToFront(n);
                return var;
            }
            return null;
        }
        ArrayList<Node> functionsToHoist = new ArrayList<Node>();
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            Node fnVar = FunctionToBlockMutator.rewriteFunctionDeclarations(c);
            if (fnVar != null) {
                functionsToHoist.add(0, fnVar);
            }
            c = next;
        }
        for (Node fnVar : functionsToHoist) {
            if (n.getFirstChild() == fnVar) continue;
            n.addChildToFront(fnVar.detach());
        }
        return null;
    }

    private static void fixUninitializedVarDeclarations(Node n, Node containingBlock) {
        if (NodeUtil.isLoopStructure(n)) {
            return;
        }
        if (n.isVar() && n.hasOneChild()) {
            Node name = n.getFirstChild();
            if (!name.hasChildren()) {
                Node srcLocation = name;
                name.addChildToBack(NodeUtil.newUndefinedNode(srcLocation));
                containingBlock.addChildToFront(n.detach());
            }
            return;
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            FunctionToBlockMutator.fixUninitializedVarDeclarations(c, containingBlock);
        }
    }

    private void makeLocalNamesUnique(Node fnNode, boolean isCallInLoop) {
        Supplier<String> idSupplier = this.compiler.getUniqueNameIdSupplier();
        NodeTraversal.traverseEs6(this.compiler, fnNode, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.InlineRenamer(this.compiler.getCodingConvention(), idSupplier, "inline_", isCallInLoop, true, null), false));
        new RenameLabels(this.compiler, new LabelNameSupplier(idSupplier), false, false).process(null, fnNode);
    }

    private String getLabelNameForFunction(String fnName) {
        String name = Strings.isNullOrEmpty((String)fnName) ? "anon" : fnName;
        return "JSCompiler_inline_label_" + name + "_" + (String)this.safeNameIdSupplier.get();
    }

    private String getUniqueThisName() {
        return "JSCompiler_inline_this_" + (String)this.safeNameIdSupplier.get();
    }

    private Node aliasAndInlineArguments(Node fnTemplateRoot, LinkedHashMap<String, Node> argMap, Set<String> namesToAlias) {
        if (namesToAlias == null || namesToAlias.isEmpty()) {
            Node result = FunctionArgumentInjector.inject(this.compiler, fnTemplateRoot, null, argMap);
            Preconditions.checkState((result == fnTemplateRoot ? 1 : 0) != 0);
            return result;
        }
        HashMap<String, Node> newArgMap = new HashMap<String, Node>(argMap);
        LinkedList<Node> newVars = new LinkedList<Node>();
        for (Map.Entry<String, Node> entry : argMap.entrySet()) {
            String name = entry.getKey();
            if (!namesToAlias.contains(name)) continue;
            if (name.equals("this")) {
                boolean referencesThis = NodeUtil.referencesThis(fnTemplateRoot);
                Node value = entry.getValue();
                if (value.isThis() || !referencesThis && !NodeUtil.mayHaveSideEffects(value, this.compiler)) continue;
                String newName = this.getUniqueThisName();
                Node newValue = entry.getValue().cloneTree();
                Node newNode = NodeUtil.newVarNode(newName, newValue).useSourceInfoIfMissingFromForTree(newValue);
                newVars.add(0, newNode);
                newArgMap.put("this", IR.name(newName).srcrefTree(newValue));
                continue;
            }
            Node newValue = entry.getValue().cloneTree();
            Node newNode = NodeUtil.newVarNode(name, newValue).useSourceInfoIfMissingFromForTree(newValue);
            newVars.add(0, newNode);
            newArgMap.remove(name);
        }
        Node result = FunctionArgumentInjector.inject(this.compiler, fnTemplateRoot, null, newArgMap);
        Preconditions.checkState((result == fnTemplateRoot ? 1 : 0) != 0);
        for (Node n : newVars) {
            fnTemplateRoot.addChildToFront(n);
        }
        return result;
    }

    private static Node replaceReturns(Node block, String resultName, String labelName, boolean resultMustBeSet) {
        Preconditions.checkNotNull((Object)block);
        Preconditions.checkNotNull((Object)labelName);
        Node root = block;
        boolean hasReturnAtExit = false;
        int returnCount = NodeUtil.getNodeTypeReferenceCount(block, Token.RETURN, new NodeUtil.MatchShallowStatement());
        if (returnCount > 0) {
            hasReturnAtExit = FunctionToBlockMutator.hasReturnAtExit(block);
            if (hasReturnAtExit) {
                FunctionToBlockMutator.convertLastReturnToStatement(block, resultName);
                --returnCount;
            }
            if (returnCount > 0) {
                FunctionToBlockMutator.replaceReturnWithBreak(block, null, resultName, labelName);
                Node name = IR.labelName(labelName).srcref(block);
                Node label = IR.label(name, block).srcref(block);
                Node newRoot = IR.block().srcref(block);
                newRoot.addChildToBack(label);
                root = newRoot;
            }
        }
        if (resultMustBeSet && !hasReturnAtExit && resultName != null) {
            FunctionToBlockMutator.addDummyAssignment(block, resultName);
        }
        return root;
    }

    private static void addDummyAssignment(Node node, String resultName) {
        Preconditions.checkArgument((boolean)node.isNormalBlock());
        Node srcLocation = node;
        Node retVal = NodeUtil.newUndefinedNode(srcLocation);
        Node resultNode = FunctionToBlockMutator.createAssignStatementNode(resultName, retVal);
        resultNode.useSourceInfoIfMissingFromForTree(node);
        node.addChildToBack(resultNode);
    }

    private static void convertLastReturnToStatement(Node block, String resultName) {
        Node ret = block.getLastChild();
        Preconditions.checkArgument((boolean)ret.isReturn());
        Node resultNode = FunctionToBlockMutator.getReplacementReturnStatement(ret, resultName);
        if (resultNode == null) {
            block.removeChild(ret);
        } else {
            resultNode.useSourceInfoIfMissingFromForTree(ret);
            block.replaceChild(ret, resultNode);
        }
    }

    private static Node createAssignStatementNode(String name, Node expression) {
        Node nameNode = IR.name(name);
        Node assign = IR.assign(nameNode, expression);
        return NodeUtil.newExpr(assign);
    }

    private static Node getReplacementReturnStatement(Node node, String resultName) {
        Node resultNode = null;
        Node retVal = null;
        if (node.hasChildren()) {
            retVal = node.getFirstChild().cloneTree();
        }
        if (resultName == null) {
            if (retVal != null) {
                resultNode = NodeUtil.newExpr(retVal);
            }
        } else {
            if (retVal == null) {
                Node srcLocation = node;
                retVal = NodeUtil.newUndefinedNode(srcLocation);
            }
            resultNode = FunctionToBlockMutator.createAssignStatementNode(resultName, retVal);
        }
        return resultNode;
    }

    private static boolean hasReturnAtExit(Node block) {
        return block.getLastChild().isReturn();
    }

    private static Node replaceReturnWithBreak(Node current, Node parent, String resultName, String labelName) {
        if (current.isFunction() || current.isExprResult()) {
            return current;
        }
        if (current.isReturn()) {
            Preconditions.checkState((boolean)NodeUtil.isStatementBlock(parent));
            Node resultNode = FunctionToBlockMutator.getReplacementReturnStatement(current, resultName);
            Node breakNode = IR.breakNode(IR.labelName(labelName));
            breakNode.useSourceInfoIfMissingFromForTree(current);
            parent.replaceChild(current, breakNode);
            if (resultNode != null) {
                resultNode.useSourceInfoIfMissingFromForTree(current);
                parent.addChildBefore(resultNode, breakNode);
            }
            current = breakNode;
        } else {
            for (Node c = current.getFirstChild(); c != null; c = c.getNext()) {
                c = FunctionToBlockMutator.replaceReturnWithBreak(c, current, resultName, labelName);
            }
        }
        return current;
    }

    static class LabelNameSupplier
    implements Supplier<String> {
        final Supplier<String> idSupplier;

        LabelNameSupplier(Supplier<String> idSupplier) {
            this.idSupplier = idSupplier;
        }

        public String get() {
            return "JSCompiler_inline_label_" + (String)this.idSupplier.get();
        }
    }
}

