/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Es6ToEs3ClassSideInheritance
implements HotSwapCompilerPass {
    static final DiagnosticType DUPLICATE_CLASS = DiagnosticType.error("DUPLICATE_CLASS", "Multiple classes cannot share the same name.");
    private final Set<String> duplicateClassNames = new HashSet<String>();
    private final AbstractCompiler compiler;
    private final LinkedHashMap<String, JavascriptClass> classByAlias = new LinkedHashMap();

    public Es6ToEs3ClassSideInheritance(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindStaticMembers findStaticMembers = new FindStaticMembers();
        TranspilationPasses.processTranspile(this.compiler, externs, findStaticMembers);
        TranspilationPasses.processTranspile(this.compiler, root, findStaticMembers);
        this.processInherits(findStaticMembers.inheritsCalls);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        FindStaticMembers findStaticMembers = new FindStaticMembers();
        TranspilationPasses.processTranspile(this.compiler, scriptRoot, findStaticMembers);
        this.processInherits(findStaticMembers.inheritsCalls);
    }

    private void processInherits(List<Node> inheritsCalls) {
        for (Node inheritsCall : inheritsCalls) {
            Node superclassNameNode = inheritsCall.getLastChild();
            String superclassQname = superclassNameNode.getQualifiedName();
            Node subclassNameNode = superclassNameNode.getPrevious();
            String subclassQname = subclassNameNode.getQualifiedName();
            JavascriptClass superClass = this.classByAlias.get(superclassQname);
            JavascriptClass subClass = this.classByAlias.get(subclassQname);
            if (this.duplicateClassNames.contains(superclassQname)) {
                this.compiler.report(JSError.make(inheritsCall, DUPLICATE_CLASS, new String[0]));
                return;
            }
            if (superClass == null || subClass == null) continue;
            this.copyStaticMembers(superClass, subClass, inheritsCall);
            this.copyDeclarations(superClass, subClass, inheritsCall);
        }
    }

    private void copyDeclarations(JavascriptClass superClass, JavascriptClass subClass, Node inheritsCall) {
        for (Node staticGetProp : superClass.staticFieldAccess) {
            Preconditions.checkState((boolean)staticGetProp.isGetProp());
            String memberName = staticGetProp.getLastChild().getString();
            if (!superClass.definedProperties.contains(memberName) || this.isOverriden(subClass, memberName)) continue;
            Node subclassNameNode = inheritsCall.getSecondChild();
            Node getprop = IR.getprop(subclassNameNode.cloneTree(), IR.string(memberName));
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(staticGetProp.getJSDocInfo());
            JSTypeExpression unknown = new JSTypeExpression(new Node(Token.QMARK), "<synthetic>");
            info.recordType(unknown);
            info.addSuppression("visibility");
            getprop.setJSDocInfo(info.build());
            Node declaration = IR.exprResult(getprop);
            declaration.useSourceInfoIfMissingFromForTree(inheritsCall);
            Node parent = inheritsCall.getParent();
            parent.getParent().addChildBefore(declaration, parent);
            this.compiler.reportChangeToEnclosingScope(parent);
            if (subClass.definedProperties.contains(memberName)) continue;
            subClass.staticFieldAccess.add(getprop);
            subClass.definedProperties.add(memberName);
        }
    }

    private void copyStaticMembers(JavascriptClass superClass, JavascriptClass subClass, Node inheritsCall) {
        for (Node staticMember : superClass.staticMembers) {
            Node function;
            Preconditions.checkState((boolean)staticMember.isAssign(), (Object)staticMember);
            String memberName = staticMember.getFirstChild().getLastChild().getString();
            if (superClass.definedProperties.contains(memberName) || this.isOverriden(subClass, memberName)) continue;
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(staticMember.getJSDocInfo());
            Node sourceInfoNode = function = staticMember.getLastChild();
            if (function.isFunction()) {
                sourceInfoNode = function.getFirstChild();
                Node params = NodeUtil.getFunctionParameters(function);
                Preconditions.checkState((boolean)params.isParamList(), (Object)params);
                for (Node param : params.children()) {
                    if (param.getJSDocInfo() == null) continue;
                    String name = param.getString();
                    info.recordParameter(name, param.getJSDocInfo().getType());
                }
            }
            Node subclassNameNode = inheritsCall.getSecondChild();
            Node superclassNameNode = subclassNameNode.getNext();
            Node assign = IR.assign(IR.getprop(subclassNameNode.cloneTree(), IR.string(memberName)), IR.getprop(superclassNameNode.cloneTree(), IR.string(memberName)));
            info.addSuppression("visibility");
            assign.setJSDocInfo(info.build());
            Node exprResult = IR.exprResult(assign);
            exprResult.useSourceInfoIfMissingFromForTree(sourceInfoNode);
            Node inheritsExpressionResult = inheritsCall.getParent();
            inheritsExpressionResult.getParent().addChildAfter(exprResult, inheritsExpressionResult);
            this.compiler.reportChangeToEnclosingScope(inheritsExpressionResult);
            subClass.staticMembers.add(assign);
        }
    }

    private boolean isOverriden(JavascriptClass subClass, String memberName) {
        for (Node subclassMember : subClass.staticMembers) {
            Preconditions.checkState((boolean)subclassMember.isAssign(), (Object)subclassMember);
            if (!subclassMember.getFirstChild().getLastChild().getString().equals(memberName)) continue;
            return true;
        }
        return subClass.definedProperties.contains(memberName);
    }

    private boolean isReferenceToClass(NodeTraversal t, Node n) {
        String className = n.getQualifiedName();
        if (!this.classByAlias.containsKey(className)) {
            return false;
        }
        if (!n.isName()) {
            return true;
        }
        Var var = t.getScope().getVar(className);
        return var == null || !var.isLocal();
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final List<Node> inheritsCalls = new LinkedList<Node>();

        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    if (n.getFirstChild().matchesQualifiedName("$jscomp.inherits")) {
                        this.inheritsCalls.add(n);
                    }
                    if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) break;
                    this.visitDefinedPropertiesCall(t, n);
                    break;
                }
                case VAR: {
                    this.visitVar(n);
                    break;
                }
                case ASSIGN: {
                    this.visitAssign(t, n);
                    break;
                }
                case GETPROP: {
                    if (!parent.isExprResult()) break;
                    this.visitGetProp(t, n);
                    break;
                }
                case FUNCTION: {
                    this.visitFunctionClassDef(n);
                    break;
                }
            }
        }

        private void visitDefinedPropertiesCall(NodeTraversal t, Node definePropertiesCall) {
            Node object = definePropertiesCall.getSecondChild();
            if (Es6ToEs3ClassSideInheritance.this.isReferenceToClass(t, object)) {
                String className = object.getQualifiedName();
                JavascriptClass c = (JavascriptClass)Es6ToEs3ClassSideInheritance.this.classByAlias.get(className);
                for (Node prop : NodeUtil.getObjectDefinedPropertiesKeys(definePropertiesCall)) {
                    c.definedProperties.add(prop.getString());
                }
            }
        }

        private void visitFunctionClassDef(Node n) {
            JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(n);
            if (classInfo != null && classInfo.isConstructor()) {
                String name = NodeUtil.getName(n);
                if (Es6ToEs3ClassSideInheritance.this.classByAlias.containsKey(name)) {
                    Es6ToEs3ClassSideInheritance.this.duplicateClassNames.add(name);
                } else {
                    Es6ToEs3ClassSideInheritance.this.classByAlias.put(name, new JavascriptClass());
                }
            }
        }

        private void setAlias(String original, String alias) {
            Preconditions.checkArgument((boolean)Es6ToEs3ClassSideInheritance.this.classByAlias.containsKey(original));
            Es6ToEs3ClassSideInheritance.this.classByAlias.put(alias, Es6ToEs3ClassSideInheritance.this.classByAlias.get(original));
        }

        private void visitGetProp(NodeTraversal t, Node n) {
            Node classNode = n.getFirstChild();
            if (Es6ToEs3ClassSideInheritance.this.isReferenceToClass(t, classNode)) {
                ((JavascriptClass)Es6ToEs3ClassSideInheritance.this.classByAlias.get(classNode.getQualifiedName())).staticFieldAccess.add(n);
            }
        }

        private void visitAssign(NodeTraversal t, Node n) {
            Node getProp;
            Node classNode;
            String existingClassQname = n.getLastChild().getQualifiedName();
            if (existingClassQname != null && Es6ToEs3ClassSideInheritance.this.classByAlias.containsKey(existingClassQname)) {
                String alias = n.getFirstChild().getQualifiedName();
                if (alias != null) {
                    this.setAlias(existingClassQname, alias);
                }
            } else if (n.getFirstChild().isGetProp() && Es6ToEs3ClassSideInheritance.this.isReferenceToClass(t, classNode = (getProp = n.getFirstChild()).getFirstChild())) {
                ((JavascriptClass)Es6ToEs3ClassSideInheritance.this.classByAlias.get(classNode.getQualifiedName())).staticMembers.add(n);
            }
        }

        private void visitVar(Node n) {
            String maybeAlias;
            Node child = n.getFirstChild();
            if (!child.hasChildren()) {
                return;
            }
            String maybeOriginalName = child.getFirstChild().getQualifiedName();
            if (Es6ToEs3ClassSideInheritance.this.classByAlias.containsKey(maybeOriginalName) && (maybeAlias = child.getQualifiedName()) != null) {
                this.setAlias(maybeOriginalName, maybeAlias);
            }
        }
    }

    private static class JavascriptClass {
        private Set<Node> staticMembers = new LinkedHashSet<Node>();
        private Set<Node> staticFieldAccess = new LinkedHashSet<Node>();
        private Set<String> definedProperties = new LinkedHashSet<String>();

        private JavascriptClass() {
        }
    }
}

