/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public final class Es6ConvertSuper
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType INVALID_SUPER_CALL = DiagnosticType.error("JSC_INVALID_SUPER_CALL", "Calls to super cannot be used outside of a constructor.");
    private final AbstractCompiler compiler;

    public Es6ConvertSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            boolean hasConstructor = false;
            for (Node member = n.getLastChild().getFirstChild(); member != null; member = member.getNext()) {
                if (!member.isMemberFunctionDef() || !member.getString().equals("constructor")) continue;
                hasConstructor = true;
                break;
            }
            if (!hasConstructor) {
                this.addSyntheticConstructor(n);
            }
        } else if (n.isSuper()) {
            this.visitSuper(n, parent);
        }
    }

    private void addSyntheticConstructor(Node classNode) {
        Node memberDef;
        Node superClass = classNode.getSecondChild();
        Node classMembers = classNode.getLastChild();
        if (superClass.isEmpty()) {
            Node function = NodeUtil.emptyFunction();
            this.compiler.reportChangeToChangeScope(function);
            memberDef = IR.memberFunctionDef("constructor", function);
        } else {
            if (!superClass.isQualifiedName()) {
                return;
            }
            Node body = IR.block();
            if (!classNode.isFromExterns() && !this.isInterface(classNode)) {
                Node exprResult = IR.exprResult(IR.call(IR.getprop(IR.superNode(), IR.string("apply")), IR.thisNode(), IR.name("arguments")));
                body.addChildToFront(exprResult);
            }
            Node constructor = IR.function(IR.name(""), IR.paramList(IR.name("var_args")), body);
            this.compiler.reportChangeToChangeScope(constructor);
            memberDef = IR.memberFunctionDef("constructor", constructor);
            JSDocInfoBuilder info = new JSDocInfoBuilder(false);
            info.recordParameter("var_args", new JSTypeExpression(new Node(Token.ELLIPSIS, new Node(Token.QMARK)), "<Es6ConvertSuper>"));
            memberDef.setJSDocInfo(info.build());
        }
        memberDef.useSourceInfoIfMissingFromForTree(classNode);
        classMembers.addChildToFront(memberDef);
        this.compiler.reportChangeToEnclosingScope(memberDef);
    }

    private boolean isInterface(Node classNode) {
        JSDocInfo classJsDocInfo = NodeUtil.getBestJSDocInfo(classNode);
        return classJsDocInfo != null && classJsDocInfo.isInterface();
    }

    private void visitSuper(Node node, Node parent) {
        Preconditions.checkState((boolean)node.isSuper());
        Node exprRoot = node;
        if (exprRoot.getParent().isGetElem() || exprRoot.getParent().isGetProp()) {
            exprRoot = exprRoot.getParent();
        }
        Node enclosingMemberDef = NodeUtil.getEnclosingNode(exprRoot, new Predicate<Node>(){

            public boolean apply(Node n) {
                switch (n.getToken()) {
                    case MEMBER_FUNCTION_DEF: 
                    case GETTER_DEF: 
                    case SETTER_DEF: 
                    case COMPUTED_PROP: {
                        return true;
                    }
                }
                return false;
            }
        });
        if (parent.isCall()) {
            this.visitSuperCall(node, parent, enclosingMemberDef);
        } else if (parent.isGetProp() || parent.isGetElem()) {
            if (parent.getFirstChild() == node) {
                if (parent.getParent().isCall() && NodeUtil.isInvocationTarget(parent)) {
                    this.visitSuperPropertyCall(node, parent, enclosingMemberDef);
                } else {
                    this.visitSuperPropertyAccess(node, parent, enclosingMemberDef);
                }
            } else {
                this.compiler.report(JSError.make(node, Es6ToEs3Util.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
            }
        } else if (parent.isNew()) {
            this.compiler.report(JSError.make(node, INVALID_SUPER_CALL, new String[0]));
        } else {
            this.compiler.report(JSError.make(node, Es6ToEs3Util.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
        }
    }

    private void visitSuperCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((boolean)parent.isCall(), (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (enclosingMemberDef.isMemberFunctionDef() && enclosingMemberDef.getString().equals("constructor")) {
            if (node.isFromExterns() || this.isInterface(clazz)) {
                Node enclosingStatement = NodeUtil.getEnclosingStatement(node);
                Node enclosingStatementParent = enclosingStatement.getParent();
                enclosingStatement.detach();
                this.compiler.reportChangeToEnclosingScope(enclosingStatementParent);
            }
            return;
        }
        this.compiler.report(JSError.make(node, INVALID_SUPER_CALL, new String[0]));
    }

    private void visitSuperPropertyCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((parent.isGetProp() || parent.isGetElem() ? 1 : 0) != 0, (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node grandparent = parent.getParent();
        Preconditions.checkState((boolean)grandparent.isCall());
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        Node callTarget = parent;
        if (enclosingMemberDef.isStaticMember()) {
            callTarget.replaceChild(node, superName.cloneTree());
            callTarget = IR.getprop(callTarget.detach(), IR.string("call"));
            grandparent.addChildToFront(callTarget);
            grandparent.addChildAfter(IR.thisNode(), callTarget);
            grandparent.useSourceInfoIfMissingFromForTree(parent);
        } else {
            String newPropName = Joiner.on((char)'.').join((Object)superName.getQualifiedName(), (Object)"prototype", new Object[0]);
            Node newProp = NodeUtil.newQName(this.compiler, newPropName);
            node.replaceWith(newProp);
            callTarget = IR.getprop(callTarget.detach(), IR.string("call"));
            grandparent.addChildToFront(callTarget);
            grandparent.addChildAfter(IR.thisNode(), callTarget);
            grandparent.putBooleanProp((byte)50, false);
            grandparent.useSourceInfoIfMissingFromForTree(parent);
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    private void visitSuperPropertyAccess(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((parent.isGetProp() || parent.isGetElem() ? 1 : 0) != 0, (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node grandparent = parent.getParent();
        if (NodeUtil.isLValue(parent)) {
            this.compiler.report(JSError.make(parent, Es6ToEs3Util.CANNOT_CONVERT_YET, "assigning to a super property"));
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (enclosingMemberDef.isStaticMember()) {
            node.replaceWith(superName.cloneTree());
        } else {
            String newPropName = Joiner.on((char)'.').join((Object)superName.getQualifiedName(), (Object)"prototype", new Object[0]);
            Node newprop = NodeUtil.newQName(this.compiler, newPropName, node, "super");
            node.replaceWith(newprop);
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, this);
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }
}

