/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Immutable
public final class ClosureCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    static final DiagnosticType OBJECTLIT_EXPECTED = DiagnosticType.warning("JSC_REFLECT_OBJECTLIT_EXPECTED", "Object literal expected as second argument");
    private final ImmutableSet<String> indirectlyDeclaredProperties;
    private final ImmutableSet<String> propertyTestFunctions = ImmutableSet.of((Object)"goog.isDef", (Object)"goog.isNull", (Object)"goog.isDefAndNotNull", (Object)"goog.isString", (Object)"goog.isNumber", (Object)"goog.isBoolean", (Object[])new String[]{"goog.isFunction", "goog.isArray", "goog.isArrayLike", "goog.isObject"});
    static final Node googCacheReflect = IR.getprop(IR.name("goog"), IR.string("reflect"), IR.string("cache"));

    public ClosureCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ClosureCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        ImmutableSet.Builder props = ImmutableSet.builder();
        props.add((Object[])new String[]{"superClass_", "instance_", "getInstance"});
        props.addAll(wrapped.getIndirectlyDeclaredProperties());
        this.indirectlyDeclaredProperties = props.build();
    }

    @Override
    public void applySubclassRelationship(com.google.javascript.rhino.jstype.FunctionType parentCtor, com.google.javascript.rhino.jstype.FunctionType childCtor, CodingConvention.SubclassType type) {
        super.applySubclassRelationship(parentCtor, childCtor, type);
        if (type == CodingConvention.SubclassType.INHERITS) {
            childCtor.defineDeclaredProperty("superClass_", parentCtor.getPrototype(), childCtor.getSource());
            childCtor.getPrototype().defineDeclaredProperty("constructor", childCtor.forgetParameterAndReturnTypes(), childCtor.getSource());
        }
    }

    @Override
    public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
        CodingConvention.SubclassRelationship relationship = super.getClassesDefinedByCall(callNode);
        if (relationship != null) {
            return relationship;
        }
        Node callName = callNode.getFirstChild();
        CodingConvention.SubclassType type = ClosureCodingConvention.typeofClassDefiningName(callName);
        if (type != null) {
            boolean isDeprecatedCall;
            Node subclass = null;
            Node superclass = callNode.getLastChild();
            boolean bl = isDeprecatedCall = callNode.hasTwoChildren() && callName.isGetProp();
            if (isDeprecatedCall) {
                subclass = callName.getFirstChild();
            } else if (callNode.getChildCount() == 3) {
                subclass = callName.getNext();
            } else {
                return null;
            }
            if (type == CodingConvention.SubclassType.MIXIN) {
                if (!ClosureCodingConvention.endsWithPrototype(superclass)) {
                    return null;
                }
                if (!isDeprecatedCall) {
                    if (!ClosureCodingConvention.endsWithPrototype(subclass)) {
                        return null;
                    }
                    subclass = subclass.getFirstChild();
                }
                superclass = superclass.getFirstChild();
            }
            if (subclass != null && subclass.isUnscopedQualifiedName() && superclass.isUnscopedQualifiedName()) {
                return new CodingConvention.SubclassRelationship(type, subclass, superclass);
            }
        }
        return null;
    }

    @Override
    public boolean isClassFactoryCall(Node callNode) {
        return callNode.getFirstChild().matchesQualifiedName("goog.defineClass");
    }

    private static CodingConvention.SubclassType typeofClassDefiningName(Node callName) {
        String name;
        int dollarIndex;
        String methodName = null;
        if (callName.isGetProp()) {
            methodName = callName.getLastChild().getString();
        } else if (callName.isName() && (dollarIndex = (name = callName.getString()).lastIndexOf(36)) != -1) {
            methodName = name.substring(dollarIndex + 1);
        }
        if (methodName != null) {
            if (methodName.equals("inherits")) {
                return CodingConvention.SubclassType.INHERITS;
            }
            if (methodName.equals("mixin")) {
                return CodingConvention.SubclassType.MIXIN;
            }
        }
        return null;
    }

    @Override
    public boolean isSuperClassReference(String propertyName) {
        return "superClass_".equals(propertyName) || super.isSuperClassReference(propertyName);
    }

    private static boolean endsWithPrototype(Node qualifiedName) {
        return qualifiedName.isGetProp() && qualifiedName.getLastChild().getString().equals("prototype");
    }

    @Override
    public boolean extractIsModuleFile(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        return namespace != null;
    }

    @Override
    public String extractClassNameIfProvide(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.provide");
        if (namespace == null) {
            namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        }
        return namespace;
    }

    @Override
    public String extractClassNameIfRequire(Node node, Node parent) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.require");
    }

    private static String extractClassNameIfGoog(Node node, Node parent, String functionName) {
        Node target;
        Node callee;
        String className = null;
        if (NodeUtil.isExprCall(parent) && (callee = node.getFirstChild()) != null && callee.isGetProp() && callee.matchesQualifiedName(functionName) && (target = callee.getNext()) != null && target.isString()) {
            className = target.getString();
        }
        return className;
    }

    @Override
    public String getExportPropertyFunction() {
        return "goog.exportProperty";
    }

    @Override
    public String getExportSymbolFunction() {
        return "goog.exportSymbol";
    }

    @Override
    public List<String> identifyTypeDeclarationCall(Node n) {
        Node typeDeclaration;
        Node typeArray;
        Node callName = n.getFirstChild();
        if (callName.matchesQualifiedName("goog.addDependency") && n.getChildCount() >= 3 && (typeArray = callName.getNext().getNext()).isArrayLit()) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (Node name = typeArray.getFirstChild(); name != null; name = name.getNext()) {
                if (!name.isString()) continue;
                typeNames.add(name.getString());
            }
            return typeNames;
        }
        if (callName.matchesQualifiedName("goog.forwardDeclare") && n.hasTwoChildren() && (typeDeclaration = n.getSecondChild()).isString()) {
            return ImmutableList.of((Object)typeDeclaration.getString());
        }
        return super.identifyTypeDeclarationCall(n);
    }

    @Override
    public String getAbstractMethodName() {
        return "goog.abstractMethod";
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (callNode.hasTwoChildren() && (callArg.matchesQualifiedName("goog.addSingletonGetter") || callArg.matchesQualifiedName("goog$addSingletonGetter"))) {
            return callArg.getNext().getQualifiedName();
        }
        return super.getSingletonGetterClassName(callNode);
    }

    @Override
    public void applySingletonGetterOld(com.google.javascript.rhino.jstype.FunctionType functionType, com.google.javascript.rhino.jstype.FunctionType getterType, ObjectType objectType) {
        functionType.defineDeclaredProperty("getInstance", getterType, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, functionType.getSource());
    }

    @Override
    public void applySingletonGetterNew(RawNominalType rawType, JSType getInstanceType, JSType instanceType) {
        rawType.addCtorProperty("getInstance", null, getInstanceType, true);
        rawType.addCtorProperty("instance_", null, instanceType, true);
    }

    @Override
    public String getGlobalObject() {
        return "goog.global";
    }

    @Override
    public boolean isAliasingGlobalThis(Node n) {
        return CodingConventions.isAliasingGlobalThis(this, n);
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument((boolean)call.isCall());
        return this.propertyTestFunctions.contains((Object)call.getFirstChild().getQualifiedName()) || super.isPropertyTestFunction(call);
    }

    @Override
    public boolean isPropertyRenameFunction(String name) {
        return super.isPropertyRenameFunction(name) || "goog.reflect.objectProperty".equals(name);
    }

    @Override
    public boolean isFunctionCallThatAlwaysThrows(Node n) {
        return CodingConventions.defaultIsFunctionCallThatAlwaysThrows(n, "goog.asserts.fail");
    }

    @Override
    public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
        Preconditions.checkArgument((boolean)callNode.isCall(), (String)"Expected call node but found %s", (Object)callNode);
        CodingConvention.ObjectLiteralCast proxyCast = super.getObjectLiteralCast(callNode);
        if (proxyCast != null) {
            return proxyCast;
        }
        Node callName = callNode.getFirstChild();
        if (!callName.matchesQualifiedName("goog.reflect.object") && !callName.matchesQualifiedName("$jscomp.reflectObject") || callNode.getChildCount() != 3) {
            return null;
        }
        Node typeNode = callName.getNext();
        if (!typeNode.isQualifiedName()) {
            return null;
        }
        Node objectNode = typeNode.getNext();
        if (!objectNode.isObjectLit()) {
            return new CodingConvention.ObjectLiteralCast(null, null, OBJECTLIT_EXPECTED);
        }
        return new CodingConvention.ObjectLiteralCast(typeNode.getQualifiedName(), typeNode.getNext(), null);
    }

    @Override
    public boolean isPrivate(String name) {
        return false;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of((Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assert", JSTypeNative.TRUTHY), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertNumber", JSTypeNative.NUMBER_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertString", JSTypeNative.STRING_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertObject", JSTypeNative.OBJECT_TYPE), (Object)new AssertFunctionByTypeName("goog.asserts.assertFunction", "Function"), (Object)new AssertFunctionByTypeName("goog.asserts.assertArray", "Array"), (Object)new AssertFunctionByTypeName("goog.asserts.assertElement", "Element"), (Object)new AssertInstanceofSpec("goog.asserts.assertInstanceof"));
    }

    @Override
    public CodingConvention.Bind describeFunctionBind(Node n, boolean callerChecksTypes, boolean iCheckTypes) {
        if (!n.isCall()) {
            return null;
        }
        Node callTarget = n.getFirstChild();
        if (callTarget.isQualifiedName()) {
            if (callTarget.matchesQualifiedName("goog.bind") || callTarget.matchesQualifiedName("goog$bind")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = ClosureCodingConvention.safeNext(fn);
                Node parameters = ClosureCodingConvention.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (callTarget.matchesQualifiedName("goog.partial") || callTarget.matchesQualifiedName("goog$partial")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = null;
                Node parameters = ClosureCodingConvention.safeNext(fn);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
        }
        return super.describeFunctionBind(n, callerChecksTypes, iCheckTypes);
    }

    @Override
    public CodingConvention.Cache describeCachingCall(Node node) {
        int paramCount;
        if (!node.isCall()) {
            return null;
        }
        Node callTarget = node.getFirstChild();
        if (this.matchesCacheMethodName(callTarget) && 3 <= (paramCount = node.getChildCount() - 1) && paramCount <= 4) {
            Node cacheObj = callTarget.getNext();
            Node keyNode = cacheObj.getNext();
            Node valueFn = keyNode.getNext();
            Node keyFn = valueFn.getNext();
            return new CodingConvention.Cache(cacheObj, keyNode, valueFn, keyFn);
        }
        return super.describeCachingCall(node);
    }

    private boolean matchesCacheMethodName(Node target) {
        if (target.isGetProp()) {
            return target.matchesQualifiedName(googCacheReflect);
        }
        if (target.isName()) {
            return target.getString().equals("goog$reflect$cache");
        }
        return false;
    }

    @Override
    public Collection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    private static Node safeNext(Node n) {
        if (n != null) {
            return n.getNext();
        }
        return null;
    }

    public static class AssertFunctionByTypeName
    extends CodingConvention.AssertionFunctionSpec {
        private final String typeName;

        public AssertFunctionByTypeName(String functionName, String typeName) {
            super(functionName, null);
            this.typeName = typeName;
        }

        @Override
        public com.google.javascript.rhino.jstype.JSType getAssertedOldType(Node call, JSTypeRegistry registry) {
            return registry.getType(this.typeName);
        }

        @Override
        public JSType getAssertedNewType(Node call, DeclaredTypeRegistry scope) {
            JSType result = scope.getDeclaredTypeOf(this.typeName).getFunTypeIfSingletonObj().getInstanceTypeOfCtor();
            return result;
        }
    }

    public static class AssertInstanceofSpec
    extends CodingConvention.AssertionFunctionSpec {
        public AssertInstanceofSpec(String functionName) {
            super(functionName, JSTypeNative.OBJECT_TYPE);
        }

        @Override
        public com.google.javascript.rhino.jstype.JSType getAssertedOldType(Node call, JSTypeRegistry registry) {
            com.google.javascript.rhino.jstype.JSType ownerType;
            Node constructor;
            if (call.getChildCount() > 2 && (constructor = call.getSecondChild().getNext()) != null && (ownerType = constructor.getJSType()) != null && ownerType.isFunctionType() && ownerType.isConstructor()) {
                com.google.javascript.rhino.jstype.FunctionType functionType = (com.google.javascript.rhino.jstype.FunctionType)ownerType;
                return functionType.getInstanceType();
            }
            return registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType getAssertedNewType(Node call, DeclaredTypeRegistry scope) {
            QualifiedName qname;
            JSType functionType;
            Node constructor;
            if (call.getChildCount() > 2 && (constructor = call.getSecondChild().getNext()) != null && constructor.isQualifiedName() && (functionType = scope.getDeclaredTypeOf((qname = QualifiedName.fromNode(constructor)).getLeftmostName())) != null) {
                FunctionType ctorType;
                if (!qname.isIdentifier()) {
                    functionType = functionType.getProp(qname.getAllButLeftmost());
                }
                FunctionType functionType2 = ctorType = functionType == null ? null : functionType.getFunTypeIfSingletonObj();
                if (ctorType != null && ctorType.isUniqueConstructor()) {
                    return ctorType.getInstanceTypeOfCtor();
                }
            }
            return scope.getCommonTypes().UNKNOWN;
        }
    }
}

