/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

class AggressiveInlineAliases
implements CompilerPass {
    static final DiagnosticType UNSAFE_CTOR_ALIASING = DiagnosticType.warning("JSC_UNSAFE_CTOR_ALIASING", "Variable {0} aliases a constructor, so it cannot be assigned multiple times");
    private AbstractCompiler compiler;
    private boolean codeChanged;

    private void rewriteAliasProps(GlobalNamespace.Name name, Node value, int depth, Set<GlobalNamespace.AstChange> newNodes) {
        if (name.props == null) {
            return;
        }
        Preconditions.checkState((!value.matchesQualifiedName(name.getFullName()) ? 1 : 0) != 0, (String)"%s should not match name %s", (Object)value, (Object)name.getFullName());
        for (GlobalNamespace.Name prop : name.props) {
            this.rewriteAliasProps(prop, value, depth + 1, newNodes);
            ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(prop.getRefs());
            for (GlobalNamespace.Ref ref : refs) {
                Node target = ref.node;
                for (int i = 0; i <= depth; ++i) {
                    if (target.isGetProp()) {
                        target = target.getFirstChild();
                        continue;
                    }
                    if (NodeUtil.isObjectLitKey(target)) {
                        Node gparent = target.getGrandparent();
                        if (gparent.isAssign()) {
                            target = gparent.getFirstChild();
                            continue;
                        }
                        Preconditions.checkState((boolean)NodeUtil.isObjectLitKey(gparent));
                        target = gparent;
                        continue;
                    }
                    throw new IllegalStateException("unexpected: " + target);
                }
                Preconditions.checkState((target.isGetProp() || target.isName() ? 1 : 0) != 0);
                Node newValue = value.cloneTree();
                target.replaceWith(newValue);
                this.compiler.reportChangeToEnclosingScope(newValue);
                prop.removeRef(ref);
                newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, ref.node));
            }
        }
    }

    AggressiveInlineAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codeChanged = true;
    }

    @Override
    public void process(Node externs, Node root) {
        while (this.codeChanged) {
            this.codeChanged = false;
            GlobalNamespace namespace = new GlobalNamespace(this.compiler, root);
            this.inlineAliases(namespace);
        }
    }

    private JSModule getRefModule(Reference ref) {
        CompilerInput input = this.compiler.getInput(ref.getInputId());
        return input == null ? null : input.getModule();
    }

    private void inlineAliases(GlobalNamespace namespace) {
        ArrayDeque<GlobalNamespace.Name> workList = new ArrayDeque<GlobalNamespace.Name>(namespace.getNameForest());
        while (!workList.isEmpty()) {
            GlobalNamespace.Name name = (GlobalNamespace.Name)workList.pop();
            if (name.type == GlobalNamespace.Name.Type.GET || name.type == GlobalNamespace.Name.Type.SET) continue;
            if (!name.inExterns && name.globalSets == 1 && name.localSets == 0 && name.aliasingGets > 0) {
                ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(name.getRefs());
                for (GlobalNamespace.Ref ref : refs) {
                    if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && ref.scope.isLocal()) {
                        if (!this.inlineAliasIfPossible(name, ref, namespace)) continue;
                        name.removeRef(ref);
                        continue;
                    }
                    if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || !ref.scope.isGlobal() || ref.getTwin() != null || !this.inlineGlobalAliasIfPossible(name, ref, namespace)) continue;
                    name.removeRef(ref);
                }
            }
            if (name.type != GlobalNamespace.Name.Type.OBJECTLIT && name.type != GlobalNamespace.Name.Type.FUNCTION || name.aliasingGets != 0 || name.props == null) continue;
            workList.addAll(name.props);
        }
    }

    private boolean inlineAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.node.getParent();
        if (aliasParent.isName()) {
            Scope scope = alias.scope;
            String aliasVarName = aliasParent.getString();
            Var aliasVar = scope.getVar(aliasVarName);
            ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(this.compiler), (Predicate<Var>)Predicates.equalTo((Object)aliasVar));
            collector.processScope(scope);
            ReferenceCollection aliasRefs = collector.getReferences(aliasVar);
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            if (aliasRefs.isWellDefined() && aliasRefs.firstReferenceIsAssigningDeclaration()) {
                if (!aliasRefs.isAssignedOnceInLifetime()) {
                    if (name.isConstructor()) {
                        boolean accessPropsAfterAliasing = false;
                        for (Reference ref : aliasRefs.references) {
                            if (!ref.getNode().getParent().isGetProp()) continue;
                            accessPropsAfterAliasing = true;
                            break;
                        }
                        if (accessPropsAfterAliasing) {
                            this.compiler.report(JSError.make(aliasParent, UNSAFE_CTOR_ALIASING, aliasVarName));
                        }
                    }
                    return false;
                }
                int size = aliasRefs.references.size();
                for (int i = 1; i < size; ++i) {
                    Reference aliasRef = aliasRefs.references.get(i);
                    Node newNode = alias.node.cloneTree();
                    aliasRef.getParent().replaceChild(aliasRef.getNode(), newNode);
                    this.compiler.reportChangeToEnclosingScope(newNode);
                    newNodes.add(new GlobalNamespace.AstChange(this.getRefModule(aliasRef), aliasRef.getScope(), newNode));
                }
                aliasParent.replaceChild(alias.node, IR.nullNode());
                this.codeChanged = true;
                this.compiler.reportChangeToEnclosingScope(aliasParent);
                namespace.scanNewNodes(newNodes);
                return true;
            }
        }
        return false;
    }

    private boolean inlineGlobalAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.node.getParent();
        if ((aliasParent.isAssign() || aliasParent.isName()) && NodeUtil.isExecutedExactlyOnce(aliasParent) || aliasParent.isName() && name.isConstructor()) {
            Node lvalue;
            Node node = lvalue = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
            if (!lvalue.isQualifiedName()) {
                return false;
            }
            if (lvalue.isName() && this.compiler.getCodingConvention().isExported(lvalue.getString(), false)) {
                return false;
            }
            name = namespace.getSlot(lvalue.getQualifiedName());
            if (name != null && name.isInlinableGlobalAlias()) {
                LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
                ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(name.getRefs());
                block4: for (GlobalNamespace.Ref ref : refs) {
                    switch (ref.type) {
                        case SET_FROM_GLOBAL: {
                            continue block4;
                        }
                        case DIRECT_GET: 
                        case ALIASING_GET: 
                        case PROTOTYPE_GET: 
                        case CALL_GET: {
                            Node newNode = alias.node.cloneTree();
                            Node node2 = ref.node;
                            node2.getParent().replaceChild(node2, newNode);
                            this.compiler.reportChangeToEnclosingScope(newNode);
                            newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, newNode));
                            name.removeRef(ref);
                            continue block4;
                        }
                    }
                    throw new IllegalStateException();
                }
                this.rewriteAliasProps(name, alias.node, 0, newNodes);
                aliasParent.replaceChild(alias.node, IR.nullNode());
                this.codeChanged = true;
                this.compiler.reportChangeToEnclosingScope(aliasParent);
                namespace.scanNewNodes(newNodes);
                return true;
            }
        }
        return false;
    }
}

