/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TypeI;
import javax.annotation.Nullable;

public final class AccessControlUtils {
    private AccessControlUtils() {
    }

    static JSDocInfo.Visibility getEffectiveNameVisibility(Node name, Var var, ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap) {
        JSDocInfo.Visibility raw;
        JSDocInfo jsDocInfo = var.getJSDocInfo();
        JSDocInfo.Visibility visibility = raw = jsDocInfo == null || jsDocInfo.getVisibility() == null ? JSDocInfo.Visibility.INHERITED : jsDocInfo.getVisibility();
        if (raw != JSDocInfo.Visibility.INHERITED) {
            return raw;
        }
        JSDocInfo.Visibility defaultVisibilityForFile = (JSDocInfo.Visibility)((Object)fileVisibilityMap.get((Object)var.getSourceFile()));
        TypeI type = name.getTypeI();
        boolean createdFromGoogProvide = type != null && type.isLiteralObject();
        return createdFromGoogProvide || defaultVisibilityForFile == null ? raw : defaultVisibilityForFile;
    }

    static JSDocInfo.Visibility getEffectivePropertyVisibility(Node property, ObjectTypeI referenceType, ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap, @Nullable CodingConvention codingConvention) {
        String propertyName = property.getLastChild().getString();
        StaticSourceFile definingSource = AccessControlUtils.getDefiningSource(property, referenceType, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = (JSDocInfo.Visibility)((Object)fileVisibilityMap.get((Object)definingSource));
        Node parent = property.getParent();
        boolean isOverride = parent.getJSDocInfo() != null && parent.isAssign() && parent.getFirstChild() == property;
        ObjectTypeI objectType = AccessControlUtils.getObjectType(referenceType, isOverride, propertyName);
        if (isOverride) {
            JSDocInfo.Visibility overridden = AccessControlUtils.getOverriddenPropertyVisibility(objectType, propertyName);
            return AccessControlUtils.getEffectiveVisibilityForOverriddenProperty(overridden, fileOverviewVisibility, propertyName, codingConvention);
        }
        return AccessControlUtils.getEffectiveVisibilityForNonOverriddenProperty(property, objectType, fileOverviewVisibility, codingConvention);
    }

    @Nullable
    static StaticSourceFile getDefiningSource(Node getprop, @Nullable ObjectTypeI referenceType, String propertyName) {
        Node propDefNode;
        if (referenceType != null && (propDefNode = referenceType.getPropertyDefSite(propertyName)) != null) {
            return propDefNode.getStaticSourceFile();
        }
        return getprop.getStaticSourceFile();
    }

    @Nullable
    static ObjectTypeI getObjectType(@Nullable ObjectTypeI referenceType, boolean isOverride, String propertyName) {
        ObjectTypeI current;
        if (referenceType == null) {
            return null;
        }
        ObjectTypeI objectTypeI = current = isOverride ? referenceType.getPrototypeObject() : referenceType;
        while (current != null) {
            JSDocInfo docInfo = current.getOwnPropertyJSDocInfo(propertyName);
            if (docInfo != null && docInfo.getVisibility() != JSDocInfo.Visibility.INHERITED) {
                return current;
            }
            current = current.getPrototypeObject();
        }
        return null;
    }

    private static JSDocInfo.Visibility getOverriddenPropertyVisibility(ObjectTypeI objectType, String propertyName) {
        return objectType != null ? objectType.getOwnPropertyJSDocInfo(propertyName).getVisibility() : JSDocInfo.Visibility.INHERITED;
    }

    private static JSDocInfo.Visibility getEffectiveVisibilityForOverriddenProperty(JSDocInfo.Visibility visibility, @Nullable JSDocInfo.Visibility fileOverviewVisibility, String propertyName, @Nullable CodingConvention codingConvention) {
        if (codingConvention != null && codingConvention.isPrivate(propertyName)) {
            return JSDocInfo.Visibility.PRIVATE;
        }
        return fileOverviewVisibility != null && visibility == JSDocInfo.Visibility.INHERITED ? fileOverviewVisibility : visibility;
    }

    private static JSDocInfo.Visibility getEffectiveVisibilityForNonOverriddenProperty(Node getprop, ObjectTypeI objectType, @Nullable JSDocInfo.Visibility fileOverviewVisibility, @Nullable CodingConvention codingConvention) {
        TypeI type;
        String propertyName = getprop.getLastChild().getString();
        if (codingConvention != null && codingConvention.isPrivate(propertyName)) {
            return JSDocInfo.Visibility.PRIVATE;
        }
        JSDocInfo.Visibility raw = JSDocInfo.Visibility.INHERITED;
        if (objectType != null) {
            raw = objectType.getOwnPropertyJSDocInfo(propertyName).getVisibility();
        }
        boolean createdFromGoogProvide = (type = getprop.getTypeI()) != null && type.isLiteralObject();
        return raw != JSDocInfo.Visibility.INHERITED || fileOverviewVisibility == null || createdFromGoogProvide ? raw : fileOverviewVisibility;
    }
}

