/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int JSDOC_INFO_PROP = 29;
    public static final int VAR_ARGS_NAME = 30;
    public static final int INCRDECR_PROP = 32;
    public static final int QUOTED_PROP = 36;
    public static final int OPT_ARG_NAME = 37;
    public static final int SYNTHETIC_BLOCK_PROP = 38;
    public static final int ADDED_BLOCK = 39;
    public static final int ORIGINALNAME_PROP = 40;
    public static final int SIDE_EFFECT_FLAGS = 42;
    public static final int IS_CONSTANT_NAME = 43;
    public static final int IS_NAMESPACE = 46;
    public static final int DIRECTIVES = 48;
    public static final int DIRECT_EVAL = 49;
    public static final int FREE_CALL = 50;
    public static final int STATIC_SOURCE_FILE = 51;
    public static final int INPUT_ID = 53;
    public static final int SLASH_V = 54;
    public static final int INFERRED_FUNCTION = 55;
    public static final int CHANGE_TIME = 56;
    public static final int REFLECTED_OBJECT = 57;
    public static final int STATIC_MEMBER = 58;
    public static final int GENERATOR_FN = 59;
    public static final int ARROW_FN = 60;
    public static final int ASYNC_FN = 61;
    public static final int YIELD_FOR = 62;
    public static final int EXPORT_DEFAULT = 63;
    public static final int EXPORT_ALL_FROM = 64;
    public static final int IS_CONSTANT_VAR = 65;
    public static final int GENERATOR_MARKER = 66;
    public static final int GENERATOR_SAFE = 67;
    public static final int RAW_STRING_VALUE = 71;
    public static final int COMPUTED_PROP_METHOD = 72;
    public static final int COMPUTED_PROP_GETTER = 73;
    public static final int COMPUTED_PROP_SETTER = 74;
    public static final int COMPUTED_PROP_VARIABLE = 75;
    public static final int ANALYZED_DURING_GTI = 76;
    public static final int CONSTANT_PROPERTY_DEF = 77;
    public static final int DECLARED_TYPE_EXPR = 78;
    public static final int TYPE_BEFORE_CAST = 79;
    public static final int OPT_ES6_TYPED = 80;
    public static final int GENERIC_TYPE_LIST = 81;
    public static final int IMPLEMENTS = 82;
    public static final int CONSTRUCT_SIGNATURE = 83;
    public static final int ACCESS_MODIFIER = 84;
    public static final int NON_INDEXABLE = 85;
    public static final int PARSE_RESULTS = 86;
    public static final int GOOG_MODULE = 87;
    public static final int GOOG_MODULE_REQUIRE = 88;
    public static final int FEATURE_SET = 89;
    public static final int IS_MODULE_NAME = 90;
    public static final int WAS_PREVIOUSLY_PROVIDED = 91;
    public static final int IS_ES6_CLASS = 92;
    public static final int TRANSPILED = 93;
    public static final int DELETED = 94;
    public static final int GOOG_MODULE_ALIAS = 95;
    Token token;
    @Nullable
    transient Node next;
    @Nullable
    transient Node previous;
    @Nullable
    transient Node first;
    @Nullable
    private PropListItem propListHead;
    public static final int COLUMN_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    public static final int COLUMN_MASK = 4095;
    private int sourcePosition;
    private int length;
    @Nullable
    private transient TypeI typei;
    @Nullable
    protected transient Node parent;
    public static final int FLAG_GLOBAL_STATE_UNMODIFIED = 1;
    public static final int FLAG_THIS_UNMODIFIED = 2;
    public static final int FLAG_ARGUMENTS_UNMODIFIED = 4;
    public static final int FLAG_NO_THROWS = 8;
    public static final int FLAG_LOCAL_RESULTS = 16;
    public static final int SIDE_EFFECTS_FLAGS_MASK = 31;
    public static final int SIDE_EFFECTS_ALL = 0;
    public static final int NO_SIDE_EFFECTS = 15;

    private static final String propToString(int propType) {
        switch (propType) {
            case 30: {
                return "var_args_name";
            }
            case 29: {
                return "jsdoc_info";
            }
            case 32: {
                return "incrdecr";
            }
            case 36: {
                return "quoted";
            }
            case 37: {
                return "opt_arg";
            }
            case 38: {
                return "synthetic";
            }
            case 39: {
                return "added_block";
            }
            case 40: {
                return "originalname";
            }
            case 42: {
                return "side_effect_flags";
            }
            case 43: {
                return "is_constant_name";
            }
            case 46: {
                return "is_namespace";
            }
            case 48: {
                return "directives";
            }
            case 49: {
                return "direct_eval";
            }
            case 50: {
                return "free_call";
            }
            case 51: {
                return "source_file";
            }
            case 53: {
                return "input_id";
            }
            case 54: {
                return "slash_v";
            }
            case 55: {
                return "inferred";
            }
            case 56: {
                return "change_time";
            }
            case 57: {
                return "reflected_object";
            }
            case 58: {
                return "static_member";
            }
            case 59: {
                return "generator_fn";
            }
            case 60: {
                return "arrow_fn";
            }
            case 61: {
                return "async_fn";
            }
            case 62: {
                return "yield_for";
            }
            case 63: {
                return "export_default";
            }
            case 64: {
                return "export_all_from";
            }
            case 65: {
                return "is_constant_var";
            }
            case 66: {
                return "is_generator_marker";
            }
            case 67: {
                return "is_generator_safe";
            }
            case 71: {
                return "raw_string_value";
            }
            case 72: {
                return "computed_prop_method";
            }
            case 73: {
                return "computed_prop_getter";
            }
            case 74: {
                return "computed_prop_setter";
            }
            case 75: {
                return "computed_prop_variable";
            }
            case 76: {
                return "analyzed_during_gti";
            }
            case 77: {
                return "constant_property_def";
            }
            case 78: {
                return "declared_type_expr";
            }
            case 79: {
                return "type_before_cast";
            }
            case 80: {
                return "opt_es6_typed";
            }
            case 81: {
                return "generic_type";
            }
            case 82: {
                return "implements";
            }
            case 83: {
                return "construct_signature";
            }
            case 84: {
                return "access_modifier";
            }
            case 85: {
                return "non_indexable";
            }
            case 86: {
                return "parse_results";
            }
            case 87: {
                return "goog_module";
            }
            case 88: {
                return "goog_module_require";
            }
            case 89: {
                return "feature_set";
            }
            case 90: {
                return "is_module_name";
            }
            case 91: {
                return "was_previously_provided";
            }
            case 92: {
                return "is_es6_class";
            }
            case 93: {
                return "transpiled";
            }
            case 94: {
                return "DELETED";
            }
            case 95: {
                return "goog_module_alias";
            }
        }
        throw new IllegalStateException("unexpected prop id " + propType);
    }

    public Node(Token nodeType) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (Object)"new child has existing parent");
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0, (Object)"new child has existing next sibling");
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0, (Object)"new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = child;
        child.next = null;
        child.previous = this.first;
        child.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0, (Object)"first new child has existing parent");
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0, (Object)"first new child has existing next sibling");
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0, (Object)"first new child has existing previous sibling");
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0, (Object)"second new child has existing parent");
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0, (Object)"second new child has existing next sibling");
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0, (Object)"second new child has existing previous sibling");
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = right;
        left.previous = right;
        left.parent = this;
        right.next = null;
        right.previous = left;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, Node left, Node mid, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = right;
        mid.previous = left;
        mid.parent = this;
        right.next = null;
        right.previous = mid;
        right.parent = this;
        this.sourcePosition = -1;
    }

    Node(Token nodeType, Node left, Node mid, Node mid2, Node right) {
        Preconditions.checkArgument((left.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((left.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((mid2.previous == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((right.previous == null ? 1 : 0) != 0);
        this.token = nodeType;
        this.parent = null;
        this.first = left;
        left.next = mid;
        left.previous = right;
        left.parent = this;
        mid.next = mid2;
        mid.previous = left;
        mid.parent = this;
        mid2.next = right;
        mid2.previous = mid;
        mid2.parent = this;
        right.next = null;
        right.previous = mid2;
        right.parent = this;
        this.sourcePosition = -1;
    }

    public Node(Token nodeType, int lineno, int charno) {
        this.token = nodeType;
        this.parent = null;
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public Node(Token nodeType, Node child, int lineno, int charno) {
        this(nodeType, child);
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public static Node newNumber(double number) {
        return new NumberNode(number);
    }

    public static Node newNumber(double number, int lineno, int charno) {
        return new NumberNode(number, lineno, charno);
    }

    public static Node newString(String str) {
        return new StringNode(Token.STRING, str);
    }

    public static Node newString(Token token, String str) {
        return new StringNode(token, str);
    }

    public static Node newString(String str, int lineno, int charno) {
        return new StringNode(Token.STRING, str, lineno, charno);
    }

    public static Node newString(Token token, String str, int lineno, int charno) {
        return new StringNode(token, str, lineno, charno);
    }

    public final Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    @Nullable
    public Node getFirstChild() {
        return this.first;
    }

    @Nullable
    public Node getFirstFirstChild() {
        return this.first.first;
    }

    @Nullable
    public Node getSecondChild() {
        return this.first.next;
    }

    @Nullable
    public Node getLastChild() {
        return this.first != null ? this.first.previous : null;
    }

    @Nullable
    public final Node getNext() {
        return this.next;
    }

    @Nullable
    public final Node getPrevious() {
        return this == this.parent.first ? null : this.previous;
    }

    @Nullable
    private Node getPrevious(@Nullable Node firstSibling) {
        return this == firstSibling ? null : this.previous;
    }

    @Nullable
    public Node getChildBefore(Node child) {
        return child.getPrevious(this.first);
    }

    public Node getChildAtIndex(int i) {
        Node n = this.first;
        while (i > 0) {
            n = n.next;
            --i;
        }
        return n;
    }

    public int getIndexOfChild(Node child) {
        Node n = this.first;
        int i = 0;
        while (n != null) {
            if (child == n) {
                return i;
            }
            n = n.next;
            ++i;
        }
        return -1;
    }

    public void addChildToFront(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        child.parent = this;
        child.next = this.first;
        if (this.first == null) {
            child.previous = child;
        } else {
            Node last;
            child.previous = last = this.first.previous;
            child.next = this.first;
            this.first.previous = child;
        }
        this.first = child;
    }

    public void addChildToBack(Node child) {
        Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0, (String)"Cannot add already-owned child node.\nChild: %s\nExisting parent: %s\nNew parent: %s", (Object)child, (Object)this.parent, (Object)this);
        Preconditions.checkArgument((child.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((child.previous == null ? 1 : 0) != 0);
        if (this.first == null) {
            child.previous = child;
            this.first = child;
        } else {
            Node last = this.first.previous;
            last.next = child;
            child.previous = last;
            this.first.previous = child;
        }
        child.parent = this;
    }

    public void addChildrenToFront(Node children) {
        if (children == null) {
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSib = children.previous;
        if (this.first != null) {
            Node last;
            children.previous = last = this.first.previous;
            lastSib.next = this.first;
            this.first.previous = lastSib;
        }
        this.first = children;
    }

    public void addChildrenToBack(Node children) {
        this.addChildrenAfter(children, this.getLastChild());
    }

    public void addChildBefore(Node newChild, Node node) {
        Preconditions.checkArgument((node.parent == this ? 1 : 0) != 0, (Object)"The existing child node of the parent should not be null.");
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        if (this.first == node) {
            Node last = this.first.previous;
            newChild.parent = this;
            newChild.next = this.first;
            newChild.previous = last;
            this.first.previous = newChild;
            this.first = newChild;
        } else {
            this.addChildAfter(newChild, node.previous);
        }
    }

    public void addChildAfter(Node newChild, Node node) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        newChild.previous = newChild;
        this.addChildrenAfter(newChild, node);
    }

    public void addChildrenAfter(@Nullable Node children, @Nullable Node node) {
        Node nodeAfter;
        if (children == null) {
            return;
        }
        Preconditions.checkArgument((node == null || node.parent == this ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)children.previous);
        if (node == null) {
            this.addChildrenToFront(children);
            return;
        }
        Node child = children;
        while (child != null) {
            Preconditions.checkArgument((child.parent == null ? 1 : 0) != 0);
            child.parent = this;
            child = child.next;
        }
        Node lastSibling = children.previous;
        lastSibling.next = nodeAfter = node.next;
        if (nodeAfter == null) {
            this.first.previous = lastSibling;
        } else {
            nodeAfter.previous = lastSibling;
        }
        node.next = children;
        children.previous = node;
    }

    public void removeChild(Node child) {
        Preconditions.checkState((child.parent == this ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)child.previous);
        Node last = this.first.previous;
        Node prevSibling = child.previous;
        Node nextSibling = child.next;
        if (this.first == child) {
            this.first = nextSibling;
            if (nextSibling != null) {
                nextSibling.previous = last;
            }
        } else if (child == last) {
            this.first.previous = prevSibling;
            prevSibling.next = null;
        } else {
            prevSibling.next = nextSibling;
            nextSibling.previous = prevSibling;
        }
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public void replaceWith(Node newNode) {
        this.parent.replaceChild(this, newNode);
    }

    public void replaceChild(Node child, Node newChild) {
        Preconditions.checkArgument((newChild.next == null ? 1 : 0) != 0, (Object)"The new child node has next siblings.");
        Preconditions.checkArgument((newChild.previous == null ? 1 : 0) != 0, (Object)"The new child node has previous siblings.");
        Preconditions.checkArgument((newChild.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        Preconditions.checkState((child.parent == this ? 1 : 0) != 0, (String)"", (Object)child, (Object)this.parent);
        newChild.useSourceInfoIfMissingFrom(child);
        newChild.parent = this;
        Node nextSibling = child.next;
        Node prevSibling = child.previous;
        Node last = this.first.previous;
        if (child == prevSibling) {
            this.first = newChild;
            this.first.previous = newChild;
        } else {
            if (child == this.first) {
                this.first = newChild;
            } else {
                prevSibling.next = newChild;
            }
            if (child == last) {
                this.first.previous = newChild;
            } else {
                nextSibling.previous = newChild;
            }
            newChild.previous = prevSibling;
        }
        newChild.next = nextSibling;
        child.next = null;
        child.previous = null;
        child.parent = null;
    }

    public void replaceChildAfter(Node prevChild, Node newChild) {
        Preconditions.checkNotNull((Object)prevChild.next, (Object)"prev doesn't have a sibling to replace.");
        this.replaceChild(prevChild.next, newChild);
    }

    public void replaceFirstOrChildAfter(@Nullable Node prev, Node newChild) {
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"prev doesn't have a sibling to replace.");
        this.replaceChild(target, newChild);
    }

    @Nullable
    @VisibleForTesting
    PropListItem lookupProperty(int propType) {
        PropListItem x;
        for (x = this.propListHead; x != null && propType != x.getType(); x = x.getNext()) {
        }
        return x;
    }

    public Node clonePropsFrom(Node other) {
        Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)"Node has existing properties.");
        this.propListHead = other.propListHead;
        return this;
    }

    public void removeProp(int propType) {
        PropListItem result = this.removeProp(this.propListHead, propType);
        if (result != this.propListHead) {
            this.propListHead = result;
        }
    }

    public boolean hasProps() {
        return this.propListHead != null;
    }

    @Nullable
    private PropListItem removeProp(@Nullable PropListItem item, int propType) {
        if (item == null) {
            return null;
        }
        if (item.getType() == propType) {
            return item.getNext();
        }
        PropListItem result = this.removeProp(item.getNext(), propType);
        if (result != item.getNext()) {
            return item.chain(result);
        }
        return item;
    }

    @Nullable
    public Object getProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.getObjectValue();
    }

    public boolean getBooleanProp(int propType) {
        return this.getIntProp(propType) != 0;
    }

    public int getIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return 0;
        }
        return item.getIntValue();
    }

    public int getExistingIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            throw new IllegalStateException("missing prop: " + propType);
        }
        return item.getIntValue();
    }

    public void putProp(int propType, @Nullable Object value) {
        this.removeProp(propType);
        if (value != null) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public void putBooleanProp(int propType, boolean value) {
        this.putIntProp(propType, value ? 1 : 0);
    }

    public void putIntProp(int propType, int value) {
        this.removeProp(propType);
        if (value != 0) {
            this.propListHead = this.createProp(propType, value, this.propListHead);
        }
    }

    public void setDeclaredTypeExpression(TypeDeclarationNode typeExpression) {
        this.putProp(78, typeExpression);
    }

    @Nullable
    public TypeDeclarationNode getDeclaredTypeExpression() {
        return (TypeDeclarationNode)this.getProp(78);
    }

    PropListItem createProp(int propType, Object value, @Nullable PropListItem next) {
        return new ObjectPropListItem(propType, value, next);
    }

    PropListItem createProp(int propType, int value, @Nullable PropListItem next) {
        return new IntPropListItem(propType, value, next);
    }

    @Nullable
    public JSType getJSTypeBeforeCast() {
        return (JSType)this.getTypeIBeforeCast();
    }

    @Nullable
    public TypeI getTypeIBeforeCast() {
        return (TypeI)this.getProp(79);
    }

    private int[] getSortedPropTypes() {
        int count = 0;
        for (PropListItem x = this.propListHead; x != null; x = x.getNext()) {
            ++count;
        }
        int[] keys = new int[count];
        for (PropListItem x = this.propListHead; x != null; x = x.getNext()) {
            keys[--count] = x.getType();
        }
        Arrays.sort(keys);
        return keys;
    }

    public double getDouble() {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public void setDouble(double value) {
        if (this.token == Token.NUMBER) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getString() {
        if (this.token == Token.STRING) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String value) {
        if (this.token == Token.STRING || this.token == Token.NAME) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String toString() {
        return this.toString(true, true, true);
    }

    public String toString(boolean printSource, boolean printAnnotations, boolean printType) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, printSource, printAnnotations, printType);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printSource, boolean printAnnotations, boolean printType) {
        String typeString;
        sb.append((Object)this.token);
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else if (this.token == Token.FUNCTION) {
            sb.append(' ');
            if (this.first == null || this.first.token != Token.NAME) {
                sb.append("<invalid>");
            } else {
                sb.append(this.first.getString());
            }
        } else if (this.token == Token.NUMBER) {
            sb.append(' ');
            sb.append(this.getDouble());
        }
        if (printSource) {
            int lineno = this.getLineno();
            if (lineno != -1) {
                sb.append(' ');
                sb.append(lineno);
            }
            if (this.length != 0) {
                sb.append(" [length: ");
                sb.append(this.length);
                sb.append(']');
            }
        }
        if (printAnnotations) {
            int[] keys = this.getSortedPropTypes();
            for (int i = 0; i < keys.length; ++i) {
                int type = keys[i];
                PropListItem x = this.lookupProperty(type);
                sb.append(" [");
                sb.append(Node.propToString(type));
                sb.append(": ");
                sb.append(x);
                sb.append(']');
            }
        }
        if (printType && this.typei != null && (typeString = this.typei.toString()) != null) {
            sb.append(" : ");
            sb.append(typeString);
        }
    }

    @CheckReturnValue
    public String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder s = new StringBuilder();
            this.appendStringTree(s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    public void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node n, int level, Appendable sb) throws IOException {
        for (int i = 0; i != level; ++i) {
            sb.append("    ");
        }
        sb.append(n.toString());
        sb.append('\n');
        Node cursor = n.first;
        while (cursor != null) {
            Node.toStringTreeHelper(cursor, level + 1, sb);
            cursor = cursor.next;
        }
    }

    public void setStaticSourceFile(@Nullable StaticSourceFile file) {
        this.putProp(51, file);
    }

    public void setSourceFileForTesting(String name) {
        this.putProp(51, new SimpleSourceFile(name, false));
    }

    @Nullable
    public String getSourceFileName() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public StaticSourceFile getStaticSourceFile() {
        return (StaticSourceFile)this.getProp(51);
    }

    public void setInputId(InputId inputId) {
        this.putProp(53, inputId);
    }

    @Nullable
    public InputId getInputId() {
        return (InputId)this.getProp(53);
    }

    @Nullable
    public String getOriginalName() {
        return (String)this.getProp(40);
    }

    public void setOriginalName(String originalName) {
        this.putProp(40, originalName);
    }

    public boolean isIndexable() {
        return !this.getBooleanProp(85);
    }

    public void makeNonIndexable() {
        this.putBooleanProp(85, true);
    }

    public boolean isFromExterns() {
        StaticSourceFile file = this.getStaticSourceFile();
        return file == null ? false : file.isExtern();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLineno() {
        return Node.extractLineno(this.sourcePosition);
    }

    public int getCharno() {
        return Node.extractCharno(this.sourcePosition);
    }

    public int getSourceOffset() {
        StaticSourceFile file = this.getStaticSourceFile();
        if (file == null) {
            return -1;
        }
        int lineno = this.getLineno();
        if (lineno == -1) {
            return -1;
        }
        return file.getLineOffset(lineno) + this.getCharno();
    }

    public int getSourcePosition() {
        return this.sourcePosition;
    }

    public void setLineno(int lineno) {
        int charno = this.getCharno();
        if (charno == -1) {
            charno = 0;
        }
        this.sourcePosition = Node.mergeLineCharNo(lineno, charno);
    }

    public void setCharno(int charno) {
        this.sourcePosition = Node.mergeLineCharNo(this.getLineno(), charno);
    }

    public void setSourceEncodedPosition(int sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public void setSourceEncodedPositionForTree(int sourcePosition) {
        this.sourcePosition = sourcePosition;
        Node child = this.first;
        while (child != null) {
            child.setSourceEncodedPositionForTree(sourcePosition);
            child = child.next;
        }
    }

    protected static int mergeLineCharNo(int lineno, int charno) {
        if (lineno < 0 || charno < 0) {
            return -1;
        }
        if ((charno & 0xFFFFF000) != 0) {
            return lineno << 12 | 0xFFF;
        }
        return lineno << 12 | charno & 0xFFF;
    }

    protected static int extractLineno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo >>> 12;
    }

    protected static int extractCharno(int lineCharNo) {
        if (lineCharNo == -1) {
            return -1;
        }
        return lineCharNo & 0xFFF;
    }

    public Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    public Iterable<Node> siblings() {
        return new SiblingNodeIterable(this);
    }

    @Nullable
    PropListItem getPropListHeadForTesting() {
        return this.propListHead;
    }

    void setPropListHead(@Nullable PropListItem propListHead) {
        this.propListHead = propListHead;
    }

    @Nullable
    public Node getParent() {
        return this.parent;
    }

    @Nullable
    public Node getGrandparent() {
        return this.parent == null ? null : this.parent.parent;
    }

    @Nullable
    public Node getAncestor(int level) {
        Node node;
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0);
        for (node = this; node != null && level-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public boolean isDescendantOf(Node node) {
        Node n = this;
        while (n != null) {
            if (n == node) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    public AncestorIterable getAncestors() {
        return new AncestorIterable((Node)Preconditions.checkNotNull((Object)this.getParent()));
    }

    public boolean hasOneChild() {
        return this.first != null && this.first.next == null;
    }

    public boolean hasTwoChildren() {
        return this.first != null && this.first.next != null && this.first.next == this.getLastChild();
    }

    public boolean hasZeroOrOneChild() {
        return this.first == this.getLastChild();
    }

    public boolean hasMoreThanOneChild() {
        return this.first != null && this.first.next != null;
    }

    public boolean hasXChildren(int x) {
        int c;
        Node n = this.first;
        for (c = 0; n != null && c <= x; ++c) {
            n = n.next;
        }
        return c == x;
    }

    public int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public boolean hasChild(Node child) {
        Node n = this.first;
        while (n != null) {
            if (child == n) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    public String checkTreeEquals(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual);
        if (diff != null) {
            return "Node tree inequality:\nTree1:\n" + this.toStringTree() + "\n\nTree2:\n" + actual.toStringTree() + "\n\nSubtree1: " + diff.nodeExpected.toStringTree() + "\n\nSubtree2: " + diff.nodeActual.toStringTree();
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    public String checkTreeEqualsIncludingJsDoc(Node actual) {
        NodeMismatch diff = this.checkTreeEqualsImpl(actual, true);
        if (diff != null) {
            if (diff.nodeActual.isEquivalentTo(diff.nodeExpected, false, true, false)) {
                String jsDocActual = diff.nodeActual.getJSDocInfo() == null ? "(none)" : diff.nodeActual.getJSDocInfo().toStringVerbose();
                String jsDocExpected = diff.nodeExpected.getJSDocInfo() == null ? "(none)" : diff.nodeExpected.getJSDocInfo().toStringVerbose();
                return "Node tree inequality:\nTree:\n" + this.toStringTree() + "\n\nJSDoc differs on subtree: " + diff.nodeExpected + "\nExpected JSDoc: " + jsDocExpected + "\nActual JSDoc  : " + jsDocActual;
            }
            return "Node tree inequality:\nExpected tree:\n" + this.toStringTree() + "\n\nActual tree:\n" + actual.toStringTree() + "\n\nExpected subtree: " + diff.nodeExpected.toStringTree() + "\n\nActual subtree: " + diff.nodeActual.toStringTree();
        }
        return null;
    }

    @Nullable
    NodeMismatch checkTreeEqualsImpl(Node actual) {
        return this.checkTreeEqualsImpl(actual, false);
    }

    @Nullable
    private NodeMismatch checkTreeEqualsImpl(Node actual, boolean jsDoc) {
        if (!this.isEquivalentTo(actual, false, false, jsDoc)) {
            return new NodeMismatch(this, actual);
        }
        Node expectedChild = this.first;
        Node actualChild = actual.first;
        while (expectedChild != null) {
            NodeMismatch res = expectedChild.checkTreeEqualsImpl(actualChild, jsDoc);
            if (res != null) {
                return res;
            }
            expectedChild = expectedChild.next;
            actualChild = actualChild.next;
        }
        return null;
    }

    public final boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, false);
    }

    public final boolean isEquivalentToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, false);
    }

    public final boolean isEquivalentWithSideEffectsTo(Node node) {
        return this.isEquivalentTo(node, false, true, false, true);
    }

    public final boolean isEquivalentWithSideEffectsToShallow(Node node) {
        return this.isEquivalentTo(node, false, false, false, true);
    }

    public final boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true, true, false);
    }

    final boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc) {
        return this.isEquivalentTo(node, compareType, recurse, jsDoc, false);
    }

    public boolean isEquivalentTo(Node node, boolean compareType, boolean recurse, boolean jsDoc, boolean sideEffect) {
        if (this.token != node.token || this.getChildCount() != node.getChildCount() || this.getClass() != node.getClass()) {
            return false;
        }
        if (compareType && !JSType.isEquivalent(this.getJSType(), node.getJSType())) {
            return false;
        }
        if (jsDoc && !JSDocInfo.areEquivalent(this.getJSDocInfo(), node.getJSDocInfo())) {
            return false;
        }
        TypeDeclarationNode thisTDN = this.getDeclaredTypeExpression();
        TypeDeclarationNode thatTDN = node.getDeclaredTypeExpression();
        if (!(thisTDN == null && thatTDN == null || thisTDN != null && thatTDN != null && thisTDN.isEquivalentTo(thatTDN, compareType, recurse, jsDoc))) {
            return false;
        }
        if (this.token == Token.INC || this.token == Token.DEC) {
            int post2;
            int post1 = this.getIntProp(32);
            if (post1 != (post2 = node.getIntProp(32))) {
                return false;
            }
        } else if (this.token == Token.STRING || this.token == Token.STRING_KEY) {
            int slashV2;
            int quoted2;
            int quoted1;
            if (this.token == Token.STRING_KEY && (quoted1 = this.getIntProp(36)) != (quoted2 = node.getIntProp(36))) {
                return false;
            }
            int slashV1 = this.getIntProp(54);
            if (slashV1 != (slashV2 = node.getIntProp(54))) {
                return false;
            }
        } else if (this.token == Token.CALL ? this.getBooleanProp(50) != node.getBooleanProp(50) : this.token == Token.FUNCTION && this.isArrowFunction() != node.isArrowFunction()) {
            return false;
        }
        if (sideEffect && this.getSideEffectFlags() != node.getSideEffectFlags()) {
            return false;
        }
        if (recurse) {
            Node n = this.first;
            Node n2 = node.first;
            while (n != null) {
                if (!n.isEquivalentTo(n2, compareType, recurse, jsDoc, sideEffect)) {
                    return false;
                }
                n = n.next;
                n2 = n2.next;
            }
        }
        return true;
    }

    @Nullable
    public String getQualifiedName() {
        switch (this.token) {
            case NAME: {
                String name = this.getString();
                return name.isEmpty() ? null : name;
            }
            case GETPROP: {
                StringBuilder builder = this.getQualifiedNameForGetProp(0);
                return builder != null ? builder.toString() : null;
            }
            case THIS: {
                return "this";
            }
            case SUPER: {
                return "super";
            }
        }
        return null;
    }

    @Nullable
    private StringBuilder getQualifiedNameForGetProp(int reserve) {
        StringBuilder builder;
        String propName = this.getLastChild().getString();
        reserve += 1 + propName.length();
        if (this.first.isGetProp()) {
            builder = this.first.getQualifiedNameForGetProp(reserve);
            if (builder == null) {
                return null;
            }
        } else {
            String left = this.first.getQualifiedName();
            if (left == null) {
                return null;
            }
            builder = new StringBuilder(left.length() + reserve);
            builder.append(left);
        }
        builder.append('.').append(propName);
        return builder;
    }

    @Nullable
    public String getOriginalQualifiedName() {
        if (this.token == Token.NAME || this.getBooleanProp(90)) {
            String name = this.getOriginalName();
            if (name == null) {
                name = this.getString();
            }
            return name.isEmpty() ? null : name;
        }
        if (this.token == Token.GETPROP) {
            String left = this.getFirstChild().getOriginalQualifiedName();
            if (left == null) {
                return null;
            }
            String right = this.getLastChild().getOriginalName();
            if (right == null) {
                right = this.getLastChild().getString();
            }
            return left + "." + right;
        }
        if (this.token == Token.THIS) {
            return "this";
        }
        if (this.token == Token.SUPER) {
            return "super";
        }
        return null;
    }

    public boolean isQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public boolean matchesQualifiedName(String name) {
        return name != null && this.matchesQualifiedName(name, name.length());
    }

    private boolean matchesQualifiedName(String qname, int endIndex) {
        int start = qname.lastIndexOf(46, endIndex - 1) + 1;
        switch (this.getToken()) {
            case NAME: 
            case MEMBER_FUNCTION_DEF: {
                String name = this.getString();
                return start == 0 && !name.isEmpty() && name.length() == endIndex && qname.startsWith(name);
            }
            case THIS: {
                return start == 0 && 4 == endIndex && qname.startsWith("this");
            }
            case SUPER: {
                return start == 0 && 5 == endIndex && qname.startsWith("super");
            }
            case GETPROP: {
                String prop = this.getLastChild().getString();
                return start > 1 && prop.length() == endIndex - start && prop.regionMatches(0, qname, start, endIndex - start) && this.getFirstChild().matchesQualifiedName(qname, start - 1);
            }
        }
        return false;
    }

    public boolean matchesQualifiedName(Node n) {
        if (n == null || n.token != this.token) {
            return false;
        }
        switch (this.token) {
            case NAME: {
                return !this.getString().isEmpty() && this.getString().equals(n.getString());
            }
            case THIS: 
            case SUPER: {
                return true;
            }
            case GETPROP: {
                return this.getLastChild().getString().equals(n.getLastChild().getString()) && this.getFirstChild().matchesQualifiedName(n.getFirstChild());
            }
        }
        return false;
    }

    public boolean isUnscopedQualifiedName() {
        switch (this.getToken()) {
            case NAME: {
                return !this.getString().isEmpty();
            }
            case GETPROP: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public boolean isValidAssignmentTarget() {
        switch (this.getToken()) {
            case NAME: 
            case GETPROP: 
            case CAST: 
            case DEFAULT_VALUE: 
            case GETELEM: 
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return true;
            }
        }
        return false;
    }

    public Node detachFromParent() {
        return this.detach();
    }

    public Node detach() {
        Preconditions.checkNotNull((Object)this.parent);
        this.parent.removeChild(this);
        return this;
    }

    @Nullable
    public Node removeFirstChild() {
        Node child = this.first;
        if (child != null) {
            this.removeChild(child);
        }
        return child;
    }

    @Nullable
    public Node removeChildren() {
        Node children = this.first;
        Node child = this.first;
        while (child != null) {
            child.parent = null;
            child = child.next;
        }
        this.first = null;
        return children;
    }

    public void detachChildren() {
        Node child = this.first;
        while (child != null) {
            Node nextChild = child.next;
            child.parent = null;
            child.next = null;
            child.previous = null;
            child = nextChild;
        }
        this.first = null;
    }

    public Node removeChildAfter(Node prev) {
        Node target = prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"no next sibling.");
        this.removeChild(target);
        return target;
    }

    public Node removeFirstOrChildAfter(@Nullable Node prev) {
        Preconditions.checkArgument((prev == null || prev.parent == this ? 1 : 0) != 0, (Object)"invalid node.");
        Node target = prev == null ? this.first : prev.next;
        Preconditions.checkNotNull((Object)target, (Object)"no next sibling.");
        this.removeChild(target);
        return target;
    }

    public Node cloneNode() {
        return this.cloneNode(false);
    }

    protected Node cloneNode(boolean cloneTypeExprs) {
        return this.copyNodeFields(new Node(this.token), cloneTypeExprs);
    }

    <T extends Node> T copyNodeFields(T dst, boolean cloneTypeExprs) {
        JSDocInfo info;
        dst.setSourceEncodedPosition(this.sourcePosition);
        dst.setLength(this.getLength());
        dst.setTypeI(this.typei);
        dst.setPropListHead(this.propListHead);
        if (cloneTypeExprs && (info = this.getJSDocInfo()) != null) {
            this.setJSDocInfo(info.clone(true));
        }
        return dst;
    }

    public Node cloneTree() {
        return this.cloneTree(false);
    }

    public Node cloneTree(boolean cloneTypeExprs) {
        Node result = this.cloneNode(cloneTypeExprs);
        Node firstChild = null;
        Node lastChild = null;
        if (this.hasChildren()) {
            Node n2 = this.getFirstChild();
            while (n2 != null) {
                Node n2clone = n2.cloneTree(cloneTypeExprs);
                n2clone.parent = result;
                if (firstChild == null) {
                    lastChild = firstChild = n2clone;
                } else {
                    lastChild.next = n2clone;
                    n2clone.previous = lastChild;
                    lastChild = n2clone;
                }
                n2 = n2.next;
            }
            firstChild.previous = lastChild;
            lastChild.next = null;
            result.first = firstChild;
        }
        return result;
    }

    @Deprecated
    public Node useSourceInfoWithoutLengthIfMissingFrom(Node other) {
        if (this.getProp(40) == null) {
            this.putProp(40, other.getProp(40));
        }
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFile(other.getStaticSourceFile());
            this.sourcePosition = other.sourcePosition;
        }
        return this;
    }

    @Deprecated
    public Node useSourceInfoWithoutLengthIfMissingFromForTree(Node other) {
        this.useSourceInfoWithoutLengthIfMissingFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoWithoutLengthIfMissingFromForTree(other);
            child = child.next;
        }
        return this;
    }

    public Node useSourceInfoFrom(Node other) {
        this.putProp(40, other.getProp(40));
        this.setStaticSourceFile(other.getStaticSourceFile());
        this.sourcePosition = other.sourcePosition;
        this.length = other.length;
        return this;
    }

    public Node srcref(Node other) {
        return this.useSourceInfoFrom(other);
    }

    public Node useSourceInfoFromForTree(Node other) {
        this.useSourceInfoFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoFromForTree(other);
            child = child.next;
        }
        return this;
    }

    public Node srcrefTree(Node other) {
        return this.useSourceInfoFromForTree(other);
    }

    public Node useSourceInfoIfMissingFrom(Node other) {
        if (this.getProp(40) == null) {
            this.putProp(40, other.getProp(40));
        }
        if (this.getStaticSourceFile() == null) {
            this.setStaticSourceFile(other.getStaticSourceFile());
            this.sourcePosition = other.sourcePosition;
            this.length = other.length;
        }
        return this;
    }

    public Node useSourceInfoIfMissingFromForTree(Node other) {
        this.useSourceInfoIfMissingFrom(other);
        Node child = this.first;
        while (child != null) {
            child.useSourceInfoIfMissingFromForTree(other);
            child = child.next;
        }
        return this;
    }

    @Nullable
    public JSType getJSType() {
        return this.typei instanceof JSType ? (JSType)this.typei : null;
    }

    public void setJSType(@Nullable JSType jsType) {
        this.typei = jsType;
    }

    @Nullable
    public TypeI getTypeI() {
        return this.typei;
    }

    public void setTypeI(@Nullable TypeI type) {
        this.typei = type;
    }

    @Nullable
    public TypeI getTypeIIfOld() {
        return this.typei instanceof JSType ? this.typei : null;
    }

    @Nullable
    public JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp(29);
    }

    public Node setJSDocInfo(JSDocInfo info) {
        this.putProp(29, info);
        return this;
    }

    public void setChangeTime(int time) {
        this.putIntProp(56, time);
    }

    public int getChangeTime() {
        return this.getIntProp(56);
    }

    public void setDeleted(boolean deleted) {
        this.putBooleanProp(94, deleted);
    }

    public boolean isDeleted() {
        return this.getBooleanProp(94);
    }

    public void setVarArgs(boolean varArgs) {
        this.putBooleanProp(30, varArgs);
    }

    public boolean isVarArgs() {
        return this.getBooleanProp(30);
    }

    public void setOptionalArg(boolean optionalArg) {
        this.putBooleanProp(37, optionalArg);
    }

    public boolean isOptionalArg() {
        return this.getBooleanProp(37);
    }

    public boolean isOptionalEs6Typed() {
        return this.getBooleanProp(80);
    }

    public void setIsSyntheticBlock(boolean val) {
        Preconditions.checkState((this.token == Token.BLOCK ? 1 : 0) != 0);
        this.putBooleanProp(38, val);
    }

    public boolean isSyntheticBlock() {
        return this.getBooleanProp(38);
    }

    public void setDirectives(Set<String> val) {
        this.putProp(48, val);
    }

    @Nullable
    public Set<String> getDirectives() {
        return (Set)this.getProp(48);
    }

    public void setIsAddedBlock(boolean val) {
        this.putBooleanProp(39, val);
    }

    public boolean isAddedBlock() {
        return this.getBooleanProp(39);
    }

    public void setStaticMember(boolean isStatic) {
        this.putBooleanProp(58, isStatic);
    }

    public boolean isStaticMember() {
        return this.getBooleanProp(58);
    }

    public void setIsGeneratorFunction(boolean isGenerator) {
        this.putBooleanProp(59, isGenerator);
    }

    public boolean isGeneratorFunction() {
        return this.getBooleanProp(59);
    }

    public void setGeneratorMarker(boolean isGeneratorMarker) {
        this.putBooleanProp(66, isGeneratorMarker);
    }

    public boolean isGeneratorMarker() {
        return this.getBooleanProp(66);
    }

    public void setGeneratorSafe(boolean isGeneratorSafe) {
        this.putBooleanProp(67, isGeneratorSafe);
    }

    public boolean isGeneratorSafe() {
        return this.getBooleanProp(67);
    }

    public void setIsArrowFunction(boolean isArrow) {
        this.putBooleanProp(60, isArrow);
    }

    public boolean isArrowFunction() {
        return this.getBooleanProp(60);
    }

    public void setIsAsyncFunction(boolean isAsync) {
        this.putBooleanProp(61, isAsync);
    }

    public boolean isAsyncFunction() {
        return this.getBooleanProp(61);
    }

    public void setYieldFor(boolean isGenerator) {
        this.putBooleanProp(62, isGenerator);
    }

    public boolean isYieldFor() {
        return this.getBooleanProp(62);
    }

    public void setSideEffectFlags(int flags) {
        Preconditions.checkArgument((this.getToken() == Token.CALL || this.getToken() == Token.NEW ? 1 : 0) != 0, (String)"setIsNoSideEffectsCall only supports CALL and NEW nodes, got %s", (Object)((Object)this.getToken()));
        this.putIntProp(42, flags);
    }

    public void setSideEffectFlags(SideEffectFlags flags) {
        this.setSideEffectFlags(flags.valueOf());
    }

    public int getSideEffectFlags() {
        return this.getIntProp(42);
    }

    public boolean isOnlyModifiesThisCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 13);
    }

    public boolean isOnlyModifiesArgumentsCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 11);
    }

    public boolean isNoSideEffectsCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags(), 15);
    }

    public boolean isLocalResultCall() {
        return Node.areBitFlagsSet(this.getSideEffectFlags(), 16);
    }

    public boolean mayMutateArguments() {
        return !Node.areBitFlagsSet(this.getSideEffectFlags(), 4);
    }

    public boolean mayMutateGlobalStateOrThrow() {
        return !Node.areBitFlagsSet(this.getSideEffectFlags(), 9);
    }

    private static boolean areBitFlagsSet(int value, int flags) {
        return (value & flags) == flags;
    }

    public boolean isQuotedString() {
        return false;
    }

    public void setQuotedString() {
        throw new IllegalStateException(this + " is not a StringNode");
    }

    public boolean isAdd() {
        return this.token == Token.ADD;
    }

    public boolean isSub() {
        return this.token == Token.SUB;
    }

    public boolean isAnd() {
        return this.token == Token.AND;
    }

    public boolean isArrayLit() {
        return this.token == Token.ARRAYLIT;
    }

    public boolean isArrayPattern() {
        return this.token == Token.ARRAY_PATTERN;
    }

    public boolean isAssign() {
        return this.token == Token.ASSIGN;
    }

    public boolean isAssignAdd() {
        return this.token == Token.ASSIGN_ADD;
    }

    public boolean isNormalBlock() {
        return this.token == Token.BLOCK;
    }

    public boolean isRoot() {
        return this.token == Token.ROOT;
    }

    public boolean isBreak() {
        return this.token == Token.BREAK;
    }

    public boolean isCall() {
        return this.token == Token.CALL;
    }

    public boolean isCase() {
        return this.token == Token.CASE;
    }

    public boolean isCast() {
        return this.token == Token.CAST;
    }

    public boolean isCatch() {
        return this.token == Token.CATCH;
    }

    public boolean isClass() {
        return this.token == Token.CLASS;
    }

    public boolean isClassMembers() {
        return this.token == Token.CLASS_MEMBERS;
    }

    public boolean isComma() {
        return this.token == Token.COMMA;
    }

    public boolean isComputedProp() {
        return this.token == Token.COMPUTED_PROP;
    }

    public boolean isContinue() {
        return this.token == Token.CONTINUE;
    }

    public boolean isConst() {
        return this.token == Token.CONST;
    }

    public boolean isDebugger() {
        return this.token == Token.DEBUGGER;
    }

    public boolean isDec() {
        return this.token == Token.DEC;
    }

    public boolean isDefaultCase() {
        return this.token == Token.DEFAULT_CASE;
    }

    public boolean isDefaultValue() {
        return this.token == Token.DEFAULT_VALUE;
    }

    public boolean isDelProp() {
        return this.token == Token.DELPROP;
    }

    public boolean isDestructuringLhs() {
        return this.token == Token.DESTRUCTURING_LHS;
    }

    public boolean isDestructuringPattern() {
        return this.isObjectPattern() || this.isArrayPattern();
    }

    public boolean isDo() {
        return this.token == Token.DO;
    }

    public boolean isEmpty() {
        return this.token == Token.EMPTY;
    }

    public boolean isExport() {
        return this.token == Token.EXPORT;
    }

    public boolean isExprResult() {
        return this.token == Token.EXPR_RESULT;
    }

    public boolean isFalse() {
        return this.token == Token.FALSE;
    }

    @Deprecated
    public boolean isFor() {
        return this.isVanillaFor() || this.isForIn();
    }

    public boolean isVanillaFor() {
        return this.token == Token.FOR;
    }

    public boolean isForIn() {
        return this.token == Token.FOR_IN;
    }

    public boolean isForOf() {
        return this.token == Token.FOR_OF;
    }

    public boolean isFunction() {
        return this.token == Token.FUNCTION;
    }

    public boolean isGetterDef() {
        return this.token == Token.GETTER_DEF;
    }

    public boolean isGetElem() {
        return this.token == Token.GETELEM;
    }

    public boolean isGetProp() {
        return this.token == Token.GETPROP;
    }

    public boolean isHook() {
        return this.token == Token.HOOK;
    }

    public boolean isIf() {
        return this.token == Token.IF;
    }

    public boolean isImport() {
        return this.token == Token.IMPORT;
    }

    public boolean isImportStar() {
        return this.token == Token.IMPORT_STAR;
    }

    public boolean isImportSpec() {
        return this.token == Token.IMPORT_SPEC;
    }

    public boolean isImportSpecs() {
        return this.token == Token.IMPORT_SPECS;
    }

    public boolean isIn() {
        return this.token == Token.IN;
    }

    public boolean isInc() {
        return this.token == Token.INC;
    }

    public boolean isInstanceOf() {
        return this.token == Token.INSTANCEOF;
    }

    public boolean isInterfaceMembers() {
        return this.token == Token.INTERFACE_MEMBERS;
    }

    public boolean isRecordType() {
        return this.token == Token.RECORD_TYPE;
    }

    public boolean isCallSignature() {
        return this.token == Token.CALL_SIGNATURE;
    }

    public boolean isIndexSignature() {
        return this.token == Token.INDEX_SIGNATURE;
    }

    public boolean isLabel() {
        return this.token == Token.LABEL;
    }

    public boolean isLabelName() {
        return this.token == Token.LABEL_NAME;
    }

    public boolean isLet() {
        return this.token == Token.LET;
    }

    public boolean isMemberFunctionDef() {
        return this.token == Token.MEMBER_FUNCTION_DEF;
    }

    public boolean isMemberVariableDef() {
        return this.token == Token.MEMBER_VARIABLE_DEF;
    }

    public boolean isModuleBody() {
        return this.token == Token.MODULE_BODY;
    }

    public boolean isName() {
        return this.token == Token.NAME;
    }

    public boolean isNE() {
        return this.token == Token.NE;
    }

    public boolean isNew() {
        return this.token == Token.NEW;
    }

    public boolean isNot() {
        return this.token == Token.NOT;
    }

    public boolean isNull() {
        return this.token == Token.NULL;
    }

    public boolean isNumber() {
        return this.token == Token.NUMBER;
    }

    public boolean isObjectLit() {
        return this.token == Token.OBJECTLIT;
    }

    public boolean isObjectPattern() {
        return this.token == Token.OBJECT_PATTERN;
    }

    public boolean isOr() {
        return this.token == Token.OR;
    }

    public boolean isParamList() {
        return this.token == Token.PARAM_LIST;
    }

    public boolean isRegExp() {
        return this.token == Token.REGEXP;
    }

    public boolean isRest() {
        return this.token == Token.REST;
    }

    public boolean isReturn() {
        return this.token == Token.RETURN;
    }

    public boolean isScript() {
        return this.token == Token.SCRIPT;
    }

    public boolean isSetterDef() {
        return this.token == Token.SETTER_DEF;
    }

    public boolean isSpread() {
        return this.token == Token.SPREAD;
    }

    public boolean isString() {
        return this.token == Token.STRING;
    }

    public boolean isStringKey() {
        return this.token == Token.STRING_KEY;
    }

    public boolean isSuper() {
        return this.token == Token.SUPER;
    }

    public boolean isSwitch() {
        return this.token == Token.SWITCH;
    }

    public boolean isTaggedTemplateLit() {
        return this.token == Token.TAGGED_TEMPLATELIT;
    }

    public boolean isTemplateLit() {
        return this.token == Token.TEMPLATELIT;
    }

    public boolean isTemplateLitSub() {
        return this.token == Token.TEMPLATELIT_SUB;
    }

    public boolean isThis() {
        return this.token == Token.THIS;
    }

    public boolean isThrow() {
        return this.token == Token.THROW;
    }

    public boolean isTrue() {
        return this.token == Token.TRUE;
    }

    public boolean isTry() {
        return this.token == Token.TRY;
    }

    public boolean isTypeOf() {
        return this.token == Token.TYPEOF;
    }

    public boolean isVar() {
        return this.token == Token.VAR;
    }

    public boolean isVoid() {
        return this.token == Token.VOID;
    }

    public boolean isWhile() {
        return this.token == Token.WHILE;
    }

    public boolean isWith() {
        return this.token == Token.WITH;
    }

    public boolean isYield() {
        return this.token == Token.YIELD;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        Node currentChild = this.first;
        while (currentChild != null) {
            out.writeObject(currentChild);
            currentChild = currentChild.next;
        }
        out.writeObject(null);
        out.writeObject(this.typei);
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.first = (Node)in.readObject();
        if (this.first != null) {
            Node currentChild;
            Preconditions.checkState((this.first.parent == null ? 1 : 0) != 0);
            this.first.parent = this;
            Node lastChild = this.first;
            while ((currentChild = (Node)in.readObject()) != null) {
                Preconditions.checkState((currentChild.parent == null ? 1 : 0) != 0);
                currentChild.parent = this;
                Preconditions.checkState((currentChild.previous == null ? 1 : 0) != 0);
                currentChild.previous = lastChild;
                Preconditions.checkState((lastChild.next == null ? 1 : 0) != 0);
                lastChild.next = currentChild;
                lastChild = currentChild;
            }
            Preconditions.checkState((this.first.previous == null ? 1 : 0) != 0);
            this.first.previous = lastChild;
        }
        this.typei = (TypeI)in.readObject();
    }

    static class NodeMismatch {
        final Node nodeExpected;
        final Node nodeActual;

        NodeMismatch(Node nodeExpected, Node nodeActual) {
            this.nodeExpected = nodeExpected;
            this.nodeActual = nodeActual;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof NodeMismatch) {
                NodeMismatch that = (NodeMismatch)object;
                return that.nodeExpected.equals(this.nodeExpected) && that.nodeActual.equals(this.nodeActual);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.nodeExpected, this.nodeActual});
        }
    }

    public static class SideEffectFlags {
        private int value = 0;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int value) {
            this.value = value;
        }

        public int valueOf() {
            return this.value;
        }

        public SideEffectFlags setAllFlags() {
            this.value = 0;
            return this;
        }

        public SideEffectFlags clearAllFlags() {
            this.value = 31;
            return this;
        }

        public void clearSideEffectFlags() {
            this.value |= 0xF;
        }

        public SideEffectFlags setMutatesGlobalState() {
            this.removeFlag(1);
            this.removeFlag(4);
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setThrows() {
            this.removeFlag(8);
            return this;
        }

        public SideEffectFlags setMutatesThis() {
            this.removeFlag(2);
            return this;
        }

        public SideEffectFlags setMutatesArguments() {
            this.removeFlag(4);
            return this;
        }

        public SideEffectFlags setReturnsTainted() {
            this.removeFlag(16);
            return this;
        }

        private void removeFlag(int flag) {
            this.value &= ~flag;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Side effects: ");
            if ((this.value & 2) == 0) {
                builder.append("this ");
            }
            if ((this.value & 1) == 0) {
                builder.append("global ");
            }
            if ((this.value & 8) == 0) {
                builder.append("throw ");
            }
            if ((this.value & 4) == 0) {
                builder.append("args ");
            }
            if ((this.value & 0x10) == 0) {
                builder.append("return ");
            }
            return builder.toString();
        }
    }

    public static class AncestorIterable
    implements Iterable<Node> {
        @Nullable
        private Node cur;

        AncestorIterable(Node cur) {
            this.cur = cur;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return AncestorIterable.this.cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node n = AncestorIterable.this.cur;
                    AncestorIterable.this.cur = AncestorIterable.this.cur.getParent();
                    return n;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterator
    implements Iterator<Node> {
        @Nullable
        private Node current;

        SiblingNodeIterator(Node start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Node n = this.current;
            this.current = this.current.getNext();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node> {
        private final Node start;

        SiblingNodeIterable(Node start) {
            this.start = start;
        }

        @Override
        public Iterator<Node> iterator() {
            return new SiblingNodeIterator(this.start);
        }
    }

    private static class IntPropListItem
    extends AbstractPropListItem {
        private static final long serialVersionUID = 1L;
        final int intValue;

        IntPropListItem(int propType, int intValue, @Nullable PropListItem next) {
            super(propType, next);
            this.intValue = intValue;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Object getObjectValue() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new IntPropListItem(this.getType(), this.intValue, next);
        }
    }

    private static class ObjectPropListItem
    extends AbstractPropListItem {
        private static final long serialVersionUID = 1L;
        private final Object objectValue;

        ObjectPropListItem(int propType, Object objectValue, @Nullable PropListItem next) {
            super(propType, next);
            this.objectValue = objectValue;
        }

        @Override
        public int getIntValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getObjectValue() {
            return this.objectValue;
        }

        public String toString() {
            return String.valueOf(this.objectValue);
        }

        @Override
        public PropListItem chain(@Nullable PropListItem next) {
            return new ObjectPropListItem(this.getType(), this.objectValue, next);
        }
    }

    private static abstract class AbstractPropListItem
    implements PropListItem,
    Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        private final PropListItem next;
        private final int propType;

        AbstractPropListItem(int propType, @Nullable PropListItem next) {
            this.propType = propType;
            this.next = next;
        }

        @Override
        public int getType() {
            return this.propType;
        }

        @Override
        @Nullable
        public PropListItem getNext() {
            return this.next;
        }

        @Override
        public abstract PropListItem chain(@Nullable PropListItem var1);
    }

    private static interface PropListItem {
        public int getType();

        @Nullable
        public PropListItem getNext();

        public PropListItem chain(@Nullable PropListItem var1);

        public Object getObjectValue();

        public int getIntValue();
    }

    private static class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        StringNode(Token token, String str) {
            super(token);
            this.setString(str);
        }

        StringNode(Token token, String str, int lineno, int charno) {
            super(token, lineno, charno);
            this.setString(str);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str.intern();
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            return super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect) && this.str.equals(((StringNode)node).str);
        }

        @Override
        public boolean isQuotedString() {
            return this.getBooleanProp(36);
        }

        @Override
        public void setQuotedString() {
            this.putBooleanProp(36, true);
        }

        @Override
        public StringNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new StringNode(this.token, this.str), cloneTypeExprs);
        }
    }

    private static class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double number) {
            super(Token.NUMBER);
            this.number = number;
        }

        public NumberNode(double number, int lineno, int charno) {
            super(Token.NUMBER, lineno, charno);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public void setDouble(double d) {
            this.number = d;
        }

        @Override
        public boolean isEquivalentTo(Node node, boolean compareType, boolean recur, boolean jsDoc, boolean sideEffect) {
            double thatValue;
            double thisValue;
            boolean equiv = super.isEquivalentTo(node, compareType, recur, jsDoc, sideEffect);
            if (equiv && (thisValue = this.getDouble()) == (thatValue = ((NumberNode)node).getDouble())) {
                return thisValue != 0.0 || 1.0 / thisValue == 1.0 / thatValue;
            }
            return false;
        }

        @Override
        public NumberNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new NumberNode(this.number), cloneTypeExprs);
        }
    }

    public static class TypeDeclarationNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        public TypeDeclarationNode(Token nodeType, String str) {
            super(nodeType);
            this.str = str;
        }

        public TypeDeclarationNode(Token nodeType) {
            super(nodeType);
        }

        public TypeDeclarationNode(Token nodeType, Node child) {
            super(nodeType, child);
        }

        public TypeDeclarationNode(Token nodeType, Node left, Node right) {
            super(nodeType, left, right);
        }

        public TypeDeclarationNode(Token nodeType, Node left, Node mid, Node right) {
            super(nodeType, left, mid, right);
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public TypeDeclarationNode cloneNode(boolean cloneTypeExprs) {
            return this.copyNodeFields(new TypeDeclarationNode(this.token, this.str), cloneTypeExprs);
        }
    }
}

