/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class NominalType
implements Serializable {
    private final ImmutableMap<String, JSType> typeMap;
    private final RawNominalType rawType;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");

    NominalType(ImmutableMap<String, JSType> typeMap, RawNominalType rawType) {
        Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll(rawType.getTypeParameters()) && rawType.getTypeParameters().containsAll((Collection)typeMap.keySet()) ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.rawType = rawType;
    }

    public RawNominalType getRawNominalType() {
        Preconditions.checkState((!this.rawType.isFrozen() ? 1 : 0) != 0);
        return this.rawType;
    }

    public RawNominalType getRawNominalTypeAfterTypeChecking() {
        return this.rawType;
    }

    public JSType getNamespaceType() {
        return this.rawType.toJSType();
    }

    public JSType getInstanceAsJSType() {
        return this.rawType.isGeneric() && !this.typeMap.isEmpty() ? JSType.fromObjectType(ObjectType.fromNominalType(this)) : this.rawType.getInstanceAsJSType();
    }

    ObjectType getInstanceAsObjectType() {
        return this.rawType.isGeneric() && !this.typeMap.isEmpty() ? ObjectType.fromNominalType(this) : this.rawType.getInstanceAsJSType().getObjTypeIfSingletonObj();
    }

    JSTypes getCommonTypes() {
        return this.rawType.getCommonTypes();
    }

    ObjectKind getObjectKind() {
        return this.rawType.getObjectKind();
    }

    Map<String, JSType> getTypeMap() {
        return this.typeMap;
    }

    ImmutableList<String> getTypeParameters() {
        return this.rawType.getTypeParameters();
    }

    JSType getIndexType() {
        if (this.isIObject()) {
            return (JSType)this.typeMap.get(this.rawType.getTypeParameters().get(0));
        }
        JSType result = this.getCommonTypes().BOTTOM;
        for (NominalType interf : this.getInstantiatedIObjectInterfaces()) {
            JSType tmp = interf.getIndexType();
            if (tmp == null) continue;
            result = JSType.join(result, tmp);
        }
        return result.isBottom() ? null : result;
    }

    JSType getIndexedType() {
        if (this.isIObject()) {
            return (JSType)this.typeMap.get(this.rawType.getTypeParameters().get(1));
        }
        JSType result = this.getCommonTypes().TOP;
        boolean foundIObject = false;
        for (NominalType interf : this.getInstantiatedIObjectInterfaces()) {
            JSType tmp = interf.getIndexedType();
            if (tmp == null) continue;
            foundIObject = true;
            result = JSType.meet(result, tmp);
        }
        return foundIObject ? result : null;
    }

    boolean inheritsFromIObjectReflexive() {
        return this.rawType.inheritsFromIObjectReflexive();
    }

    boolean isClassy() {
        return !this.isFunction() && !this.isBuiltinObject() && !this.isLiteralObject();
    }

    public boolean isFunction() {
        return this.rawType.isBuiltinWithName("Function");
    }

    public boolean isBuiltinObject() {
        return this.rawType.isBuiltinObject();
    }

    public boolean isLiteralObject() {
        return this.rawType.isBuiltinWithName("Object{}");
    }

    boolean isIObject() {
        return this.rawType.isBuiltinWithName("IObject");
    }

    boolean isIArrayLike() {
        return this.rawType.isBuiltinWithName("IArrayLike");
    }

    public boolean isStruct() {
        return this.rawType.isStruct();
    }

    public boolean isDict() {
        return this.rawType.isDict();
    }

    public boolean isGeneric() {
        return this.rawType.isGeneric();
    }

    public boolean isUninstantiatedGenericType() {
        return this.rawType.isGeneric() && this.typeMap.isEmpty();
    }

    public Node getDefSite() {
        return this.rawType.getDefSite();
    }

    public JSType getPrototypeObject() {
        return this.rawType.getPrototypeObject();
    }

    public FunctionType getConstructorFunction() {
        if (this.typeMap.isEmpty()) {
            return this.rawType.getConstructorFunction();
        }
        return this.rawType.getConstructorFunction().instantiateGenerics((Map<String, JSType>)this.typeMap);
    }

    NominalType substituteGenerics(Map<String, JSType> newTypeMap) {
        if (!this.isGeneric()) {
            return this.rawType.getAsNominalType();
        }
        if (this.typeMap.isEmpty()) {
            return this.instantiateGenerics(newTypeMap);
        }
        if (newTypeMap.isEmpty()) {
            return this;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String oldKey : this.typeMap.keySet()) {
            builder.put((Object)oldKey, (Object)((JSType)this.typeMap.get((Object)oldKey)).substituteGenerics(newTypeMap));
        }
        return new NominalType((ImmutableMap<String, JSType>)builder.build(), this.rawType);
    }

    NominalType instantiateGenerics(Map<String, JSType> newTypeMap) {
        if (newTypeMap.isEmpty()) {
            return this;
        }
        if (!this.rawType.isGeneric()) {
            return this.rawType.getAsNominalType();
        }
        Preconditions.checkState((boolean)this.typeMap.isEmpty(), (String)"Expected empty typemap, found: %s", this.typeMap);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableList<String> typeParams = this.getTypeParameters();
        for (String newKey : typeParams) {
            if (!newTypeMap.containsKey(newKey)) continue;
            builder.put((Object)newKey, (Object)newTypeMap.get(newKey));
        }
        ImmutableMap resultMap = builder.build();
        if (resultMap.isEmpty()) {
            return this;
        }
        if (resultMap.size() < typeParams.size()) {
            return this;
        }
        return new NominalType((ImmutableMap<String, JSType>)resultMap, this.rawType);
    }

    NominalType instantiateGenerics(List<JSType> types) {
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((types.size() == typeParams.size() ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> typeMap = new LinkedHashMap<String, JSType>();
        for (int i = 0; i < typeParams.size(); ++i) {
            typeMap.put((String)typeParams.get(i), types.get(i));
        }
        return this.instantiateGenerics(typeMap);
    }

    NominalType instantiateGenericsWithUnknown() {
        NominalType thisWithoutTypemap = this.rawType.getAsNominalType();
        return thisWithoutTypemap.instantiateGenerics(this.getCommonTypes().MAP_TO_UNKNOWN);
    }

    NominalType instantiateGenericsWithIdentity() {
        Preconditions.checkState((boolean)this.isUninstantiatedGenericType());
        LinkedHashMap<String, JSType> m = new LinkedHashMap<String, JSType>();
        for (String typeParam : this.getTypeParameters()) {
            m.put(typeParam, JSType.fromTypeVar(this.getCommonTypes(), typeParam));
        }
        return this.instantiateGenerics(m);
    }

    public String getName() {
        return this.rawType.name;
    }

    public RawNominalType getId() {
        return this.rawType;
    }

    Set<RawNominalType> getSubtypes() {
        return this.rawType.getSubtypes();
    }

    public boolean isClass() {
        return this.rawType.isClass();
    }

    public boolean isAbstractClass() {
        return this.rawType.isAbstractClass();
    }

    public boolean isInterface() {
        return this.rawType.isInterface();
    }

    boolean isStructuralInterface() {
        return this.rawType.isStructuralInterface();
    }

    public boolean isFrozen() {
        return this.rawType.isFrozen();
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        return this.rawType.hasAncestorClass(ancestor);
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        return this.rawType.hasAncestorInterface(ancestor);
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        return this.rawType.getAllPropsOfInterface();
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        return this.rawType.getAllPropsOfClass();
    }

    public Set<String> getAllOwnClassProps() {
        return this.rawType.getAllOwnClassProps();
    }

    public NominalType getInstantiatedSuperclass() {
        Preconditions.checkState((boolean)this.rawType.isFrozen());
        if (this.rawType.getSuperClass() == null) {
            return null;
        }
        return this.rawType.getSuperClass().substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPrototypePropertyOfCtor() {
        Preconditions.checkState((boolean)this.rawType.isFrozen());
        return this.rawType.getCtorPropDeclaredType("prototype");
    }

    public ImmutableSet<NominalType> getInstantiatedInterfaces() {
        Preconditions.checkState((boolean)this.rawType.isFrozen());
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.getInterfaces()) {
            result.add((Object)interf.substituteGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    private ImmutableSet<NominalType> getInstantiatedIObjectInterfaces() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.getInterfaces()) {
            if (!interf.inheritsFromIObjectReflexive()) continue;
            result.add((Object)interf.substituteGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    NominalType getTopDefiningInterface(String pname) {
        Preconditions.checkState((boolean)this.isInterface(), (String)"Expected interface, found: %s", (Object)this);
        NominalType result = null;
        if (this.getOwnProp(pname) != null) {
            result = this;
        }
        for (NominalType nt : this.getInstantiatedInterfaces()) {
            if (nt.getOwnProp(pname) == null) continue;
            result = nt.getTopDefiningInterface(pname);
        }
        return result;
    }

    Property getProp(String pname) {
        if (this.rawType.isBuiltinWithName("Array") && NUMERIC_PATTERN.matcher(pname).matches()) {
            if (this.typeMap.isEmpty()) {
                return Property.make(this.getCommonTypes().UNKNOWN, null);
            }
            Preconditions.checkState((this.typeMap.size() == 1 ? 1 : 0) != 0);
            JSType elmType = (JSType)Iterables.getOnlyElement((Iterable)this.typeMap.values());
            return Property.make(elmType, null);
        }
        Property p = this.rawType.getProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPropDeclaredType(String pname) {
        JSType type = this.rawType.getInstancePropDeclaredType(pname);
        if (type == null) {
            return null;
        }
        return type.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    Property getOwnProp(String pname) {
        Property p = this.rawType.getOwnProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public boolean hasConstantProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p != null && p.isConstant();
    }

    boolean mayHaveProp(String pname) {
        return this.rawType.mayHaveProp(pname);
    }

    public boolean hasAbstractMethod(String pname) {
        return this.rawType.hasAbstractMethod(pname);
    }

    boolean isSubtypeOf(NominalType other, SubtypeCache subSuperMap) {
        return this.isNominalSubtypeOf(other) || other.isStructuralInterface() && this.isStructuralSubtypeOf(other, subSuperMap);
    }

    private boolean isStructuralSubtypeOf(NominalType other, SubtypeCache subSuperMap) {
        Preconditions.checkArgument((boolean)other.isStructuralInterface());
        for (String pname : other.getAllPropsOfInterface()) {
            Property prop2 = other.getProp(pname);
            Property prop1 = this.getProp(pname);
            if (!(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap))) continue;
            return false;
        }
        return true;
    }

    boolean isRawSubtypeOf(NominalType other) {
        return this.rawType.isSubtypeOf(other.rawType);
    }

    boolean isNominalSubtypeOf(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this.areTypeMapsCompatible(other);
        }
        if (other.isBuiltinObject()) {
            return true;
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                if (!i.substituteGenerics((Map<String, JSType>)this.typeMap).isNominalSubtypeOf(other)) continue;
                return true;
            }
        }
        return this.isClass() && thisRaw.getSuperClass() != null && thisRaw.getSuperClass().substituteGenerics((Map<String, JSType>)this.typeMap).isNominalSubtypeOf(other);
    }

    boolean isIObjectSubtypeOf(NominalType other) {
        Preconditions.checkState((this.inheritsFromIObjectReflexive() && other.inheritsFromIObjectReflexive() ? 1 : 0) != 0);
        return other.getIndexType().isSubtypeOf(this.getIndexType()) && this.getIndexedType().isSubtypeOf(other.getIndexedType());
    }

    private boolean areTypeMapsCompatible(NominalType other) {
        Preconditions.checkState((boolean)this.rawType.equals(other.rawType));
        if (this.typeMap.isEmpty()) {
            return other.instantiationIsUnknownOrIdentity();
        }
        if (other.typeMap.isEmpty()) {
            return this.instantiationIsUnknownOrIdentity();
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object)typeVar, (Object)this.typeMap.keySet());
            Preconditions.checkState((boolean)other.typeMap.containsKey((Object)typeVar), (String)"Other (%s) doesn't contain mapping (%s->%s) from this (%s)", (Object)other, (Object)typeVar, (Object)this.typeMap.get((Object)typeVar), (Object)this);
            JSType thisType = (JSType)this.typeMap.get((Object)typeVar);
            JSType otherType = (JSType)other.typeMap.get((Object)typeVar);
            JSTypes commonTypes = this.getCommonTypes();
            if (!(commonTypes.bivariantArrayGenerics && this.rawType.isBuiltinWithName("Array") ? !(thisType = thisType.removeType(commonTypes.NULL_OR_UNDEFINED)).isSubtypeOf(otherType = otherType.removeType(commonTypes.NULL_OR_UNDEFINED)) && !otherType.isSubtypeOf(thisType) : !thisType.isSubtypeOf(otherType))) continue;
            return false;
        }
        return true;
    }

    static NominalType unifyUnknowns(NominalType nt1, NominalType nt2) {
        if (!nt1.rawType.equals(nt2.rawType)) {
            return null;
        }
        ImmutableMap<String, JSType> m1 = nt1.typeMap;
        ImmutableMap<String, JSType> m2 = nt2.typeMap;
        if (m1.isEmpty() && m2.isEmpty()) {
            return nt1;
        }
        if (m1.isEmpty() || m2.isEmpty()) {
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : m1.entrySet()) {
            String typeVar = (String)entry.getKey();
            JSType t1 = (JSType)entry.getValue();
            JSType t2 = (JSType)m2.get(typeVar);
            if (t1.isUnknown()) {
                builder.put((Object)typeVar, (Object)t2);
                continue;
            }
            if (t2.isUnknown()) {
                builder.put((Object)typeVar, (Object)t1);
                continue;
            }
            JSType newType = JSType.unifyUnknowns(t1, t2);
            if (newType == null) {
                return null;
            }
            builder.put((Object)typeVar, (Object)newType);
        }
        return new NominalType((ImmutableMap<String, JSType>)builder.build(), nt1.rawType);
    }

    private boolean instantiationIsUnknownOrIdentity() {
        if (this.typeMap.isEmpty()) {
            return true;
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object)typeVar, (Object)this.typeMap.keySet());
            JSType t = (JSType)this.typeMap.get((Object)typeVar);
            if (t.isUnknown() || t.equals(JSType.fromTypeVar(this.getCommonTypes(), typeVar))) continue;
            return false;
        }
        return true;
    }

    private static NominalType joinTypeMaps(NominalType nt1, NominalType nt2) {
        Preconditions.checkState((boolean)nt1.rawType.equals(nt2.rawType));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (nt1.isIObject()) {
            String indexTypevar = (String)nt1.rawType.getTypeParameters().get(0);
            builder.put((Object)indexTypevar, (Object)JSType.meet(nt1.getIndexType(), nt2.getIndexType()));
            String indexedTypevar = (String)nt1.rawType.getTypeParameters().get(1);
            builder.put((Object)indexedTypevar, (Object)JSType.join(nt1.getIndexedType(), nt2.getIndexedType()));
            return new NominalType((ImmutableMap<String, JSType>)builder.build(), nt1.rawType);
        }
        if (nt1.typeMap.isEmpty() || nt2.typeMap.isEmpty()) {
            return nt1.instantiateGenericsWithUnknown();
        }
        for (String typevar : nt1.typeMap.keySet()) {
            builder.put((Object)typevar, (Object)JSType.join((JSType)nt1.typeMap.get((Object)typevar), (JSType)nt2.typeMap.get((Object)typevar)));
        }
        return new NominalType((ImmutableMap<String, JSType>)builder.build(), nt1.rawType);
    }

    static NominalType join(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isNominalSubtypeOf(c2)) {
            return c2;
        }
        if (c2.isNominalSubtypeOf(c1)) {
            return c1;
        }
        if (c1.rawType.equals(c2.rawType)) {
            return c1.isGeneric() ? NominalType.joinTypeMaps(c1, c2) : c1;
        }
        Preconditions.checkState((!c1.isRawSubtypeOf(c2) && !c2.isRawSubtypeOf(c1) ? 1 : 0) != 0);
        return null;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isNominalSubtypeOf(c2)) {
            return c1;
        }
        return c2.isNominalSubtypeOf(c1) ? c2 : null;
    }

    boolean unifyWithSubtype(NominalType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        if ((other = other.findMatchingAncestorWith(this)) == null) {
            return false;
        }
        if (!this.isGeneric()) {
            return true;
        }
        if (this.typeMap.isEmpty() || other.typeMap.isEmpty()) {
            return true;
        }
        boolean hasUnified = true;
        for (String typeParam : this.rawType.getTypeParameters()) {
            JSType fromOtherMap = (JSType)other.typeMap.get((Object)typeParam);
            Preconditions.checkNotNull((Object)fromOtherMap, (String)"Type variable %s not found in map %s", (Object)typeParam, other.typeMap);
            hasUnified = hasUnified && ((JSType)this.typeMap.get((Object)typeParam)).unifyWithSubtype(fromOtherMap, typeParameters, typeMultimap, subSuperMap);
        }
        return hasUnified;
    }

    private NominalType findMatchingAncestorWith(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this;
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                NominalType nt = i.substituteGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
                if (nt == null) continue;
                return nt;
            }
        }
        if (this.isClass() && thisRaw.getSuperClass() != null) {
            return thisRaw.getSuperClass().substituteGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
        }
        return null;
    }

    boolean isPropDefinedOnSubtype(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return this.rawType.isPropDefinedOnSubtype(pname.getLeftmostName());
    }

    Set<JSType> getSubtypesWithProperty(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return this.rawType.getSubtypesWithProperty(pname.getLeftmostName());
    }

    static boolean equalRawTypes(NominalType n1, NominalType n2) {
        return n1.rawType.equals(n2.rawType);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), ToStringContext.TO_STRING).toString();
    }

    StringBuilder appendTo(StringBuilder builder, ToStringContext ctx) {
        if (ctx.forAnnotation()) {
            builder.append("!");
        }
        if (this.typeMap.isEmpty()) {
            return this.rawType.appendTo(builder);
        }
        builder.append(this.rawType.name);
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((boolean)this.typeMap.keySet().containsAll(typeParams));
        boolean firstIteration = true;
        builder.append('<');
        for (String typeParam : typeParams) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                builder.append(',');
            }
            JSType concrete = (JSType)this.typeMap.get((Object)typeParam);
            ((JSType)Preconditions.checkNotNull((Object)concrete)).appendTo(builder, ctx);
        }
        builder.append('>');
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typeMap, this.rawType);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Preconditions.checkState((boolean)(other instanceof NominalType));
        NominalType o = (NominalType)other;
        return this.rawType.equals(o.rawType) && Objects.equals(this.typeMap, o.typeMap);
    }
}

