/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.Set;
import javax.annotation.Nullable;

public final class CheckJSDocStyle
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType INVALID_SUPPRESS = DiagnosticType.disabled("JSC_INVALID_SUPPRESS", "@suppress annotation not allowed here. See https://github.com/google/closure-compiler/wiki/@suppress-annotations");
    public static final DiagnosticType CONSTRUCTOR_DISALLOWED_JSDOC = DiagnosticType.disabled("JSC_CONSTRUCTOR_DISALLOWED_JSDOC", "Visibility annotations on constructors are not supported.\nPlease mark the visibility on the class instead.");
    public static final DiagnosticType CLASS_DISALLOWED_JSDOC = DiagnosticType.disabled("JSC_CLASS_DISALLOWED_JSDOC", "@constructor annotations are redundant on classes.");
    public static final DiagnosticType MISSING_JSDOC = DiagnosticType.disabled("JSC_MISSING_JSDOC", "Function must have JSDoc.");
    public static final DiagnosticType MISSING_PARAMETER_JSDOC = DiagnosticType.disabled("JSC_MISSING_PARAMETER_JSDOC", "Parameter must have JSDoc.");
    public static final DiagnosticType MIXED_PARAM_JSDOC_STYLES = DiagnosticType.disabled("JSC_MIXED_PARAM_JSDOC_STYLES", "Functions may not use both @param annotations and inline JSDoc");
    public static final DiagnosticType MISSING_RETURN_JSDOC = DiagnosticType.disabled("JSC_MISSING_RETURN_JSDOC", "Function with non-trivial return must have @return JSDoc or inline return JSDoc.");
    public static final DiagnosticType MUST_BE_PRIVATE = DiagnosticType.disabled("JSC_MUST_BE_PRIVATE", "Property {0} must be marked @private");
    public static final DiagnosticType MUST_HAVE_TRAILING_UNDERSCORE = DiagnosticType.disabled("JSC_MUST_HAVE_TRAILING_UNDERSCORE", "Private property {0} should end with ''_''");
    public static final DiagnosticType OPTIONAL_PARAM_NOT_MARKED_OPTIONAL = DiagnosticType.disabled("JSC_OPTIONAL_PARAM_NOT_MARKED_OPTIONAL", "Parameter {0} is optional so its type must end with =");
    public static final DiagnosticType WRONG_NUMBER_OF_PARAMS = DiagnosticType.disabled("JSC_WRONG_NUMBER_OF_PARAMS", "Wrong number of @param annotations");
    public static final DiagnosticType INCORRECT_PARAM_NAME = DiagnosticType.disabled("JSC_INCORRECT_PARAM_NAME", "Incorrect param name. Are your @param annotations in the wrong order?");
    public static final DiagnosticType EXTERNS_FILES_SHOULD_BE_ANNOTATED = DiagnosticType.disabled("JSC_EXTERNS_FILES_SHOULD_BE_ANNOTATED", "Externs files should be annotated with @externs in the @fileoverview block.");
    public static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(INVALID_SUPPRESS, CLASS_DISALLOWED_JSDOC, CONSTRUCTOR_DISALLOWED_JSDOC, MISSING_JSDOC, MISSING_PARAMETER_JSDOC, MIXED_PARAM_JSDOC_STYLES, MISSING_RETURN_JSDOC, MUST_BE_PRIVATE, MUST_HAVE_TRAILING_UNDERSCORE, OPTIONAL_PARAM_NOT_MARKED_OPTIONAL, WRONG_NUMBER_OF_PARAMS, INCORRECT_PARAM_NAME, EXTERNS_FILES_SHOULD_BE_ANNOTATED);
    private final AbstractCompiler compiler;

    public CheckJSDocStyle(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
        NodeTraversal.traverseEs6(this.compiler, externs, new ExternsCallback());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                this.visitFunction(t, n, parent);
                break;
            }
            case CLASS: {
                this.visitClass(t, n);
                break;
            }
            case ASSIGN: {
                if (!n.getLastChild().isFunction()) {
                    this.visitNonFunction(t, n);
                }
                this.checkStyleForPrivateProperties(t, n);
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                for (Node decl : n.children()) {
                    if (decl.getFirstChild() != null && decl.getFirstChild().isFunction()) continue;
                    this.visitNonFunction(t, n);
                }
                break;
            }
            case STRING_KEY: {
                if (n.getFirstChild() != null && n.getFirstChild().isFunction()) break;
                this.visitNonFunction(t, n);
                break;
            }
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (NodeUtil.getEnclosingClass(n) == null) break;
                this.checkStyleForPrivateProperties(t, n);
                break;
            }
            default: {
                this.visitNonFunction(t, n);
            }
        }
    }

    private void visitNonFunction(NodeTraversal t, Node n) {
        JSDocInfo jsDoc = n.getJSDocInfo();
        if (jsDoc == null) {
            return;
        }
        if (!n.isScript()) {
            this.checkSuppressionsOnNonFunction(t, n, jsDoc);
        }
    }

    private void checkStyleForPrivateProperties(NodeTraversal t, Node n) {
        String name;
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
        if (n.isMemberFunctionDef() || n.isGetterDef() || n.isSetterDef()) {
            name = n.getString();
        } else {
            Preconditions.checkState((boolean)n.isAssign());
            Node lhs = n.getFirstChild();
            if (!lhs.isGetProp()) {
                return;
            }
            name = lhs.getLastChild().getString();
        }
        if (name.equals("constructor")) {
            return;
        }
        if (jsDoc != null && name != null) {
            if (this.compiler.getCodingConvention().isPrivate(name) && !jsDoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                t.report(n, MUST_BE_PRIVATE, name);
            } else if (this.compiler.getCodingConvention().hasPrivacyConvention() && !this.compiler.getCodingConvention().isPrivate(name) && jsDoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                t.report(n, MUST_HAVE_TRAILING_UNDERSCORE, name);
            }
        }
    }

    private void checkSuppressionsOnNonFunction(NodeTraversal t, Node n, JSDocInfo jsDoc) {
        ImmutableSet specialSuppressions = ImmutableSet.of((Object)"const", (Object)"duplicate", (Object)"extraRequire", (Object)"missingRequire");
        Sets.SetView suppressions = Sets.difference(jsDoc.getSuppressions(), (Set)specialSuppressions);
        if (!suppressions.isEmpty()) {
            t.report(n, INVALID_SUPPRESS, new String[0]);
        }
    }

    private void visitFunction(NodeTraversal t, Node function, Node parent) {
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(function);
        if (jsDoc == null && !this.hasAnyInlineJsDoc(function)) {
            this.checkMissingJsDoc(t, function);
        } else {
            if (t.inGlobalScope() || this.hasAnyInlineJsDoc(function) || !jsDoc.getParameterNames().isEmpty() || jsDoc.hasReturnType()) {
                this.checkParams(t, function, jsDoc);
            }
            this.checkReturn(t, function, jsDoc);
        }
        if (parent.isMemberFunctionDef() && "constructor".equals(parent.getString()) && jsDoc != null && !jsDoc.getVisibility().equals((Object)JSDocInfo.Visibility.INHERITED)) {
            t.report(function, CONSTRUCTOR_DISALLOWED_JSDOC, new String[0]);
        }
    }

    private void visitClass(NodeTraversal t, Node cls) {
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(cls);
        if (jsDoc == null) {
            return;
        }
        if (jsDoc.isConstructor()) {
            t.report(cls, CLASS_DISALLOWED_JSDOC, new String[0]);
        }
    }

    private void checkMissingJsDoc(NodeTraversal t, Node function) {
        String name;
        if (this.isFunctionThatShouldHaveJsDoc(t, function) && ((name = NodeUtil.getName(function)) == null || !ExportTestFunctions.isTestFunction(name))) {
            t.report(function, MISSING_JSDOC, new String[0]);
        }
    }

    private boolean isFunctionThatShouldHaveJsDoc(NodeTraversal t, Node function) {
        if (!t.inGlobalHoistScope() && !t.inModuleScope()) {
            return false;
        }
        if (NodeUtil.isFunctionDeclaration(function)) {
            return true;
        }
        if (NodeUtil.isNameDeclaration(function.getGrandparent()) || function.getParent().isAssign()) {
            return true;
        }
        if (function.getGrandparent().isClassMembers()) {
            Node memberNode = function.getParent();
            if (memberNode.isMemberFunctionDef()) {
                return !this.isConstructorWithoutParameters(function);
            }
            if (memberNode.isGetterDef() || memberNode.isSetterDef()) {
                return true;
            }
        }
        return function.getGrandparent().isObjectLit() && NodeUtil.isCallTo(function.getGrandparent().getParent(), "Polymer");
    }

    private boolean isConstructorWithoutParameters(Node function) {
        return function.getParent().matchesQualifiedName("constructor") && !NodeUtil.getFunctionParameters(function).hasChildren();
    }

    private void checkParams(NodeTraversal t, Node function, JSDocInfo jsDoc) {
        ImmutableList paramsFromJsDoc;
        if (jsDoc != null && jsDoc.isOverride()) {
            return;
        }
        if (jsDoc != null && jsDoc.getType() != null) {
            return;
        }
        ImmutableList immutableList = paramsFromJsDoc = jsDoc == null ? ImmutableList.of() : ImmutableList.copyOf(jsDoc.getParameterNames());
        if (paramsFromJsDoc.isEmpty()) {
            this.checkInlineParams(t, function);
        } else {
            Node paramList = NodeUtil.getFunctionParameters(function);
            if (paramsFromJsDoc.size() != paramList.getChildCount()) {
                t.report(paramList, WRONG_NUMBER_OF_PARAMS, new String[0]);
                return;
            }
            Node param = paramList.getFirstChild();
            for (int i = 0; i < paramsFromJsDoc.size(); ++i) {
                JSTypeExpression paramType;
                String name;
                if (param.getJSDocInfo() != null) {
                    t.report(param, MIXED_PARAM_JSDOC_STYLES, new String[0]);
                }
                if (this.checkParam(t, param, name = (String)paramsFromJsDoc.get(i), paramType = jsDoc.getParameterType(name))) {
                    return;
                }
                param = param.getNext();
            }
        }
    }

    private void checkInlineParams(NodeTraversal t, Node function) {
        Node paramList = NodeUtil.getFunctionParameters(function);
        for (Node param : paramList.children()) {
            JSDocInfo jsDoc = param.getJSDocInfo();
            if (jsDoc == null) {
                t.report(param, MISSING_PARAMETER_JSDOC, new String[0]);
                return;
            }
            JSTypeExpression paramType = jsDoc.getType();
            Preconditions.checkNotNull((Object)paramType, (Object)"Inline JSDoc info should always have a type");
            this.checkParam(t, param, null, paramType);
        }
    }

    private boolean checkParam(NodeTraversal t, Node param, @Nullable String name, JSTypeExpression paramType) {
        boolean jsDocOptional;
        boolean nameOptional;
        Node nodeToCheck = param;
        if (param.isDefaultValue()) {
            nodeToCheck = param.getFirstChild();
            nameOptional = true;
        } else if (param.isName()) {
            nameOptional = param.getString().startsWith("opt_");
        } else {
            Preconditions.checkState((param.isDestructuringPattern() || param.isRest() ? 1 : 0) != 0, (Object)param);
            nameOptional = false;
        }
        if (name == null || !nodeToCheck.isName()) {
            name = "<unknown name>";
        } else if (!nodeToCheck.matchesQualifiedName(name)) {
            t.report(nodeToCheck, INCORRECT_PARAM_NAME, new String[0]);
            return true;
        }
        boolean bl = jsDocOptional = paramType != null && paramType.isOptionalArg();
        if (nameOptional && !jsDocOptional) {
            t.report(nodeToCheck, OPTIONAL_PARAM_NOT_MARKED_OPTIONAL, name);
            return true;
        }
        return false;
    }

    private boolean hasAnyInlineJsDoc(Node function) {
        if (function.getFirstChild().getJSDocInfo() != null) {
            return true;
        }
        for (Node param : NodeUtil.getFunctionParameters(function).children()) {
            if (param.getJSDocInfo() == null) continue;
            return true;
        }
        return false;
    }

    private void checkReturn(NodeTraversal t, Node function, JSDocInfo jsDoc) {
        if (jsDoc != null && (jsDoc.hasType() || jsDoc.hasReturnType() || jsDoc.isOverride())) {
            return;
        }
        if (function.getFirstChild().getJSDocInfo() != null) {
            return;
        }
        FindNonTrivialReturn finder = new FindNonTrivialReturn();
        NodeTraversal.traverseEs6(this.compiler, function.getLastChild(), finder);
        if (finder.found) {
            t.report(function, MISSING_RETURN_JSDOC, new String[0]);
        }
    }

    private static class ExternsCallback
    implements NodeTraversal.Callback {
        private ExternsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || n.isScript();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info;
            if (n.isScript() && ((info = n.getJSDocInfo()) == null || !info.isExterns())) {
                t.report(n, EXTERNS_FILES_SHOULD_BE_ANNOTATED, new String[0]);
            }
        }
    }

    private static class FindNonTrivialReturn
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        private FindNonTrivialReturn() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.found) {
                return false;
            }
            if (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) {
                if (n.isReturn() && n.hasChildren()) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

