/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.deps.BrowserModuleResolver;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.LegacyModuleResolver;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.deps.ModuleResolver;
import com.google.javascript.jscomp.deps.NodeModuleResolver;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

public final class ModuleLoader {
    public static final DiagnosticType MODULE_CONFLICT = DiagnosticType.warning("JSC_MODULE_CONFLICT", "File has both goog.module and ES6 modules: {0}");
    public static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    public static final DiagnosticType LOAD_WARNING = DiagnosticType.warning("JSC_JS_MODULE_LOAD_WARNING", "Failed to load module \"{0}\"");
    public static final DiagnosticType INVALID_MODULE_PATH = DiagnosticType.warning("JSC_INVALID_MODULE_PATH", "Invalid module path \"{0}\" for resolution mode \"{1}\"");
    private final ErrorHandler errorHandler;
    private final ImmutableList<String> moduleRootPaths;
    private final ImmutableSet<String> modulePaths;
    private final PathResolver pathResolver;
    private final ModuleResolver moduleResolver;
    private static final Function<DependencyInfo, String> UNWRAP_DEPENDENCY_INFO = new Function<DependencyInfo, String>(){

        public String apply(DependencyInfo info) {
            return info.getName();
        }
    };
    public static final ModuleLoader EMPTY = new ModuleLoader(null, (Iterable<String>)ImmutableList.of(), (Iterable<? extends DependencyInfo>)ImmutableList.of(), ResolutionMode.BROWSER);

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, PathResolver pathResolver, ResolutionMode resolutionMode, Map<String, String> packageJsonMainEntries) {
        Preconditions.checkNotNull(moduleRoots);
        Preconditions.checkNotNull(inputs);
        Preconditions.checkNotNull((Object)((Object)pathResolver));
        this.pathResolver = pathResolver;
        this.errorHandler = errorHandler == null ? new NoopErrorHandler() : errorHandler;
        this.moduleRootPaths = ModuleLoader.createRootPaths(moduleRoots, pathResolver);
        this.modulePaths = ModuleLoader.resolvePaths(Iterables.transform((Iterable)Iterables.transform(inputs, UNWRAP_DEPENDENCY_INFO), (Function)pathResolver), this.moduleRootPaths);
        switch (resolutionMode) {
            case BROWSER: {
                this.moduleResolver = new BrowserModuleResolver(this.modulePaths, this.moduleRootPaths, this.errorHandler);
                break;
            }
            default: {
                this.moduleResolver = new LegacyModuleResolver(this.modulePaths, this.moduleRootPaths, this.errorHandler);
                break;
            }
            case NODE: {
                this.moduleResolver = new NodeModuleResolver(this.modulePaths, this.moduleRootPaths, packageJsonMainEntries, this.errorHandler);
            }
        }
    }

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, ResolutionMode resolutionMode) {
        this(errorHandler, moduleRoots, inputs, PathResolver.RELATIVE, resolutionMode);
    }

    public ModuleLoader(@Nullable ErrorHandler errorHandler, Iterable<String> moduleRoots, Iterable<? extends DependencyInfo> inputs, PathResolver pathResolver, ResolutionMode resolutionMode) {
        this(errorHandler, moduleRoots, inputs, pathResolver, resolutionMode, null);
    }

    @VisibleForTesting
    public Map<String, String> getPackageJsonMainEntries() {
        return this.moduleResolver.getPackageJsonMainEntries();
    }

    public ModulePath resolve(String path) {
        return new ModulePath(ModuleLoader.normalize(ModuleNames.escapePath((String)this.pathResolver.apply(path)), this.moduleRootPaths));
    }

    public static boolean isRelativeIdentifier(String name) {
        return name.startsWith(DEFAULT_FILENAME_PREFIX) || name.startsWith("../");
    }

    public static boolean isAbsoluteIdentifier(String name) {
        return name.startsWith(MODULE_SLASH);
    }

    public static boolean isAmbiguousIdentifier(String name) {
        return !ModuleLoader.isAbsoluteIdentifier(name) && !ModuleLoader.isRelativeIdentifier(name);
    }

    public static boolean isPathIdentifier(String name) {
        return name.contains(MODULE_SLASH);
    }

    private static ImmutableList<String> createRootPaths(Iterable<String> roots, PathResolver resolver) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String root : roots) {
            String rootModuleName = ModuleNames.escapePath((String)resolver.apply(root));
            if (ModuleLoader.isAmbiguousIdentifier(rootModuleName)) {
                rootModuleName = MODULE_SLASH + rootModuleName;
            }
            builder.add((Object)rootModuleName);
        }
        return builder.build();
    }

    private static ImmutableSet<String> resolvePaths(Iterable<String> modulePaths, Iterable<String> roots) {
        ImmutableSet.Builder resolved = ImmutableSet.builder();
        HashSet<String> knownPaths = new HashSet<String>();
        for (String name : modulePaths) {
            String canonicalizedPath = ModuleNames.escapePath(name);
            if (!knownPaths.add(ModuleLoader.normalize(canonicalizedPath, roots))) {
                throw new IllegalArgumentException("Duplicate module path after resolving: " + name);
            }
            if (ModuleLoader.isAmbiguousIdentifier(canonicalizedPath)) {
                canonicalizedPath = MODULE_SLASH + canonicalizedPath;
            }
            resolved.add((Object)canonicalizedPath);
        }
        return resolved.build();
    }

    private static String normalize(String path, Iterable<String> moduleRootPaths) {
        String normalizedPath = path;
        if (ModuleLoader.isAmbiguousIdentifier(normalizedPath)) {
            normalizedPath = MODULE_SLASH + normalizedPath;
        }
        for (String moduleRoot : moduleRootPaths) {
            String trailing;
            if (!normalizedPath.startsWith(moduleRoot) || !(trailing = normalizedPath.substring(moduleRoot.length())).startsWith(MODULE_SLASH)) continue;
            return trailing.substring(MODULE_SLASH.length());
        }
        return path;
    }

    private final class NoopErrorHandler
    implements ErrorHandler {
        private NoopErrorHandler() {
        }

        @Override
        public void report(CheckLevel level, JSError error) {
        }
    }

    public static enum ResolutionMode {
        BROWSER,
        LEGACY,
        NODE;

    }

    public static enum PathResolver implements Function<String, String>
    {
        RELATIVE{

            public String apply(String path) {
                return path;
            }
        }
        ,
        ABSOLUTE{

            public String apply(String path) {
                return Paths.get(path, new String[0]).toAbsolutePath().toString();
            }
        };

    }

    public class ModulePath {
        private final String path;

        private ModulePath(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }

        public String toJSIdentifier() {
            return ModuleNames.toJSIdentifier(this.path);
        }

        public String toModuleName() {
            return ModuleNames.toModuleName(this.path);
        }

        @Nullable
        public ModulePath resolveJsModule(String moduleAddress) {
            return this.resolveJsModule(moduleAddress, null, -1, -1);
        }

        @Nullable
        public ModulePath resolveJsModule(String moduleAddress, String sourcename, int lineno, int colno) {
            String loadAddress = ModuleLoader.this.moduleResolver.resolveJsModule(this.path, moduleAddress, sourcename, lineno, colno);
            if (loadAddress != null) {
                return new ModulePath(loadAddress);
            }
            return null;
        }

        public ModulePath resolveModuleAsPath(String moduleAddress) {
            if (!moduleAddress.endsWith(".js")) {
                moduleAddress = moduleAddress + ".js";
            }
            String path = ModuleNames.escapePath(moduleAddress);
            if (ModuleLoader.isRelativeIdentifier(moduleAddress)) {
                String ourPath = this.path;
                int lastIndex = ourPath.lastIndexOf(ModuleLoader.MODULE_SLASH);
                path = ModuleNames.canonicalizePath(ourPath.substring(0, lastIndex + ModuleLoader.MODULE_SLASH.length()) + path);
            }
            return new ModulePath(ModuleLoader.normalize(path, (Iterable)ModuleLoader.this.moduleRootPaths));
        }
    }
}

